{ TOvrDbMemo
  ----------
  An improved TDBMemo component which reflect keyboard
  insert/overwrite mode, Special desiged for Windows
  Traditional Chinese Version.

  by Wolfgang Chien <wolfgang@ms2.hinet.net>
}
unit ODbMemo;

interface

{$ifdef Windows}
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Mask, DB, DBCtrls;
{$endif}

{$ifdef Win32}
uses
  SysUtils, Windows, Messages, Classes, Graphics,
  Controls, Forms, Dialogs, StdCtrls, Mask, DB, DBCtrls;
{$endif}

type
  TInsertKeyStates = (iksInsert, iksOverWrite);

  TOvrDBMemo = class(TDBMemo)
  private
    procedure WMChar(var Msg: TWMKey); message WM_Char;
  protected
    function GetInsertKeyState: TInsertKeyStates;
{$ifdef Win32}
    {
    On Windows 95 Tradition Chinese Version, users use the IME
    (input method editor) keyin the Chinese word. But if Dataset
    is in Browse mode, the IME couldn't appear, so I override the
    WndProc to solve this problem.
    }
    procedure WndProc(var Message: TMessage); override;
{$endif}

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property InsertKeyState: TInsertKeyStates read GetInsertKeyState;
  published

  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TOvrDBMemo]);
end;

constructor TOvrDBMemo.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

(* -------------------------------------------------- *)
destructor TOvrDBMemo.Destroy;
begin
  inherited Destroy;
end;

(* -------------------------------------------------- *)
function TOvrDBMemo.GetInsertKeyState: TInsertKeyStates;
begin
  if GetKeyState(VK_INSERT) = 0 then
    Result := iksInsert
  else
    Result := iksOverWrite;
end;

(* -------------------------------------------------- *)
procedure TOvrDBMemo.WMChar(var Msg: TWMKey);
begin
  { if Overwrite state and user select nothing }
  if (InsertKeyState = iksOverWrite) and (SelLength = 0)
    and (SelStart < GetTextLen) then
  begin
    if Ord(Msg.CharCode) < 32 then
      SelLength := 0
    else
    begin
      SelLength := 2;
      case SelText[1] of
        #9: SelLength := 1;  { Tab }
        #13, #10: SelLength := 0; { Line End }
      else
        begin
          if Ord(Msg.CharCode) > 127 then { Chinese Word Lead-byte, BIG-5}
          begin
            { Only one char before the end of Line }
            if (SelText[2] in [#13, #10]) then
              SelLength := 1
            else
              SelLength := 2
          end
          else
            SelLength := 1;
        end;
      end;
    end;
  end;

  inherited;
end;

(* -------------------------------------------------- *)
{$ifdef Win32}
procedure TOvrDBMemo.WndProc(var Message: TMessage);
begin
  { solve problem of the IME wouldn't appear in browse mode }
  if (Message.Msg = WM_SETFOCUS) or (Message.Msg = WM_MOUSEACTIVATE) then
    SendMessage(Handle, EM_SETREADONLY, 0, 0);
  inherited WndProc(Message);
end;
{$endif}

end.

