unit TestUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls, Db, DBTables, DBCtrls, Grids, DBGrids,
  ODCalend, ODPopCal, ODDBCal;

type
  TTestForm = class(TForm)
    ODCalendarDialog1: TODCalendarDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Bevel1: TBevel;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel2: TBevel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Memo1: TMemo;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ODCalendar1: TODCalendar;
    ODPopupCalendar1: TODPopupCalendar;
    Button1: TButton;
    Edit1: TEdit;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    GroupBox2: TGroupBox;
    YearToDateBtn: TSpeedButton;
    Last2MonthsBtn: TSpeedButton;
    Last6MonthsBtn: TSpeedButton;
    ThisMonthBtn: TSpeedButton;
    Label8: TLabel;
    ODDBCalendar1: TODDBCalendar;
    DBNavigator1: TDBNavigator;
    ODDBPopupCalendar1: TODDBPopupCalendar;
    DBGrid1: TDBGrid;
    Table1: TTable;
    DataSource1: TDataSource;
    PlainCheck: TCheckBox;
    Label9: TLabel;
    Table1StartDate: TDateField;
    Table1FinishDate: TDateField;
    GotoStartButton: TButton;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CalendarSetupDay(Sender: TObject; Date: TDateTime;
      var AColor: TColor; var AHint: String);
    procedure CalendarSelectYear(Sender: TObject; Year: Integer;
      var YearStart, YearFinish: TDateTime);
    procedure CalendarDayDblClick(Sender: TObject; ADate: TDateTime);
    procedure YearToDateBtnClick(Sender: TObject);
    procedure Last2MonthsBtnClick(Sender: TObject);
    procedure Last6MonthsBtnClick(Sender: TObject);
    procedure ThisMonthBtnClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure PlainCheckClick(Sender: TObject);
    procedure CalendarChange(Sender: TObject);
    procedure ODPopupCalendar1StartClick(Sender: TObject;
      var ADate: TDateTime);
    procedure GotoStartButtonClick(Sender: TObject);
    procedure ODCalendar1StartClick(Sender: TObject; var ADate: TDateTime);
  end;

var
  TestForm: TTestForm;

implementation

{$R *.DFM}

procedure TTestForm.FormShow(Sender: TObject);
begin
{ ODCalendar1.StartDate := EncodeDate(1998, 1, 15);
  ODCalendar1.FinishDate := Date;}
{ ODPopupCalendar1.StartDate := Date - 14;
  ODPopupCalendar1.FinishDate := Date;}
end;

procedure TTestForm.Button1Click(Sender: TObject);
begin
  with ODCalendarDialog1 do
    if Execute then
      if SingleDate then
        Edit1.Text := FormatDateTime(DateFormat, StartDate)
      else
        Edit1.Text := FormatDateTime(DateFormat, StartDate) +
          ' - ' + FormatDateTime(DateFormat, FinishDate);
end;

procedure TTestForm.CheckBox1Click(Sender: TObject);
begin
  with CheckBox1 do
  begin
    ODCalendar1.SingleDate := Checked;
    ODPopupCalendar1.SingleDate := Checked;
    ODCalendarDialog1.SingleDate := Checked;
    if Checked then
      ODPopupCalendar1.PopupCaption := 'Select A Date'
    else
      ODPopupCalendar1.PopupCaption := 'Select Date Range';
    ODCalendarDialog1.Caption := ODPopupCalendar1.PopupCaption;
  end;
end;

procedure TTestForm.CheckBox2Click(Sender: TObject);
begin
  ODCalendar1.ShowStatus := CheckBox2.Checked;
  ODPopupCalendar1.ShowStatus := CheckBox2.Checked;
  ODCalendarDialog1.ShowStatus := CheckBox2.Checked;
end;

procedure TTestForm.CheckBox3Click(Sender: TObject);
begin
  ODCalendar1.StartOnMonday := CheckBox3.Checked;
  ODPopupCalendar1.StartOnMonday := CheckBox3.Checked;
  ODCalendarDialog1.StartOnMonday := CheckBox3.Checked;
end;

procedure TTestForm.CalendarSetupDay(Sender: TObject; Date: TDateTime;
  var AColor: TColor; var AHint: String);
begin                                    //customise certain days -
  if Date = EncodeDate(1998, 8, 10) then
  begin
    AColor := clFuchsia;
    AHint := 'Happy birthday!';
  end
  else if Date = EncodeDate(1998, 8, 22) then
  begin
    AColor := clRed;
    AHint := 'Important!';
  end;
end;

procedure TTestForm.CalendarSelectYear(Sender: TObject; Year: Integer;
  var YearStart, YearFinish: TDateTime);
begin
  if Year = 1998 then       //use custom year start and end for 1998
  begin                              //as for a business year
    YearStart := EncodeDate(1998, 1, 4);
    YearFinish := EncodeDate(1999, 1, 2);
  end;
end;

procedure TTestForm.CalendarDayDblClick(Sender: TObject;
  ADate: TDateTime);
begin
  ShowMessage(DateToStr(ADate));
end;

procedure TTestForm.YearToDateBtnClick(Sender: TObject);
var
  yr, mo, dy: Word;
begin
  DecodeDate(Date, yr, mo, dy);
  if IsLeapYear(yr) then
    ODCalendar1.StartDate := Date - 366
  else
    ODCalendar1.StartDate := Date - 365;
  ODCalendar1.FinishDate := Date;
  ODCalendar1.DisplayDate := Date;
end;

procedure TTestForm.Last2MonthsBtnClick(Sender: TObject);
var
  yr, mo, dy: Word;
  m1, m2: Integer;
begin
  DecodeDate(Date, yr, mo, dy);
  if mo = 1 then
  begin
   Dec(yr);
   mo := 12;
  end
  else Dec(mo);
  m1 := ODCalendar1.DaysInMonth(mo, yr);
  if mo = 1 then
  begin
   Dec(yr);
   mo := 12;
  end
  else Dec(mo);
  m2 := ODCalendar1.DaysInMonth(mo, yr);
  ODCalendar1.StartDate := Date - m1 - m2;
  ODCalendar1.FinishDate := Date;
  ODCalendar1.DisplayDate := Date;
end;

procedure TTestForm.Last6MonthsBtnClick(Sender: TObject);
var
  yr, mo, dy: Word;
  dc, ix: Integer;
begin
  DecodeDate(Date, yr, mo, dy);
  dc := 0;
  for ix := 0 to 5 do
  begin
    if Mo = 1 then
    begin
     Dec(yr);
     mo := 12;
    end
    else Dec(mo);
    Inc(dc, ODCalendar1.DaysInMonth(mo, yr));
  end;
  ODCalendar1.StartDate := Date - dc;
  ODCalendar1.FinishDate := Date;
  ODCalendar1.DisplayDate := Date;
end;

procedure TTestForm.ThisMonthBtnClick(Sender: TObject);
begin
  ODCalendar1.DisplayDate := Date;
end;

procedure TTestForm.PageControl1Change(Sender: TObject);
begin
  Table1.Active := PageControl1.ActivePage.TabIndex = 2;
end;

procedure TTestForm.PlainCheckClick(Sender: TObject);
begin
  with PlainCheck do
  begin
    ODCalendar1.Plain := Checked;
    ODPopupCalendar1.Plain := Checked;
    ODCalendarDialog1.Plain := Checked;
    if Checked then
      ODCalendar1.BevelEdge := bvLowered
    else
      ODCalendar1.BevelEdge := bvNone;
  end;
end;

procedure TTestForm.CalendarChange(Sender: TObject);
begin
  ShowMessage('Change');
end;

procedure TTestForm.ODPopupCalendar1StartClick(Sender: TObject;
  var ADate: TDateTime);
begin
  ShowMessage('Start click');
end;

procedure TTestForm.GotoStartButtonClick(Sender: TObject);
begin
  ODCalendar1.DisplayDate := ODCalendar1.StartDate;
end;

procedure TTestForm.ODCalendar1StartClick(Sender: TObject;
  var ADate: TDateTime);
begin
  GotoStartButton.Enabled := True;
end;

end.
