unit Ochbtn;
(*
 OCH Button V1.00 - January 06, 1998

 Copyright (c) 1998 by Demian

 Disclaimer:
 This component is distributed as Freeware. There is no charge or warranty
 whatsoever. The author will not be held responsible for any direct or indirect
 damage resulting from the use of the component or any derivatives thereof.
 In short: USE IT AT YOUR OWN RISK! You are allowed to include the component
 code in any commercial or non commercial product. You are also allowed to make
 as many copies of the component as you want and distribute them, as long as you
 do not receive any money for the copying/distribution.

 You can send any comments, suggestions and bugs to demian@bhnet.com.br
 New versions can be found at: http://www.bhnet.com.br/~demian
                               http://web.unix.horizontes.com.br/~demian

 If you do any modification to this code, please send me a copy.
 If you use this code on any 'real-life' application, please let me know.
 If you think this code is completely useless, please DON'T LET ME KNOW!

 Description:
 TCustomPanel descendent which encapsulates 3 buttons (OK, Cancel, Help) in one
 panel, allowing the system to treat them as a single object.

 How to use it:
 1. Install the component [VNM Pallete];
 2. Drop one TOCHButton onto a form;
 3. Set the 'Orientation' and 'HelpContext' properties;
 4. Doubleclick the component for specifying the actions to be executed when
    the OK button or Cancel button are clicked (There's no event for the Help
    button. Just specify a value for the 'HelpContext' property). Then, on the
    TOCHButton OnClick event, insert this code:
      if OKButton then
        {OK button action...}
      else
        {Cancel button action...};
*)

interface

uses
  SysUtils, Classes, Controls, ExtCtrls, Buttons, WinTypes, Forms, Graphics;

type
  TOCHEvent = procedure (const OKButton: boolean) of object;
  TOCHDefault = (bdNone,bdOK,bdCancel,bdHelp);
  TOCHOrientation = (Horizontal,Vertical);
  TOCHButton = class(TCustomPanel)
  private
    BitBtnOK: TBitBtn;
    BitBtnCancel: TBitBtn;
    BitBtnHelp: TBitBtn;
    FOnClick: TOCHEvent;
    FCancel: boolean;
    FDefault: TOCHDefault;
    FOrientation: TOCHOrientation;
    FTabStop: boolean;
    FButtonsHeight: integer;
    FButtonsWidth: integer;
    FButtonsSpacing: integer;
    procedure SetTabStop(const Value: boolean);
    procedure SetCancel(const Value: boolean);
    procedure SetDefault(const Value: TOCHDefault);
    procedure SetOrientation(const Value: TOCHOrientation);
    procedure SetButtonsHeight(const Value: integer);
    procedure SetButtonsWidth(const Value: integer);
    procedure SetButtonsSpacing(const Value: integer);
    procedure RedrawPanel;
    procedure OCHButtonClick(Sender: TObject);
  public
    constructor Create(AOwner:TComponent); override;
  published
    property Align;
    property Font;
    property ParentFont;
    property OnClick: TOCHEvent read FOnClick write FOnClick;
    property BevelOuter;
    property Cancel: boolean read FCancel write SetCancel;
    property Default: TOCHDefault read FDefault write SetDefault default bdNone;
    property Orientation: TOCHOrientation read FOrientation write SetOrientation default Vertical;
    property ButtonsHeight: integer read FButtonsHeight write SetButtonsHeight;
    property ButtonsWidth: integer read FButtonsWidth write SetButtonsWidth;
    property ButtonsSpacing: integer read FButtonsSpacing write SetButtonsSpacing;
    property TabStop: boolean read FTabStop write SetTabStop;
end;

procedure Register;

implementation

{$IFDEF WIN32}
 {$R *.R32}
{$ELSE}
 {$R *.R16}
{$ENDIF}

{______________________________________________________________________________}
procedure Register;
begin
  RegisterComponents('VNM',[TOCHButton]);
end;

{______________________________________________________________________________}
constructor TOCHButton.Create (AOwner:TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csOpaque];
  Font.Name := 'Arial';
  FButtonsSpacing := 4;
  FDefault := bdNone;
  FOrientation := Vertical;
  FButtonsHeight := 28;
  FButtonsWidth := 93;
  BitBtnOK := TBitBtn.Create(self);
  with BitBtnOK do begin
    Kind := bkOK;
    Default := false;
    Parent := self;
    ModalResult := mrNone;
    OnClick := OCHButtonClick;
  end;
  BitBtnCancel := TBitBtn.Create(self);
  with BitBtnCancel do begin
    Tag := 1;
    Kind := bkCancel;
    Cancel := false;
    Parent := self;
    OnClick := OCHButtonClick;
  end;
  BitBtnHelp := TBitBtn.Create(self);
  with BitBtnHelp do begin
    Tag := 2;
    Kind := bkHelp;
    Parent := self;
    OnClick := OCHButtonClick;
  end;
  SetButtonsHeight(FButtonsHeight);
  SetButtonsWidth(FButtonsWidth);
  RedrawPanel;
end;

{______________________________________________________________________________}
procedure TOCHButton.SetTabStop(const Value: boolean);
begin
  FTabStop := Value;
  BitBtnOK.TabStop := Value;
  BitBtnCancel.TabStop := Value;
  BitBtnHelp.TabStop := Value;
end;

{______________________________________________________________________________}
 procedure TOCHButton.SetButtonsWidth(const Value: integer);
 begin
   FButtonsWidth := value;
   BitBtnOK.Width := FButtonsWidth;
   BitBtnCancel.Width := FButtonsWidth;
   BitBtnHelp.Width := FButtonsWidth;
   RedrawPanel;
 end;

 {______________________________________________________________________________}
 procedure TOCHButton.SetButtonsHeight(const Value: integer);
 begin
   FButtonsHeight := value;
   BitBtnOK.Height := FButtonsHeight;
   BitBtnCancel.Height := FButtonsHeight;
   BitBtnHelp.Height := FButtonsHeight;
   RedrawPanel;
 end;

{______________________________________________________________________________}
procedure TOCHButton.SetButtonsSpacing(const Value: integer);
begin
  FButtonsSpacing := value;
  RedrawPanel;
end;

{______________________________________________________________________________}
procedure TOCHButton.SetCancel(const Value: boolean);
begin
  FCancel := Value;
  BitBtnCancel.Cancel := Value;
end;

{______________________________________________________________________________}
procedure TOCHButton.SetOrientation(const Value: TOCHOrientation);
begin
  FOrientation := Value;
  RedrawPanel;
end;

{______________________________________________________________________________}
procedure TOCHButton.SetDefault(const Value: TOCHDefault);
begin
  FDefault := Value;
  BitBtnOk.Default := false;
  BitBtnCancel.Default := false;
  BitBtnHelp.Default := false;
  case Value of
    bdOK:     BitBtnOk.Default := true;
    bdCancel: BitBtnCancel.Default := true;
    bdHelp:   BitBtnHelp.Default := true;
  end;
end;

{______________________________________________________________________________}
procedure TOCHButton.OCHButtonClick(Sender: TObject);
begin
  with TBitBtn(Sender) do
    if Tag = 2 then
      Application.HelpContext(HelpContext)
    else if Assigned(FOnClick) then
      FOnClick(Tag=0);
end;

{______________________________________________________________________________}
procedure TOCHButton.RedrawPanel;
begin
  if Orientation = Vertical then begin
    Height := BitBtnOK.Height*3+FButtonsSpacing*4;
    Width := BitBtnOK.Width+FButtonsSpacing*2;
    BitBtnOK.Top := FButtonsSpacing;
    BitBtnCancel.Top := BitBtnOK.Top+BitBtnOK.Height+FButtonsSpacing;
    BitBtnHelp.Top := BitBtnCancel.Top+BitBtnCancel.Height+FButtonsSpacing;
    BitBtnOK.Left := FButtonsSpacing;
    BitBtnCancel.Left := FButtonsSpacing;
    BitBtnHelp.Left := FButtonsSpacing;
    end
  else begin
    Height := BitBtnOK.Height+FButtonsSpacing*2;
    Width := BitBtnOK.Width*3+FButtonsSpacing*4;
    BitBtnOK.Top := FButtonsSpacing;
    BitBtnCancel.Top := FButtonsSpacing;
    BitBtnHelp.Top := FButtonsSpacing;
    BitBtnOK.Left := FButtonsSpacing;
    BitBtnCancel.Left := BitBtnOK.Left+BitBtnOK.Width+FButtonsSpacing;
    BitBtnHelp.Left := BitBtnCancel.Left+BitBtnCancel.Width+FButtonsSpacing;
  end;
end;

end.

