{$A+,B-,D-,F-,G+,I-,K+,L-,N+,P+,Q-,R-,S-,T-,V-,W-,X+,Y-}
{ $IFDEF DEBUG_ALL}
  {$D+,L+,Y+}
{ $ENDIF}
UNIT SysTools;

{ SysTools unit V1.0 Copyright by Fink Guy

  Purpose	: Some fast memory routines.
		  File routines not found in BORLAND's SysUtils unit

  This unit is freeware.

  USE AT YOUR OWN RISK! No garantees expressed or implied!

  The autor is not responsible for any damages resulting from the use
  of the routines in this unit.

  You are free to distribute this unit in an unmodified form and without any
  charges other than those necessary for the needed media and the copy costs.
  Please do not distribute modified versions.

  THIS UNIT IS NOT PUBLIC DOMAIN!!! }

INTERFACE

{ FastMove is an equivalent to the system library's MOVE instruction,
  but it uses 16bit transfers. For maximum performance no checking is
  done if source or destination are NIL, nor if the memory ranges overlap.
  The destination is checked for misalignement and adjusted if necessary.
  This routine is max. 1.5% slower than MOVE on blocksizes under 16 Bytes
  but up to 100% faster on bigger blocks, even if one of the operands
  is misaligned. }
PROCEDURE FastMove(Source, Destination : POINTER; Count : WORD);

{ This is the secure counterpart of FastMove, Source and Destination
  are checked and if one is NIL no operation is performed. The memory
  ranges are checked for overlapping and misalignement. The overlap
  test is more accurate than the one used by the system library.
  This routine is in worst case (misalignement and overlapping) 15%
  slower than MOVE on blocksizes under 32 Bytes (due to the checking)
  but up to 120% faster on bigger blocks. }
PROCEDURE FastMoveSecure(Source, Destination : POINTER; Count : WORD);

(* {This routines are different implementations of FastMove. No alignment
    check is performed and so on. Please feel free to uncomment and test }
PROCEDURE FastMove1(VAR Source, Destination; Count : WORD);
PROCEDURE FastMove2(VAR Source, Destination; Count : WORD);
PROCEDURE FastMove3(VAR Source, Destination; Count : WORD);
PROCEDURE FastMove4(VAR Source, Destination; Count : WORD);
PROCEDURE FastMove5(VAR Source, Destination; Count : WORD);
*)

{ FastFillChar is a faster counterpart to FILLCHAR. It uses 16bit transfers. }
PROCEDURE FastFillchar(Destination : POINTER; Count : WORD; Fill : BYTE);
{ FastFillCharSecure is the secure counterpart to FastFillChar. It uses
  16bit transfers and operands are checked to be valid. }
PROCEDURE FastFillCharSecure(Destination : POINTER; Count : WORD; Fill : BYTE);

{ FastFillWord and FastFillWordSecure are equivalent to FastFillChar and
  FastFillCharSecure but they use a word operand to fill destination }
PROCEDURE FastFillWord(Destination : POINTER; Count : WORD; Fill : WORD);
PROCEDURE FastFillWordSecure(Destination : POINTER; Count : WORD; Fill : WORD);

{ Some routines to swap values of differnet variables. }
PROCEDURE SwapPointer(VAR x, y : POINTER);
PROCEDURE SwapLongInt(VAR x, y : LONGINT);
PROCEDURE SwapWord(VAR x, y : WORD);
PROCEDURE SwapInteger(VAR x, y : INTEGER);
PROCEDURE SwapByte(VAR x, y : BYTE);
PROCEDURE SwapDouble(VAR x, y : DOUBLE);
PROCEDURE SwapExtended(VAR x, y : EXTENDED);

{ FileFlush is used to flush the DOS internal buffers of a file to disk
  and update the directory entry. It uses DOS-function $45 to duplicate
  the given filehandle and closes the returned handle immediately.
  Regardless of the compilerswitch I, errors are returned via IORESULT }
PROCEDURE FileFlush(Handle : INTEGER);

{ FileTruncate is used to truncate the file associated with the given filehandle.
  Regardless of the compilerswitch I, errors are returned via IORESULT }
PROCEDURE FileTruncate(Handle : INTEGER);

IMPLEMENTATION

USES
  WinProcs;
(*
PROCEDURE FastMove1(VAR Source, Destination; Count : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI,[Destination]
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV	BX, DS			{ Save data segment }
	LDS	SI, [Source]
	MOV	AX, DS
	OR	AX, SI
	JZ	@@2			{ Source = NIL }
	CLD
	SHR	CX, 1			{ We will use MOVSW }
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else move one byte }
@@2:	REP	MOVSW
	MOV	DS, BX			{ Restore data segment }
@@1:
END;

PROCEDURE FastMove2(VAR Source, Destination; Count : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI,[Destination]
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV	BX, DS			{ Save data segment }
	LDS	SI, [Source]
	MOV	AX, DS
	OR	AX, SI
	JZ	@@2			{ Source = NIL }
	CLD
	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@2:	MOV	DS, BX			{ Restore data segment }
@@1:
END;

PROCEDURE FastMove3(VAR Source, Destination; Count : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI,[Destination]
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV	BX, DS			{ Save data segment }
	LDS	SI, [Source]
	MOV	AX, DS
	OR	AX, SI
	JZ	@@2			{ Source = NIL }
	CLD
	MOV	AX, DI
	SHR	AX, 1
	JNC	@@3			{ DI is aligned }
	MOVSB				{ now DI is aligned }
@@3:	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@2:	MOV	DS, BX			{ Restore data segment }
@@1:
END;

PROCEDURE FastMove4(VAR Source, Destination; Count : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI,[Destination]
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV	BX, DS			{ Save data segment }
	LDS	SI, [Source]
	MOV	AX, DS
	OR	AX, SI
	JZ	@@2			{ Source = NIL }
	CLD
	CMP	CX, 16
	JG	@@4
	REP	MOVSB
	JMP	@@2
@@4:	MOV	AX, DI
	SHR	AX, 1
	JNC	@@3			{ DI is even }
	MOVSB				{ now DI is aligned }
@@3:	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@2:	MOV	DS, BX			{ Restore data segment }
@@1:
END;

PROCEDURE FastMove5(VAR Source, Destination; Count : WORD); ASSEMBLER;

ASM
	MOV	BX, DS			{ Save data segment }
	CLD
	LDS	SI, [Source]
	LES	DI, [Destination]
	MOV	CX, Count
	CMP	CX, 16			{ if 16 or less bytes to move }
	JG	@@1                     { use MOVSB, it's faster }
	REP	MOVSB                   { at least on my machine }
	JMP	@@3
@@1:	MOV	AX, DI			{ test if DI aligned }
	SHR	AX, 1
	JNC	@@2			{ DI is aligned }
	MOVSB				{ now DI is aligned }
@@2:	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW			{ REP and MOVSW will not change the carryflag }
	JNC	@@3			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@3:	MOV	DS, BX			{ Restore data segment }
END;
*)

PROCEDURE FastMove(Source, Destination : POINTER; Count : WORD); ASSEMBLER;

ASM
	MOV	BX, DS			{ Save data segment }
	CLD
	LDS	SI, Source
	LES	DI, Destination
	MOV	CX, Count
	CMP	CX, 16			{ if 16 or less bytes to move }
	JG	@@1                     { use MOVSB, it's faster }
	REP	MOVSB                   { at least on my machine }
	JMP	@@3
@@1:	MOV	AX, DI			{ test if DI aligned }
	SHR	AX, 1
	JNC	@@2			{ DI is aligned }
	MOVSB				{ now DI is aligned }
@@2:	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW			{ REP and MOVSW will not change the carryflag }
	JNC	@@3			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@3:	MOV	DS, BX			{ Restore data segment }
END;

PROCEDURE FastMoveSecure(Source, Destination : POINTER; Count : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI, Destination
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV	BX, DS			{ Save data segment }
	LDS	SI, Source
	MOV	AX, DS
	OR	AX, SI
	JZ	@@2			{ Source = NIL }
	CLD
        MOV	AX, DS
        MOV	DX, ES
        CMP	AX, DX			{ Is it in the same segment? }
        JNE	@@4
        CMP	SI, DI			{ it is the same segment! }
        JE	@@2			{ HA Source and Destination are the same -> nothing to do }
        JG	@@4			{ ok SI is greater then DI we kann move forward }
        ADD	SI, CX
        ADD	DI, CX
        DEC	SI
        DEC	DI
        STD
(*@@5:	CMP	CX, 16			{ if 16 or less bytes to move }
	JG	@@4                     { use MOVSB, it's faster }
	REP	MOVSB                   { at least on my machine }
	JMP	@@2	*)
@@4:	MOV	AX, DI			{ test if DI aligned }
	SHR	AX, 1
	JNC	@@3			{ DI is aligned }
	MOVSB				{ now DI is aligned }
@@3:	SHR	CX, 1			{ We will use MOVSW }
	REP	MOVSW			{ REP and MOVSW will not change the carryflag }
	JNC	@@2			{ Ok, the size is even }
	MOVSB				{ else we have to move one last byte }
@@2:	MOV	DS, BX			{ Restore data segment }
@@1:
END;

PROCEDURE FastFillchar(Destination : POINTER; Count : WORD; Fill : BYTE); ASSEMBLER;

ASM
	LES	DI, Destination
        CLD
	MOV	CX, Count
	MOV 	AL, Fill
	CMP	CX, 4			{ if less than 4 bytes to store }
	JGE	@@1                     { use STOSB, it's faster }
	REP	STOSB                   { at least on my machine }
	JMP	@@3
@@1:	MOV	BX, DI			{ test if DI aligned }
	SHR	BX, 1
	JNC	@@2			{ DI is aligned }
	STOSB				{ now DI is aligned }
@@2:   	MOV	AH, AL
	SHR	CX, 1			{ We will use STOSW }
	REP	STOSW			{ REP and STOSW will not change the carryflag }
	JNC	@@3			{ Ok, the size is even }
	STOSB				{ else we have to store one last byte }
@@3:					{ Restore data segment }
END;

PROCEDURE FastFillCharSecure(Destination : POINTER; Count : WORD; Fill : BYTE); ASSEMBLER;

ASM
	MOV	CX, Count
        OR	CX, CX
        JZ	@@3			{ nothing to do }
	LES	DI, Destination
	MOV	AX, ES
	OR	AX, DI
	JZ	@@3			{ Destination = NIL }
        CLD
	MOV 	AL, Fill
	CMP	CX, 4			{ if less than 4 bytes to store }
	JGE	@@1                     { use STOSB, it's faster }
	REP	STOSB                   { at least on my machine }
	JMP	@@3
@@1:	MOV	BX, DI			{ test if DI aligned }
	SHR	BX, 1
	JNC	@@2			{ DI is aligned }
	STOSB				{ now DI is aligned }
@@2:   	MOV	AH, AL
	SHR	CX, 1			{ We will use STOSW }
	REP	STOSW			{ REP and STOSW will not change the carryflag }
	JNC	@@3			{ Ok, the size is even }
	STOSB				{ else we have to store one last byte }
@@3:					{ Restore data segment }
END;

PROCEDURE FastFillWord(Destination : POINTER; Count : WORD; Fill : WORD); ASSEMBLER;

ASM
	LES	DI, Destination
	MOV 	CX, Count
	MOV 	AX, Fill
	CLD
	SHR	CX, 1			{ We will use STOSW }
	REP	STOSW
	JNC	@@1			{ Ok, the size is even }
	STOSB				{ else we have to store one last byte }
@@1:
END;

PROCEDURE FastFillWordSecure(Destination : POINTER; Count : WORD; Fill : WORD); ASSEMBLER;

ASM
	MOV	CX, Count
	OR	CX, CX
	JZ	@@1			{ Nothing to do }
	LES	DI, Destination
	MOV	AX, ES
	OR	AX, DI
	JZ	@@1			{ Destination = NIL }
	MOV 	AX, Fill
	CLD
	SHR	CX, 1			{ We will use STOSW }
	REP	STOSW
	JNC	@@1			{ Ok, the size is even }
	STOSB				{ else we have to store one last byte }
@@1:
END;

PROCEDURE SwapPointer(VAR x, y : POINTER); ASSEMBLER;
ASM
	MOV	BX, DS
	LDS	SI, [x]
	LES	DI, [y]
	MOV	AX, [WORD PTR DS:SI]
	XCHG	AX, [WORD PTR ES:DI]
	MOV	[WORD PTR DS:SI], AX
	MOV	AX, [WORD PTR DS:SI+2]
	XCHG	AX, [WORD PTR ES:DI+2]
	MOV	[WORD PTR DS:SI+2], AX
	MOV	DS, BX
END;

PROCEDURE SwapLongInt(VAR x, y : LONGINT); ASSEMBLER;
ASM
	MOV	BX, DS
	LDS	SI, [x]
	LES	DI, [y]
	MOV	AX, [WORD PTR DS:SI]
	XCHG	AX, [WORD PTR ES:DI]
	MOV	[WORD PTR DS:SI], AX
	MOV	AX, [WORD PTR DS:SI+2]
	XCHG	AX, [WORD PTR ES:DI+2]
	MOV	[WORD PTR DS:SI+2], AX
	MOV	DS, BX
END;

PROCEDURE SwapInteger(VAR x, y : INTEGER); ASSEMBLER;
ASM
	MOV	BX, DS
	LDS	SI, [x]
	LES	DI, [y]
	MOV	AX, [WORD PTR DS:SI]
	XCHG	AX, [WORD PTR ES:DI]
	MOV	[WORD PTR DS:SI], AX
	MOV	DS, BX
END;

PROCEDURE SwapWord(VAR x, y : WORD); ASSEMBLER;
ASM
	MOV	BX, DS
	LDS	SI, [x]
	LES	DI, [y]
	MOV	AX, [WORD PTR DS:SI]
	XCHG	AX, [WORD PTR ES:DI]
	MOV	[WORD PTR DS:SI], AX
	MOV	DS, BX
END;

PROCEDURE SwapByte(VAR x, y : BYTE); ASSEMBLER;
ASM
	MOV	BX, DS
	LDS	SI, [x]
	LES	DI, [y]
	MOV	AL, [BYTE PTR DS:SI]
	XCHG	AL, [BYTE PTR ES:DI]
	MOV	[BYTE PTR DS:SI], AL
	MOV	DS, BX
END;


PROCEDURE SwapDouble(VAR x, y : DOUBLE); ASSEMBLER;
ASM
	MOV     AX, DS
	LDS     SI, [x]
	LES     DI, [y]
	FLD	[QWORD PTR DS:SI]	{ ST= X }
	FLD	[QWORD PTR ES:DI]	{ ST(1)= X	ST = Y }
	FSTP  	[QWORD PTR DS:SI]	{ ST= X }
	FSTP	[QWORD PTR ES:DI]
	MOV     DS, AX
END;

PROCEDURE SwapExtended(VAR x, y : EXTENDED); ASSEMBLER;
ASM
	MOV     AX, DS
	LDS     SI, [x]
	LES     DI, [y]
	FLD	[TBYTE PTR DS:SI]	{ ST= X }
	FLD	[TBYTE PTR ES:DI]	{ ST(1)= X	ST = Y }
	FSTP  	[TBYTE PTR DS:SI]	{ ST= X }
	FSTP	[TBYTE PTR ES:DI]
	MOV     DS, AX
END;

PROCEDURE FileFlush(Handle : INTEGER); ASSEMBLER;

ASM
	MOV	AX, InOutRes
	OR	AX, AX
	JNZ	@@2			{ InOutRes <> 0 so no IO-Operations allowed }
	MOV	AH, $45			{ Duplicate file handle }
	MOV	BX, Handle
	CALL	DOS3Call
	JC	@@1
	MOV	BX, AX
	MOV	AH, $3E			{ Close file }
	CALL	DOS3Call
	JNC	@@2
@@1:	MOV	InOutRes, AX
@@2:
END;

PROCEDURE FileTruncate(Handle : INTEGER); ASSEMBLER;

ASM
	MOV	AX, InOutRes
	OR	AX, AX
	JNZ	@@1			{ InOutRes <> 0 so no IO-Operations allowed }
	MOV	AH, $40			{ Write file }
	MOV	BX, Handle
	XOR	CX, CX			{ Write 0 bytes }
	CALL	DOS3Call
	JNC	@@1
	MOV	InOutRes, AX
@@1:
END;

END.
