unit Number;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TNumberType = (ttStick,ttHex,ttBinary);

  TNumber = class(TGraphicControl)
  private
    { Private declarations }
    BH,BW,BS,number : Word;
    Col             : TColor;
    UseFont         : TFont;
    Kind            : TNumberType;

    Procedure SetValue(nr : Word);

    Procedure SetBH(nr : Word);
    Procedure SetBW(nr : Word);
    Procedure SetBS(nr : Word);
    Procedure SetCol(c : TColor);
    Procedure SetKind(k : TNumberType);
    Procedure SetFont(f : TFont);
  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Color : TColor Read Col Write SetCol;
    property BarHeight : Word Read BH Write SetBH;
    property BarWidth : Word Read BW Write SetBW;
    property Font : TFont Read UseFont Write SetFont;
    property Value : Word Read Number Write SetValue;
    Property ShownAs : TNumberType Read Kind Write SetKind;
    property Spacing : Word Read BS Write SetBS;
    property Visible;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TNumber]);
end;

constructor TNumber.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  UseFont:=TFont.Create;
  Color := clBlack;
  BarHeight := 15;
  BarWidth := 2;
  spacing:=2;
  Value:=5;
  Width:=100;
  Height:=15;
  Invalidate;
End;

Procedure Tnumber.SetValue(nr : Word);
Begin
  number:=nr;
  Invalidate;
End;

Procedure TNumber.SetBH(nr : Word);
Begin
  BH:=nr;
  Invalidate;
End;

Procedure TNumber.SetBW(nr : Word);
Begin
  BW:=nr;
  Invalidate;
End;

Procedure TNumber.SetFont(f : TFont);
Begin
  UseFont:=f;
End;

Procedure TNumber.SetBS(nr : Word);
Begin
  BS:=nr;
  Invalidate;
End;

Procedure TNumber.SetCol(c : TColor);
Begin
  Col:=c;
  Invalidate;
End;

Procedure TNumber.SetKind(k : TNumberType);
Begin
  Kind:=k;
  Invalidate;
End;


procedure TNumber.Paint;
Var
  Modi : Byte;
  count : Word;
  Offset : Word;
  StartPos : Word;
  AndResul : Word;
  VSize    : Byte;
  OutPut   : String;
  tmp      : Word;
  HowFar   : Word;

Begin
    Canvas.Pen.Color:=Col;
    Canvas.Font:=UseFont;
    Case Kind Of

    ttStick : Begin
                Modi:=BW DIV 2;
                StartPos:=0;
                { Make space for the vertcal Line }
                Offset:=Modi+BS;
                With Canvas Do
                Begin
                  Pen.Width:=BW;
                  {Pen.Color:=Col;}
                  For count:=1 To Value Do
                  Begin
                    If (count MOD 5) = 0 Then
                    begin
                      { Horisental Line }
                      MoveTo(StartPos,(BH DIV 3));
                      LineTo(Offset-(Modi*2),BH-(BH DIV 3));
                      Offset:=Offset+Modi+BS;
                      StartPos:=Offset-BS;
                    End
                    Else
                    Begin
                      { Vertical Line }
                      MoveTo(Offset,0);
                      LineTo(Offset,BH);
                      Offset:=Offset+BS+BW;
                    End;
                  End;
                End;
                Height:=BH;
                Width:=Offset+(2*Modi);
              End;

      ttHex : Begin
                   Howfar:=15;
                   Output:='';
                   vSize:=(SizeOf(Value)*8) DIV 4;
                   tmp:=Value;
                   { One bit at a time }
                   For count:=1 To VSize Do
                   Begin
                     AndResul:=tmp AND Howfar;
                     case AndResul Of
                        0 : OutPut:='0'+Output;
                        1 : OutPut:='1'+Output;
                        2 : OutPut:='2'+Output;
                        3 : OutPut:='3'+Output;
                        4 : OutPut:='4'+Output;
                        5 : OutPut:='5'+Output;
                        6 : OutPut:='6'+Output;
                        7 : OutPut:='7'+Output;
                        8 : OutPut:='8'+Output;
                        9 : OutPut:='9'+Output;
                       10 : OutPut:='A'+Output;
                       11 : OutPut:='B'+Output;
                       12 : OutPut:='C'+Output;
                       13 : OutPut:='D'+Output;
                       14 : OutPut:='E'+Output;
                       15 : OutPut:='F'+Output;
                     End;
                     tmp:=tmp DIV 16;
                   End;
                   {Canvas.Font:=Font;}
                   With Canvas Do
                   Begin
                     Width:=textWidth(OutPut);
                     Height:=TextHeight(OutPut);
                     {Font:=UseFont;}
                     TextOut(0,0,Output);
                   End;
                 End;

      ttBinary : Begin
                   Howfar:=1;
                   Output:='';
                   vSize:=(SizeOf(Value)*8);
                   tmp:=Value;
                   { One bit at a time }
                   For count:=1 To VSize Do
                   Begin
                     If (tmp AND HowFar) = HowFar Then Output:='1'+Output
                     Else Output:='0'+Output;
                     tmp:=tmp;
                     Howfar:=howfar*2;
                   End;
                   {Canvas.Font:=Font;}
                   With Canvas Do
                   Begin
                     Width:=textWidth(OutPut);
                     Height:=TextHeight(OutPut);
                     {Font:=UseFont;}
                     TextOut(0,0,Output);
                   End;
                 End;
  End;
End;

end.
