unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Call32NT;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Label1: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    OrginalRgn : HRGN;
    NormalRgn : Boolean;
    Moving : Boolean;
    Original_x , Original_y : Integer;
  public
    { Public declarations }
  end;

  TPoint= record
    x: longint;
    y: longint;
  end;

  ptrPoint = ^TPoint;

var
  Form1: TForm1;
  SetWindowRgn :function(hwnd,hrgn,bredrawi,id:longint):longint;
  SetProp : function(hwnd:longint ; name: PChar; hrgn,id: longint): longint ;
  RemoveProp : function (hwnd :longint; name:PChar; id: longint) : longint;
  GetWindowRgn : function (hwnd, hrgn ,id: longint) : longint;
  CreateEllipticRgn: function (x1,y1,x2,y2,id : longint): longint;
  CreatePolygonRgn : function(pPoints:ptrPoint;cPoints, fnPolyFillMode,id:longint): longint;
  CombineRgn : function (hdest,hreg1, hreg2,fnCombineMode,id : longint): longint;

  idSetWindowRgn : longint;
  idSetProp : longint;
  idRemoveProp : longint;
  idGetWindowRgn : longint;
  idCreateEllipticRgn :longint;
  idCreatePolygonRgn :longint;
  idCombineRgn:longint;
implementation

{Circle Region}
procedure TForm1.Button1Click(Sender: TObject);
var
         NewRgn : HRGN;
begin

     if NormalRgn then
          GetWindowRgn(Form1.handle,OrginalRgn,idGetWindowRgn);
     Form1.BorderStyle:=bsNone;
     if ClientWidth> ClientHeight then
           NewRgn:=CreateEllipticRgn( ClientWidth div 2 - ClientHeight div 2, 0, ClientWidth div 2 + ClientHeight div 2,
           ClientHeight,idCreateEllipticRgn )
     else
     NewRgn:=CreateEllipticRgn( 0,ClientHeight div 2 - ClientWidth div 2, ClientWidth,
             ClientHeight div 2 + ClientWidth div 2,idCreateEllipticRgn );

     SetWindowRgn( Form1.Handle, NewRgn,1, idSetWindowRgn);
     RemoveProp(Form1.Handle,'region',idRemoveProp);
     SetProp( Form1.Handle, 'region', NewRgn , idSetProp);


     if  NormalRgn then NormalRgn:=Not(NormalRgn);
end;

{Triangle Region}
procedure TForm1.Button2Click(Sender: TObject);
var
     NewRgn : HRGN;
     Points : array[1..3] of TPoint;
     longWidth : longint;
     longHeight : longint;
begin
     if NormalRgn then
        GetWindowRgn(Form1.handle,OrginalRgn,idGetWindowRgn);

     Form1.BorderStyle:=bsNone;
     Points[1].x:= 0;
     Points[1].y:= 0;
     Points[2].x:=ClientWidth;
     Points[2].y:=0;
     Points[3].x:=ClientWidth div 2;
     Points[3].y:=ClientHeight;


     NewRgn:=CreatePolygonRgn(@Points,3,1,idCreatePolygonRgn);
     SetWindowRgn( Form1.Handle, NewRgn,1, idSetWindowRgn);
     RemoveProp(Form1.Handle,'region',idRemoveProp);
     SetProp( Form1.Handle, 'region', NewRgn , idSetProp);
     if NormalRgn then NormalRgn:=Not(NormalRgn);

end;

{Two circle region}
procedure TForm1.Button4Click(Sender: TObject);
var
   Ellipse1Rgn, Ellipse2Rgn: HRGN;

begin

     if NormalRgn then
          GetWindowRgn(Form1.handle,OrginalRgn,idGetWindowRgn);

     Form1.BorderStyle:=bsNone;
     Ellipse1Rgn:=CreateEllipticRgn(0 ,0, ClientWidth div 2 , ClientHeight ,idCreateEllipticRgn);
     Ellipse2Rgn:=CreateEllipticRgn(ClientWidth div 2 ,0, ClientWidth,ClientHeight,idCreateEllipticRgn);
     CombineRgn(Ellipse1Rgn,Ellipse1Rgn,Ellipse2Rgn,RGN_OR,idCombineRgn);
     SetWindowRgn( Form1.Handle, Ellipse1Rgn,1, idSetWindowRgn);
     RemoveProp(Form1.Handle,'region',idRemoveProp);
     SetProp( Form1.Handle, 'region', Ellipse1Rgn , idSetProp);


     if  NormalRgn then NormalRgn:=Not(NormalRgn);
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
     NormalRgn:=True;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
     if Not(NormalRgn) then
     begin
          BorderStyle:=bsSizeable;
          SetWindowRgn(Form1.Handle,OrginalRgn,1,idSetWindowRgn);
          NormalRgn:=Not(NormalRgn);
     end;


end;












procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     Moving:=True;
     Original_x:=X;
     Original_y:=Y;
end;

procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     Moving:=False;
end;

procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
     if Moving then begin
        left:=left+(X-Original_x);
        top:=top+(Y-Original_Y);
     end;
end;

begin
     @SetWindowRgn:=@Call32;
     @SetProp := @Call32;
     @RemoveProp:=@Call32;
     @GetWindowRgn := @Call32;
     @CreateEllipticRgn:=@Call32;
     @CreatePolygonRgn:=@Call32;
     @CombineRgn:=@Call32;

     idSetWindowRgn:=Declare32('SetWindowRgn', 'user32', 'wwi');
     idSetProp := Declare32('SetProp','user32','wpw');
     idRemoveProp :=Declare32('RemoveProp','user32','wp');
     idGetWindowRgn:=Declare32('GetWindowRgn', 'user32', 'ww');
     idCreateEllipticRgn:=Declare32('CreateEllipticRgn','gdi32','iiii');
     idCreatePolygonRgn:=Declare32('CreatePolygonRgn','gdi32','pii');
     idCombineRgn:=Declare32('CombineRgn','gdi32','wwwi');

     if Call32NTError then begin
     messagebox(0,'Sorry, cannot load 32 bit system!','testw32',mb_ok);
     halt(1);
  end;


{$R *.DFM}
















end.
