{Written by Attila Szomor, his e-mail: aszomor@dravanet.hu}
Unit NewCRT;
Interface
Uses {$IfDef Win32}CRT32{$Else}CRT{$EndIf};
Const
  { CRT modes }
  BW40={$IfDef Win32}CRT32.BW40{$Else}CRT.BW40{$EndIf};
  CO40={$IfDef Win32}CRT32.CO40{$Else}CRT.CO40{$EndIf};
  BW80={$IfDef Win32}CRT32.BW80{$Else}CRT.BW80{$EndIf};
  CO80={$IfDef Win32}CRT32.CO80{$Else}CRT.CO80{$EndIf};
  Mono={$IfDef Win32}CRT32.Mono{$Else}CRT.Mono{$EndIf};
  Font8x8={$IfDef Win32}CRT32.Font8x8{$Else}CRT.Font8x8{$EndIf};
  { Mode constants for 3.0 compatibility }
  C40={$IfDef Win32}CRT32.C40{$Else}CRT.C40{$EndIf};
  C80={$IfDef Win32}CRT32.C80{$Else}CRT.C80{$EndIf};
  { Foreground and background color constants }
  Black={$IfDef Win32}CRT32.Black{$Else}CRT.Black{$EndIf};
  Blue={$IfDef Win32}CRT32.Blue{$Else}CRT.Blue{$EndIf};
  Green={$IfDef Win32}CRT32.Green{$Else}CRT.Green{$EndIf};
  Cyan={$IfDef Win32}CRT32.Cyan{$Else}CRT.Cyan{$EndIf};
  Red={$IfDef Win32}CRT32.Red{$Else}CRT.Red{$EndIf};
  Magenta={$IfDef Win32}CRT32.Magenta{$Else}CRT.Magenta{$EndIf};
  Brown={$IfDef Win32}CRT32.Brown{$Else}CRT.Brown{$EndIf};
  LightGray={$IfDef Win32}CRT32.LightGray{$Else}CRT.LightGray{$EndIf};
  { Foreground color constants }
  DarkGray={$IfDef Win32}CRT32.DarkGray{$Else}CRT.DarkGray{$EndIf};
  LightBlue={$IfDef Win32}CRT32.LightBlue{$Else}CRT.LightBlue{$EndIf};
  LightGreen={$IfDef Win32}CRT32.LightGreen{$Else}CRT.LightGreen{$EndIf};
  LightCyan={$IfDef Win32}CRT32.LightCyan{$Else}CRT.LightCyan{$EndIf};
  LightRed={$IfDef Win32}CRT32.LightRed{$Else}CRT.LightRed{$EndIf};
  LightMagenta={$IfDef Win32}CRT32.LightMagenta{$Else}CRT.LightMagenta{$EndIf};
  Yellow={$IfDef Win32}CRT32.Yellow{$Else}CRT.Yellow{$EndIf};
  White={$IfDef Win32}CRT32.White{$Else}CRT.White{$EndIf};
  { Add-in for blinking }
  Blink={$IfDef Win32}CRT32.Blink{$Else}CRT.Blink{$EndIf};

Var
  { Interface variables }
  CheckBreak: boolean {$IfDef Win32}ABSOLUTE CRT32.CheckBreak{$Else}ABSOLUTE CRT.CheckBreak{$EndIf};
  CheckEOF: boolean {$IfDef Win32}ABSOLUTE CRT32.CheckEOF{$Else}ABSOLUTE CRT.CheckEOF{$EndIf};
  DirectVideo: boolean {$IfDef Win32}ABSOLUTE CRT32.DirectVideo{$Else}ABSOLUTE CRT.DirectVideo{$EndIf};
  CheckSnow: boolean {$IfDef Win32}ABSOLUTE CRT32.CheckSnow{$Else}ABSOLUTE CRT.CheckSnow{$EndIf};
  LastMode: word {$IfDef Win32}ABSOLUTE CRT32.LastMode{$Else}ABSOLUTE CRT.LastMode{$EndIf};
  TextAttr: byte {$IfDef Win32}ABSOLUTE CRT32.TextAttr{$Else}ABSOLUTE CRT.TextAttr{$EndIf};
  WindMin: word {$IfDef Win32}ABSOLUTE CRT32.WindMin{$Else}ABSOLUTE CRT.WindMin{$EndIf};
  WindMax: word {$IfDef Win32}ABSOLUTE CRT32.WindMax{$Else}ABSOLUTE CRT.WindMax{$EndIf};

Type
  TScrBorders= (NoLine,ThinLine,DoubleLine,DoubleTop,DoubleSide,FatLine1,FatLine2,FatLine3);
Var
  NoCursor,UlCursor,InsCursor: word;

{ Interface functions & procedures }
Procedure AssignCrt(Var F: Text);
Function  KeyPressed: boolean;
Function  ReadKey: char;
Procedure TextMode(Mode: integer);
Procedure Window(X1,Y1,X2,Y2: byte);
Procedure GotoXY(X,Y: byte);
Function  WhereX: byte;
Function  WhereY: byte;
Procedure ClrScr;
Procedure ClrEol;
Procedure InsLine;
Procedure DelLine;
Procedure TextColor(Color: byte);
Procedure TextBackground(Color: byte);
Procedure LowVideo;
Procedure HighVideo;
Procedure NormVideo;
Procedure Delay(MS: word);
Procedure Sound(Hz: word);
Procedure NoSound;
{ }
Procedure FillerScreen(FillChar: Char);
Procedure WriteChrXY(X,Y: byte; Chr: char);
Procedure WriteStrXY(X,Y: byte; Str: PChar; dwSize: integer );
Procedure FlushInputBuffer;
Function  GetCursor: word;
Procedure SetCursor(NewCursor: word);
{ }
Procedure DrawBorder(X,Y,Width,Height: integer; BorderStyle:TScrBorders);
Function  GetSetCursor(NewCursor: word): word;
Procedure Play(Octave,Note,Duration: integer);
Procedure Alarm;
Procedure Siren;
Procedure Train;
Procedure PhoneRing;
Procedure Click;
Procedure Birds;
Procedure WolfWhistle;
{ }

Implementation
Type
  NotesRecord= packed Record
    C,CF,D,DF,E,F,FF,G,GF,A,AF,B: integer;
  End;
Const
  Notes: NotesRecord = (C:1;CF:2;D:3;DF:4;E:5;F:6;FF:7;G:8;GF:9;A:10;AF:11;B:12);
  BordersCh: array [TScrBorders] Of
    {$IfDef Win32}ShortString{$Else}String[10]{$EndIf}=
  (
    '          ',
    'Ŀ',
    'ͻȺ',
    '͸Գ',
    'ķӺ',
    '',
    '',
    ''
  );

Procedure AssignCrt(Var F: Text);
Begin
{$IfDef Win32}CRT32.AssignCrt(F){$Else}CRT.AssignCrt(F){$EndIf};
End;

Function KeyPressed: boolean;
Begin
  KeyPressed:={$IfDef Win32}CRT32.KeyPressed{$Else}CRT.KeyPressed{$EndIf};
End;

Function ReadKey: char;
Begin
  ReadKey:={$IfDef Win32}CRT32.ReadKey{$Else}CRT.ReadKey{$EndIf};
End;

Procedure TextMode(Mode: Integer);
Begin
{$IfDef Win32}CRT32.TextMode(Mode){$Else}CRT.TextMode(Mode){$EndIf};
End;

Procedure Window(X1,Y1,X2,Y2: byte);
Begin
{$IfDef Win32}CRT32.Window(X1,Y1,X2,Y2){$Else}CRT.Window(X1,Y1,X2,Y2){$EndIf};
End;

Procedure GotoXY(X,Y: byte);
Begin
{$IfDef Win32}CRT32.GotoXY(X,Y){$Else}CRT.GotoXY(X,Y){$EndIf};
End;

Function WhereX: byte;
Begin
  WhereX:={$IfDef Win32}CRT32.WhereX{$Else}CRT.WhereX{$EndIf};
End;

Function WhereY: byte;
Begin
  WhereY:={$IfDef Win32}CRT32.WhereY{$Else}CRT.WhereY{$EndIf};
End;

Procedure ClrScr;
Begin
{$IfDef Win32}CRT32.ClrScr{$Else}CRT.ClrScr{$EndIf};
End;

Procedure ClrEol;
Begin
{$IfDef Win32}CRT32.ClrEol{$Else}CRT.ClrEol{$EndIf};
End;

Procedure InsLine;
Begin
{$IfDef Win32}CRT32.InsLine{$Else}CRT.InsLine{$EndIf};
End;

Procedure DelLine;
Begin
{$IfDef Win32}CRT32.DelLine{$Else}CRT.DelLine{$EndIf};
End;

Procedure TextColor(Color: byte);
Begin
{$IfDef Win32}CRT32.TextColor(Color){$Else}CRT.TextColor(Color){$EndIf};
End;

Procedure TextBackground(Color: byte);
Begin
{$IfDef Win32}CRT32.TextBackground(Color){$Else}CRT.TextBackground(Color){$EndIf};
End;

Procedure LowVideo;
Begin
{$IfDef Win32}CRT32.LowVideo{$Else}CRT.LowVideo{$EndIf};
End;

Procedure HighVideo;
Begin
{$IfDef Win32}CRT32.HighVideo{$Else}CRT.HighVideo{$EndIf};
End;

Procedure NormVideo;
Begin
{$IfDef Win32}CRT32.NormVideo{$Else}CRT.NormVideo{$EndIf};
End;

Procedure Delay(MS: word);
Begin
{$IfDef Win32}CRT32.Delay(MS){$Else}CRT.Delay(MS){$EndIf};
End;

Procedure Sound(Hz: word);
Begin
{$IfDef Win32}CRT32.Sound(Hz){$Else}CRT.Sound(Hz){$EndIf};
End;

Procedure NoSound;
Begin
{$IfDef Win32}CRT32.NoSound{$Else}CRT.NoSound{$EndIf};
End;

Procedure FillerScreen(FillChar: Char);
Begin
{$IfDef Win32}
  CRT32.FillerScreen(FillChar);
{$Else}

{$EndIf}
End;

Procedure WriteChrXY(X,Y: byte; Chr: char);
Begin
{$IfDef Win32}
  CRT32.WriteChrXY(X,Y,Chr);
{$Else}
  GotoXY(X,Y);
  ASM
    {$IfDef DPMI}
      push ES;
      push DS;
      xor  AX,AX;
      push AX;
      pop  ES;
      push AX;
      pop  DX;
    {$EndIf}
    push BP;
    push DI;
    push SI;
    mov  Ah,$09;
    mov  Al,Chr;
    xor  BX,BX;
    mov  Bl,TextAttr;
    mov  CX,1;
    INT  $10;
    pop  SI;
    pop  DI;
    pop  BP;
    {$IfDef DPMI}
      pop DS;
      pop ES;
    {$EndIf}
  END;
{$EndIf};
End;

Procedure WriteStrXY(X,Y: byte; Str: PChar; dwSize: integer );
Begin
{$IfDef Win32}
  CRT32.WriteStrXY( X,Y,Str,dwSize );
{$Else}
  GotoXY(X,Y);
{$EndIf}
End;

Procedure FlushInputBuffer;
Begin
{$IfDef Win32}
  CRT32.FlushInputBuffer
{$Else}
  ASM
    {$IfDef DPMI}
      push ES;
      push DS;
      xor  AX,AX;
      push AX;
      pop  DS;
      push AX;
      pop  ES;
    {$EndIf}
      push BP;
      push DI;
      push SI;
      mov  AX,$0C06;
      mov  DX,$00FF;
      INT  $21;
      pop  SI;
      pop  DI;
      pop  BP;
    {$IfDef DPMI}
      pop  DS;
      pop  ES;
    {$EndIf}
  END;
{$EndIf};
End;

Function GetCursor: word;
{$IfNdef Win32}
Var
  wCursor: word;
{$EndIf}
begin
{$IfDef Win32}
  GetCursor:= CRT32.GetCursor;
{$Else}
  ASM
    {$IfDef DPMI}
      push ES;
      push DS;
      xor  AX,AX;
      push AX;
      pop  ES;
      push AX;
      pop  DX;
    {$EndIf}
    push BP;
    push DI;
    push SI;
    mov  AX,$0300;
    xor  BX,BX;
    INT  $10;
    pop  SI;
    pop  DI;
    pop  BP;
    {$IfDef DPMI}
      pop DS;
      pop ES;
    {$EndIf}
    mov wCursor,CX;
  END;
  GetCursor:= wCursor;
{$EndIf}
End;

Procedure SetCursor(NewCursor: word);
Begin
{$IfDef Win32}
  CRT32.SetCursor(NewCursor);
{$Else}
  ASM
    {$IfDef DPMI}
      push ES;
      push DS;
      xor  AX,AX;
      push AX;
      pop  ES;
      push AX;
      pop  DX;
    {$EndIf}
    push BP;
    push DI;
    push SI;
    mov  AX,$0100;
    xor  BX,BX;
    mov  CX,NewCursor;
    INT  $10;
    pop  SI;
    pop  DI;
    pop  BP;
    {$IfDef DPMI}
      pop DS;
      pop ES;
    {$EndIf}
  END;
{$EndIf}
End;

Procedure DrawBorder(X,Y,Width,Height: integer; BorderStyle:TScrBorders);
Const
  LeftTop= 1;
  Top= 2;
  RightTop= 3;
  RightCh= 4;
  RightBottom= 5;
  Bottom= 6;
  LeftBottom= 7;
  LeftCh= 8;
Var
  SS: {$IfDef Win32}ShortString{$Else}String{$EndIf};
  II: integer;
  PSS: PChar;
Begin
  Window(X,Y,X+Width-1,Y+Height-1);
  PSS:=@SS; Inc(PSS);
  SS:=BordersCh[BorderStyle][LeftTop];
  For II:=1 To (Width-2) Do SS:=SS+BordersCh[BorderStyle][Top];
  SS:=SS+BordersCh[BorderStyle][RightTop]+#0;
  WriteStrXY(X,Y,PSS,Length(SS)-1);
  {}
  For II:=1 To Height-2 Do Begin
    WriteChrXY(X,Y+II,BordersCh[BorderStyle][LeftCh]);
    WriteChrXY(X+Width-1,Y+II,BordersCh[BorderStyle][RightCh]);
  End;
  {}
  SS:=BordersCh[BorderStyle][LeftBottom];
  For II:=1 To (Width-2) Do SS:=SS+BordersCh[BorderStyle][Bottom];
  SS:=SS+BordersCh[BorderStyle][RightBottom]+#0;
  WriteStrXY(X,Y+Height-1,PSS,Length(SS)-1);
  Window(X+1,Y+1,X+Width-2,Y+Height-2);
End;

Function GetSetCursor(NewCursor: word): word;
Begin
  GetSetCursor:= GetCursor;
  SetCursor(NewCursor);
End;

Procedure Play(Octave,Note,Duration: integer);
Var
  II: integer;
  Frequency: real;
Begin
  Frequency:= 32.625;
  For II:= 1 To Octave Do                { Compute C in Octave             }
    Frequency := Frequency * 2;
  For II:= 1 To Note - 1 Do              { Increase frequency Note-1 times }
    Frequency:= Frequency * 1.059463094;
  If Duration <> 0 Then Begin
    Sound(Round(Frequency));
    Delay(Duration);
    NoSound;
  End Else Sound(Round(Frequency));
End;

Procedure Alarm;
Var
  II: integer;
Begin
  For II:= 1 To 7 Do
    With Notes Do Begin
      Play(4,G,70);
      Play(4,D,70);
    End;
  Delay(1000);
End;

Procedure Siren;
Var
  Frequency: integer;
Begin
  For Frequency:= 500 To 2000 Do Begin
    Delay(1);
    Sound(Frequency);
  End;
  For Frequency:= 2000 DownTo 500 Do Begin
    Delay(1);
    Sound(Frequency);
  End;
  NoSound;
End;

Procedure Train;
Var
  Frequency: integer;
Begin
  For Frequency:= 500 DownTo 250 Do Begin
    Sound(Frequency);
    Delay(7);
    NoSound;
  End;
End;

Procedure PhoneRing;
Var
  II: integer;
Begin
  For II:= 1 To 25 Do
    With Notes Do Begin
      Play(4,C,37);
      Delay(2);
      Play(4,E,18);
      Delay(4);
    End;
End;

Procedure Click;
Begin
  With Notes Do Begin
    Play(6,DF,6);
  End;
End;

Procedure Birds;
Begin
  With Notes Do Begin
    Play(6,a,40);
    Delay(50);
    Play(6,ff,60);
    Delay(50);
    Play(6,a,40);
  End;
End;

Procedure WolfWhistle;
Var
  Frequency: integer;
begin
  Frequency:= 400;
  While Frequency < 1350 Do begin
    Frequency:=Frequency+2;
    Delay(1);
    Sound(Frequency);
  End;
  NoSound;
  Delay(300);
  Frequency:=1550;
  While Frequency > 250 Do Begin
    Frequency:=Frequency-2;
    Delay(1);
    Sound(Frequency);
  End;
  NoSound;
End;

{$IfDef Win32}
initialization
{$Else}
BEGIN
{$EndIf}
  {$IfDef Win32}
    NoCursor:= $0000;
    ULCursor:= $0014;
    InsCursor:= $0063;
  {$Else}
    NoCursor:= $2000;
    ULCursor:= $0607;
    InsCursor:= $0107;
  {$EndIf}
END.
