{Written by Attila Szomor, his e-mail: aszomor@dravanet.hu}
{Based on Frank Zimmer's CRT32.TXT, his e-mail: fzimmer@compuserve.com}
Unit CRT32;
Interface
{$IfDef Win32}
  Const
    { CRT modes of original CRT unit }
    BW40          = 0;     { 40x25 B/W on Color Adapter }
    CO40          = 1;     { 40x25 Color on Color Adapter }
    BW80          = 2;     { 80x25 B/W on Color Adapter }
    CO80          = 3;     { 80x25 Color on Color Adapter }
    Mono          = 7;     { 80x25 on Monochrome Adapter }
    Font8x8       = 256;   { Add-in for ROM font }
    { Mode constants for 3.0 compatibility of original CRT unit }
    C40           = CO40;
    C80           = CO80;
    { Foreground and background color constants of original CRT unit }
    Black= 0;
    Blue= 1;
    Green= 2;
    Cyan= 3;
    Red= 4;
    Magenta= 5;
    Brown= 6;
    LightGray= 7;
    { Foreground color constants of original CRT unit }
    DarkGray= 8;
    LightBlue= 9;
    LightGreen= 10;
    LightCyan= 11;
    LightRed= 12;
    LightMagenta= 13;
    Yellow= 14;
    White= 15;
    { Add-in for blinking of original CRT unit }
    Blink= 128;

  Var
    { Interface variables of original CRT unit }
    CheckBreak: boolean;    { Enable Ctrl-Break }
    CheckEOF: boolean;      { Enable Ctrl-Z }
    DirectVideo: boolean;   { Enable direct video addressing }
    CheckSnow: boolean;     { Enable snow filtering }
    LastMode: word;         { Current text mode }
    TextAttr: byte;         { Current text attribute }
    WindMin: word;          { Window upper left coordinates }
    WindMax: word;          { Window lower right coordinates }

  { Interface functions & procedures of original CRT unit }
  Procedure AssignCrt(Var F: Text);
  Function KeyPressed: boolean;
  Function ReadKey: char;
  Procedure TextMode(Mode: integer);
  Procedure Window(X1,Y1,X2,Y2: byte);
  Procedure GotoXY(X,Y: byte);
  Function WhereX: byte;
  Function WhereY: byte;
  Procedure ClrScr;
  Procedure ClrEol;
  Procedure InsLine;
  Procedure DelLine;
  Procedure TextColor(Color: byte);
  Procedure TextBackground(Color: byte);
  Procedure LowVideo;
  Procedure HighVideo;
  Procedure NormVideo;
  Procedure Delay(MS: word);
  Procedure Sound(Hz: word);
  Procedure NoSound;
  { New functions & procedures there are not in original CRT unit }
  Procedure FillerScreen(FillChar: Char);
  Procedure WriteChrXY(X,Y: byte; Chr: char);
  Procedure WriteStrXY(X,Y: byte; Str: PChar; dwSize: integer );
  Procedure FlushInputBuffer;
  Function GetCursor: word;
  Procedure SetCursor(NewCursor: word);
{$EndIf Win32}

Implementation
{$IfDef Win32}
  Uses Windows,SysUtils;
  Type
    POpenText= ^TOpenText;
    TOpenText= Function (var F: Text; Mode: word): integer; far;

  Var
    PtrOpenText: POpenText;
    HConsoleInput: THandle;
    HConsoleOutput: THandle;
    ConsoleScreenRect: TSmallRect;
    StartAttr: word;
    LastX,LastY: byte;
    SoundDuration: integer;
    SoundFrequency: integer;
    OldCP: integer;
  {  }
  {  This function handles the Write and WriteLn commands }
  {  }
  Function TextOut( var F: Text ): integer; far;
  {$IfDef OneByOne}
    Var
      dwSize: DWORD;
  {$EndIf}
  Begin
    LastX:=WhereX;
    LastY:=WhereY;
    With TTExtRec(F) Do Begin
      {$IfDef OneByOne}
        dwSize:=0;
        While (dwSize < BufPos) Do Begin
          WriteChrXY(LastX,LastY,BufPtr[dwSize]);
          Inc(dwSize);
        End;
      {$Else}
        WriteStrXY(LastX,LastY,BufPtr,BufPos);
      {$EndIf}
      BufPos:=0;
    End;
    Result:=0;
  End;
  {  }
  {  This function handles the exchanging of Ipnout or Output }
  {  }
  Function OpenText(var F: Text; Mode: word): integer; far;
  Var
    OpenResult: integer;
  Begin
    OpenResult:=102; { Text not assigned }
    If Assigned(PtrOpenText) Then Begin
      TTextRec(F).OpenFunc:=PtrOpenText;
      OpenResult:=PtrOpenText^(F, Mode);
      If OpenResult=0 Then Begin
        If Mode=fmInput Then
          HConsoleInput:=TTextRec(F).Handle
        Else Begin
          HConsoleOutput:=TTextRec(F).Handle;
          TTextRec(Output).InOutFunc:=@TextOut;
          TTextRec(Output).FlushFunc:=@TextOut;
        End;
      End;
    End;
    Result:=OpenResult;
  End;
  {  }
  {  Filler the actual window with special character }
  {  }
  Procedure FillerScreen(FillChar: Char);
  Var
    Coord: TCoord;
    dwSize,dwCount: DWORD;
    Y: integer;
  Begin
    Coord.X:= ConsoleScreenRect.Left;
    dwSize:= ConsoleScreenRect.Right-ConsoleScreenRect.Left+1;
    For Y:=ConsoleScreenRect.Top To ConsoleScreenRect.Bottom Do Begin
      Coord.Y:= Y;
      FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
      FillConsoleOutputCharacter(HConsoleOutput,FillChar,dwSize,Coord,dwCount);
    End;
  End;
  {  }
  {  Write one character into the X,Y position }
  {  }
  Procedure WriteChrXY(X,Y: byte; Chr: char);
  Var
    Coord: TCoord;
    dwSize,dwCount: DWORD;
  Begin
    LastX:=X;
    LastY:=Y;
    Case Chr Of
      #13: LastX:=ConsoleScreenRect.Left+1;
      #10: Begin
        Inc(LastY);
      End;
      Else Begin
        Coord.X:= LastX-1+ConsoleScreenRect.Left;
        Coord.Y:= LastY-1+ConsoleScreenRect.Top;
        dwSize:=1;
        FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
        FillConsoleOutputCharacter(HConsoleOutput,Chr,dwSize,Coord,dwCount);
        Inc(LastX);
      End;
    End;
    If (LastX+ConsoleScreenRect.Left)>(ConsoleScreenRect.Right+1) Then Begin
      LastX:=1;
      Inc(LastY);
    End;
    If (LastY+ConsoleScreenRect.Top)>(ConsoleScreenRect.Bottom+1) Then Begin
      LastY:=1;
    End;
    GotoXY(LastX,LastY);
  End;
  {  }
  {  Write characterstring into the X,Y position }
  {  }
  Procedure WriteStrXY(X,Y: byte; Str: PChar; dwSize: integer );
  Var
    Coord: TCoord;
    dwCrLfPos,dwWidth: integer;
    dwCount: DWORD;
    Buffer: PChar;

    Procedure IncLine;
    Begin
      Inc(LastY);
      If (LastY+ConsoleScreenRect.Top)>(ConsoleScreenRect.Bottom+1) Then Begin
        LastY:=1;
      End;
      GotoXY(LastX,LastY);
    End;
    Procedure NewLine;
    Begin
      LastX:=1;
      IncLine;
    End;
  Begin
    If dwSize>0 Then Begin
      LastX:=X;
      LastY:=Y;
      dwCrLfPos:=Pos(#13#10,Str);
      If (dwCrLfPos>0) AND (dwCrLfPos<dwSize) Then Begin
        GetMem(Buffer,dwSize+1);
        If (dwCrLfPos-1)>0 Then Begin
          WriteStrXY(LastX,LastY,StrPCopy(Buffer,Copy(Str,1,dwCrLfPos-1)),dwCrLfPos-1);
          If ((dwSize-2)-(dwCrLfPos-1))>0 Then Begin
            WriteStrXY(LastX,LastY,StrPCopy(Buffer,Copy(Str,dwCrLfPos+2,(dwSize-2)-(dwCrLfPos-1))),(dwSize-2)-(dwCrLfPos-1));
          End Else NewLine;
        End Else NewLine;
        FreeMem(Buffer,dwSize+1);
      End Else begin
        If (LastX-1+dwSize+ConsoleScreenRect.Left)>(ConsoleScreenRect.Right+1) Then Begin
          GetMem(Buffer,dwSize+1);
          dwWidth:=ConsoleScreenRect.Right-(LastX-1+ConsoleScreenRect.Left)+1;
          If dwSize<dwWidth Then dwWidth:=dwSize;
          WriteStrXY(LastX,LastY,StrPCopy(Buffer,Copy(Str,1,dwWidth)),dwWidth);
          WriteStrXY(LastX,LastY,StrPCopy(Buffer,Copy(Str,dwWidth+1,dwSize-dwWidth)),dwSize-dwWidth);
          FreeMem(Buffer,dwSize+1);
        End Else Begin
          Coord.X:= LastX-1+ConsoleScreenRect.Left;
          Coord.Y:= LastY-1+ConsoleScreenRect.Top;
          FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
          WriteConsoleOutputCharacter(HConsoleOutput,Str,dwSize,Coord,dwCount);
          LastX:=LastX+dwSize+1;
          If (LastX+ConsoleScreenRect.Left)>(ConsoleScreenRect.Right+1) Then Begin
            NewLine;
          End Else GotoXY(LastX,LastY);
        End;
      End;
    End;
  End;
  {  }
  {  Empty the buffer }
  {  }
  Procedure FlushInputBuffer;
  Begin
    FlushConsoleInputBuffer(HConsoleInput);
  End;
  {  }
  {  Give size of actual cursor }
  {  }
  Function GetCursor: word;
  Var
    CCI: TConsoleCursorInfo;
  begin
    GetConsoleCursorInfo(HConsoleOutput,CCI);
    GetCursor:= CCI.dwSize;
  End;
  {  }
  {  Set size of actual cursor }
  {  }
  Procedure SetCursor(NewCursor: word);
  Var
    CCI: TConsoleCursorInfo;
  Begin
    If NewCursor=$0000 Then Begin
      CCI.dwSize:= GetCursor;
      CCI.bVisible:=False;
    End Else Begin
      CCI.dwSize:=NewCursor;
      CCI.bVisible:=True;
    End;
    SetConsoleCursorInfo(HConsoleOutput,CCI);
  End;
  {  }
  { --- Begin of Interface functions & procedures of original CRT unit --- }
  Procedure AssignCrt(Var F: Text);
  Begin
    Assign(F,'');
    TTextRec(F).OpenFunc:=@OpenText;
  End;

  Function KeyPressed: boolean;
  Var
    NumberOfEvents: DWORD;
    NumRead: DWORD;
    InputRec: TInputRecord;
    Pressed: boolean;
  Begin
    Pressed:=False;
    GetNumberOfConsoleInputEvents(HConsoleInput,NumberOfEvents);
    If NumberOfEvents > 0 Then Begin
      If PeekConsoleInput(HConsoleInput,InputRec,1,NumRead) Then Begin
         (*If (InputRec.EventType = KEY_EVENT) AND (InputRec{$IfDef VER90}.Event{$EndIf}.KeyEvent.bKeyDown) Then*)
         If (InputRec.EventType = KEY_EVENT) AND (InputRec.Event.KeyEvent.bKeyDown) Then
           Pressed:=True
         Else ReadConsoleInput(HConsoleInput,InputRec,1,NumRead);
      End;
    End;
    Result := Pressed;
  End;

  Function ReadKey: char;
  Var
    NumRead: DWORD;
    InputRec: TInputRecord;
  Begin
    Repeat
      Repeat
      Until KeyPressed;
      ReadConsoleInput(HConsoleInput,InputRec,1,NumRead);
(*
    Until InputRec{$IfDef VER90}.Event{$EndIf}.KeyEvent.AsciiChar>#0;
    Result:= InputRec{$IfDef VER90}.Event{$EndIf}.KeyEvent.AsciiChar;
*)
    Until InputRec.Event.KeyEvent.AsciiChar>#0;
    Result:= InputRec.Event.KeyEvent.AsciiChar;
  End;

  Procedure TextMode(Mode: Integer);
  Begin
  End;

  Procedure Window(X1,Y1,X2,Y2: byte);
  Begin
    ConsoleScreenRect.Left:= X1-1;
    ConsoleScreenRect.Top:= Y1-1;
    ConsoleScreenRect.Right:= X2-1;
    ConsoleScreenRect.Bottom:= Y2-1;
    WindMin:= (ConsoleScreenRect.Top SHL 8) OR ConsoleScreenRect.Left;
    WindMax:= (ConsoleScreenRect.Bottom SHL 8) OR ConsoleScreenRect.Right;
    {$IfDef WindowFrameToo}
      SetConsoleWindowInfo(HConsoleOutput,TRUE,ConsoleScreenRect);
    {$EndIf}
    GotoXY(1,1);
  End;

  Procedure GotoXY(X,Y: byte);
  Var
    Coord :TCoord;
  Begin
    Coord.X:= X-1+ConsoleScreenRect.Left;
    Coord.Y:= Y-1+ConsoleScreenRect.Top;
    SetConsoleCursorPosition(HConsoleOutput,Coord);
  End;

  Function WhereX: byte;
  Var
    CBI: TConsoleScreenBufferInfo;
  Begin
    GetConsoleScreenBufferInfo(HConsoleOutput,CBI);
    Result:= TCoord(CBI.dwCursorPosition).X+1-ConsoleScreenRect.Left;
  End;

  Function WhereY: byte;
  Var
    CBI: TConsoleScreenBufferInfo;
  Begin
    GetConsoleScreenBufferInfo(HConsoleOutput,CBI);
    Result:= TCoord(CBI.dwCursorPosition).Y+1-ConsoleScreenRect.Top;
  End;

  Procedure ClrScr;
  Begin
    FillerScreen(' ');
    GotoXY(1,1);
  End;

  Procedure ClrEol;
  Var
    Coord:TCoord;
    dwSize,dwCount: DWORD;
  Begin
    Coord.X:= WhereX-1+ConsoleScreenRect.Left;
    Coord.Y:= WhereY-1+ConsoleScreenRect.Top;
    dwSize:= ConsoleScreenRect.Right-Coord.Y+1;
    FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
    FillConsoleOutputCharacter(HConsoleOutput,' ',dwSize,Coord,dwCount);
  End;

  Procedure InsLine;
  Var
    SourceScreenRect: TSmallRect;
    Coord: TCoord;
    CI: TCharInfo;
    dwSize,dwCount: DWORD;
  Begin
    SourceScreenRect:= ConsoleScreenRect;
    SourceScreenRect.Top:= WhereY-1+ConsoleScreenRect.Top;
    SourceScreenRect.Bottom:=ConsoleScreenRect.Bottom-1;
    CI.AsciiChar:= ' ';
    CI.Attributes:= TextAttr;
    Coord.X:= SourceScreenRect.Left;
    Coord.Y:= SourceScreenRect.Top+1;
    dwSize:= SourceScreenRect.Right-SourceScreenRect.Left+1;
    ScrollConsoleScreenBuffer(HconsoleOutput,SourceScreenRect,NIL,Coord,CI);
    Dec(Coord.Y);
    FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
  End;

  Procedure DelLine;
  Var
    SourceScreenRect: TSmallRect;
    Coord: TCoord;
    CI: TCharinfo;
    dwSize,dwCount: DWORD;
  Begin
    SourceScreenRect:= ConsoleScreenRect;
    SourceScreenRect.Top:= WhereY+ConsoleScreenRect.Top;
    CI.AsciiChar:= ' ';
    CI.Attributes:= TextAttr;
    Coord.X:= SourceScreenRect.Left;
    Coord.Y:= SourceScreenRect.Top-1;
    dwSize:= SourceScreenRect.Right-SourceScreenRect.Left+1;
    ScrollConsoleScreenBuffer(HconsoleOutput,SourceScreenRect,NIL,Coord,CI);
    FillConsoleOutputAttribute(HConsoleOutput,TextAttr,dwSize,Coord,dwCount);
  End;

  Procedure TextColor(Color: byte);
  Begin
    LastMode:= TextAttr;
    TextAttr:= (Color AND $0F) OR (TextAttr AND $F0);
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
  End;

  Procedure TextBackground(Color: byte);
  Begin
    LastMode:= TextAttr;
    TextAttr:= (Color SHL 4) OR (TextAttr AND $0F);
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
  End;

  Procedure LowVideo;
  Begin
    LastMode:= TextAttr;
    TextAttr:= TextAttr AND $F7;
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
  End;

  Procedure HighVideo;
  Begin
    LastMode:= TextAttr;
    TextAttr:= TextAttr OR $08;
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
  End;

  Procedure NormVideo;
  Begin
    LastMode := TextAttr;
    TextAttr := StartAttr;
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
  End;

  Procedure Delay(MS: word);
  Begin
    Sleep(MS);
  End;

  Procedure Sound(Hz: word);
  Begin
    SoundFrequency:=Hz;
    Windows.Beep(Hz,SoundDuration);
  End;

  Procedure NoSound;
  Begin
    Windows.Beep(SoundFrequency,0);
  End;
  { --- End of Interface functions & procedures of original CRT unit --- }
  {  }
  Procedure Init;
  var
    CBI: TConsoleScreenBufferInfo;
    Coord: TCoord;
    cMode: DWord;
  Begin
{
    AllocConsole;
    HConsoleInput:= GetStdHandle(STD_INPUT_HANDLE);
    HConsoleOutput:= GetStdHandle(STD_OUTPUT_HANDLE);
}
    Reset(Input);
    HConsoleInput:= TTextRec(Input).Handle;
    GetConsoleMode(HConsoleInput,cMode);
    cMode:=cMode OR ENABLE_WINDOW_INPUT;
    SetConsoleMode(HConsoleInput,cMode);

    PtrOpenText:= TTextRec(Output).OpenFunc;
    ReWrite(Output);
    HConsoleOutput:= TTextRec(Output).Handle;
    TTextRec(Output).InOutFunc:=@TextOut;
    TTextRec(Output).FlushFunc:=@TextOut;

    GetConsoleScreenBufferInfo(HConsoleOutput,CBI);
    GetConsoleMode(HConsoleOutput,cMode);
    cMode:=cMode OR ENABLE_WINDOW_INPUT;
    SetConsoleMode(HConsoleOutput,cMode);

    TextAttr:= CBI.wAttributes;
    StartAttr:= CBI.wAttributes;
    LastMode:= CBI.wAttributes;

    Coord.X:= CBI.srWindow.Left;
    Coord.Y:= CBI.srWindow.Top;
    WindMin:= (Coord.Y SHL 8) OR Coord.X;
    Coord.X:= CBI.srWindow.Right;
    Coord.Y:= CBI.srWindow.Bottom;
    WindMax:= (Coord.Y SHL 8) OR Coord.X;
    ConsoleScreenRect:=CBI.srWindow;

    SoundDuration:= -1;
    OldCp:= GetConsoleOutputCP;
    SetConsoleOutputCP(1250);
  End;
  {  }
  Procedure Done;
  Begin
    SetConsoleOutputCP(OldCP);
    TextAttr:= StartAttr;
    SetConsoleTextAttribute(HConsoleOutput,TextAttr);
    ClrScr;
    FlushInputBuffer;
{
    FreeConsole;
}
  end;

  initialization
    Init;
  finalization
    Done;
{$Endif win32}
End.
