{ When given the NetWare WorkStation Number, NetID returns the
  UserID and FullName.  
  If given zero as the WorkStation Number, the Logged In User 
  details are returned.
  I have tested it with Novell Netware 3.x, 4.x and WFW, Win95.  
  Not all the code is mine.  This code is FreeWare.}

unit Netuser2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TNetID = class(TComponent)
  private    { Private declarations }
    FStationNum: byte;
    FUserID: String;
    FUserName: String;
    FDummy: String;
  protected  { Protected declarations }
  public     { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure Loaded; virtual;
    procedure SetStationNumber(StationNumber: byte);
    procedure SetID(UserId: string);
    procedure SetName(UserName : String);
  published  { Published declarations }
    Property StationNumber: byte read FStationNum write SetStationNumber;
    Property UserID: string read FUserID write SetID;
    Property UserName: string read FUserName write FDummy;
{    Property UserName: string read FUserName write SetName;}
end;

procedure Register;

implementation

constructor TNetID.Create(AOwner: TComponent);
var
  NewRect: TRect;
begin
  inherited Create(AOwner);
  SetStationNumber(0);
end;

procedure TNetID.Loaded;
begin
  inherited Loaded;	{ always call the inherited Loaded first! }
  SetStationNumber(0);
end;

{======================================================================}

{ Set my logical Station(connection)-Number }
procedure TNetID.SetStationNumber(StationNumber: byte);
var
  RetVal: Byte;
begin
  if StationNumber = 0 then begin
    asm
     MOV AH, $DC;
     INT 21H
     MOV RetVal, AL;
    end;
    FStationNum := Retval;
  end
  else
    FStationNum := StationNumber;
  SetID('Dummy');
end;


{======================================================================}

procedure TNetID.SetID(UserId: string);
var
  Request : record                     { Request buffer for "Get Conn Info" }
    Len  : Word;                       { Buffer length - 2      	    }
    Func : Byte;                       { Subfunction number ( = $16 )       }
    Conn : Byte                        { Connection number to be researched }
  end;
  Reply    : record                    { Reply buffer for "Get Conn Info"   }
    Len    : Word;                     { Buffer length - 2                  }
    ID     : Longint;                  { Object ID (hi-lo order)            }
    Obj    : Word;                     { Object type (hi-lo order again)    }
    Name   : array[ 1..48 ] of Byte;   { Object name as ASCII string        }
    Time   : array[ 1.. 7 ] of Byte;   { Y, M, D, Hr, Min, Sec, DOW         }
		                       { Y < 80 is in the next century      }
                                       { DOW = 0 -> 6, Sunday -> Saturday   }
    Filler : Byte                      { Call screws up without this!       }
  end;
  W      : Word;
  RetVal : Byte;

begin				       { "Get Connection Information"       }
  with Request do                      { Initialize request buffer:         }
  begin
    Len := 2;                          { Buffer length,                     }
    Func := $16;                       { API function,            	    }
    Conn := FStationNum;               { Returned in previous call!         }
  end;
  Reply.Len := SizeOf( Reply ) - 2;    { Initialize reply buffer length     }
  asm
   push ds
   push ss
   push es
   MOV AH, $E3;                        { Connection Services API call       }
   LEA SI, Request             	       { Location of request buffer         }
   PUSH SS
   POP DS
   LEA DI, Reply                       { Location of reply buffer           }
   PUSH SS
   POP ES
   INT 21H
   MOV RetVal, AL
   pop ES
   pop SS
   pop DS
  end;
  if ( RetVal = 0 )                     { Success code returned in AL   }
       and ( Hi( Reply.Obj ) = 1 )      { Obj of 1 is a user,           }
       and ( Lo( Reply.Obj ) = 0 ) then { stored Hi-Lo                  }
    with Reply do
    begin
      Move( Name, FUserID[ 1 ], 48 );   { Convert ASCIIZ to string      }
      FUserID[ 0 ] := #48;
      W := 1;
      while ( FUserID[ W ] <> #0 ) and ( W < 48 ) do
        Inc( W );
      FUserID[ 0 ] := Char( W - 1 )
    end
  else
    FUserID := 'Unknown';
  SetName(FUserID);
end;

{======================================================================}

procedure TNetID.SetName(UserName: String);
Type
  RequestBuffer = Record
    RequestBufferLength : Word;
    Code                : Byte;
    ObjectType          : Word;
    ObjectNameLength    : Byte;
    ObjectName          : Array[1..48] of char;
    SegmentNumber       : Byte;
    PropertyNameLength  : Byte;
    PropertyName        : Array[1..15] of char;
  end;
  ReplyBuffer = Record
    ReplyBufferLength : Word;
    PropertyValue     : Array[1..128] of char;
    MoreSegments      : Byte;
    PropertyFlags     : Byte;
  end;
Var
  Request : RequestBuffer;
  Reply   : ReplyBuffer;
  PropertyName : String[15];
  Counter : Byte;
  Temp    : String[128];
begin
 if UserName = 'Unknown' then
  FUserName := UserName
 else begin
  PropertyName := 'IDENTIFICATION';
  Request.RequestBufferLength := SizeOf(Request) - 2;
  Request.Code := $3D;
  Request.SegmentNumber := 1;
  Request.ObjectType := $0100;
  Request.ObjectNameLength := SizeOf(Request.ObjectName);
  FillChar(Request.ObjectName, SizeOf(Request.ObjectName), #0);
  For Counter := 1 to length(FUserID) do
    Request.ObjectName[Counter] := FUserID[Counter];
  Request.PropertyNameLength := SizeOf(Request.PropertyName);
  FillChar(Request.PropertyName, SizeOf(Request.PropertyName), #0);
  For Counter := 1 to Length(PropertyName) do
    Request.PropertyName[Counter] := PropertyName[Counter];
  Reply.ReplyBufferLength := SizeOf(Reply) - 2;
 asm
  PUSH SS
  PUSH DS
  MOV AH, $E3;
  LEA SI, Request
  PUSH SS
  POP DS
  LEA DI,Reply
  PUSH SS
  POP ES
  INT 21H
  POP DS
  POP SS
 end;
  Temp := '';
  Counter := 1;
  While (Reply.PropertyValue[Counter] <> #0) do begin
    Temp := Temp + Reply.PropertyValue[Counter];
    inc(Counter);
  end;
  FUserName := Temp;
 end;
end;

{======================================================================}

procedure Register;
begin
  RegisterComponents('System', [TNetID]);
end;

end.




