{==============================================================================}
{= NetUName Unit v1.2                                                         =}
{=                                                                            =}
{= The TMgNetUserName component is a 32 bit non-visual component which        =}
{= returns the Username of the user currently logged into the network.        =}
{= As it uses BDE calls, it will support any network type that is supported   =}
{= by Windows.                                                                =}
{=                                                                            =}
{= Copyright  1996 by Malcolm Groves.                                        =}
{==============================================================================}
{= History                                                                    =}
{=   13/06/96  v1.0 Initial Version                                           =}
{=   15/03/96  v1.1 Fixed memory leak in Destructor.                          =}
{=                  Altered so that FAbout object only created at design time.=}
{=   20/03/96  v1.2 Resolved some 16 bit incompatibilities.                   =}
{==============================================================================}
unit NetUName;

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, {$IFDEF WIN32} BDE, {$ELSE} DBIPROCS, DBITYPES, DBIERRS, {$ENDIF} MgCommon,
  MgAbout, DsgnIntf;

type
  TMgNetUserName = class(TComponent)
  private
    { Private declarations }
    FAbout  : TMgAboutInfo;
    FUserName : String;
    function GetMyNetUserName: String;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property UserName : string read FUserName;
  published
    { Published declarations }
    property About : TMgAboutInfo read FAbout;
    Property Name;
    Property Tag;
  end;

procedure Register;

implementation

function TMgNetUserName.GetMyNetUserName: String;
var
  TempStr : array[0..255] of char;
begin
  Check(DbiGetNetUserName(TempStr));
  Result := StrPas(TempStr);
end;

constructor TMgNetUserName.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Check(DbiInit(Nil));
  FUserName := GetMyNetUserName;

  if csDesigning in ComponentState then
  begin
    FAbout := TMgAboutInfo.Create;
    FAbout.CopyrightDate := '1996. Version 1.2';
    FAbout.Company := 'Malcolm Groves';
    FAbout.Description := 'The TMgNetUserName component returns the Username ' +
                          'of the user currently logged into the network. ' +
                          #10'As it uses BDE calls, it will support any network ' +
                          'type that is supported by Windows.';
    FAbout.URL := 'http://www.ozemail.com.au/~mgroves';
  end;

end;

destructor TMgNetUserName.Destroy;
begin
  if csDesigning in ComponentState then
    FAbout.Free;
  inherited Destroy;
end;

procedure Register;
begin
  RegisterPropertyEditor( TypeInfo(TMgAboutInfo), nil, '', TMgAboutBoxProperty);
  RegisterComponents('Malcolm Groves', [TMgNetUserName]);
end;

end.
