{==============================================================================}
{= MgAbout Unit                                                               =}
{=                                                                            =}
{= This unit defines the TMgAboutBoxProperty editor and the corresponding     =}
{= form that is displayed when invoked.                                       =}
{=                                                                            =}
{==============================================================================}


unit MgAbout;

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls,
  StdCtrls, ExtCtrls, Buttons, DsgnIntf, MgCommon, ShellAPI;

const
  mgcrHand = 5;

type
  TMgAboutBoxProperty = class( TPropertyEditor )
  public
    procedure Edit; override;
    function GetAttributes : TPropertyAttributes; override;
    function GetValue : string; override;
  end;


  TMgAboutEditDlg = class( TForm )
    BtnOk: TButton;
    Panel1 : TPanel;
    LblCopyright: TLabel;
    BtnPaletteBmp: TSpeedButton;
    LblDescription: TLabel;
    LblCompany: TLabel;
    Bevel1: TBevel;
    LblComponentName: TLabel;
    lblURL: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure lblURLMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure lblURLMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    FAboutInfo : TMgAboutInfo;
    procedure SetAboutInfo( Value : TMgAboutInfo );
  public
    ComponentName : string;
    property AboutInfo : TMgAboutInfo read FAboutInfo write SetAboutInfo;
  end;



implementation
{$R MgCursor.res}
{$R *.DFM}

uses
  SysUtils;

{=================================}
{== TRzAboutBoxProperty Methods ==}
{=================================}

function TMgAboutBoxProperty.GetAttributes : TPropertyAttributes;
begin
  Result := [ paDialog, paReadOnly ];
end;


function TMgAboutBoxProperty.GetValue : string;
begin
  Result := 'Press ... to Display';
end;


procedure TMgAboutBoxProperty.Edit;
var
  ComponentRef : TComponent;
  Dialog : TMgAboutEditDlg;
begin
  Dialog := TMgAboutEditDlg.Create( Application );
  try
    ComponentRef := GetComponent( 0 );
                                               { Get Class Name from Component }
    Dialog.ComponentName := ComponentRef.ClassName;
    Dialog.AboutInfo := TMgAboutInfo( GetOrdValue );
    Dialog.ShowModal;
  finally
    Dialog.Free;
  end;
end;


{============================}
{== TMgAboutEditDlg Methods =}
{============================}

procedure TMgAboutEditDlg.SetAboutInfo( Value : TMgAboutInfo );
var
  BmpName : array[ 0..128 ] of Char;
begin
  if ComponentName[ 1 ] = 'T' then
    LblComponentName.Caption := Copy( ComponentName, 2, 255 )
  else
    LblComponentName.Caption := ComponentName;

  LblCopyright.Caption := 'Copyright  '+ Value.CopyrightDate;
  LblCompany.Caption := Value.Company;
  LblDescription.Caption := Value.Description;
  LblURL.Caption := Value.URL;

                       { Load Component Bitmap from Delphi's Component Library }
  StrPCopy( BmpName, UpperCase( ComponentName ) );
  BtnPaletteBmp.Glyph.Handle := LoadBitmap( HInstance, BmpName );
end;



procedure TMgAboutEditDlg.FormCreate(Sender: TObject);
begin
   Screen.Cursors[ mgcrHand ] := LoadCursor( HInstance, PChar( 'MGHAND' ) );
end;

procedure TMgAboutEditDlg.lblURLClick(Sender: TObject);
var
  tempStr : array[0..255] of Char;
begin
  ShellExecute( Application.Handle, 'open', StrPCopy(tempStr, lblURL.Caption), nil, nil, SW_NORMAL );
end;

procedure TMgAboutEditDlg.lblURLMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if Button = mbLeft then begin
      Font.Color := clPurple;
   end;
end;

procedure TMgAboutEditDlg.lblURLMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then Font.Color := clBlue;
end;

end.

