unit Montr_01;

interface

uses
  MONTR_02, StdCtrls, Controls, Classes,
  Forms, ExtCtrls, Messages, SysUtils, WinTypes,
  WinProcs, Dialogs, Nbcomp, NBCONST;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label4: TLabel;
    Panel2: TPanel;
    LTime1: TLabel;
    Time1: TLabel;
    ack1: TLabel;
    Memo1: TMemo;
    Panel3: TPanel;
    LTime2: TLabel;
    Time2: TLabel;
    ack2: TLabel;
    Memo2: TMemo;
    AcknowledgeButton: TButton;
    MinimizeButton: TButton;
    CloseButton: TButton;
    NetBIOSControl1: TNetBIOSControl;
    NetBIOSControl2: TNetBIOSControl;
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure MinimizeButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure MemoEnter(Sender: TObject);
    procedure AcknowledgeButtonClick(Sender: TObject);
    procedure AppMinimize(Sender: TObject);
    procedure NetBIOSControl1Done(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  received,closing:boolean;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  splash:Tform;
begin
  caption:=application.title;
  splash:=Tform2.create(self);
  splash.show;
  splash.refresh;
  closing:=false;
  NetBIOSControl1.name:='PC_Auth_Watcher'+chr(0);
  NetBIOSControl1.execute(NB_AddGroupName);
  received:=false;
  NetBIOSControl1.execute(NB_NWReceiveDatagram);
  caption:=application.title;
  application.OnDeactivate:=AppMinimize;
  splash.release;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  ButtonSelected: Word;
begin
  ButtonSelected := MessageDlg('ARE YOU SURE!?!'+chr(13)+
                      'Doing this will prevent you from'+chr(13)+
                      'recieving PC-Auth warnings!', mtInformation,
    [mbOk, mbNo], 0);
  if ButtonSelected = mrOk then
  begin
    closing:=true;
    Application.processmessages;
    NetBIOSControl2.BufAdr:=NetBIOSControl1.Address;
    NetBIOSControl2.execute(NB_Cancel);
    repeat
      Application.processmessages;
    until received;
    NetBIOSControl1.name:='PC_Auth_Watcher'+chr(0);
    NetBIOSControl1.execute(NB_DeleteName);
    CanClose:=true;
  end
  else
    CanClose := False;
end;

procedure TForm1.NetBIOSControl1Done(Sender: TObject);
var
  p:pchar;
  buffsize:integer;
begin
  windowstate:=wsNormal;
  CloseButton.SetFocus;
  received:=true;
  time2.caption:=time1.caption;
  ack2.caption:=ack1.caption;
  memo2.text:=memo1.text;

  time1.caption:=FormatDateTime('hh:mm'+chr(13)+'dd/mm/yy',Now);
  if NetBIOSControl1.retcode=0 then
  begin
    ack1.caption:='Recieved.';
    buffsize:=NetBIOSControl1.usedbuff;
    getmem(p,buffsize);
    NetBIOSControl1.GetBuffer(p);
    Memo1.SetTextBuf(p);
    freemem(p,buffsize);
  end
  else Ack1.caption:='ERR : '+IntToStr(NetBIOSControl1.retcode);
  MessageBeep(MB_IconAsterisk);
  if not closing then
  begin
    received:=false;
    NetBIOSControl1.execute(NB_NWReceiveDatagram);
  end;
end;

procedure TForm1.AppMinimize(Sender: TObject);
begin
  windowstate:=wsMinimized;
end;

procedure TForm1.MinimizeButtonClick(Sender: TObject);
begin
  windowstate:=wsMinimized;
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  close;
end;

procedure TForm1.MemoEnter(Sender: TObject);
begin
  AcknowledgeButton.SetFocus;
end;

procedure TForm1.AcknowledgeButtonClick(Sender: TObject);
begin
  If ack1.caption<>'Unused.' then
    Ack1.caption:='Acknowledged.';
  If ack2.caption<>'Unused.' then
    Ack2.caption:='Acknowledged.';
  windowstate:=wsMinimized;
end;

end.

