{*********************************************
* TNagScreen unit for Delphi                 *
* NAG.PAS 09/19/95                           *
* Version 1.0a                               *
* By: David M. Gentils                       *
* Copyright: D & L Tech Services '95         *
**********************************************}
unit Nag;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, frmNag;

type
  TNagScreen = class(TComponent)
  private
    { Private declarations }
    FProductName: string;
    FVersion: string;
    FCopyRight: string;
    FComments: string;
    FAuthor: string;
    FAddress: string;
    FCityStateZip: string;
    FTitle: string;

  protected
    { Protected declarations }
  public
    { Public declarations }
    function Execute: Boolean;
  published
    { Published declarations }
    property ProductName: string read FProductName write FProductName;
    property Version: string read FVersion write FVersion;
    property CopyRight: string read FCopyRight write FCopyRight;
    property Comments: string read FComments write FComments;
    property Author: string read FAuthor write FAuthor;
    property Address: string read FAddress write FAddress;
    property CityStateZip: string read FCityStateZip write FCityStateZip;
    property Title: string read FTitle write FTitle;

  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Dialogs', [TNagScreen]);
end;

function TNagScreen.Execute: Boolean;
begin
     FormNag := TFormNag.Create(Application);
     try
        FormNag.ProductName.Caption := ProductName;
        FormNag.Caption := Title;
        FormNag.Version.Caption := Version;
        FormNag.CopyRight.Caption := CopyRight;
        FormNag.Comments.Caption := Comments;
        FormNag.Author.Caption := Author;
        FormNag.Address.Caption := Address;
        FormNag.CityStateZip.Caption := CityStateZip;
        FormNag.ShowModal;
     finally
        FormNag.Free;
     end;
end;

end.
