{*********************************************
* TNagScreen form unit for Delphi            *
* FRMNAG.PAS 09/19/95                        *
* Version 1.0a                               *
* Copyright: D & L Tech Services '95         *
* By: David M. Gentils                       *
**********************************************}
unit Frmnag;

interface

uses WinTypes, WinProcs, sysutils, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TFormNag = class(TForm)
    Bevel1: TBevel;
    ProductName: TPanel;
    cmdContinue: TBitBtn;
    Timer1: TTimer;
    panTime: TPanel;
    Version: TLabel;
    CopyRight: TLabel;
    Comments: TLabel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Author: TLabel;
    Address: TLabel;
    CityStateZip: TLabel;
    Bevel4: TBevel;
    procedure cmdContinueClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    TimeIndex, TotTime: Byte;
  public
    { Public declarations }
  end;

const
     MaxTime = 10; {Change this setting for
                    delay time (in Secs.)
                    Higher increases, Lower
                    decreases (Min = 0, Max = 200)}

var
  FormNag: TFormNag;

implementation
{$R *.DFM}

procedure TFormNag.cmdContinueClick(Sender: TObject);
begin
     Close; {Close Nag Form}
end;

procedure TFormNag.Timer1Timer(Sender: TObject);
begin
     Dec(TotTime);
     Inc(TimeIndex);
     panTime.Caption := IntToStr(TotTime);
     if TimeIndex >= MaxTime then
     begin
          cmdContinue.Enabled := True;
          panTime.Visible := False;
          Timer1.Enabled := False;
     end;
end;

procedure TFormNag.FormCreate(Sender: TObject);
begin
     TimeIndex := 0;
     TotTime := MaxTime;
     if MaxTime > 0 then
     begin
          panTime.Visible := True;
          panTime.Caption := IntToStr(MaxTime);
          Timer1.Enabled := True;
     end
     else
     begin
         panTime.Visible := False;
         cmdContinue.Enabled := True;
     end;
end;

end.
