{+--------------------------------------------------------------------------+
 | Component:   TmwSimpleDemo
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: Demo, how to use the TmwCustomCompoundComponent Class.
 | Version:     1.1
 | Status:      Freeware
 | DISCLAIMER: This is provided as is, expressly without a warranty of any kind.
 |             You use it at your own risc.
 +--------------------------------------------------------------------------+}

unit mwDemo;



interface

uses
  Windows, SysUtils, Messages, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, mwCuCoCo, ExtCtrls, StdCtrls, ComCtrls;

type
  TmwSimpleDemo = class(TmwCustomCompoundComponent)
    Label1: TLabel;
    ProgressBar: TProgressBar;
    Abort: TButton;
  private
    procedure SetCaption(newValue: TCaption);
    function GetCaption: TCaption;
    procedure SetMax(newValue: TProgressRange);
    function GetMax: TProgressRange;
    procedure SetMin(newValue: TProgressRange);
    function GetMin: TProgressRange;
    procedure SetPosition(newValue: TProgressRange);
    function GetPosition: TProgressRange;
    procedure SetStep(newValue: TProgressRange);
    function GetStep: TProgressRange;
    function GetOnAbortClick:TNotifyEvent;
    procedure SetOnAbortClick(value:TNotifyEvent);
  protected
    procedure SetBounds(Left, Top, Width, Height: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure StepIt;
  published
    property Caption: TCaption read GetCaption write SetCaption;
    property Max: TProgressRange read GetMax write SetMax;
    property Min: TProgressRange read GetMin write SetMin;
    property Position: TProgressRange read GetPosition write SetPosition;
    property Step: TProgressRange read GetStep write SetStep;
  property OnAbortClick:TNotifyEvent read GetOnAbortClick write SetOnAbortClick;
  end;

procedure Register;

var
  mwSimpleDemo: TmwSimpleDemo;

implementation

{$R *.DFM}

procedure Register;
begin
  RegisterComponents('mw', [TmwSimpleDemo]);
end;  { Register }

constructor TmwSimpleDemo.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Label1.ControlStyle := Label1.ControlStyle - [csSetCaption];
  Label1.Caption:= '';
end;  { Create }

destructor TmwSimpleDemo.Destroy;
begin
  inherited Destroy;
end;  { Destroy }


procedure TmwSimpleDemo.SetBounds(Left, Top, Width, Height: Integer);
begin
  inherited SetBounds(Left, Top, Width, Height);
  if Parent = nil then
    Exit;
    Label1.Left := Trunc((Width - Label1.Width)/2);
    Label1.Top := Trunc((Height - Label1.Height - ProgressBar.Height - Abort.Height - 20)/2);
    ProgressBar.Left := Trunc((Width - ProgressBar.Width)/2);
    ProgressBar.Top := (Label1.Top + Label1.Height + 5);
    Abort.Left := Trunc((Width - Abort.Width)/2);
    Abort.Top := (ProgressBar.Top + ProgressBar.Height + 15);
end;

procedure TmwSimpleDemo.SetCaption(newValue: TCaption);
begin
  Label1.Caption := newValue;
  Label1.Left := Trunc((Width - Label1.Width)/2);
end;  { SetCaption }

function TmwSimpleDemo.GetCaption: TCaption;
begin
  GetCaption := Label1.Caption;
end;  { GetCaption }

procedure TmwSimpleDemo.SetMax(newValue: TProgressRange);
begin
  ProgressBar.Max := newValue;
end;  { SetMax }

function TmwSimpleDemo.GetMax: TProgressRange;
begin
  GetMax := ProgressBar.Max;
end;  { GetMax }

procedure TmwSimpleDemo.SetMin(newValue: TProgressRange);
begin
  ProgressBar.Min := newValue;
end;  { SetMin }

function TmwSimpleDemo.GetMin: TProgressRange;
begin
  GetMin := ProgressBar.Min;
end;  { GetMin }

procedure TmwSimpleDemo.SetPosition(newValue: TProgressRange);
begin
  ProgressBar.Position := newValue;
end;  { SetPosition }

function TmwSimpleDemo.GetPosition: TProgressRange;
begin
  GetPosition := ProgressBar.Position;
end;  { GetPosition }

procedure TmwSimpleDemo.SetStep(newValue: TProgressRange);
begin
  ProgressBar.Step := newValue;
end;  { SetStep }

function TmwSimpleDemo.GetStep: TProgressRange;
begin
  GetStep := ProgressBar.Step;
end;  { GetStep }

procedure TmwSimpleDemo.StepIt;
begin
  ProgressBar.StepIt;
end;  { StepIt }

procedure TmwSimpleDemo.SetOnAbortClick(value:TNotifyEvent);
begin
  Abort.OnClick:= Value;
end;  { SetOnAbortClick }

function TmwSimpleDemo.GetOnAbortClick:TNotifyEvent;
begin
  GetOnAbortClick:= Abort.OnClick;
end;  { GetOnAbortClick }

end.

