{+--------------------------------------------------------------------------+
 | Component:   TmwCustomCompoundComponent
 | Author:      Martin Waldenburg
 | Copyright    1997, all rights reserved.
 | Description: Base class for compound components, you can design visually
 |              with help of the form editor.
 | Version:     1.1
 | Status:      Freeware
 | DISCLAIMER: This is provided as is, expressly without a warranty of any kind.
 |             You use it at your own risc.
 +--------------------------------------------------------------------------+}

unit mwCuCoCo;

interface

uses
  SysUtils, WinTypes, Classes, Graphics, Controls, ExtCtrls, Buttons, Forms, 
  Menus;

type
  TmwCustomCompoundComponent = class(TPanel)
  HeightDummy: TBevel;
  WidthDummy: TBevel;
 private
    { Private declarations }
    fTextHeight: Integer;
    procedure GetTextHeight(Reader: TReader);
    procedure SetTextHeight(Writer: TWriter);
    procedure GetPixelsPerInch(Reader: TReader);
    procedure SetPixelsPerInch(Writer: TWriter);
    procedure DefineProperties(Filer: TFiler); override;
    function RunTime: Boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Owner: TComponent); override;
  published
  end;

var
  mwCustomCompoundComponent: TmwCustomCompoundComponent;

implementation

{$R *.DFM}

{ This component has two fake properties, TextHeight and PixelsPerInch.
  The form editor stores these properties in the .DFM file, TextHeight
  always and PixelsPerInch in some cases.
  This will only be a problem if you use the form editor as a component editor.
  However what is stored in the .DFM file must be handled.
  You may use the the TextHeight Property to store any integer value. }
procedure TmwCustomCompoundComponent.DefineProperties(Filer: TFiler);
begin
  inherited DefineProperties(Filer);
  Filer.DefineProperty('TextHeight', GetTextHeight, SetTextHeight, True);
  Filer.DefineProperty('PixelsPerInch', GetPixelsPerInch, SetPixelsPerInch, False);
end;

{ Create a CustomCompoundComponent and set some default properties. }
constructor TmwCustomCompoundComponent.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  ReadComponentRes(Self.ClassName, Self);
  Align := alNone;
  BevelOuter := bvRaised;
  Caption := '';
  { Consider this is a panel. To prevent your user from dropping
    any other controls on it, you must set the ControlStyle accordingly. }
  ControlStyle := ControlStyle - [csAcceptsControls, csSetCaption];
  Height:= HeightDummy.Height;
  Width:= WidthDummy.Width;
end;

procedure TmwCustomCompoundComponent.GetTextHeight(Reader: TReader);
begin
  FTextHeight:= Reader.ReadInteger;
end;  { GetTextHeight }

procedure TmwCustomCompoundComponent.SetTextHeight(Writer: TWriter);
begin
  Writer.WriteInteger(fTextHeight);
end;  { SetTextHeight }

procedure TmwCustomCompoundComponent.GetPixelsPerInch(Reader: TReader);
begin
  { Ignore it } Reader.ReadInteger;
end;  { GetPixelsPerInch }

procedure TmwCustomCompoundComponent.SetPixelsPerInch(Writer: TWriter);
begin
  Writer.WriteInteger(0);
end;  { SetPixelsPerInch }

function TmwCustomCompoundComponent.RunTime: Boolean;
begin
  RunTime := not (csDesigning in ComponentState);
end;		{ RunTime }

end.
















end.

