unit Msgdlg;

{==========================================================================}
{ MessageDlg Replacement v1.0 for Delphi                                   }
{ (16 & 32 bits)                                                           }
{                                                                          }
{ Copyright  1997 by BitSoft Development, L.L.C.                          }
{ All rights reserved                                                      }
{                                                                          }
{ Web:     http://www.bitsoft.com                                          }
{ E-mail:  info@bitsoft.com                                                }
{ Support: tech-support@bitsoft.com                                        }
{--------------------------------------------------------------------------}
{ This file is distributed as freeware and without warranties of any kind. }
{ You can use it in your own applications at your own risk.                }
{ See the License Agreement for more information.                          }
{==========================================================================}

interface

uses
  {$ifdef Win32}
  Windows,
  {$else}
  WinProcs, Wintypes,
  {$endif}
  StdCtrls, Forms, Dialogs, Buttons, ExtCtrls;

const
  ButtonSize : Integer = 87;
  { You can change this at the beginning of an application to customize the
    size of the buttons in a message dialog box. }

  ButtonSpacing : Integer = 16;
  { You can change this at the beginning of an application to customize the
    separation of the buttons in a message dialog box. }

  MinMargin : Integer = 10;
  { The minimum space that must exist between the edges of the dialog box
    and the buttons in it. }

function MessageDialog(const Msg: string; AType: TMsgDlgType;
  AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
{ Works exactly like Delphi's MessageDlg function. }

function MessageDialogPos(const Msg: string; AType: TMsgDlgType;
  AButtons: TMsgDlgButtons; HelpCtx: Longint; X, Y: Integer): Word;
{ Works exactly like Delphi's MessageDlgPos function. }

implementation

uses SysUtils, Graphics;

{$ifdef Win32}
  {$R msgdlg32.res}
{$else}
  {$R msgdlg16.res}
{$endif}

function MessageDialog(const Msg: string; AType: TMsgDlgType;
  AButtons: TMsgDlgButtons; HelpCtx: Longint): Word;
begin
  Result := MessageDialogPos(Msg, AType, AButtons, HelpCtx, -1, -1);
end;

function MessageDialogPos(const Msg: string; AType: TMsgDlgType;
  AButtons: TMsgDlgButtons; HelpCtx: Longint; X, Y: Integer): Word;
const
  strWarning = 10;
  strError = 11;
  strInformation = 12;
  strConfirmation = 13;
const
  ButtonKinds : array [0..8] of TBitBtnKind = (bkYes, bkNo, bkOk, bkCancel,
    bkAbort, bkRetry, bkIgnore, bkAll, bkHelp);
var
  Dialog : TForm;
  i : Integer;
  LeftPos : Integer;
  ButtonsWidth : Integer;
  ButtonCount : Integer;
  ButtonList : array[0..8] of TBitBtn;
  DialogImage : TImage;
  BMPHandle : HBitmap;
  MsgText : TLabel;
  InfoWidth : Integer;
begin
  Dialog := TForm.Create(Application);
  with Dialog do
  begin
    HelpContext := HelpCtx;
    if (X < 0) or (Y < 0) then
      Position := poScreenCenter
    else
      begin
        Left := X;
        Top := Y;
      end; { else }
    Width := 230;
    Height := 125;
    BorderIcons := [biSystemMenu];
    BorderStyle := bsDialog;
    case AType of
      mtWarning:
        begin
          Caption := LoadStr(strWarning);
          BMPHandle := LoadBitmap(HInstance, MakeIntResource(500));
        end; { case of }
      mtError:
        begin
          Caption := LoadStr(strError);
          BMPHandle := LoadBitmap(HInstance, MakeIntResource(501));
        end; { case of }
      mtInformation:
        begin
          Caption := LoadStr(strInformation);
          BMPHandle := LoadBitmap(HInstance, MakeIntResource(502));
        end; { case of }
      mtConfirmation:
        begin
          Caption := LoadStr(strConfirmation);
          BMPHandle := LoadBitmap(HInstance, MakeIntResource(503));
        end; { case of }
      mtCustom: Caption := Application.Title;
    end; { case }
    LeftPos := 10;
    if AType <> mtCustom then
    begin
      DialogImage := TImage.Create(nil);
      DialogImage.Left := LeftPos;
      LeftPos := 55;
      DialogImage.Top := 8;
      DialogImage.Picture.Bitmap.Handle := BMPHandle;
      DialogImage.AutoSize := True;
      InsertControl(DialogImage);
    end; { if }
    MsgText := TLabel.Create(nil);
    with MsgText do
    begin
      AutoSize := True;
      Caption := Msg;
      Font.Name := 'MS Sans Serif';
      Font.Size := 8;
      Font.Style := [fsBold];
      InfoWidth := Width + LeftPos + 15;
      if InfoWidth > Dialog.Width then
      begin
        AutoSize := False;
        WordWrap := True;
        if InfoWidth > 380 then
          begin
            Dialog.Width := 390;
            Height := (Height * 3);
          end { if }
        else
          Dialog.Width := InfoWidth + 15;
      end; { if }
      Width := Dialog.Width - LeftPos - 15;
      Top := ((Dialog.Height - 65 - Height) shr 1);
      Left := LeftPos;
    end; { with }
    InsertControl(MsgText);
    ButtonCount := 0;
    for i := 0 to 8 do
    begin
      if TMsgDlgBtn(i) in AButtons then
      begin
       ButtonList[ButtonCount] := TBitBtn.Create(nil);
       with ButtonList[ButtonCount] do
       begin
         Kind := ButtonKinds[i];
         Caption := LoadStr(Succ(i));
         Font.Name := 'MS Sans Serif';
         Font.Size := 8;
         Width := ButtonSize;
         Height := 27;
         Spacing := -1;
       end; { with }
       Inc(ButtonCount);
     end; { if }
    end; { for }
    ButtonsWidth := (ButtonCount * (ButtonSize + 2)) + (Pred(ButtonCount) *
      ButtonSpacing);
    if (Width - (MinMargin * 2)) < ButtonsWidth then
      Width := ButtonsWidth + (MinMargin * 2);
    LeftPos := ((Width - ButtonsWidth) shr 1);
    for i := 0 to Pred(ButtonCount) do
    begin
      with ButtonList[i] do
      begin
        Top := Dialog.Height - 60;
        Left := LeftPos;
      end; { with }
      InsertControl(ButtonList[i]);
      Inc(LeftPos, ButtonList[i].Width + ButtonSpacing);
    end; { for }
  end; { with }
  Result := Dialog.ShowModal;
  Dialog.Destroy;
end;

end.
