unit MSBITBTN;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons
  ,MHooking
  ;

type
  TMSBitBtn = class(TBitBtn)
  private
    { Private declarations }
    FOnMouseOut : TNotifyEvent;
    FHighLight : TColor;
  protected
    { Protected declarations }
    OldColor : TColor;
    procedure wmMouseMove(var Msg : TMessage); message WM_MOUSEMOVE;
    procedure wmMouseOut(var Msg : TMessage); message WM_MOUSEOUT;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
    property OnMouseOut : TNotifyEvent read FOnMouseOut write FOnMouseOut;
    property HighLight : TColor read FHighLight write FHighLight;
  end;

procedure Register;

implementation

constructor TMSBitBtn.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
end;

procedure TMSBitBtn.wmMouseOut(var Msg : TMessage);
begin
  if NOT(csDesigning in ComponentState) then
    ReleaseMouseHook;
  Font.Color := OldColor;
  if Assigned(FOnMouseOut) then
    OnMouseOut(self);
end;

procedure TMSBitBtn.wmMouseMove(var Msg : TMessage);
begin
  if NOT(csDesigning in ComponentState) then
    if SetMouseHook(self.Handle) then begin
      OldColor := Font.Color;
      Font.Color := FHighLight;
      end;
  inherited;
end;

procedure Register;
begin
  RegisterComponents('Kemna', [TMSBitBtn]);
end;

end.
