unit Umontre;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Menus, StdCtrls, inifiles, MPlayer;

type
  TFmontre1 = class(TForm)
    Timer1: TTimer;
    PopupMenu1: TPopupMenu;
    Fermer1: TMenuItem;
    Toujoursvisible1: TMenuItem;
    Apropos1: TMenuItem;
    Image1: TImage;
    Icone1: TMenuItem;
    Image2: TImage;
    Alarme1: TMenuItem;
    WP1: TMediaPlayer;
    procedure Timer1Timer(Sender: TObject);
    procedure Fermer1Click(Sender: TObject);
    procedure Toujoursvisible1Click(Sender: TObject);
    procedure Apropos1Click(Sender: TObject);
    procedure Icone1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure Alarme1Click(Sender: TObject);
  private
    { Private declarations }
    rect : Trect;
    CX,CY,RH,RM,RS,DTX,DTY,DNX,DNY : integer;
  public
    ALH,ALM,ATOP : integer;
    { Public declarations }
  end;

var
  Fmontre1: TFmontre1;

implementation

uses

  uabout,ualarme;

{$R *.DFM}

procedure TFmontre1.Timer1Timer(Sender: TObject);
var
  MyNow      : TDateTime;
  Hour, Min,
  Sec, mSec  : Word;
  Annee,Mois,Jour : Word;
  vh, vm, vs : Real;
begin
  MyNow := Now;
  DecodeTime(MyNow,Hour,Min,Sec,mSec);
  DecodeDate(MyNow, Annee, Mois, Jour);

  vh := ((Hour/12.0)+((Min/60)/12))*2*Pi;
  vm := Min/60.0*2*Pi;
  vs := Sec/60.0*2*Pi;

  with Fmontre1.Image1.Canvas do
  begin
    image1.Canvas.draw(0,0,image2.picture.bitmap);
    image1.Canvas.Pen.Color := clBlack;

    if DNX>0 then image1.Canvas.TextOut(DNX,DNY,inttostr(Jour));
    if DTX>0 then image1.Canvas.TextOut(DTX,DTY,FormatDateTime('ddd', Now));

    Pen.Color := clBlack;
    Pen.width := 3;
    MoveTo(cx,cy);
    LineTo(cx+Round(RH*Sin(vh)),cy-Round(RH*Cos(vh)));
    LineTo(cx-Round((RH div 4)*Sin(vh)),cy+Round((RH div 4)*Cos(vh)));
    MoveTo(cx,cy);
    LineTo(cx+Round(RM*Sin(vm)),cy-Round(RM*Cos(vm)));
    LineTo(cx-Round((RH div 4)*Sin(vm)),cy+Round((RH div 4)*Cos(vm)));
    Pen.width := 3;
    MoveTo(cx,cy);
    LineTo(cx-Round((RH div 4)*Sin(vs)),cy+Round((RH div 4)*Cos(vs)));
    Pen.width := 1;
    MoveTo(cx,cy);
    LineTo(cx+Round(RS*Sin(vs)),cy-Round(RS*Cos(vs)));

    if ATOP=1 then
    begin
      if (hour=ALH) and ((Min>=ALM) and (Min<ALM+5)) then
      begin
          WP1.play;
      end;
    end;
  end;
end;

procedure TFmontre1.Fermer1Click(Sender: TObject);
begin
  close;
end;


procedure TFmontre1.Toujoursvisible1Click(Sender: TObject);
begin
  if(Fmontre1.formstyle=fsNormal) then
  begin
    Fmontre1.formstyle:=fsStayOnTop;
    Toujoursvisible1.caption:='Fentre normale';
  end
  else
  begin
    Fmontre1.formstyle:=fsNormal;
    Toujoursvisible1.caption:='Avant plan';
  end;
end;

procedure TFmontre1.Apropos1Click(Sender: TObject);
begin
  aboutbox1:=TAboutBox1.create(self);
  aboutbox1.L1.caption:=caption;
  aboutbox1.show;
end;

procedure TFmontre1.Icone1Click(Sender: TObject);
begin
  Fmontre1.WindowState:=wsMinimized;
end;


procedure TFmontre1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
action:=cafree;
end;

procedure TFmontre1.FormCreate(Sender: TObject);
var
  WinIni: TIniFile;
begin
  WinIni := TIniFile.Create('montre.Ini');
  with WinIni do
  begin
    CX:=ReadInteger('MONTRE', 'CENTERX', -1);
    CY:=ReadInteger('MONTRE', 'CENTERY', -1);
    RH:=ReadInteger('MONTRE', 'RAY_H', -1);
    RM:=ReadInteger('MONTRE', 'RAY_M', -1);
    RS:=ReadInteger('MONTRE', 'RAY_S', -1);
    Fmontre1.caption:=ReadString('MONTRE', 'TITLE', 'Gasp Software');
    Image2.picture.loadfromfile(ReadString('MONTRE', 'PICTURE', 'Montre.bmp'));
    Fmontre1.height:=Image2.picture.height;
    Fmontre1.width:=Image2.picture.width;
    DTX:=ReadInteger('DATE', 'DTX', -1);
    DTY:=ReadInteger('DATE', 'DTY', -1);
    DNX:=ReadInteger('DATE', 'DNX', -1);
    DNY:=ReadInteger('DATE', 'DNY', -1);
    ALH:=ReadInteger('ALARM', 'HOUR', -1);
    ALM:=ReadInteger('ALARM', 'MIN', -1);
    ATOP:=ReadInteger('ALARM', 'TOP', -1);
    WP1.Filename:=ReadString('ALARME', 'SOUND', 'msremind.wav');
  end;
  Winini.free;
end;

procedure TFmontre1.Alarme1Click(Sender: TObject);
begin
  falarme1:=Tfalarme1.create(self);
  falarme1.Spinedit1.value:=ALH;
  falarme1.Spinedit2.value:=ALM;
  if ATOP=0 then falarme1.Checkbox1.State:=cbUnchecked
  else falarme1.Checkbox1.State:=cbChecked;
  falarme1.show;
end;

end.
