unit Modlstu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Listboxt, ToolHelp, TabNotBk, Tabs, Buttons,
  Grids, ExtCtrls;

type
  TForm1 = class(TForm)
	 grdInfo: TStringGrid;
	 RadioGroup1: TRadioGroup;
	 RadioButton1: TRadioButton;
	 RadioButton2: TRadioButton;
	 RadioButton3: TRadioButton;
	 RadioButton4: TRadioButton;
	 RadioButton5: TRadioButton;
	 procedure FormCreate(Sender: TObject);
	 procedure SelectTypeClick( Sender : TObject );
	 procedure SortGrid( const ColNum : integer );
    procedure grdInfoMouseDown(Sender: TObject; Button: TMouseButton;
		Shift: TShiftState; X, Y: Integer);

  private
	 { Private declarations }
  public
	 { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin

	{ initialise column headings and set widths }
	grdInfo.Cells[0,0] := 'Module';
	grdInfo.ColWidths[0] := grdInfo.Canvas.TextWidth('X') * 9;	{ 8 chars + 1 }

	grdInfo.Cells[1,0] := 'Usage';
	grdInfo.ColWidths[1] := grdInfo.Canvas.TextWidth('Usage');	{ should be small }

	grdInfo.Cells[2,0] := 'Size';
	grdInfo.ColWidths[2] := grdInfo.Canvas.TextWidth('8') * 9;	{ very big number }

	grdInfo.Cells[3,0] := 'Date';
	grdInfo.ColWidths[3] := grdInfo.Canvas.TextWidth('X') * 16;	{ big enough? }

	grdInfo.Cells[4,0] := 'Path';
	grdInfo.ColWidths[4] := grdInfo.Canvas.TextWidth('X') * 65; { 64 chars + 1 }

	{ fire up the analysis }
	SelectTypeClick( RadioButton1 );
	RadioButton1.Checked := True;
end;

procedure TForm1.SelectTypeClick(Sender: TObject);

var
	strTemp    : String;
	strType    : string;
	StrModule  : String;
	strExePath : string;
	Module     : TModuleEntry;
	FSearchrec : TSearchRec;
	FindResult : integer;
	i          : integer;

begin { TForm1.SelectTypeClick }
	{ clear the grid }
	grdInfo.RowCount := 2;
	grdInfo.Cells[0,1] := '';
	grdInfo.Cells[1,1] := '';
	grdInfo.Cells[2,1] := '';
	grdInfo.Cells[3,1] := '';
	grdInfo.Cells[4,1] := '';

	i := 1;
	strType := TRadioButton( Sender ).Caption;
	Module.dwSize := SizeOf(Module);

	if ModuleFirst(@Module) then begin
		repeat
			strExePath := strpas(Module.szExepath);
			FindResult := FindFirst(strExePath, faAnyFile, FSearchRec);
			strTemp := Copy(strExepath, length(strExepath)-2,3);

			if uppercase(strTemp) = uppercase(strType) then begin
				grdInfo.Cells[0,i] := StrPas(Module.szModule);
				grdInfo.Cells[1,i] := FormatFloat('##', Module.wUsageFlags);
				grdInfo.Cells[2,i] := FormatFloat('###,###,##0',FSearchrec.size);
				grdInfo.Cells[3,i] := FormatDateTime( 'c', FileDateToDateTime(FSearchRec.Time));
				grdInfo.Cells[4,i] := strExePath;

				grdInfo.RowCount := grdInfo.RowCount + 1;
				Inc( i );
			end;
		until ModuleNext(@Module) = False;
	end
	else
		grdInfo.Cells[0,i] := '(none)';

end; { TForm1.SelectTypeClick }

procedure TForm1.grdInfoMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);

var
	c, r : longint;

begin

	if (Button = mbLeft) and (Shift = [ssLeft]) then begin
		grdInfo.MouseToCell( X, Y, c, r );

		{ only sort if clicked on title row and either module name or path name }
		if (r = 0) and ((c = 0) or (c = 4)) then SortGrid( c );
	end;

end;

{ --------------------------------------------------------------------------- }
{ SortGrid -- sort the grid on the given column                               }
{    Uses a simple bubble sort - assume relatively few entries                }
{ --------------------------------------------------------------------------- }
procedure TForm1.SortGrid( const ColNum : integer );

var
	bSorted  : boolean;
	sTmpVal  : string;
	i, j     : integer;

begin { TForm1.SortGrid }

	Screen.Cursor := crHourGlass;
	bSorted := False;

	while not bSorted do begin
		bSorted := True;

		for i := 1 to grdInfo.RowCount-2 do begin
			if  (grdInfo.Cells[ColNum,i] > grdInfo.Cells[ColNum,i+1])
			and (grdInfo.Cells[0,i+1] <> '') then begin
				bSorted := False;

				for j := 0 to 4 do begin
					sTmpVal := grdInfo.Cells[j,i];
					grdInfo.Cells[j,i] := grdInfo.Cells[j,i+1];
					grdInfo.Cells[j,i+1] := sTmpVal;
				end;
			end;
		end;
	end;

	Screen.Cursor := crDefault;

end; { TForm1.SortGrid }

end.
