unit NewGameUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TNewGameForm = class(TForm)
    BoardSizeGroup: TGroupBox;
    HorSizeSlider: TTrackBar;
    VertSizeSlider: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    OkBtn: TButton;
    CancelBtn: TButton;
    NoMinesSlider: TTrackBar;
    ColEdit: TEdit;
    RowEdit: TEdit;
    MineEdit: TEdit;
    Label3: TLabel;
    procedure OkBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure HorSizeSliderChange(Sender: TObject);
    procedure VertSizeSliderChange(Sender: TObject);
    procedure NoMinesSliderChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  NewGameForm: TNewGameForm;

implementation

{$R *.DFM}

procedure TNewGameForm.OkBtnClick(Sender: TObject);
begin
  ModalResult := mrOk;
end;

procedure TNewGameForm.CancelBtnClick(Sender: TObject);
begin
  { Abort New Game }
  ModalResult := mrCancel;
end;

procedure TNewGameForm.HorSizeSliderChange(Sender: TObject);
begin
  { Update Columns Edit }
  ColEdit.Text := IntToStr(HorSizeSlider.Position);
end;

procedure TNewGameForm.VertSizeSliderChange(Sender: TObject);
begin
  { Update Rows Edit }
  RowEdit.Text:= IntToStr(VertSizeSlider.Position);
end;

procedure TNewGameForm.NoMinesSliderChange(Sender: TObject);
begin
  { Update Mines Edit }
  MineEdit.Text:=IntToStr(NoMinesSlider.Position);
end;

end.
