unit MenuBut;

{TDirMenuButton: Version 1.0  07/07/1999

Bouton de la Classe TSpeedButton: Pour Delphi 1 et 2 (3,4,5: Pas essay !!)
   Click Normal: Ouvre un menu contenant les
                 Sous rpertoires de "Directory".
   Click Droit: Remonte au Rpertoire PARENT de "Directory".
                Arriv  la racine propose le choix d'un disque.

Proprits ajoutes:

AddAntiSlash: Ajoute ou enlve le caratre: "\"  la fin du
              nom du rpertoire.
Directory:    Rpertoire  partir duquel s'effectue les actions.
DirSorted:    Trie ou NON, dans le menu, les rpertoires par
              ordre Alphabtique.
RightClickOn: Permet ou empche la remonte au rpertoire Parent
              par Click Droit SUR le bouton.
              (J'ai ajout cela au cas ou il y ait un menu PopUp
              pour la Form propritaire.)

Evnement Ajout:

DirChange:  A chaque fois que "Directory" change par Click sur le
            Bouton. NewDir est le nom du Nouveau rpertoire Choisi.

Fonctions:

GetPrevDir: Donne le rpertoire Parent, Permet d'agir
            lorsque RightClickOn est  False.
            "AntiSlash" Ajoute un "\"  la fin s'il est  True.
RepExiste:  Dit si un rpertoire existe.
            Aprs essais: si Rep='A:\' (par exemple) permet de dire si
            le Lecteur A est plein ou non (Fonctionne mieux dans D2
            que D1).
GetListDiscs: Donne la liste des disques installs sur le systme.

Ces fonctions peuvent tre appeles SANS placer un bouton
TDirMenuButton sur la Form, Juste en mettant MenuBut dans Uses.
}

{=====================================================================

How to use ????

   Put a DirMenuButton on a Form and put a Label.
   In DirMenuButton1.OnDirChange write:
       Label1.Caption:=NewDir;
   Run and see what happens when you Click or Right Click on 
the DirMenuButton.

=====================================================================}

{Freeware by Mezou Prod:

*********************************************************************
Si votre ordinateur casse, dites pas que c'est de ma faute !!!
Ce composant est fourni SANS AUCUNE garanties.
*********************************************************************

VOUS POUVEZ:

   Distribuer: Distribuez l'archive COMPLETE MenuBut.zip.

   Utiliser GRATUITEMENT ce composant. Juste un petit mot
                          pour me rappeler combien je suis gnial.
   Modifier ce composant; Expdiez moi le rsultat  quel point
                          j'ai manqu d'ide ou fais des co....
Vous pouvez ENFIN traduire en anglais tous les commentaires et
            m'expdier la traduction pour bien me montrer
            comme je suis NUL en Anglais.

And Now, in ENGLISH... (Don't laugh !!!)
             
You can use, distribute and modify, 
just tell me what you do with this component.

JJ Rou
GrandChamp
71160 Rigny Sur Arroux
Charollais
Bourgogne
France

   EMail: jean-jacques.roue@worldonline.fr
or
   EMail: jjroue@ifrance.com
   Web: None

Passons aux choses srieuses...}

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons,Menus;

type
   TDMBDirChange=procedure(Sender:TObject;NewDir:String) of Object;

  TDirMenuButton = class(TSpeedButton)
  private
    { Dclarations prives }
    FPop:TPopupMenu;
    FSousPop:TMenuItem;
    FListDir:TStringList;
    FButtonDown,
    FRightClickOn,
    FDirSorted,
    FAddAntiSlash:Boolean;
    FDir:String;
    FChange:TDMBDirChange;

    Procedure MenuClicked(Sender:TObject);
    Procedure SetFAddAntiSlash(Value:Boolean);
    Procedure SetFDir(Value:String);

  protected
    { Dclarations protges }
    procedure MouseDown(Button: TMouseButton; Shift:
            TShiftState; X, Y: Integer);Override;
    procedure MouseUp(Button: TMouseButton; Shift:
            TShiftState; X, Y: Integer);Override;

  public
    { Dclarations publiques }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;


  published
    { Dclarations publies }
  {Rpertoire  partir duquel s'effectue les actions.}
  Property Directory:String Read FDir Write SetFDir;
  {Enabled or Not the RightClick Action.}
  Property RightClickOn:Boolean read FRightClickOn Write FRightClickOn;
  Property DirSorted:Boolean Read FDirSorted Write FDirSorted;
  {Add or Subtract the "\" Character.}
  Property AddAntiSlash:Boolean Read FAddAntiSlash Write SetFAddAntiSlash;
  {Event: When Directory Change.}
  Property OnDirChange:TDMBDirChange Read FChange Write FChange;
  end;

{FUNCTION POUVANT ETRE APPELEES DE L'EXTERIEUR:}
{Donne le rpertoire Parent.}
{Get the Parent Folder of OldDir.}
Function GetPrevDir(OldDir:String;AntiSlash:Boolean):String;
{Le rpertoire Rep existe-t-il ???}
{Check if Dir "REP" Exists.}
Function RepExiste(Rep:String):Boolean;
{Rechercher les disques du Systme.}
Function GetListDiscs:String;

procedure Register;

implementation

{Get the Parent Folder of OldDir.}
Function GetPrevDir(OldDir:String;AntiSlash:Boolean):String;
var
Fxx:Integer;
begin
   {Ne pas Remonter au del de la racine.}
   if Length(OldDir)=3 then
   begin
   GetPrevDir:=OldDir;
   Exit;
   end;
   {Enlever l'antiSlash au cas ou...}
   if OldDir[Length(OldDir)]='\'
   then OldDir:=Copy(OldDir,1,Length(OldDir)-1);
   {Chercher l'antiSlash Prcdent.}
   for Fxx:=0 to 100 do
   begin
      if OldDir[Length(OldDir)-Fxx]='\' then
      begin
      OldDir:=Copy(OldDir,1,Length(OldDir)-Fxx-1);
      Break;
      end;
   end;
   {Add the "\" Character.}
   if AntiSlash
   or(Length(OldDir)<3)
   then Result:=OldDir+'\'
   else Result:=OldDir;
end;

{Check if Dir "REP" Exists.}
Function RepExiste(Rep:String):Boolean;
var
FSrCh:TSearchRec;
Begin
Result:=False;
  {$IFDEF WIN32}
  Rep:=Trim(Rep);
  {$ELSE}

  {$ENDIF}
   {False si Chaine Vide ou avec un seul caractre}
   If (Rep='')
   or (Length(Rep)=1)
   then Exit;
   {Ajouter un AntiSlash au cas ou...}
   if Rep[Length(Rep)]<>'\'
   then Rep:=Rep+'\';
Result:=(SysUtils.FindFirst(Rep+'*.*',faDirectory,FSrCh)=0);
{Ne SURTOUT pas OUBLIER FindClose.}
SysUtils.FindClose(FSrCh);
   if Not Result
   and (Length(Rep)=3)
   then ShowMessage('Le lecteur: "'+Rep+'" est vide !!');
end;

{Rechercher les disques du Systme.}
Function GetListDiscs:String;
Var
x:Integer;
Ch:Char;
Begin
Result:='';
  {$IFDEF WIN32}
   for Ch:='A' to 'Z' do
   begin
      if GetDriveType(PChar(Ch+':\'))>1
      then Result:=Result+Ch;
   end;
  {$ELSE}
   for x:=0 to 25 do
   begin
   Ch:=Chr(x+ord('A'));
      if GetDriveType(x)<>0
      then Result:=Result+Ch;
   end;
  {$ENDIF}
end;

{Cration.}
constructor TDirMenuButton.Create(AOwner : TComponent );
begin
   inherited Create(AOwner);
FListDir:=TStringList.Create;
FRightClickOn:=True;
FDirSorted:=True;
FAddAntiSlash:=True;
{On dit que Directory est l o on est.}
GetDir(0,FDir);
Fdir:=Fdir+'\';
end;

{On casse TOUT...}
destructor TDirMenuButton.Destroy;
begin
FListDir.Free;
   if FPop<>Nil
   then Fpop.Free;
   inherited Destroy;

end;

{Ajoute ou Enlve l'AntiSlash.}
{Add or Substract the "\" Character.}
Procedure TDirMenuButton.SetFAddAntiSlash(Value:Boolean);
begin
   if Value=FAddAntiSlash
   then Exit;
FAddAntiSlash:=Value;
   {if Not RepExiste(Directory)
   then Exit;}
   If FAddAntiSlash
   and(Directory[Length(Directory)]<>'\')
   then Directory:=Directory+'\';
   if Not FAddAntiSlash
   and(Length(Directory)>3)
   and(Directory[Length(Directory)]='\')
   then Directory:=Copy(Directory,1,Length(Directory)-1);
   if Assigned(FChange)
   Then FChange(Self,Directory);
end;

{Vrifier Directory.}
{Verify Directory.}
Procedure TDirMenuButton.SetFDir(Value:String);
begin
   if Value=FDir
   then Exit;
   If RepExiste(Value) then
   begin
      If FAddAntiSlash
      and(Value[Length(Value)]<>'\')
      then Value:=Value+'\';
      if Not FAddAntiSlash
      and(Length(Value)>3)
      and(Value[Length(Value)]='\')
      then Value:=Copy(Value,1,Length(Value)-1);
   FDir:=Value;
      if Assigned(FChange)
      Then FChange(Self,Directory);
   end
   else Directory:=FDir;
end;

procedure TDirMenuButton.MouseDown(Button: TMouseButton; Shift:
TShiftState; X, Y: Integer);
begin
FButtonDown:=True;
   Inherited MouseDown(Button,Shift,X,Y);

end;

procedure TDirMenuButton.MouseUp(Button: TMouseButton; Shift:
TShiftState; X, Y: Integer);
var
FSrCh:TSearchRec;
FResult,Fxx:Integer;
FP:TPoint;
FStr:String;
MenuExists:Boolean;
Begin
   if (Not FButtonDown)then
   begin
    Inherited MouseUp(Button,Shift,X,Y);
   exit;
   end;
FDir:=Directory;
   if FDir[Length(FDir)]<>'\'
   then FDir:=FDir+'\';
MenuExists:=False;
   {Faire le Menu avec les SOUS rpertoires.}
   if Button=mbLeft then
   begin
   {Dtruire le Menu.}
   FPop.Free;
   {Vider la liste.}
   FListDir.Clear;
   {La Recherche des Rpertoires.}
   FResult:=SysUtils.FindFirst(FDir+'*.*',faDirectory,FSrCh);
      While FResult=0 do
      begin
         if (FSrCh.Attr and faDirectory)>0 then
         begin
            {Ajouter  la liste.}
            if (FSrCh.Name<>'.')and(FSrCh.Name<>'..')
            then FListDir.Add(FDir+FSrCh.Name);
         end;
      FResult:=SysUtils.FindNext(FSrCh);
      end;
   SysUtils.FindClose(FSrCh);
   {Fin de la recherche des rpertoires.}
   {Cration du Menu.}
   FPop:=TPopupMenu.Create(Owner);
   MenuExists:=True;
      {Si il y a des rpertoires  afficher:}
      if FListDir.Count>0 then
      begin
         {Trier la liste des rpertoires.}
         if FDirSorted
         then FListDir.Sort;
         {Cration des MenuItems.}
         for Fxx:=0 to FListDir.Count-1 do
         begin
         FSousPop:=TMenuItem.Create(FPop);
         FSousPop.Caption:=FListDir[Fxx];
         FSousPop.OnClick:=MenuClicked;
         {Ajouter le MenuItem au Menu.}
         FPop.Items.Add(FSousPop);
         end;
      end;

   end;
   {Remonter d'un rpertoire.}
   if Button=mbRight then
   begin
      if FRightClickOn then
      begin
         {Si Racine, on propose TOUS les lecteurs.}
         if Length(FDir)=3 then
         begin
         {Dtruire le Menu.}
         FPop.Free;
         {Ajouter un truc  la liste.}
         FListDir.Add('Truc');
         FStr:=GetListDiscs;
         {Cration du Menu.}
         FPop:=TPopupMenu.Create(Owner);
         MenuExists:=True;
            for Fxx:=1 to Length(FStr) do
            begin
            FSousPop:=TMenuItem.Create(FPop);
            FSousPop.Caption:=FStr[Fxx]+':\';
               if FSousPop.Caption=Copy(FDir,1,3)
               then FSousPop.Checked:=true;
            FSousPop.OnClick:=MenuClicked;
            {Ajouter le MenuItem au Menu.}
            FPop.Items.Add(FSousPop);
            end;
        end
        else Directory:=GetPrevDir(FDir,FAddAntiSlash);
      end;
   end;
   if MenuExists then
   begin
   {Cration d'un MenuItem qui affichera "Annuler"
   OU "Pas de Sous Rpertoire !" si on n'a pas
   trouv de Sous Rpertoire.}
   FSousPop:=TMenuItem.Create(FPop);
      if FListDir.Count=0
      then FSousPop.Caption:='Pas de Sous Rpertoire !'
      else FSousPop.Caption:='Annuler.';
   {Ajouter le MenuItem au Menu.}
   FPop.Items.Add(FSousPop);
   {Positionner le Menu SOUS le bouton.}
   FP:=Point(0,height);
   FP:=ClientToScreen(FP);
   {Montrer le Menu.}
   FPop.PopUp(FP.x,FP.y);
   end;
FButtonDown:=False;
   Inherited MouseUp(Button,Shift,X,Y);

end;

{Quand on clique sur un lment du menu.}
Procedure TDirMenuButton.MenuClicked(Sender:TObject);
Begin
Directory:=TMenuItem(Sender).Caption;
end;

procedure Register;
begin
  RegisterComponents('Mezou', [TDirMenuButton]);
end;

end.
