unit Menu1;

interface

uses
  {$IFDEF WIN32}
  Windows,
  {$ELSE}
  WinTypes, WinProcs,
  {$ENDIF}Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, MenuBut, ExtCtrls;

type
  TForm1 = class(TForm)
    DirMenuButton1: TDirMenuButton;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Button1: TButton;
    Edit1: TEdit;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Label2: TLabel;
    Panel1: TPanel;
    Label3: TLabel;
    DirMenuButton2: TDirMenuButton;
    procedure Label1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure DirMenuButton1DirChange(Sender: TObject; NewDir: string);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure DirMenuButton2DirChange(Sender: TObject; NewDir: string);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Procedure ListerFichiers(PathName:String);
var
SrCh:TSearchRec;
Result:Integer;
x:LongInt;
S:String;
begin
Form1.ListBox1.Clear;
{La Recherche des fichiers.}
   if PathName[Length(PathName)]<>'\'
   then PathName:=PathName+'\';
Result:=FindFirst(PathName+'*.*',faAnyFile,SrCh);
   While Result = 0 do
   begin
      if (SrCh.Attr and faDirectory)>0 then
      {begin
         if (SrCh.Name<>'.')and(SrCh.Name<>'..')
         then Form1.ListBox1.Items.Add(SrCh.Name+'     (Rep)');
      end}
      else
      begin
      S:=SrCh.Name;
      x:=SrCh.Size;
         if x>1024
         then S:=S+Format('          %.2n  Ko',[x/1024])
         else S:=S+Format('          %.2d  Oct',[x]);
      Form1.ListBox1.Items.Add(S);
      end;
   Result:=FindNext(SrCh);
   end;
FindClose(SrCh);
{Fin de la recherche.}
   if Form1.ListBox1.Items.Count=0
   then Form1.ListBox1.Items.Add('Pas de Fichiers...');
end;

procedure TForm1.FormCreate(Sender: TObject);
var
S:String;
x:Integer;
begin
Label1.Caption:=DirMenuButton1.Directory;
CheckBox1.Checked:=DirMenuButton1.DirSorted;
CheckBox2.Checked:=DirMenuButton1.AddAntiSlash;
CheckBox3.Checked:=Not DirMenuButton1.RightClickOn;
{Montrere les fichiers du rpertoire.}
ListerFichiers(Label1.Caption);
{Chercher les disques du systme.}
S:=GetListDiscs;
   For x:=1 to Length(S)
   do ListBox2.Items.Add(S[x]);
ListBox2.Columns:=ListBox2.Items.Count;
ListBox2.ItemIndex:=ListBox2.Items.IndexOf(DirMenuButton1.Directory[1]);

{Juste un DirMenuButton et OnDirChange:}
DirMenuButton2.Caption:=DirMenuButton2.Directory;
end;

procedure TForm1.DirMenuButton1DirChange(Sender: TObject; NewDir: string);
begin
Label1.Caption:=NewDir;
ListBox2.ItemIndex:=ListBox2.Items.IndexOf(NewDir[1]);
ListerFichiers(Label1.Caption);
end;

procedure TForm1.Label1Click(Sender: TObject);
begin
Label1.Caption:=GetPrevDir(Label1.Caption,DirMenuButton1.AddAntiSlash);
DirMenuButton1.Directory:=Label1.Caption;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
DirMenuButton1.DirSorted:=CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
DirMenuButton1.AddAntiSlash:=CheckBox2.Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
DirMenuButton1.RightClickOn:=Not CheckBox3.Checked;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
DirMenuButton1.Directory:=Edit1.Text;
end;

{Changer de Disque.}
procedure TForm1.ListBox2Click(Sender: TObject);
var
S:String;
begin
S:=ListBox2.Items[ListBox2.ItemIndex]+':\';
   if RepExiste(S)then
   begin
   DirMenuButton1.Directory:=S;
   end
   else ShowMessage('Le Lecteur: "'+S+'" est vide !!');
end;

{Juste un DirMenuButton et OnDirChange:}
procedure TForm1.DirMenuButton2DirChange(Sender: TObject; NewDir: string);
begin
DirMenuButton2.Caption:=NewDir;
end;

end.
