(**********************************************************************)
(* TmenuButton                                                        *)
(* Ver 1.0                                                            *)
(* Copyright (c) 1995 Peter van Lonkhuyzen                            *)
(* This source may be freely distributed/used without any restrictions*)
(* whatsoever.                                                        *)
(**********************************************************************)
(* Background to this component                                       *)
(* Having moved to Delphi from BP7.0 I found that using Tpanel with   *)
(* Tspeedbuttons it was a poor substitute for the toolbar unit supplied*)
(* with OWL (modified for menu synchronisation by myself) So I came up*)
(* this little unit to handle the synchronisation.                    *)
(**********************************************************************)
(* There are 3 new properties defined                                 *)
(* Menuitem : This is the menuitem you wish to Synchronise with       *)
(* Syncdown : This allows you to syncronise the permanent down state  *)
(*            with the checked property on the menuitem (NB Group may *)
(*            not be 0)                                               *)
(* SyncEnabled : Speaks for itself                                    *)
(**********************************************************************)
(* Usage                                                              *)
(* 1. Set the menuitem you wish to sync with, with no menuitem set it *)
(*    is just a normal speedbutton.                                   *)
(* 2. Set the Sync options and away you go                            *)
(**********************************************************************)
(* Things to keep in mind                                             *)
(* The button automatically clicks the menuitem so don't assign a     *)
(* onclick event unless you want to perform additional handling that  *)
(* gets used only when the button is pressed and not the menu.        *)
(* Make all programatic state changes to the button or the menu won't *)
(* stay in synch. (If you have the VCL source you can modify the menus*)
(* unit to export a onchanged event (don't use the private one already*)
(* their as that gets used by TMainmenu) to notify you of changes made*)
(* programatically to the menu to stay synchronised.                  *)
(**********************************************************************)
(* Any feedback or suggestions can be made directly to me at          *)
(* peterv@inet.co.za                                                  *)
(* unfortunately this internet address will change in Feb 1996        *)
(* or by post To                                                      *)
(*                                                                    *)
(* Peter van Lonkhuyzen                                               *)
(* PO Box 1041                                                        *)
(* Randpark Ridge                                                     *)
(* 2156                                                               *)
(* Rep of South Africa                                                *)
(**********************************************************************)

unit Menubtn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, menus;

type
  TMenuButton = class(TSpeedButton)
  private
    FMenuItem : TMenuItem;
    FSyncDown : Boolean;
    FSyncEnabled : Boolean;
    Function GetEnabled : Boolean;
    Procedure SetEnabled(AEnabled : Boolean);
    Function GetDown : Boolean;
    Procedure SetDown(ADown : Boolean);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure click; override;
  published
    { Published declarations }
    Property Down : Boolean Read GetDown Write SetDown;
    Property Enabled : Boolean Read GetEnabled Write SetEnabled;
    property MenuItem : TmenuItem read Fmenuitem Write FmenuItem;
    property SyncDown : Boolean read FSyncDown Write FSyncDown;
    property SyncEnabled : Boolean read FSyncEnabled Write FSyncEnabled;
  end;

procedure Register;

implementation


Function TMenuButton.GetDown : Boolean;
Begin
  GetDown := inherited Down;
End;

Procedure TMenuButton.SetDown(ADown : Boolean);
Begin
  If ADown <> inherited Down Then
  Begin
    inherited Down:=ADown;
    if FSyncDown and (fmenuitem<>nil) then
      FMenuitem.Checked:=inherited Down;
  End;
End;

Function TMenuButton.GetEnabled : Boolean;
Begin
  GetEnabled := inherited Enabled;
End;

Procedure TMenuButton.SetEnabled(AEnabled : Boolean);
Begin
  If AEnabled <> inherited Enabled Then
  Begin
    inherited Enabled:=AEnabled;
    if FSyncEnabled and (fmenuitem<>nil) then
      FMenuitem.Enabled:=inherited Enabled;
  End;
End;

procedure TMenubutton.click;
begin
  inherited click;
  if fmenuitem<>nil then
  begin
    fmenuitem.click;
    if FSyncDown then
      FMenuitem.Checked:=inherited Down;
  end;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TMenuButton]);
end;

end.
