(*
////////////////////////////////////////////////////////////////////////////////
// MEGAPROP.PAS : MEGAPANEL PROPERTY EDITORS                                  //
// Copyright  1996-1999 Steve Flynn. All Rights Reserved                     //
//----------------------------------------------------------------------------//
// By using this source code you agree to be bound by the terms of the        //
// following Software License Agreement. Any breach of this agreement will be //
// prosecuted to the full extent of the law.                                  //
////////////////////////////////////////////////////////////////////////////////

LICENSE AGREEMENT - MARCH 1999

USE OF THE SOFTWARE

Steven M. Flynn (the "Author") grants you, the end user, a non-exclusive
single-user license to use the supplied software program and all associated
materials including the Source Code (the "Software"). The Software and all
Intellectual Property embodied in the Software always remains the property of
the Author. Your use of the Software indicates your acceptance in full of the
terms and conditions of this agreement.


COPYING THE SOFTWARE

You may freely copy the Software provided that such copies do not infringe upon
any other part of this agreement.


DISTRIBUTION OF THE SOFTWARE

The Software may be re-distributed royalty free providing that it is not
modified in any way and that no charge is made for the Software itself. Only a
nominal fee for media and/or copying services is allowed. All files, including
the License Agreement, that are supplied by the Author with the Software must
also be included in any such distribution.


DERIVED WORKS

You may NOT use the Software to derive any works which are based substantially
in part or in full on the Software or any portion of the Software. Any such
derived works will remain the property of the Author.


MODIFIED VERSIONS OF THE SOFTWARE

All updated, revised, modified or improved versions of the Software are also
subject to the conditions of this license agreement and shall remain the
property of the Author. You are required under the terms of this agreement to
submit to the Author any and all improvements or additions made by you to the 
Software for future inclusion in the general distribution of the Software by
the Author.


TERMINATION OF THIS AGREEMENT

You may terminate this License Agreement at any time by destroying all copies
of the Software in your possession.


LIMITED WARRANTY

The Software is distributed and licensed "AS IS". The Author specifically
disclaims all other warranties, express or implied, including but not limited
to, implied warranties of merchantability and fitness for a particular purpose,
with regard to the Software.


DAMAGES

By using the Software you do so at your own risk. In no event shall the Author
be responsible for any damages whatsoever (including but not limited to,
damages for loss of business profits, business interruption, loss of business
information, or any other pecuniary loss or any other real or consequential 
damages) arising out of the use or inability to use this product.


LIABILITY

In the event of failure of the Software, for any reason, the Author's sole
liability shall be to refund to you the amount paid by you to the Author for
the use of the Software.


COPYRIGHT

The Software and the Intellectual Property embodied in the Software shall
always remain the property of the Author and is protected by Australian
Copyright Law and International Treaty Provisions.


AGREEMENT

Your use of the Software indicates your agreement with the above terms and
conditions. If you do not agree with these terms and conditions then you must
destroy all copies of the software in your possession.


CONSUMER RIGHTS

If any clause in the above Software License Agreement is in violation of your
rights under your local laws then you must cease using the Software
immediately. It is your own responsibility to be aware of your legal rights
under your own local laws.


END OF LICENSE AGREEMENT
*)

{$A-,B-,D-,F-,G+,I-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z-}
{$IFDEF WIN32}
{$H+,J+,K-}
{$M 16384,1048576}
{$ELSE}
{$K+,M 16384,8192}
{$C PRELOAD}
{$ENDIF}


unit MegaProp;

interface

uses
	SysUtils, WinTypes, WinProcs, Classes, Graphics, Dialogs, Controls,
	ExtCtrls, Messages, DsgnIntf, StdCtrls, Buttons, IniFiles, Consts, Forms, Grids;

type
	TMegaPropForm = class(TForm)
		Pages: TNotebook;
		HintPanel: TPanel;
		Panel3: TPanel;
		Label1: TLabel;
		Label2: TLabel;
		Label3: TLabel;
		FlyoverHint: TMemo;
		StatusHint: TMemo;
		Panel5: TPanel;
		Panel6: TPanel;
		ControlHint: TMemo;
		Panel4: TPanel;
		Copy0: TBitBtn;
		OK0: TBitBtn;
		Cancel0: TBitBtn;
		Paste0: TBitBtn;
		StatusPanel: TPanel;
		FixupPanel: TPanel;
		Panel1: TPanel;
		Header: THeader;
		Grid: TStringGrid;
		Panel2: TPanel;
		OK1: TBitBtn;
		Cancel1: TBitBtn;
		Get1: TBitBtn;
		Add1: TBitBtn;
		Remove1: TBitBtn;
		Save1: TBitBtn;
		AutoAdd: TCheckBox;
		Cleanup: TCheckBox;
		procedure FormCreate(Sender: TObject);
		procedure Copy0Click(Sender: TObject);
		procedure Paste0Click(Sender: TObject);
		procedure FlyoverHintChange(Sender: TObject);
		procedure StatusHintChange(Sender: TObject);
		procedure GatherClick(Sender: TObject);
		procedure GridDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
		procedure Add1Click(Sender: TObject);
		procedure Remove1Click(Sender: TObject);
		procedure GridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; x, y: Integer);
		procedure GridKeyPress(Sender: TObject; var Key: Char);
		procedure GridKeyUpDown(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure MemoEnter(Sender: TObject);
		procedure Save1Click(Sender: TObject);
		procedure AutoAddClick(Sender: TObject);
		procedure CleanupClick(Sender: TObject);
	private
		{ Private declarations }
		FocusedMemo: TMemo;
		CheckBmp: TBitmap;
		Pnl: TWinControl;
		Fix: pointer;
		Ini: TIniFile;
		procedure ToggleCell;
	protected
		procedure Activate; override;
	public
		{ Public declarations }
		end;

var
	MegaPropForm: TMegaPropForm;

procedure Register;

implementation

uses megapanl;

{$R *.DFM}

{// Forward References & Class Enablers ///////////////////////////////////////}
type
	TMegaMega = class(TMegaPanel);

{// TNameListProperty /////////////////////////////////////////////////////////}
	TNameListProperty = class(TStringProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		procedure GetValueList(List: TStrings); virtual; abstract;
		procedure GetValues(Proc: TGetStrProc); override;
		end;

function TNameListProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := [paValueList, paSortList, paMultiSelect];
	end;


procedure TNameListProperty.GetValues(Proc: TGetStrProc);
	var
	i: integer;
	Values: TStringList;
	begin
	Values := TStringList.Create;
	try
		GetValueList(Values);
		for i := 0 to Values.Count - 1 do
			Proc(Values[i]);
	finally
		Values.Free;
		end;
	end;


{// TPanelFormProperty /////////////////////////////////////////////////////////}
type
	TPanelFormProperty = class(TNameListProperty)
	public
		procedure GetValueList(List: TStrings); override;
		end;


procedure TPanelFormProperty.GetValueList(List: TStrings);
	var
	tWnd: HWnd;
	Frm: TForm;
	AName, CName, OName: string;
	begin
	CName := TComponent(GetComponent(0)).Name;
	OName := TComponent(GetComponent(0)).Owner.Name;
	tWnd := GetFocus;
	while (GetParent(tWnd) <> 0) do
		tWnd := GetParent(tWnd);
	tWnd := GetWindow(tWnd, GW_HWNDFIRST);
	while (tWnd <> 0) do
		begin
		Frm := TForm(FindControl(tWnd));
		if (Frm <> nil)
			and (Frm is TForm)
			and (Frm.Name <> OName)
			and (Frm.ClassName <> 'THintWindow')
			and (Frm.ClassName <> 'TMenuBuilder')
			and (Frm.ClassName <> 'TDbEngineErrorDlg')
			then
			begin
			AName := Copy(Frm.ClassName, 2, Length(Frm.ClassName) - 1);
			if List.IndexOf(AName) = -1 then
				List.Add(AName);
			end;
		tWnd := GetWindow(tWnd, GW_HWNDNEXT);
		end;
	end;


{// HintEdit Property Editor //////////////////////////////////////////////////}
procedure GetLines(Lines : TStrings; const s : string);
	var
	x : integer;
	Temp : string;
	begin
	if (s <> '') then
		begin
		Temp := '';
		for x := 1 to Length(s) do
			begin
			if (s[x] = #13) then
				begin
				Lines.Add(Temp);
				Temp := '';
				end
			else
				Temp := Temp + s[x];
			end;
		if (Temp <> '') then
			Lines.Add(Temp);
		end;
	end;


procedure GetText(Lines: TStrings; var s: string);
	var
	x : integer;
	begin
	s := '';
	for x := 0 to Lines.Count - 1 do
		begin
		s := s + Lines[x];
		if x < (Lines.Count - 1) then
			s := s + #13;
		end
	end;


procedure TMegaPropForm.Activate;
	begin
	inherited Activate;
	FlyoverHint.SelectAll;
	end;


procedure TMegaPropForm.Copy0Click(Sender: TObject);
	begin
	if FocusedMemo <> nil then
		begin
		FocusedMemo.CopyToClipboard;
		FocusedMemo.SetFocus;
		end;
	end;


procedure TMegaPropForm.Paste0Click(Sender: TObject);
	begin
	if FocusedMemo <> nil then
		begin
		FocusedMemo.PasteFromClipboard;
		FocusedMemo.SetFocus;
		end;
	end;


procedure TMegaPropForm.FlyoverHintChange(Sender: TObject);
	var
	S: string;
	begin
	GetText(FlyoverHint.Lines, S);
	FlyoverHint.Hint := S;
	end;


procedure TMegaPropForm.StatusHintChange(Sender: TObject);
	var
	S: string;
	begin
	GetText(StatusHint.Lines, S);
	StatusPanel.Caption := S;
	end;


procedure TMegaPropForm.MemoEnter(Sender: TObject);
	begin
	FocusedMemo := TMemo(ActiveControl);
	end;


{// THintProperty /////////////////////////////////////////////////////////////}
type
	THintProperty = class(TStringProperty)
	public
		procedure Edit; override;
		function GetAttributes: TPropertyAttributes; override;
		end;

function THintProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := [paDialog, paMultiSelect, paAutoUpdate];
	end;


procedure THintProperty.Edit;
	var
	x: integer;
	s, t, u: string;
	Cmp: TComponent;
	InvalidateHint: boolean;
	begin
	MegaPropForm := TMegaPropForm.Create(Application);
	InvalidateHint := False;
	with MegaPropForm do
		begin
		ClientWidth := HintPanel.Width;
		Pages.PageIndex := 0;
		Caption := Pages.Pages[0];
		Cmp := TComponent(GetComponent(0));
		Pnl := nil;
		Fix := nil;
		FlyoverHint.MaxLength := 255;
		StatusHint.MaxLength := 255;
		ControlHint.MaxLength := 255;
		if CompareText(GetName, 'HINT') = 0 then
			if Cmp is TControl then
				with Cmp as TControl do
					if (Parent <> nil) and (Parent is TMegaPanel) then
						begin
						Pnl := Parent;
						if (TMegaPanel(Pnl).LabelStyle = lsInPanel)
							or (TMegaPanel(Pnl).LabelStyle = lsMixed) then
							InvalidateHint := True;
						end;
		try
			s := GetStrValue;
			if (s <> '') then
				begin
				x := Pos('|', s);
				if x > 0 then
					begin
					GetLines(FlyoverHint.Lines, GetShortHint(s));
					s := GetLongHint(s);
					x := Pos('|', s);
					if x > 0 then
						begin
						GetLines(StatusHint.Lines, GetShortHint(s));
						GetLines(ControlHint.Lines, GetLongHint(s));
						end
					else
						GetLines(StatusHint.Lines, s);
					end
				else
					GetLines(FlyoverHint.Lines, s);
				end;
			if ShowModal = mrOK then
				begin
				if InvalidateHint then
					TMegaMega(Pnl).InvalidateLabel(TControl(Cmp));
				GetText(FlyoverHint.Lines, s);
				GetText(StatusHint.Lines, t);
				GetText(ControlHint.Lines, u);
				if (length(s) + length(t) + length(u)) > 255 then
					MessageDlg('String too long', mtError, [mbOK], 0)
				else
					begin
					if (Length(t) > 0) or (Length(u) > 0) then
						SetStrValue(s + '|' + t + '|' + u)
					else
						SetStrValue(s);
					if InvalidateHint then
						TMegaMega(Pnl).InvalidateLabel(TControl(Cmp));
					end;
				end;
		finally
			MegaPropForm.Free;
			MegaPropForm := nil;
			end;
		end;
	end;


{// TMegaColor & Tag Property Editors /////////////////////////////////////////}
type
	TMegaColorProperty = class(TColorProperty)
	public
		function GetAttributes: TPropertyAttributes; override;
		function GetValue: string; override;
		procedure GetValues(Proc: TGetStrProc); override;
		procedure SetValue(const Value: string); override;
		end;

	TTagProperty = class(TMegaColorProperty);

const
	hcDColorEditor = 25010;

function TMegaColorProperty.GetAttributes: TPropertyAttributes;
	var
	i: integer;
	dummy: longint;
	begin
	Result := [paMultiSelect, paDialog, paValueList];
	for i := 0 to PropCount - 1 do
		begin
		dummy := TControl(GetComponent(i)).Tag;
		TControl(GetComponent(i)).Tag := dummy;
		end;
	end;


procedure TMegaColorProperty.SetValue(const Value: string);
	var
	NewValue: Longint;
	begin
	if IdentToMegaColor(Value, NewValue) then
		SetOrdValue(NewValue)
	else
		inherited SetValue(Value);
	end;


function TMegaColorProperty.GetValue: string;
	var
	Cmp: TComponent;
	begin
	Cmp := TComponent(GetComponent(0));
	if (CompareText(GetName, 'TAG') <> 0)
		or ((CompareText(GetName, 'TAG') = 0)
		and (Cmp is TControl)
		and (TControl(Cmp).Parent <> nil)
	 	and (TControl(Cmp).Parent is TMegaPanel)
		and (TMegaPanel(TControl(Cmp).Parent).TagUsage <> tuNone)) then
		Result := MegaColorToString(TMegaColor(GetOrdValue))
	else
		Result := IntToStr(GetOrdValue);
	end;


procedure TMegaColorProperty.GetValues(Proc: TGetStrProc);
	begin
	GetMegaColorValues(Proc);
	end;


{// TMegaPanelEditor Component Editor /////////////////////////////////////////}
const
	MegaVerb = 'About MegaPanel...';

type
	TMegaPanelEditor = class(TDefaultEditor)
	public
		procedure ExecuteVerb(Index: integer); override;
		function GetVerb(Index: integer): string; override;
		function GetVerbCount: integer; override;
		end;


procedure TMegaPanelEditor.ExecuteVerb(Index: integer);
	var
	ps: array [0..255] of char;
	begin
	MessageBox(0, StrPCopy(ps, TMegaPanel.GetCopyright), MegaVerb, MB_OK);
	end;


function TMegaPanelEditor.GetVerb(Index: integer): string;
	var
	w, h: integer;
	r: TRect;
	s: string;
	begin
	case Index of
		1:
			begin
			r := TMegaPanel(Component).ClientRect;
			TMegaMega(Component).AlignControls(nil, r);
			s := 'Panel Area';
			end;
		2:
			begin
			r := TMegaMega(Component).CaptionRect;
			s := 'Caption Area';
			end;
		3:
			begin
			r := TMegaPanel(Component).ClientRect;
			s := 'Total Area';
			end;
		end;
	if Index = 0 then
		Result := MegaVerb
	else
		begin
		w := r.Right - r.Left;
		h := r.Bottom - r.Top;
		Result := Format(s + ': W=%d H=%d', [w, h]);
		end;
	end;


function TMegaPanelEditor.GetVerbCount: integer;
	begin
	Result := 4;
	end;


{// TMegaFixProperty //////////////////////////////////////////////////////////}
type
	TMegaFixProperty = class(TStringProperty)
	public
		procedure Edit; override;
		function GetAttributes: TPropertyAttributes; override;
		function GetValue: string; override;
		procedure FillGrid(List: TStrings);
		end;

function TMegaFixProperty.GetValue : string;
	begin
	Result := 'Click Over There -->';
	end;


function TMegaFixProperty.GetAttributes: TPropertyAttributes;
	begin
	Result := inherited GetAttributes + [ paDialog ] - [ paSubProperties ];
	end;


procedure TMegaFixProperty.FillGrid(List: TStrings);
	var
	i: integer;
	begin
	if MegaPropForm <> nil then
		with MegaPropForm do
			begin
			Grid.RowCount := 1;
			for i := 0 to List.Count - 1 do
				if Length(List[i]) > 7 then
					begin
					Grid.Cells[0, i] := Copy(List[i], 7, 99);
					Grid.Cells[1, i] := Copy(List[i], 1, 1);
					Grid.Cells[2, i] := Copy(List[i], 2, 1);
					Grid.Cells[3, i] := Copy(List[i], 3, 1);
					Grid.Cells[4, i] := Copy(List[i], 4, 1);
					Grid.Cells[5, i] := Copy(List[i], 5, 1);
					Grid.Cells[6, i] := Copy(List[i], 6, 1);
					if i > 0 then
						Grid.RowCount := Grid.RowCount + 1;
					end;
			end;
	end;


procedure TMegaFixProperty.Edit;
	var
	i: integer;
	s: string;
	begin
	MegaPropForm := TMegaPropForm.Create(Application);
	with MegaPropForm do
		begin
		ClientWidth := FixupPanel.Width;
		Ini := TIniFile.Create(IniFile);
		try
			StatusHint.MaxLength := 0;
			StatusHint.Lines := TStringList(GetOrdValue);
			Pnl := TMegaPanel(GetComponent(0));
			Fix := self;
			FocusedMemo := nil;
			CheckBmp := TBitmap.Create;
			CheckBmp.Handle := LoadBitmap(0, pchar(32759));
			Pages.PageIndex := 1;
			Caption := Pages.Pages[1];
			FillGrid(StatusHint.Lines);
			AutoAdd.Checked := Ini.ReadString(IniSection, AutoAddKey, '0') = '1';
			Cleanup.Checked := Ini.ReadString(IniSection, CleanupKey, '0') = '1';
			if ShowModal = mrOK then
				begin
				StatusHint.Clear;
				for i := 0 to Grid.RowCount - 1 do
					begin
					s := Grid.Cells[1, i] + Grid.Cells[2, i] + Grid.Cells[3, i]
						 + Grid.Cells[4, i] + Grid.Cells[5, i] + Grid.Cells[6, i] + Grid.Cells[0, i];
					if Length(s) > 7 then
						StatusHint.Lines.Add(s);
					end;
				SetOrdValue(longint(StatusHint.Lines));
				if AutoAdd.Checked then
					Ini.WriteString(IniSection, AutoAddKey, '1')
				else
					Ini.WriteString(IniSection, AutoAddKey, '0');
				if Cleanup.Checked then
					Ini.WriteString(IniSection, CleanupKey, '1')
				else
					Ini.WriteString(IniSection, CleanupKey, '0');
				end;
			DeleteObject(CheckBmp.Handle);
			CheckBmp.Handle := 0;
			CheckBmp.Free;
		finally
			Ini.Free;
			MegaPropForm.Free;
			end;
		end;
	end;


procedure TMegaPropForm.FormCreate(Sender: TObject);
	var
	i: integer;
	begin
	for i := 0 to Header.Sections.Count - 2 do
		Grid.ColWidths[i] := Header.SectionWidth[i] - 1;
	end;


procedure TMegaPropForm.GridDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect; State: TGridDrawState);
	begin
	if Col > 0 then
		begin
		Grid.Canvas.FillRect(Rect);
		if Grid.Cells[Col, Row] = '0' then
			BitBlt(Grid.Canvas.Handle, Rect.Left + 16, Rect.Top + 4, 13, 13,
					CheckBmp.Canvas.Handle, 0, 0, SRCCOPY)
		else
			BitBlt(Grid.Canvas.Handle, Rect.Left + 16, Rect.Top + 4, 13, 13,
					CheckBmp.Canvas.Handle, 13, 0, SRCCOPY);
		end;
	if (gdFocused in State) and (Col > 0) then
	end;


procedure TMegaPropForm.GatherClick(Sender: TObject);
	var
	i, j: integer;
	s: string;
	Ctl: TControl;
	InList: boolean;
	StrList: TStringList;
	begin
	if (Pnl = nil) or (Fix = nil) then
		exit;
	StrList := TStringList.Create;
	try
		for i := 0 to TMegaPanel(Pnl).FixClasses.Count - 1 do
			StrList.Add(TMegaPanel(Pnl).FixClasses[i]);
		for i := 0 to Pnl.ControlCount - 1 do
			begin
			Ctl := Pnl.Controls[i];
			if Ctl is TControl then
				begin
				InList := False;
				for j := 0 to StrList.Count - 1 do
					if CompareText(Ctl.ClassName, Copy(StrList[j], 7, 99)) = 0 then
						begin
						InList := True;
						break;
						end;
				if InList then
					continue;
				s := Ini.ReadString(IniSection, Ctl.ClassName, '');
				if s = '' then
					begin
					if TWinControl(Ctl).CanFocus then
						s := '111111' + Ctl.ClassName
					else
						s := '000100' + Ctl.ClassName;
					end
				else
					begin
					if length(s) < 6 then
						if Ctl is TWinControl then
							s := s + '111'
						else
							s := s + '100';
					s := s + Ctl.ClassName;
					end;
				StrList.Add(s);
				end;
			end;
		if StrList.Count > 0 then
			TMegaFixProperty(Fix).FillGrid(StrList);
	finally
		StrList.Free;
		end;
	Grid.EditorMode := True;
	Grid.Col := 0;
	Grid.Row := 0;
	Grid.SetFocus;
	end;


procedure TMegaPropForm.Add1Click(Sender: TObject);
	begin
	Grid.EditorMode := True;
	if Grid.Cells[0, Grid.RowCount - 1] <> '' then
		Grid.RowCount := Grid.RowCount + 1;
	Grid.Col := 0;
	Grid.Row := Grid.RowCount - 1;
	Grid.Cells[0, Grid.Row] := '';
	Grid.Cells[1, Grid.Row] := '0';
	Grid.Cells[2, Grid.Row] := '0';
	Grid.Cells[3, Grid.Row] := '0';
	Grid.Cells[4, Grid.Row] := '0';
	Grid.Cells[5, Grid.Row] := '0';
	Grid.Cells[6, Grid.Row] := '0';
	Grid.SetFocus;
	end;


procedure TMegaPropForm.Remove1Click(Sender: TObject);
	var
	i, j: integer;
	begin
	Grid.EditorMode := True;
	if Grid.RowCount = 1 then
		begin
		Grid.Cells[0, 0] := '';
		Grid.Cells[1, 0] := '0';
		Grid.Cells[2, 0] := '0';
		Grid.Cells[3, 0] := '0';
		Grid.Cells[4, 0] := '0';
		Grid.Cells[5, 0] := '0';
		Grid.Cells[6, 0] := '0';
		end
	else
		begin
		for j := Grid.Row to Grid.RowCount - 2 do
			for i := 0 to 6 do
				Grid.Cells[i, j] := Grid.Cells[i, j + 1];
		Grid.RowCount := Grid.RowCount - 1;
		end;
	Grid.Col := 0;
	Grid.SetFocus;
	end;


procedure TMegaPropForm.ToggleCell;
	var
	Rect: TRect;
	begin
	Rect := Grid.CellRect(Grid.Col, Grid.Row);
	InvalidateRect(Grid.Handle, @Rect, False);
	SendMessage(Grid.Handle, WM_PAINT, 0, 0);
	if Grid.Cells[Grid.Col, Grid.Row] = '0' then
		Grid.Cells[Grid.Col, Grid.Row] := '1'
	else
		Grid.Cells[Grid.Col, Grid.Row] := '0';
	InvalidateRect(Grid.Handle, @Rect, False);
	SendMessage(Grid.Handle, WM_PAINT, 0, 0);
	Grid.EditorMode := False;
	end;


procedure TMegaPropForm.GridMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; x, y: Integer);
	var
	c, r: longint;
	begin
	Grid.MouseToCell(x, y, c, r);
	Grid.Col := c;
	Grid.Row := r;
	if c > 0 then
		ToggleCell
	else
		Grid.EditorMode := True;
	end;


procedure TMegaPropForm.GridKeyPress(Sender: TObject; var Key: Char);
	begin
	if Grid.Col > 0 then
		begin
		Grid.EditorMode := False;
		if Key < ' ' then
			exit;
		if Key = ' ' then
			ToggleCell;
		Key := #0
		end
	else
		Grid.EditorMode := True;
	end;


procedure TMegaPropForm.GridKeyUpDown(Sender: TObject; var Key: Word; Shift: TShiftState);
	begin
	if Grid.Col > 0 then
		Grid.EditorMode := False
	else
		Grid.EditorMode := True;
	end;


procedure TMegaPropForm.Save1Click(Sender: TObject);
	var
	i: integer;
	begin
	for i := 0 to Grid.RowCount - 1 do
		if Grid.Cells[0, i] = '' then
			break
		else
			Ini.WriteString(IniSection, Grid.Cells[0, i], Grid.Cells[1, i] + Grid.Cells[2, i] + Grid.Cells[3, i]
									  					+ Grid.Cells[4, i] + Grid.Cells[5, i] + Grid.Cells[6, i]);
	end;


procedure TMegaPropForm.AutoAddClick(Sender: TObject);
	begin
	if AutoAdd.Checked then
		Ini.WriteString(IniSection, AutoAddKey, '1')
	else
		Ini.WriteString(IniSection, AutoAddKey, '0');
	end;


procedure TMegaPropForm.CleanupClick(Sender: TObject);
	begin
	if Cleanup.Checked then
		Ini.WriteString(IniSection, CleanupKey, '1')
	else
		Ini.WriteString(IniSection, CleanupKey, '0');
	end;


{// Register Property Editors /////////////////////////////////////////////////}
procedure Register;
	begin
	RegisterComponentEditor(TMegaPanel, TMegaPanelEditor);
	RegisterPropertyEditor(TypeInfo(string), TControl, 'Hint', THintProperty);
	RegisterPropertyEditor(TypeInfo(longint), TControl, 'Tag', TTagProperty);
	RegisterPropertyEditor(TypeInfo(string), TMegaPanel, 'Caption', THintProperty);
	RegisterPropertyEditor(TypeInfo(string), TMegaPanel, 'PanelFormName', TPanelFormProperty);
	RegisterPropertyEditor(TypeInfo(TStrings), TMegaPanel, 'FixClasses', TMegaFixProperty);
	RegisterPropertyEditor(TypeInfo(TMegaColor), nil, '', TMegaColorProperty);
	end;


{// Initialization ////////////////////////////////////////////////////////////}
Initialization
	begin
	with TIniFile.Create(IniFile) do
		begin
		AutoAddFixups := ReadString(IniSection, AutoAddKey, '0') = '1';
		CleanupFixups := ReadString(IniSection, CleanupKey, '0') = '1';
		Free;
		end;
	end;

end.

