(*
////////////////////////////////////////////////////////////////////////////////
// MEGAPANL.PAS : THE MOTHER OF ALL PANEL COMPONENTS                          //
// Copyright  1996-1999 Steve Flynn. All Rights Reserved                     //
//----------------------------------------------------------------------------//
// By using this source code you agree to be bound by the terms of the        //
// following Software License Agreement. Any breach of this agreement will be //
// prosecuted to the full extent of the law.                                  //
////////////////////////////////////////////////////////////////////////////////

LICENSE AGREEMENT - MARCH 1999

USE OF THE SOFTWARE

Steven M. Flynn (the "Author") grants you, the end user, a non-exclusive
single-user license to use the supplied software program and all associated
materials including the Source Code (the "Software"). The Software and all
Intellectual Property embodied in the Software always remains the property of
the Author. Your use of the Software indicates your acceptance in full of the
terms and conditions of this agreement.


COPYING THE SOFTWARE

You may freely copy the Software provided that such copies do not infringe upon
any other part of this agreement.


DISTRIBUTION OF THE SOFTWARE

The Software may be re-distributed royalty free providing that it is not
modified in any way and that no charge is made for the Software itself. Only a
nominal fee for media and/or copying services is allowed. All files, including
the License Agreement, that are supplied by the Author with the Software must
also be included in any such distribution.


DERIVED WORKS

You may NOT use the Software to derive any works which are based substantially
in part or in full on the Software or any portion of the Software. Any such
derived works will remain the property of the Author.


MODIFIED VERSIONS OF THE SOFTWARE

All updated, revised, modified or improved versions of the Software are also
subject to the conditions of this license agreement and shall remain the
property of the Author. You are required under the terms of this agreement to
submit to the Author any and all improvements or additions made by you to the 
Software for future inclusion in the general distribution of the Software by
the Author.


TERMINATION OF THIS AGREEMENT

You may terminate this License Agreement at any time by destroying all copies
of the Software in your possession.


LIMITED WARRANTY

The Software is distributed and licensed "AS IS". The Author specifically
disclaims all other warranties, express or implied, including but not limited
to, implied warranties of merchantability and fitness for a particular purpose,
with regard to the Software.


DAMAGES

By using the Software you do so at your own risk. In no event shall the Author
be responsible for any damages whatsoever (including but not limited to,
damages for loss of business profits, business interruption, loss of business
information, or any other pecuniary loss or any other real or consequential 
damages) arising out of the use or inability to use this product.


LIABILITY

In the event of failure of the Software, for any reason, the Author's sole
liability shall be to refund to you the amount paid by you to the Author for
the use of the Software.


COPYRIGHT

The Software and the Intellectual Property embodied in the Software shall
always remain the property of the Author and is protected by Australian
Copyright Law and International Treaty Provisions.


AGREEMENT

Your use of the Software indicates your agreement with the above terms and
conditions. If you do not agree with these terms and conditions then you must
destroy all copies of the software in your possession.


CONSUMER RIGHTS

If any clause in the above Software License Agreement is in violation of your
rights under your local laws then you must cease using the Software
immediately. It is your own responsibility to be aware of your legal rights
under your own local laws.


END OF LICENSE AGREEMENT
*)

{$A-,B-,D-,F-,G+,I-,L-,M-,N+,O+,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y-,Z-}
{$IFDEF WIN32}
{$H+,J+,K-}
{$M 16384,1048576}
{$R MEGAPANL.R32}
{$ELSE}
{$K+,M 16384,8192}
{$R MEGAPANL.R16}
{$C PRELOAD}
{$ENDIF}


unit MegaPanl;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms,
	ExtCtrls, StdCtrls, Grids;

const
{$IFNDEF WIN32}
	COLOR_3DDKSHADOW = 21;
	COLOR_3DLIGHT = 22;
	COLOR_INFOTEXT = 23;
	COLOR_INFOBK = 24;
	cl3DDkShadow = COLOR_3DDKSHADOW or $80000000;
	cl3DLight = COLOR_3DLIGHT or $80000000;
	clInfoText = COLOR_INFOTEXT or $80000000;
	clInfoBk = COLOR_INFOBK or $80000000;
	clNone = $1FFFFFFF;
{$ENDIF}
	COLOR_NONE = 25;
	clOld3DDkShadow = -COLOR_3DDKSHADOW - 1;
	clOld3DLight = -COLOR_3DLIGHT - 1;
	clOldInfoText = -COLOR_INFOTEXT - 1;
	clOldInfoBk = -COLOR_INFOBK - 1;
	clOldNone = -COLOR_NONE - 1;
	AutoAddKey = 'AutoAddFixups';
	CleanupKey = 'CleanupFixups';
	IniSection = 'Class Fixups';
	IniFile = 'MEGAPANL.INI';
	WM_MEGATEXT  = WM_USER + 123;

type
{$IFDEF VER120}
	TMegaColor = -$7FFFFFFF-1..$7FFFFFFF;
{$ELSE}
	TMegaColor = $80000000..$7FFFFFFF;
{$ENDIF}
	TMegaPanel = class;
	TCaptionStyle = (csNone, csPanel, csGroupBox, csFloating);
	TLabelStyle = (lsNone, lsInPanel, lsInControl, lsMixed);
	TVertJust = (vjTop, vjCenter, vjBottom);
	THorzJust = (hjLeft, hjCenter, hjRight);
	TFontStyle = (fsNormal,fsRaisedLight, fsRaisedHeavy,
				fsInsetLight, fsInsetHeavy, fsDropShadow, fsHeavy);
	TLabelPos = (lpTopLeftCorner, lpTopLeft, lpTopCenter, lpTopRight, lpTopRightCorner,
				lpLeftTop, lpLeftCenter, lpLeftBottom,
				lpRightTop, lpRightCenter, lpRightBottom,
				lpBottomLeftCorner, lpBottomLeft, lpBottomCenter, lpBottomRight, lpBottomRightCorner);
	TPicturePos = (ppTopLeft, ppTopCenter, ppTopRight,
				ppLeftCenter, ppCenter, psRightCenter,
				ppBottomLeft, ppBottomCenter, ppBottomRight,
				ppStretch, ppTile, ppTileFast,
				ppStretchTop, ppStretchBottom, ppStretchLeft, ppStretchRight,
				ppStripTop, ppStripBottom, ppStripLeft, ppStripRight,
				ppStripTopFast, ppStripBottomFast, ppStripLeftFast, ppStripRightFast);
	TPictureStyle = (psAll, psPanel, psPanelFrame, psPanelInsideFrame,
				psCaption, psCaptionFrame, psCaptionInsideFrame, psCaptionText);
	TCaptionPos = (cpTopLeft, cpTopCenter, cpTopRight,
				cpLeftTop, cpLeftCenter, cpLeftBottom,
				cpRightTop, cpRightCenter, cpRightBottom,
				cpBottomLeft, cpBottomCenter, cpBottomRight);
	TTagUsage = (tuNone, tuLabelColor, tuLabelBackground);
	TCaptionLoc = (clInsideFrame, clOutsideFrame);
	TResizeCont = (rcHorizontal, rcVertical, rcScrollBars, rcCaptionFrames, rcPanelFrames,
				   rcLabelFrames, rcCtlShadow, rcPictureOffsets, rcGridCells, rcGridLines);
	TResizeConts = set of TResizeCont;
	TResizeFont = (rfCaption, rfLabels, rfControls);
	TResizeFonts = set of TResizeFont;
	TAutoCent = (acControls, acLabels, acPanels);
	TAutoCenter = set of TAutoCent;
	TGradientType = (gtNone, gtHorizontal, gtVertical, gtHorzSplit, gtVertSplit);
	TFixKey = (fkEnter, fkUpDown);
	TFixKeys = set of TFixKey;
	TClassFix = (cfShadow, cfPnlLabel, cfCtlLabel, cfFocEffect);
	TClassFixup = set of TClassFix;
	TEffect = (feNone, feFocus, feLive, feColor);
	TPictureTransparent = (ptNone, ptSimple, ptFull);
	TColorStyle = (csOpaque, csDithered, csTransparent, csAND, csOR, csNAND, csNOR, csXOR);
	TDesignView = (dvNormal, dvRuntime);
	TPanelFormEvent = procedure(Panel: TMegaPanel; Form: TForm) of object;
	TLabelType = (ltNormal, ltAutomatic);

{// TGradient /////////////////////////////////////////////////////////////////}
	TGradient = class(TPersistent)
	private
		FPanel: TMegaPanel;
		FStyle: TPictureStyle;
		FType: TGradientType;
		FStart: TMegaColor;
		FEnd: TMegaColor;
		FSteps: integer;
		CStart: array [0..2] of byte;
		CDiff: array [0..2] of integer;
		procedure Fill(Grad, Clip: TRect);
		procedure SetEnd(Value: TMegaColor);
		procedure SetStart(Value: TMegaColor);
		procedure SetStyle(Value: TPictureStyle);
		procedure SetType(Value: TGradientType);
		procedure SetSteps(Value: integer);
		procedure SetColors;
	public
		constructor Create(Panel: TMegapanel);
	published
		property Bands: integer read FSteps write SetSteps default 64;
		property EndColor: TMegaColor read FEnd write SetEnd default clBlue;
		property FillType: TGradientType read FType write SetType default gtNone;
		property StartColor: TMegaColor read FStart write SetStart default clBlack;
		property Style: TPictureStyle read FStyle write SetStyle default psAll;
		end;


{// TShadowEffect /////////////////////////////////////////////////////////////}
	TShadowEffect = class(TPersistent)
	private
		FPanel: TMegaPanel;
		FColor: TMegaColor;
		FStyle: TColorStyle;
		FXOffset: integer;
		FYOffset: integer;
		procedure SetColor(Value: TMegaColor);
		procedure SetShadow(Value: TColorStyle);
		procedure SetXOffset(Value: integer);
		procedure SetYOffset(Value: integer);
	public
		constructor Create(Panel: TMegaPanel);
	published
		property Color: TMegaColor read FColor write SetColor default clGray;
		property Style: TColorStyle read FStyle write SetShadow default csTransparent;
		property XOffset: integer read FXOffset write SetXOffset default 4;
		property YOffset: integer read FYOffset write SetYOffset default 4;
		end;


{// TFocusEffect //////////////////////////////////////////////////////////////}
	TFocusEffect = class(TPersistent)
	private
		FEffect: TEffect;
		FBack: TMegaColor;
		FBevel: TPanelBevel;
		FFontColor: TMegaColor;
		FStyle: TFontStyle;
		FColStyle: TColorStyle;
		procedure SetLabelBack(Value: TMegaColor);
	public
		constructor Create;
	published
		property Effect: TEffect read FEffect write FEffect default feNone;
		property LabelBackground: TMegaColor read FBack write SetLabelBack default clNone;
		property LabelBackgroundStyle: TColorStyle read FColStyle write FColStyle default csOpaque;
		property LabelBevel: TPanelBevel read FBevel write FBevel default bvNone;
		property LabelFontColor: TMegaColor read FFontColor write FFontColor default clBlack;
		property LabelFontStyle: TFontStyle read FStyle write FStyle default fsNormal;
		end;


{// TMegaPanel ////////////////////////////////////////////////////////////////}
	TMegaPanel = class(TCustomPanel)
	private
		FClassFix: TStrings;
		FGradient: TGradient;
		FShadow: TShadowEffect;
		FFocus: TFocusEffect;
		FFixKeys: TFixKeys;
		FResizeEnable: boolean;
		FResizeDesign: boolean;
		FResizeControls: TResizeConts;
		FResizeFonts: TResizeFonts;
		FVertJustify: TVertJust;
		FHorzJustify: integer;
		FString: string;
		FRect: TRect;
		FRad: real;
		FAngle: integer;
		FRotatedFont: HFont;
		FIsCaption: boolean;
		FTagUsage: TTagUsage;
		FPanelFraming: integer;
		FPanelBevelInner: TPanelBevel;
		FPanelBevelWidth: integer;
		FPanelBevelOuter: TPanelBevel;
		FPanelBevelMargin: integer;
		FPanelBorderStyle: TBorderStyle;
		FPanelBorderWidth: integer;
		FPanelFormAlign: TAlign;
		FPanelFormName: string;
		FPanelFormView: TDesignView;
		FPanelForm: TForm;
		FCaptionFraming: integer;
		FCaptionPos: TCaptionPos;
		FCaptionAngle: integer;
		FCaptionBevelWidth: integer;
		FCaptionBevelInner: TPanelBevel;
		FCaptionBevelOuter: TPanelBevel;
		FCaptionBevelMargin: integer;
		FCaptionBorderWidth: integer;
		FCaptionBorderStyle: TBorderStyle;
		FCaptionClear: integer;
		FCaptionFont: TFont;
		FCaptionLoc: TCaptionLoc;
		FCaptionFontStyle: TFontStyle;
		FCaptionSpace: integer;
		FCaptionStyle: TCaptionStyle;
		FCaptionHorzJust: THorzJust;
		FLabelList: TList;
		FDividersVert: integer;
		FDividersHorz: integer;
		FDividerBevel: TPanelBevel;
		FDividerWidth: integer;
		FDividerColor1: TMegaColor;
		FDividerColor2: TMegaColor;
		FTextHeight: integer;
		FTextWidth: integer;
		FLabelAngle: integer;
		FLabelStyle: TLabelStyle;
		FLabelFont: TFont;
		FLabelWidth: integer;
		FLabelHeight: integer;
		FLabelPos: TLabelPos;
		FLabelBevel: TPanelBevel;
		FLabelClear: integer;
		FLabelSpace: integer;
		FLabelBevelWidth: integer;
		FLabelFontStyle: TFontStyle;
		FLabelHorzJust: THorzJust;
		FLabelVertJust: TVertJust;
		FLabelX: integer;
		FLabelY: integer;
		FLabelType: TLabelType;
		FColorHighlight: TMegaColor;
		FColorShadow: TMegaColor;
		FColorDisabled: TMegaColor;
		FColorCaptionBkgnd: TMegaColor;
		FColorLabelBkgnd: TMegaColor;
		FCtlLabelCol: TMegaColor;
		FCtlLabelBkgnd: TMegaColor;
		FPanelColStyle, FCaptionColStyle, FLabelColStyle: TColorStyle;
		FAutoCenter: TAutoCenter;
		FPicture: TBitmap;
		FPictureTransparent: TPictureTransparent;
		FPicturePos: TPicturePos;
		FPictureStyle: TPictureStyle;
		FPictureXOffset: integer;
		FPictureYOffset: integer;
		FCaptionPicture: TBitmap;
		FCaptionPictureTransparent: TPictureTransparent;
		FCaptionPicturePos: TPicturePos;
		FCaptionPictureStyle: TPictureStyle;
		FCaptionPictureXOffset: integer;
		FCaptionPictureYOffset: integer;
		FHideCount, Fx, Fy: integer;
		FTransparent, FUpdateControls, FClipChildren: boolean;
		FPainting, FResizing, FFormActivate: boolean;
		FFocusCtl: TWinControl;
		FFocusCtlFore, FFocusCtlBack: TColor;
		FWid, FHgt, FCapSize, FLabSize, FLabX, FLabY: integer;
		FCapSpc, FCapBevWid, FCapBevMar, FCapBorWid, FCapClr: integer;
		FPanBevWid, FPanBorWid, FPanBevMar, FDivWid: integer;
		FLabWid, FLabHgt, FLabBevWid, FLabClr, FLabSpc: integer;
		FShdXOff, FShdYOff, FPicXOff, FPicYOff, FCapPicXOff, FCapPicYOff: integer;
		FPanelFormDestroy: TNotifyEvent;
		FOnAutoCenter: TNotifyEvent;
		FOnRescale: TNotifyEvent;
		FOnPanelFormActivated: TPanelFormEvent;
		FOnPanelFormDeActivated: TPanelFormEvent;
		FOnPanelFormDestroying: TPanelFormEvent;
		FOnPanelFormShow: TPanelFormEvent;
		FOnPanelFormHide: TPanelFormEvent;
		procedure SetClassFixups(Value: TStrings);
		procedure SetGradient(Value: TGradient);
		procedure SetShadowEffect(Value: TShadowEffect);
		procedure SetFocusEffect(Value: TFocusEffect);
		procedure SetResizeFonts(Value: TResizeFonts);
		procedure SetResizeControls(Value: TResizeConts);
		procedure SetAutoCenter(Value: TAutoCenter);
		procedure SetLabelAngle(Value: integer);
		procedure SetLabelFont(Value: TFont);
		procedure SetLabelStyle(Value: TLabelStyle);
		procedure SetLabelHorzJust(Value: THorzJust);
		procedure SetLabelVertJust(Value: TVertJust);
		procedure SetLabelWidth(Value: integer);
		procedure SetLabelHeight(Value: integer);
		procedure SetLabelPos(Value: TLabelPos);
		procedure SetLabelBevelWidth(Value: integer);
		procedure SetLabelClear(Value: integer);
		procedure SetLabelSpace(Value: integer);
		procedure SetLabelFontStyle(Value: TFontStyle);
		procedure SetLabelBevel(Value: TPanelBevel);
		procedure SetLabelX(Value: integer);
		procedure SetLabelY(Value: integer);
		procedure SetLabelType(Value: TLabelType);
		procedure SetDividerBevel(Value: TPanelBevel);
		procedure SetDividerWidth(Value: integer);
		procedure SetCaptionHorzJust(Value: THorzJust);
		procedure SetCaptionStyle(Value: TCaptionStyle);
		procedure SetCaption(Value: string);
		procedure SetCaptionAngle(Value: integer);
		procedure SetCaptionPos(Value: TCaptionPos);
		procedure SetCaptionBevelWidth(Value: integer);
		procedure SetCaptionBevelInner(Value: TPanelBevel);
		procedure SetCaptionBevelOuter(Value: TPanelBevel);
		procedure SetCaptionBevelMargin(Value: integer);
		procedure SetCaptionBorderWidth(Value: integer);
		procedure SetCaptionClear(Value: integer);
		procedure SetCaptionFont(Value: TFont);
		procedure SetCaptionSpace(Value: integer);
		procedure SetCaptionLoc(Value: TCaptionLoc);
		procedure SetCaptionFontStyle(Value: TFontStyle);
		procedure SetDividersHorz(Value: integer);
		procedure SetDividersVert(Value: integer);
		procedure SetColorHighlight(Value: TMegaColor);
		procedure SetColorShadow(Value: TMegaColor);
		procedure SetColorDisabled(Value: TMegaColor);
		procedure SetColorCaptionBkgnd(Value: TMegaColor);
		procedure SetColorLabelBkgnd(Value: TMegaColor);
		procedure SetCaptionBorderStyle(Value: TBorderStyle);
		procedure SetTagUsage(Value: TTagUsage);
		procedure SetPanelBevelMargin(Value: integer);
		procedure SetPanelColor(Value: TMegaColor);
		procedure SetPanelBevelInner(Value: TPanelBevel);
		procedure SetPanelBevelWidth(Value: integer);
		procedure SetPanelBevelOuter(Value: TPanelBevel);
		procedure SetPanelBorderStyle(Value: TBorderStyle);
		procedure SetPanelBorderWidth(Value: integer);
		procedure SetPanelFormAlign(Value: TAlign);
		procedure SetPanelFormName(Value: string);
		procedure SetPanelForm(Value: TForm);
		procedure SetPicture(Value: TBitmap);
		procedure SetPicturePos(Value: TPicturePos);
		procedure SetPictureTransparent(Value: TPictureTransparent);
		procedure SetPictureStyle(Value: TPictureStyle);
		procedure SetPictureXOffset(Value: integer);
		procedure SetPictureYOffset(Value: integer);
		procedure SetCaptionPicture(Value: TBitmap);
		procedure SetCaptionPicturePos(Value: TPicturePos);
		procedure SetCaptionPictureTransparent(Value: TPictureTransparent);
		procedure SetCaptionPictureStyle(Value: TPictureStyle);
		procedure SetCaptionPictureXOffset(Value: integer);
		procedure SetCaptionPictureYOffset(Value: integer);
		procedure SetParentFont(Value: boolean);
		procedure SetPanelFormView(Value: TDesignView);
		procedure SetPanelColStyle(Value: TColorStyle);
		procedure SetCaptionColStyle(Value: TColorStyle);
		procedure SetLabelColStyle(Value: TColorStyle);
		procedure SetClipChildren(Value: boolean);
		procedure SetWSClipChild;
		procedure SetScalingFactors;
		procedure DrawTextRect(Offset: integer);
		procedure DrawTextStyle(DrawStyle: TFontStyle; DrawColor: TMegaColor);
		procedure PaintPanelForm(pr: TRect);
		procedure ReleasePanelForm;
		procedure DrawPanel;
		procedure PanelText;
		procedure ControlShadows;
		procedure RealignPanel;
		procedure DoAutoCenter;
		procedure AdjustTextRect;
		procedure CanvasFont(AFont: TFont);
		procedure DeleteRotatedFont;
		procedure RotateFont(Angle: integer; AFont: TFont);
		procedure InvalidateLiveLabel(Ctl: TWinControl);
		procedure InvalidateShadow(Ctl: TControl);
		procedure InvalidatePanel;
		procedure FocusControl(Ctl: TWinControl);
		procedure UnFocusControl;
		procedure PaintCaption;
		procedure PaintGradient(ClipRect: TRect);
		procedure PaintPicture(ClipRect, PicRect: TRect; Pic: TBitmap; Sty: TPictureStyle;
							   Pos: TPicturePos; XOffset, YOffset: integer; Tran: TPictureTransparent);
		procedure TransStretchBlt(Bmp: TBitmap; dr, sr: TRect; TransparentColor: TColor; FreeFlag: boolean);
		procedure PaintShadow(Ctl: TControl);
		procedure PaintDitherRect(r: TRect; c: TMegaColor);
		procedure PaintRopRect(r: TRect; c: TMegaColor; Style: TColorStyle);
		procedure UpdateClassFixups;
		procedure PanelFormDestroy(Sender: TObject);
		function CreateShadowRgn(Ctl: TControl): HRgn;
		function AdjustPanelRect(Rect: TRect): TRect;
		function GroupBoxOffset: integer;
		function UnSafe: boolean;
		function LabelRect(LabelCtl: TControl): TRect;
		function GetCaption: string;
		function GetColor: TMegaColor;
		function GetParentFont: boolean;
		function RotatedCaptionRect: TRect;
		function InsideCaptionRect: TRect;
		function InsidePanelRect: TRect;
		function PanelFraming: integer;
		function CaptionFraming: integer;
		function TxWidth(s: string): integer;
		function TxHeight(s: string): integer;
		function GetPanelLabel(Ctl: TControl): string;
		function PanelFormRect: TRect;
		property Alignment;
		property BevelInner;
		property BevelWidth;
		property BevelOuter;
		property BorderStyle;
		property BorderWidth;
		property Color;
		property Font;
	protected
		procedure Loaded; override;
		procedure WMWinPosChanging(var Message: TWMWindowPosChanging); message WM_WINDOWPOSCHANGING;
		procedure WMSize(var Message: TWMSize); message WM_SIZE;
		procedure WMMove(var Message: TWMMove); message WM_MOVE;
		procedure WMMegaText(var Message: TMessage); message WM_MEGATEXT;
		procedure WMDestroy(var Message: TWMDestroy); message WM_DESTROY;
		procedure WMEraseBkgnd(var Message: TWMEraseBkgnd); message WM_ERASEBKGND;
		procedure WMNCPaint(var Message: TWMNCPaint); message WM_NCPAINT;
		procedure WMCTLColor(var Message: TWMCTLColor); message WM_CTLCOLOR;
		procedure WMMouseMove(var Message: TWMMouseMove); message WM_MOUSEMOVE;
		procedure AlignControls(AControl: TControl; var Rect: TRect); override;
		procedure Notification(AComponent: TComponent; Operation: TOperation); override;
		procedure CreateParams(var Params: TCreateParams); override;
		procedure Paint; override;
		procedure InvalidateLabel(Ctl: TControl);
		procedure WriteState(Writer: TWriter); override;
		function GetPalette: HPalette; override;
		function CaptionRect: TRect;
	public
		class function GetCopyright: string;
		constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;
		procedure ActivatePanelForm;
		procedure ControlHint(Ctl: TControl; Hnt: string);
		property Canvas;
		property PanelForm: TForm read FPanelForm write SetPanelForm;
		property ScaleXDivisor: integer read FWid;
		property ScaleYDivisor: integer read FHgt;
		property ScaleXMultiplier: integer read Fx;
		property ScaleYMultiplier: integer read Fy;
	published
		property AutoCenter: TAutoCenter read FAutoCenter write SetAutoCenter default [];
		property Caption: string read GetCaption write SetCaption;
		property CaptionAngle: integer read FCaptionAngle write SetCaptionAngle default 0;
		property CaptionBevelInner: TPanelBevel read FCaptionBevelInner write SetCaptionBevelInner default bvNone;
		property CaptionBevelOuter: TPanelBevel read FCaptionBevelOuter write SetCaptionBevelOuter default bvRaised;
		property CaptionBevelMargin: integer read FCaptionBevelMargin write SetCaptionBevelMargin default 2;
		property CaptionBevelWidth: integer read FCaptionBevelWidth write SetCaptionBevelWidth default 1;
		property CaptionBorderStyle: TBorderStyle read FCaptionBorderStyle write SetCaptionBorderStyle default bsNone;
		property CaptionBorderWidth: integer read FCaptionBorderWidth write SetCaptionBorderWidth default 1;
		property CaptionClearance: integer read FCaptionClear write SetCaptionClear default 2;
		property CaptionFont: TFont read FCaptionFont write SetCaptionFont;
		property CaptionFontStyle: TFontStyle read FCaptionFontStyle write SetCaptionFontStyle default fsNormal;
		property CaptionHorzJustify: THorzJust read FCaptionHorzJust write SetCaptionHorzJust default hjLeft;
		property CaptionLocation: TCaptionLoc read FCaptionLoc write SetCaptionLoc default clOutsideFrame;
		property CaptionPicture: TBitmap read FCaptionPicture write SetCaptionPicture;
		property CaptionPicturePosition: TPicturePos read FCaptionPicturePos write SetCaptionPicturePos default ppTile;
		property CaptionPictureStyle: TPictureStyle read FCaptionPictureStyle
									  write SetCaptionPictureStyle default psCaptionInsideFrame;
		property CaptionPictureTransparent: TPictureTransparent read FCaptionPictureTransparent
											write SetCaptionPictureTransparent default ptNone;
		property CaptionPictureXOffset: integer read FCaptionPictureXOffset write SetCaptionPictureXOffset default 0;
		property CaptionPictureYOffset: integer read FCaptionPictureYOffset write SetCaptionPictureYOffset default 0;
		property CaptionPosition: TCaptionPos read FCaptionPos write SetCaptionPos default cpTopLeft;
		property CaptionSpace: integer read FCaptionSpace write SetCaptionSpace default 2;
		property CaptionStyle: TCaptionStyle read FCaptionStyle write SetCaptionStyle default csNone;
		property ClipChildControls: boolean read FClipChildren write SetClipChildren default False;
		property ColorCaptionBkgnd: TMegaColor read FColorCaptionBkgnd write SetColorCaptionBkgnd default clBtnFace;
		property ColorCaptionStyle: TColorStyle read FCaptionColStyle write SetCaptionColStyle default csOpaque;
		property ColorControlLabel: TMegaColor read FCtlLabelCol write FCtlLabelCol default clNone;
		property ColorControlLabelBkgnd: TMegaColor read FCtlLabelBkgnd write FCtlLabelBkgnd default clNone;
		property ColorDisabledLabel: TMegaColor read FColorDisabled write SetColorDisabled default clInactiveCaptionText;
		property ColorHighlight: TMegaColor read FColorHighlight write SetColorHighlight default clBtnHighlight;
		property ColorLabelBkgnd: TMegaColor read FColorLabelBkgnd write SetColorLabelBkgnd default clNone;
		property ColorLabelStyle: TColorStyle read FLabelColStyle write SetLabelColStyle default csOpaque;
		property ColorPanel: TMegaColor read GetColor write SetPanelColor default clBtnFace;
		property ColorPanelStyle: TColorStyle read FPanelColStyle write SetPanelColStyle default csOpaque;
		property ColorShadow: TMegaColor read FColorShadow write SetColorShadow default clBtnShadow;
		property CtlShadow: TShadowEffect read FShadow write SetShadowEffect;
		property DividerBevel: TPanelBevel read FDividerBevel write SetDividerBevel default bvLowered;
		property DividersHorz: integer read FDividersHorz write SetDividersHorz default 0;
		property DividersVert: integer read FDividersVert write SetDividersVert default 0;
		property DividerWidth: integer read FDividerWidth write SetDividerWidth default 2;
		property FixKeys: TFixKeys read FFixKeys write FFixKeys default [fkEnter, fkUpDown];
		property FixClasses: TStrings read FClassFix write SetClassFixups;
		property GradientFill: TGradient read FGradient write SetGradient;
		property LabelAngle: integer read FLabelAngle write SetLabelAngle default 0;
		property LabelBevel: TPanelBevel read FLabelBevel write SetLabelBevel default bvNone;
		property LabelBevelWidth: integer read FLabelBevelWidth write SetLabelBevelWidth default 1;
		property LabelClearance: integer read FLabelClear write SetLabelClear default 2;
		property LabelControlX: integer read FLabelX write SetLabelX default 3;
		property LabelControlY: integer read FLabelY write SetLabelY default 3;
		property LabelFocusEffect: TFocusEffect read FFocus write SetFocusEffect;
		property LabelFont: TFont read FLabelFont write SetLabelFont;
		property LabelFontStyle: TFontStyle read FLabelFontStyle write SetLabelFontStyle default fsNormal;
		property LabelHeight: integer read FLabelHeight write SetLabelHeight default 0;
		property LabelHorzJustify: THorzJust read FLabelHorzJust write SetLabelHorzJust default hjRight;
		property LabelPosition: TLabelPos read FLabelPos write SetLabelPos default lpLeftTop;
		property LabelSpace: integer read FLabelSpace write SetLabelSpace default 4;
		property LabelStyle: TLabelStyle read FLabelStyle write SetLabelStyle default lsNone;
		property LabelType: TLabelType read FLabelType write SetLabelType default ltNormal;
		property LabelVertJustify: TVertJust read FLabelVertJust write SetLabelVertJust default vjCenter;
		property LabelWidth: integer read FLabelWidth write SetLabelWidth default 75;
		property PanelBevelInner: TPanelBevel read FPanelBevelInner write SetPanelBevelInner default bvNone;
		property PanelBevelMargin: Integer read FPanelBevelMargin write SetPanelBevelMargin default 0;
		property PanelBevelOuter: TPanelBevel read FPanelBevelOuter write SetPanelBevelOuter default bvRaised;
		property PanelBevelWidth: integer read FPanelBevelWidth write SetPanelBevelWidth default 1;
		property PanelBorderStyle: TBorderStyle read FPanelBorderStyle write SetPanelBorderStyle default bsNone;
		property PanelBorderWidth: integer read FPanelBorderWidth write SetPanelBorderWidth default 0;
		property PanelFormActivate: boolean read FFormActivate write FFormActivate default True;
		property PanelFormAlign: TAlign read FPanelFormAlign write SetPanelFormAlign default alClient;
		property PanelFormDesignView: TDesignView read FPanelFormView write SetPanelFormView stored False default dvNormal;
		property PanelFormName: string read FPanelFormName write SetPanelFormName;
		property ParentFont: boolean read GetParentFont write SetParentFont default True;
		property Picture: TBitmap read FPicture write SetPicture;
		property PicturePosition: TPicturePos read FPicturePos write SetPicturePos default ppTile;
		property PictureStyle: TPictureStyle read FPictureStyle write SetPictureStyle default psAll;
		property PictureTransparent: TPictureTransparent read FPictureTransparent write SetPictureTransparent default ptNone;
		property PictureXOffset: integer read FPictureXOffset write SetPictureXOffset default 0;
		property PictureYOffset: integer read FPictureYOffset write SetPictureYOffset default 0;
		property ResizeEnabled: boolean read FResizeEnable write FResizeEnable default True;
		property ResizeControls: TResizeConts read FResizeControls write SetResizeControls
					default [rcHorizontal, rcVertical, rcCaptionFrames, rcPanelFrames, rcLabelFrames,
							 rcCtlShadow, rcPictureOffsets, rcGridCells, rcGridLines];
		property ResizeFonts: TResizeFonts read FResizeFonts write SetResizeFonts default [rfCaption, rfLabels, rfControls];
		property ResizeWhileDesigning: boolean read FResizeDesign write FResizeDesign default False;
		property TagUsage: TTagUsage read FTagUsage write SeTTagUsage default tuNone;
		property Align;
		property Ctl3D;
		property Cursor;
		property DragCursor;
		property DragMode;
		property Enabled;
		property Height;
		property HelpContext;
		property Left;
		property Locked;
		property Name;
		property ParentColor;
		property ParentCtl3D;
		property ParentShowHint;
		property ShowHint;
		property TabOrder;
		property Tag;
		property TabStop;
		property Top;
		property Visible;
		property Width;
		property OnClick;
		property OnDblClick;
		property OnDragDrop;
		property OnDragOver;
		property OnEndDrag;
		property OnEnter;
		property OnExit;
		property OnMouseDown;
		property OnMouseMove;
		property OnMouseUp;
		property OnResize;
		property OnAutoCenter: TNotifyEvent read FOnAutoCenter write FOnAutoCenter;
		property OnRescale: TNotifyEvent read FOnRescale write FOnRescale;
		property OnPanelFormActivated: TPanelFormEvent read FOnPanelFormActivated write FOnPanelFormActivated;
		property OnPanelFormDeActivated: TPanelFormEvent read FOnPanelFormDeactivated write FOnPanelFormDeactivated;
		property OnPanelFormDestroying: TPanelFormEvent read FOnPanelFormDestroying write FOnPanelFormDestroying;
		property OnPanelFormShow: TPanelFormEvent read FOnPanelFormShow write FOnPanelFormShow;
		property OnPanelFormHide: TPanelFormEvent read FOnPanelFormHide write FOnPanelFormHide;
		end;

procedure Register;
procedure GetMegaColorValues(Proc: TGetStrProc);
function IdentToMegaColor(const Ident: string; var Color: Longint): Boolean;
function MegaColorToIdent(Color: Longint; var Ident: string): Boolean;
function MegaColorToString(Color: TMegaColor): string;
function MegaColorToRGB(Color: TMegaColor): longint;
procedure SetFixKeys(Ctl: TWinControl; Fix: TFixKeys);
procedure SetClassFix(Ctl: TControl; Fix: TClassFixup);
function GetFixKeys(Ctl: TWinControl): TFixKeys;
function GetClassFix(Ctl: TControl): TClassFixup;

const
AutoAddFixups: boolean = False;
CleanupFixups: boolean = True;

implementation

uses {$IFDEF SHAREWARE}Dialogs,{$ENDIF}Consts, IniFiles, TypInfo;

{// Delphi 16 Fixerupers //////////////////////////////////////////////////////}
{$IFNDEF WIN32}
const
	WM_COPYDATA = $004A;

type
	DWORD = longint;
	UInt = Word;
	WParam = Word;
	LParam = longint;
	LResult = longint;
	TCopyDataStruct = packed record
		dwData: DWORD;
		cbData: DWORD;
		lpData: Pointer;
		end;
{$ENDIF}

type	{ For the benefit of Delphi 1 which won't allow - if Assigned(TWinControl.OnKeyPress) }
	ProcHack = packed record
		case word of
			0: (tke: TKeyEvent);
			1: (tkp: TKeyPressEvent);
			2: (ptr: pointer);
			end;


{// Forward References and Class Enablers /////////////////////////////////////}
type
	TMegaCtl = class(TControl);
	TMegaWin = class(TWinControl);
	TMegaGrid = class(TCustomGrid);


{// TGridInfo /////////////////////////////////////////////////////////////////}
	TGridInfo = class(TObject)
	protected
		GridLineWidth: integer;
		DefaultColWidth: integer;
		DefaultRowHeight: integer;
		TitleSize: integer;
		ColWidths: TList;
	public
		constructor Create(Grd: TMegaGrid);
		destructor Destroy; override;
		end;


{// TMegaInfo /////////////////////////////////////////////////////////////////}
	TMegaInfo = class(TObject)
	private
		Pnl: TMegaPanel;
		Ctl: TControl;
		Par: TControl;
{$IFDEF VER120}
		Hwn: HWND;
{$ELSE}
		Hwn: integer;
{$ENDIF}
		Prc: pointer;
		Key: TFixKeys;
		Fix: TClassFixup;
		Acl: Word;
		Lft: integer;
		Top: integer;
		Wid: integer;
		Hgt: integer;
		Fnt: integer;
		Dfs: integer;
		Ddw: integer;
		Dlw: integer;
		Gin: TGridInfo;
	public
		constructor Create(Panel: TMegaPanel; Control: TControl; HWindow: HWnd);
		destructor Destroy; override;
		end;


{// TMegaList /////////////////////////////////////////////////////////////////}
	TMegaList = class(TList)
	public
		function AddControl(Panel: TMegaPanel; Control: TControl; HWindow: HWnd): TMegaInfo;
		function AddHandle(Panel: TMegaPanel; HWindow: HWnd): TMegaInfo;
		procedure RemoveControl(Ctl: TControl);
		procedure RemoveHandle(HWindow: HWnd);
		procedure Update(Panel: TMegaPanel);
		procedure DestroyPanel(Panel: TMegaPanel);
		function GetControlInf(Ctl: TControl): TMegaInfo;
		function GetHandleInf(Handle: HWnd): TMegaInfo;
		end;


{// TColorEntry ///////////////////////////////////////////////////////////////}
	TColorEntry = packed record
		Value: TMegaColor;
		Name: PChar;
		end;

var
	CopyrightNotice: string;
	MegaList: TMegaList;
	ShadowBmp, DitherBmp: TBitMap;
{$IFNDEF WIN32}
	MegaProcInst: TFarProc;
{$ENDIF}


const
	SWP_HIDE = SWP_NOSIZE + SWP_NOMOVE + SWP_NOZORDER + SWP_NOACTIVATE + SWP_HIDEWINDOW;
	SWP_SHOW = SWP_NOSIZE + SWP_NOMOVE + SWP_NOZORDER + SWP_NOACTIVATE + SWP_SHOWWINDOW;
	WM_SYSTIMER = $0118;
	WS_EX_TRANSPARENT = $00000020;
	OldColor: array[0..4] of TColorEntry =
	   ((Value: clOld3DDkShadow;	Name: 'clBtnDarkShadow'),
		(Value: clOld3DLight;	 	Name: 'clBtnLight'),
		(Value: clOldInfoText;	 	Name: 'clInfoText'),
		(Value: clOldInfoBk;	 	Name: 'clInfoWindow'),
		(Value: clOldNone;		 	Name: 'clNone'));
	NewColor: array[0..4] of TColorEntry =
	   ((Value: cl3DDkShadow;		Name: 'cl3DDkShadow'),
		(Value: cl3DLight;  		Name: 'cl3DLight'),
		(Value: clInfoText; 		Name: 'clInfoText'),
		(Value: clInfoBk;	 		Name: 'clInfoBk'),
		(Value: clNone;				Name: 'clNone'));
	Colormax = 4;
	LiveCtl: TWinControl = nil;
	FocusPnl: TMegaPanel = nil;
	TitleFontIndex: integer = 0;
	DropFontIndex: integer = 0;
	DropWidthIndex: integer = 0;
	DropLineIndex: integer = 0;
	DropOpenIndex: integer = 0;


procedure Register;
	begin
	RegisterComponents('Standard', [TMegaPanel]);
	end;


procedure DebugStr(const DebugMsg: String);
var
  CDS	: TCopyDataStruct;
  DbWin	: hWnd;
  Msg	: PChar;
  LenStr	: Integer;
begin
  DbWin := FindWindow('TDbWinScrn', nil);
  if DbWin <> 0 then begin
    LenStr := Length(DebugMsg) + 1;
    CDS.cbData := LenStr;
    GetMem(Msg,LenStr);
    Try
      StrPCopy(Msg,DebugMsg);
      CDS.lpData := Msg;
      SendMessage(DbWin, WM_COPYDATA, 0, LParam(@CDS));
    Finally
      FreeMem(Msg,LenStr);
      end;
    end;

end;


{// MegaColor Helpers /////////////////////////////////////////////////////////}
procedure GetMegaColorValues(Proc: TGetStrProc);
{$IFNDEF WIN32}
	var
	i: integer;
{$ENDIF}
	begin
	GetColorValues(Proc);
{$IFNDEF WIN32}
	for i := 0 to ColorMax do
		Proc(StrPas(NewColor[i].Name));
{$ENDIF}
	end;


function IdentToMegaColor(const Ident: string; var Color: Longint): Boolean;
	var
	i: integer;
	Text: array[0..32] of char;
	begin
	Result := IdentToColor(Ident, Color);
	if not Result then
		begin
		StrPLCopy(Text, Ident, SizeOf(Text) - 1);
		for i := 0 to ColorMax do
			if (StrIComp(OldColor[i].Name, Text) = 0)
				or (StrIComp(NewColor[i].Name, Text) = 0) then
				begin
				Result := True;
				Color := NewColor[i].Value;
				exit;
				end;
		end;
	end;


function MegaColorToIdent(Color: Longint; var Ident: string): Boolean;
	var
	i: integer;
	begin
	Result := ColorToIdent(Color, Ident);
	if not Result then
		begin
		for i := 0 to ColorMax do
		    if (OldColor[i].Value = Color)
				or (NewColor[i].Value = Color) then
				begin
				Result := True;
				Ident := StrPas(NewColor[i].Name);
				exit;
				end;
		end;
	end;


function MegaColorToString(Color: TMegaColor): string;
	begin
	if not MegaColorToIdent(Color, Result) then
		FmtStr(Result, '$%.8x', [Color]);
	end;


function MegaColorToRGB(Color: TMegaColor): longint;
	begin
	if Color < 0 then
	    Result := GetSysColor(Color and $000000FF)
	else
	    Result := Color;
	end;


function IsColorNone(Value: longint): boolean;
	begin
	Result := (Value = clNone) or (Value = clOldNone);
	end;



function IsDBFilterCombo(Ctl: TControl): boolean;
	var
	i, AllocSize, Count: integer;
	PropInfo: PPropInfo;
	PropList: PPropList;
	begin
	Result := False;
	if CompareText(Ctl.ClassName, 'TDBFilterCombo') = 0 then
		begin
		Result := True;
		if (DropFontIndex * DropWidthIndex * DropLineIndex * DropOpenIndex) = 0 then
			begin
			Count := GetTypeData(Ctl.ClassInfo)^.PropCount;
			if Count > 0 then
				begin
				AllocSize := Count * SizeOf(Pointer);
				GetMem(PropList, AllocSize);
				try
					GetPropInfos(Ctl.ClassInfo, PropList);
					for i := 0 to Count - 1 do
						begin
						PropInfo := PropList^[i];
						if CompareText(PropInfo^.Name, 'DropDownFont') = 0 then
							DropFontIndex := i;
						if CompareText(PropInfo^.Name, 'DropDownWidth') = 0 then
							DropWidthIndex := i;
						if CompareText(PropInfo^.Name, 'DropDownLineWidth') = 0 then
							DropLineIndex := i;
						if CompareText(PropInfo^.Name, 'DropDownOpen') = 0 then
							DropOpenIndex := i;
						if (DropFontIndex * DropWidthIndex * DropLineIndex * DropOpenIndex) <> 0 then
							break;
						end;
				finally
					FreeMem(PropList, AllocSize);
					end;
				end;
			end;
		if (DropFontIndex * DropWidthIndex * DropLineIndex * DropOpenIndex) = 0 then
			MessageBox(0, 'Invalid DBFilterCombo control !'#13'Expect Access Violation errors.', 'Megapanel', MB_OK);
		end;
	end;


function IsDBGrid(Ctl: TControl): boolean;
	var
	i, AllocSize, Count: integer;
	PropInfo: PPropInfo;
	PropList: PPropList;
	Ancestor: TClass;
	begin
	Result := False;
	Ancestor := Ctl.ClassType;
	while Ancestor <> nil do
		begin
		if CompareText(Ancestor.ClassName, 'TDBGrid') = 0 then
			begin
			Result := True;
			if TitleFontIndex = 0 then
				begin
				Count := GetTypeData(Ctl.ClassInfo)^.PropCount;
				if Count > 0 then
					begin
					AllocSize := Count * SizeOf(Pointer);
					GetMem(PropList, AllocSize);
					try
						GetPropInfos(Ctl.ClassInfo, PropList);
						for i := 0 to Count - 1 do
							begin
							PropInfo := PropList^[i];
							if CompareText(PropInfo^.Name, 'TitleFont') = 0 then
								begin
								TitleFontIndex := i;
								break;
								end;
							end;
					finally
						FreeMem(PropList, AllocSize);
						end;
					end;
				end;
			if TitleFontIndex = 0 then
				MessageBox(0, 'Invalid DBGrid control !'#13'Expect Access Violation errors.', 'Megapanel', MB_OK);
			exit;
			end;
		Ancestor := Ancestor.ClassParent;
		end;
	end;


{// General Methods ///////////////////////////////////////////////////////////}
function min(a, b: longint): longint;
	begin
	if a < b then
		Result := a
	else
		Result := b;
	end;


function max(a, b: longint): longint;
	begin
	if a > b then
		Result := a
	else
		Result := b;
	end;


procedure ListAdd(var List: TList; Item: Pointer);
	begin
	if List = nil then
		List := TList.Create;
	List.Add(Item);
	end;


procedure ListRemove(var List: TList; Item: Pointer);
	begin
	if List <> nil then
		begin
		List.Remove(Item);
		if List.Count = 0 then
			begin
			List.Free;
			List := nil;
			end;
		end;
	end;


function FindAccelerator(s: string): Word;
	var
	i, l: integer;
	begin
	Result := 0;
	l := Length(s);
	for i := 1 to l do
		if (s[i] = '&')
			and (i < l)
			and (s[i + 1] <> '&')
			and (((i > 1) and (s[i - 1] <> '&')) or (i = 1)) then
			begin
			Result := Word(s[i + 1]) and $DF;
			break;
			end;
	end;


procedure SetFixKeys(Ctl: TWinControl; Fix: TFixKeys);
	var
	Inf: TMegaInfo;
	begin
	Inf := MegaList.GetControlInf(Ctl);
	if Inf <> nil then
		Inf.Key := Fix;
	end;


procedure SetClassFix(Ctl: TControl; Fix: TClassFixup);
	var
	Inf: TMegaInfo;
	OldFix: TClassFixup;
	begin
	Inf := MegaList.GetControlInf(Ctl);
	OldFix := Inf.Fix;
	if (Inf = nil) or (Inf.Ctl = nil) or (Inf.Pnl = nil) then
		exit;
	if (cfPnlLabel in Inf.Fix)
		and not (cfPnlLabel in Fix)
		and ((Inf.Pnl.FLabelStyle = lsInPanel) or (Inf.Pnl.FLabelStyle = lsMixed)) then
		Inf.Pnl.InvalidateLabel(Inf.Ctl);
	if (cfCtlLabel in Inf.Fix)
		and not (cfCtlLabel in Fix)
		and ((Inf.Pnl.FLabelStyle = lsInControl) or (Inf.Pnl.FLabelStyle = lsInControl)) then
		Inf.Ctl.Invalidate;
	if (cfShadow in Inf.Fix)
		and not (cfShadow in Fix)
		and (Inf.Pnl.FShadow.FStyle <> csTransparent) then
		Inf.Pnl.InvalidateShadow(Ctl);
	Inf.Fix := Fix;
	if not (cfPnlLabel in OldFix)
		and (cfPnlLabel in Fix)
		and ((Inf.Pnl.FLabelStyle = lsInPanel) or (Inf.Pnl.FLabelStyle = lsMixed)) then
		Inf.Pnl.InvalidateLabel(Inf.Ctl);
	if not (cfCtlLabel in OldFix)
		and (cfCtlLabel in Fix)
		and ((Inf.Pnl.FLabelStyle = lsInControl) or (Inf.Pnl.FLabelStyle = lsInControl)) then
		Inf.Ctl.Invalidate;
	if not (cfShadow in OldFix)
		and (cfShadow in Fix)
		and (Inf.Pnl.FShadow.FStyle <> csTransparent) then
		Inf.Pnl.InvalidateShadow(Ctl);
	end;


function GetFixKeys(Ctl: TWinControl): TFixKeys;
	var
	Inf: TMegaInfo;
	begin
	Inf := MegaList.GetControlInf(Ctl);
	if Inf = nil then
		Result := []
	else
		Result := Inf.Key;
	end;


function GetClassFix(Ctl: TControl): TClassFixup;
	var
	Inf: TMegaInfo;
	begin
	Inf := MegaList.GetControlInf(Ctl);
	if Inf = nil then
		Result := []
	else
		Result := Inf.Fix;
	end;


function FocusAccelControl(Ctl: TWinControl; Wp: WParam): boolean;
	var
	Inf: TMegaInfo;
	begin
	Result := False;
	Inf := MegaList.GetHandleInf(Ctl.Handle);
	if Ctl.CanFocus
		and Ctl.Visible
		and Ctl.Enabled
		and (Inf <> nil)
		and (Inf.Acl = Wp and $DF) then
		begin
		Ctl.SetFocus;
		if Ctl is TButtonControl then
			begin
			PostMessage(Ctl.Handle, WM_LBUTTONDOWN, 0, MakeLong(1, 1));
			PostMessage(Ctl.Handle, WM_LBUTTONUP, 0, MakeLong(1, 1));
			end;
		Result := True;
		end;
	end;


{// ChildProc /////////////////////////////////////////////////////////////////}
function ChildProc(HWindow: HWnd; Message: UInt; Wp: WParam; Lp: LParam):
				   LResult; {$IFDEF WIN32} stdcall {$ELSE} export {$ENDIF};
	var
	i, AllocSize: integer;
	Inf: TMegaInfo;
	Ctl: TWinControl;
{$IFDEF VER100}
	PnlParent: TCustomForm;
{$ELSE}
{$IFDEF VER120}
	PnlParent: TCustomForm;
{$ELSE}
	PnlParent: TForm;
{$ENDIF}
{$ENDIF}
	Pnl: TMegaPanel;
	SkipKeys, KeyHandled: boolean;
	Shift: TShiftState;
	Hack: ProcHack;
	Wpar: word;
	WParc: char;
	PropList: PPropList;
	begin
	Inf := MegaList.GetHandleInf(HWindow);
	Pnl := Inf.Pnl;
	PnlParent := GetParentForm(Pnl);
	if (Inf <> nil) and (Message = WM_SYSCHAR) then
		begin
		if Pnl.Visible then
			for i := 0 to Pnl.ControlCount - 1 do
				if (Pnl.Controls[i] is TWinControl)
					and FocusAccelControl(TWinControl(Pnl.Controls[i]), Wp) then
					begin
					Result := 1;
					exit;
					end;
		for i := 0 to PnlParent.ComponentCount - 1 do
			if (PnlParent.Components[i] is TWinControl)
				and FocusAccelControl(TWinControl(PnlParent.Components[i]), Wp) then
				begin
				Result := 1;
				exit;
				end;
		end;
	Ctl := TWinControl(Inf.Ctl);
	SkipKeys := False;
	if (Ctl <> nil)
		and ((Message = WM_KEYDOWN) or (Message = WM_CHAR) or (Message = WM_KEYUP))
		and IsDBFilterCombo(Ctl) then
		begin
		AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
		GetMem(PropList, AllocSize);
		try
			GetPropInfos(Ctl.ClassInfo, PropList);
			SkipKeys := Boolean(GetOrdProp(Ctl, PropList^[DropOpenIndex])) ;
		finally
			FreeMem(PropList, AllocSize);
			end;
		end;
	KeyHandled := False;
	if not SkipKeys and
		((Message = WM_KEYDOWN) or (Message = WM_CHAR) or (Message = WM_KEYUP))
		and (Pnl.FixKeys <> []) and (Inf.Key <> [])
		and (((GetKeyState(VK_SHIFT) or GetKeyState(VK_CONTROL) or GetKeyState(VK_MENU)) and $8000) = 0) then
		begin
		PnlParent := GetParentForm(Pnl);
		if (Wp = VK_RETURN)
			and (fkEnter in (Pnl.FixKeys * Inf.Key))
			and (PnlParent <> nil) then
			begin
			if PnlParent.ActiveControl is TCustomGrid then
				begin
				if (Message = WM_KEYDOWN) then
					with TMegaGrid(PnlParent.ActiveControl) do
						begin
						if Row < (RowCount - 1) then
							Row := Row + 1
						else
							if Col < (ColCount - 1) then
								begin
								Row := FixedRows;
								Col := Col + 1;
								end
							else
								PostMessage(PnlParent.Handle, WM_NEXTDLGCTL, 0, 0);
						end;
				end
			else
				if (Message = WM_KEYDOWN) then
					PostMessage(PnlParent.Handle, WM_NEXTDLGCTL, 0, 0);
			KeyHandled := True;
			end;
		if ((Wp = VK_UP) or (Wp = VK_DOWN))
			and (fkUpDown in (Pnl.FixKeys * Inf.Key))
			and (PnlParent <> nil) then
			begin
			if (Message = WM_KEYDOWN) then
				PostMessage(PnlParent.Handle, WM_NEXTDLGCTL, Ord(Wp = VK_UP), 0);
			KeyHandled := True;
			end;
		end;
	if KeyHandled then
		begin
		if (Message = WM_KEYDOWN) then
			begin
			if (PnlParent <> nil)
				and PnlParent.KeyPreview then
				begin
				Shift := KeyDataToShiftState(Lp);
				WPar := word(Wp);
				Hack.tke := TMegaWin(PnlParent).OnKeyDown;
				if Assigned(Hack.ptr) then
					TMegaWin(PnlParent).OnKeyDown(Ctl, WPar, Shift);
				end;
			if (Ctl <> nil)
{$IFDEF WIN32}
				and not (csNoStdEvents in Ctl.ControlStyle)
{$ENDIF}
				then
				begin
				Hack.tke := TMegaWin(Ctl).OnKeyDown;
				if Assigned(Hack.ptr) then
					TMegaWin(Ctl).OnKeyDown(Ctl, WPar, Shift);
				end;
			end;
		if (Message = WM_CHAR) then
			begin
			if (PnlParent <> nil)
				and PnlParent.KeyPreview then
				begin
				WParc := char(Wp);
				Hack.tkp := TMegaWin(PnlParent).OnKeyPress;
				if Assigned(Hack.ptr) then
					TMegaWin(PnlParent).OnKeyPress(Ctl, WParc);
				end;
			if (Ctl <> nil)
{$IFDEF WIN32}
				and not (csNoStdEvents in Ctl.ControlStyle)
{$ENDIF}
				then
				begin
				Hack.tkp := TMegaWin(Ctl).OnKeyPress;
				if Assigned(Hack.ptr) then
					TMegaWin(Ctl).OnKeyPress(Ctl, WParc);
				end;
			end;
		if (Message = WM_KEYUP) then
			begin
			if (PnlParent <> nil)
				and PnlParent.KeyPreview then
				begin
				Shift := KeyDataToShiftState(Lp);
				WPar := word(Wp);
				Hack.tke := TMegaWin(PnlParent).OnKeyUp;
				if Assigned(Hack.ptr) then
					TMegaWin(PnlParent).OnKeyUp(Ctl, WPar, Shift);
				end;
			if (Ctl <> nil)
{$IFDEF WIN32}
				and not (csNoStdEvents in Ctl.ControlStyle)
{$ENDIF}
				then
				begin
				Hack.tke := TMegaWin(Ctl).OnKeyUp;
				if Assigned(Hack.ptr) then
					TMegaWin(Ctl).OnKeyUp(Ctl, WPar, Shift);
				end;
			end;
		if (Ctl <> nil) and IsDBFilterCombo(Ctl) then
			Result := CallWindowProc(Inf.Prc, HWindow, Message, Wp, Lp)
		else
			Result := 0;
		exit;
		end;
	if Ctl = nil then
		Ctl := TWinControl(Inf.Par);
	Result := CallWindowProc(Inf.Prc, HWindow, Message, Wp, Lp);
	if (Message = WM_DESTROY)
		or Pnl.FResizing then
		exit;
	if (cfFocEffect in Inf.Fix)
		and (Pnl.FFocus.FEffect = feLive)
		and (Message = WM_MOUSEMOVE) then
		Pnl.InvalidateLiveLabel(Ctl);
	if (cfFocEffect in Inf.Fix)
		and (Message = WM_SETFOCUS) then
		Pnl.FocusControl(Ctl);
	if (cfFocEffect in Inf.Fix)
		and (Message = WM_KILLFOCUS)
		and (FocusPnl <> nil) then
		FocusPnl.UnFocusControl;
	if (cfPnlLabel in Inf.Fix)
		and ((Message = WM_WINDOWPOSCHANGING) or (Message = WM_WINDOWPOSCHANGED) or (Message = WM_ENABLE))
		and ((Pnl.FLabelStyle = lsInPanel) or (Pnl.FLabelStyle = lsMixed)) then
		Pnl.InvalidateLabel(Ctl);
	if (cfShadow in Inf.Fix)
		and((Message = WM_WINDOWPOSCHANGING) or (Message = WM_WINDOWPOSCHANGED))
		and (Pnl.FShadow.FStyle <> csTransparent)
		and not IsColorNone(Pnl.FShadow.FColor) then
		Pnl.InvalidateShadow(Ctl);
	if (Inf.Ctl = nil)
		or (Pnl.FLabelStyle < lsInControl) then
		exit;
//@@
//	if Message = WM_PAINT then
//		for i := 0 to Ctl.ControlCount - 1 do
//			Ctl.Controls[i].Repaint;
//@@
	if (Message = WM_CHAR)
		and (Length(TMegaWin(Ctl).Text) = 1) then
		Ctl.Refresh;
	if TMegaWin(Ctl).Text <> '' then
		exit;
	if ((Pnl.FLabelList = nil) or (Pnl.FLabelList.IndexOf(Ctl) = -1))
		and (Message <> WM_NCHITTEST)
		and (Message <> WM_MOUSEMOVE)
		and (Message <> WM_SETCURSOR)
		and (Message <> WM_SYSTIMER)
		and (Message <> WM_GETTEXT) then
		begin
		if Pnl.FLabelList = nil then
			PostMessage(Pnl.Handle, WM_MEGATEXT, 0, 0);
		ListAdd(Pnl.FLabelList, Ctl);
		end;
	end;


{// TMegaInfo /////////////////////////////////////////////////////////////////}
constructor TMegaInfo.Create(Panel: TMegaPanel; Control: TControl; HWindow: HWnd);
	var
	i, AllocSize: integer;
	Child: HWnd;
	Inf: TMegaInfo;
	DoIt: boolean;
	Ini: TIniFile;
	s: string;
	PropList: PPropList;
	begin
	Pnl := Panel;
	Ctl := Control;
	Par := Panel;
	Hwn := HWindow;
	Prc := nil;
	Acl := 0;
	Fix := [];
	Key := [];
	Gin := nil;
	Dfs := 0;
	Ddw := 0;
	Dlw := 0;
	MegaList.Add(self);
	if Hwn <> 0 then
		begin
		Prc := pointer(GetWindowLong(Hwn, GWL_WNDPROC));
		SetWindowLong(Hwn, GWL_WNDPROC,  LParam({$IFDEF WIN32} @ChildProc {$ELSE} MegaProcInst {$ENDIF}));
		end;
	if Ctl <> nil then
		begin
		Lft := Ctl.Left;
		Top := Ctl.Top;
		Wid := Ctl.Width;
		Hgt := Ctl.Height;
		Fnt := TMegaCtl(Ctl).Font.Size;
		if Ctl is TCustomGrid then
			Gin := TGridInfo.Create(TMegaGrid(Ctl));
		if IsDBFilterCombo(Ctl) then
			begin
			AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
			GetMem(PropList, AllocSize);
			try
				GetPropInfos(Ctl.ClassInfo, PropList);
				Dfs := TFont(GetOrdProp(Ctl, PropList^[DropFontIndex])).Size;
				Ddw := GetOrdProp(Ctl, PropList^[DropWidthIndex]);
				Dlw := GetOrdProp(Ctl, PropList^[DropLineIndex]);
			finally
				FreeMem(PropList, AllocSize);
				end;
			end;
		if AutoAddFixups and not (csLoading in Pnl.ComponentState) and (csDesigning in Pnl.ComponentState) then
			begin
			DoIt := True;
			for i := 0 to Pnl.FClassFix.Count - 1 do
				if CompareText(Ctl.ClassName, Copy(Pnl.FClassFix[i], 7, 99)) = 0 then
					begin
					DoIt := False;
					break;
					end;
			if DoIt then
				begin
				Ini := TIniFile.Create(IniFile);
				s := Ini.ReadString(IniSection, Ctl.ClassName, '');
				if s = '' then
					begin
					if (Ctl is TWinControl) and TWinControl(Ctl).CanFocus then
						s := '111111' + Ctl.ClassName
					else
						s := '000100' + Ctl.ClassName;
					end
				else
					begin
					if length(s) < 6 then
						if Ctl is TWinControl then
							s := s + '111'
						else
							s := s + '100';
					s := s + Ctl.ClassName;
					end;
				Pnl.FClassFix.Add(s);
				Ini.Free;
				end;
			end;
		DoIt := True;
		for i := 0 to Pnl.FClassFix.Count - 1 do
			if CompareText(Ctl.ClassName, Copy(Pnl.FClassFix[i], 7, 99)) = 0 then
				begin
				DoIt := False;
				Key := [];
				if Pnl.FClassFix[i][1] = '1' then
					Key := Key + [fkEnter];
				if Pnl.FClassFix[i][2] = '1' then
					Key := Key + [fkUpDown];
				if Pnl.FClassFix[i][3] = '1' then
					Fix := Fix + [cfShadow];
				if Pnl.FClassFix[i][4] = '1' then
					Fix := Fix + [cfPnlLabel];
				if Pnl.FClassFix[i][5] = '1' then
					Fix := Fix + [cfCtlLabel];
				if Pnl.FClassFix[i][6] = '1' then
					Fix := Fix + [cfFocEffect];
				break;
				end;
		if DoIt then
			begin
			Key := [fkEnter, fkUpDown];
			Fix := [cfPnlLabel];
			if Ctl is TWinControl then
				Fix := Fix + [cfShadow, cfFocEffect];
			end;
		Acl := FindAccelerator(GetLongHint(Ctl.Hint));
		if Ctl is TCustomComboBox then
			begin
			Child := GetWindow(Hwn, GW_CHILD);
			while Child <> 0 do
				begin
				MegaList.AddHandle(Pnl, Child).Par := Ctl;
				Child := GetWindow(Child, GW_HWNDNEXT);
				end;
			end;
		end
	else
		begin
		Inf := MegaList.GetHandleInf(GetParent(Hwn));
		if Inf <> nil then
			begin
			Fix := Inf.Fix;
			Key := Inf.Key;
			end;
		end;
	end;


destructor TMegaInfo.Destroy;
	var
	Child: HWnd;
	begin
	MegaList.Remove(self);
	if (Hwn <> 0) and (Prc <> nil) then
		SetWindowLong(Hwn, GWL_WNDPROC, longint(Prc));
	ListRemove(Pnl.FLabelList, Ctl);
	Pnl.InvalidateLabel(Ctl);
	Pnl.InvalidateShadow(Ctl);
	Child := GetWindow(Hwn, GW_CHILD);
	while Child <> 0 do
		begin
		TMegaInfo(MegaList.GetHandleInf(Child)).Free;
		Child := GetWindow(Child, GW_HWNDNEXT);
		end;
	Gin.Free;
	Gin := nil;
	inherited Destroy;
	end;


{// TGridInfo /////////////////////////////////////////////////////////////////}
constructor TGridInfo.Create(Grd: TMegaGrid);
	var
	i, AllocSize: integer;
	PropList: PPropList;
	begin
	ColWidths := TList.Create;
	GridLineWidth := Grd.GridLineWidth;
	DefaultColWidth := Grd.DefaultColWidth;
	DefaultRowHeight := Grd.DefaultRowHeight;
	TitleSize := 0;
	if IsDBGrid(Grd) then
		begin
		AllocSize := GetTypeData(Grd.ClassInfo)^.PropCount * SizeOf(Pointer);
		GetMem(PropList, AllocSize);
		try
			GetPropInfos(Grd.ClassInfo, PropList);
			TitleSize := TFont(GetOrdProp(Grd, PropList^[TitleFontIndex])).Size;
		finally
			FreeMem(PropList, AllocSize);
			end;
		end;
	for i := 0 to Grd.ColCount - 1 do
		ColWidths.Add(pointer(Grd.ColWidths[i]));
	end;


destructor TGridInfo.Destroy;
	begin
	ColWidths.Free;
	inherited Destroy;
	end;


{// TMegaList /////////////////////////////////////////////////////////////////}
function TMegaList.AddControl(Panel: TMegaPanel; Control: TControl; HWindow: HWnd): TMegaInfo;
	begin
	Result := GetControlInf(Control);
	if Result = nil then
		Result := TMegaInfo.Create(Panel, Control, HWindow)
	end;


function TMegaList.AddHandle(Panel: TMegaPanel; HWindow: HWnd): TMegaInfo;
	begin
	Result := GetHandleInf(HWindow);
	if Result = nil then
		Result := TMegaInfo.Create(Panel, nil, HWindow)
	end;


procedure TMegaList.RemoveControl(Ctl: TControl);
	begin
	TMegaInfo(GetControlInf(Ctl)).Free
	end;


procedure TMegaList.RemoveHandle(HWindow: HWnd);
	begin
	TMegaInfo(GetHandleInf(HWindow)).Free
	end;


procedure TMegaList.Update(Panel: TMegaPanel);
	var
	i: integer;
	Inf: TMegaInfo;
	Ctl: TControl;
	begin
	for i := 0 to Panel.ControlCount - 1 do
		begin
		Ctl := Panel.Controls[i];
		if (GetControlInf(Ctl) = nil) then
			begin
			if (Ctl is TGraphicControl) then
				AddControl(Panel, Ctl, 0);
			if (Ctl is TWinControl) then
				AddControl(Panel, Ctl, TWinControl(Ctl).Handle);
			end
		end;
	i := 0;
	while i < Count do
		begin
		Inf := TMegaInfo(Items[i]);
		if (Inf.Pnl = Panel)
			and (Inf.Ctl <> nil)
			and not Panel.ContainsControl(Inf.Ctl) then
			Inf.Free
		else
			Inc(i);
		end;
	Panel.FUpdateControls := False;
	end;


procedure TMegaList.DestroyPanel(Panel: TMegaPanel);
	var
	i: integer;
	Inf: TMegaInfo;
	begin
	i := Count - 1;
	while i > -1 do
		begin
		Inf := TMegaInfo(Items[i]);
		if Inf.Pnl = Panel then
			Inf.Free;
		if i > (Count - 1) then
			i := Count - 1
		else
			Dec(i);
		end;
	end;


function TMegaList.GetControlInf(Ctl: TControl): TMegaInfo;
	var
	i: integer;
	begin
	for i := 0 to Count - 1 do
		begin
		Result := TMegaInfo(Items[i]);
		if Result.Ctl = Ctl then
			exit;
		end;
	Result := nil;
	end;


function TMegaList.GetHandleInf(Handle: HWnd): TMegaInfo;
	var
	i: integer;
	begin
	for i := 0 to Count - 1 do
		begin
		Result := TMegaInfo(Items[i]);
		if Result.Hwn = Handle then
			exit;
		end;
	Result := nil;
	end;


{// TGradient /////////////////////////////////////////////////////////////}
constructor TGradient.Create(Panel: TMegaPanel);
	begin
	FPanel := Panel;
	FStyle := psAll;
	FType := gtNone;
	FStart := clBlack;
	FEnd := clBlue;
	FSteps := 64;
	SetColors;
	end;


procedure TGradient.Fill(Grad, Clip: TRect);
	var
	i, j, RSize, RSize1, Steps, Steps1, Bound1, Bound2: integer;
	CBrush: array [0..2] of byte;
	Band, Band1: TRect;
	begin
	FPanel.Canvas.Brush.Style := bsSolid;
	case FType of
		gtHorizontal:
			begin
			Band.Top := Grad.Top;
			Band.Bottom := Grad.Top;
			Band.Left := max(Grad.Left, Clip.Left);
			Band.Right := min(Grad.Right, Clip.Right);
			Bound1 := max(Grad.Top, Clip.Top);
			Bound2 := min(Grad.Bottom, Clip.Bottom);
			RSize := Grad.Bottom - Grad.Top;
			if RSize > FSteps then
				Steps := FSteps
			else
				Steps := RSize;
			Steps1 := Steps - 1;
			for j := 0 to Steps1 do
				begin
				for i := 0 to 2 do
					CBrush[i] := CStart[i] + MulDiv(j, CDiff[i], Steps1);
				Band.Bottom := Grad.Top + MulDiv(RSize, j + 1, Steps);
				FPanel.Canvas.Brush.Color := RGB(CBrush[0], CBrush[1], CBrush[2]);
				if (Band.Bottom >= Bound1) and (Band.Top <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band.Left, Band.Top, Band.Right - Band.Left, Band.Bottom - Band.Top, PATCOPY);
				Band.Top := Band.Bottom;
				end;
			end;
		gtHorzSplit:
			begin
			Band.Top := Grad.Top;
			Band.Bottom := Grad.Top;
			Band.Left := max(Grad.Left, Clip.Left);
			Band.Right := min(Grad.Right, Clip.Right);
			Band1.Top := Grad.Bottom;
			Band1.Bottom := Grad.Bottom;
			Band1.Left := Band.Left;
			Band1.Right := Band.Right;
			Bound1 := max(Grad.Top, Clip.Top);
			Bound2 := min(Grad.Bottom, Clip.Bottom);
			RSize := Grad.Bottom - Grad.Top;
			if RSize > FSteps then
				Steps := FSteps
			else
				Steps := RSize;
			RSize1 := RSize - (RSize div 2);
			RSize := RSize div 2;
			Steps1 := Steps - 1;
			for j := 0 to Steps1 do
				begin
				for i := 0 to 2 do
					CBrush[i] := CStart[i] + MulDiv(j, CDiff[i], Steps1);
				Band.Bottom := Grad.Top + MulDiv(RSize, j + 1, Steps);
				Band1.Top := Grad.Bottom - MulDiv(RSize1, j + 1, Steps);
				FPanel.Canvas.Brush.Color := RGB(CBrush[0], CBrush[1], CBrush[2]);
				if (Band.Bottom >= Bound1) and (Band.Top <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band.Left, Band.Top, Band.Right - Band.Left, Band.Bottom - Band.Top, PATCOPY);
				if (Band1.Bottom >= Bound1) and (Band1.Top <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band1.Left, Band1.Top, Band1.Right - Band1.Left, Band1.Bottom - Band1.Top, PATCOPY);
				Band.Top := Band.Bottom;
				Band1.Bottom := Band1.Top;
				end;
			end;
		gtVertical:
			begin
			Band.Top := max(Grad.Top, Clip.Top);
			Band.Bottom := min(Grad.Bottom, Clip.Bottom);
			Band.Left := Grad.Left;
			Band.Right := Grad.Left;
			Bound1 := max(Grad.Left, Clip.Left);
			Bound2 := min(Grad.Right, Clip.Right);
			RSize := Grad.Right - Grad.Left;
			if RSize > FSteps then
				Steps := FSteps
			else
				Steps := RSize;
			Steps1 := Steps - 1;
			for j := 0 to Steps1 do
				begin
				for i := 0 to 2 do
					CBrush[i] := CStart[i] + MulDiv(j, CDiff[i], Steps1);
				Band.Right := Grad.Left + MulDiv(RSize, j + 1, Steps);
				FPanel.Canvas.Brush.Color := RGB(CBrush[0], CBrush[1], CBrush[2]);
				if (Band.Right >= Bound1) and (Band.Left <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band.Left, Band.Top, Band.Right - Band.Left, Band.Bottom - Band.Top, PATCOPY);
				Band.Left := Band.Right;
				end;
			end;
		gtVertSplit:
			begin
			Band.Top := max(Grad.Top, Clip.Top);
			Band.Bottom := min(Grad.Bottom, Clip.Bottom);
			Band.Left := Grad.Left;
			Band.Right := Grad.Left;
			Band1.Top := Band.Top;
			Band1.Bottom := Band.Bottom;
			Band1.Left := Grad.Right;
			Band1.Right := Grad.Right;
			Bound1 := max(Grad.Left, Clip.Left);
			Bound2 := min(Grad.Right, Clip.Right);
			RSize := Grad.Right - Grad.Left;
			if RSize > FSteps then
				Steps := FSteps
			else
				Steps := RSize;
			RSize1 := RSize - (RSize div 2);
			RSize := RSize div 2;
			Steps1 := Steps - 1;
			for j := 0 to Steps1 do
				begin
				for i := 0 to 2 do
					CBrush[i] := CStart[i] + MulDiv(j, CDiff[i], Steps1);
				Band.Right := Grad.Left + MulDiv(RSize, j + 1, Steps);
				Band1.Left := Grad.Right - MulDiv(RSize1, j + 1, Steps);
				FPanel.Canvas.Brush.Color := RGB(CBrush[0], CBrush[1], CBrush[2]);
				if (Band.Right >= Bound1) and (Band.Left <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band.Left, Band.Top, Band.Right - Band.Left, Band.Bottom - Band.Top, PATCOPY);
				if (Band1.Right >= Bound1) and (Band1.Left <= Bound2) then
					PatBlt(FPanel.Canvas.Handle, Band1.Left, Band1.Top, Band1.Right - Band1.Left, Band1.Bottom - Band1.Top, PATCOPY);
				Band.Left := Band.Right;
				Band1.Right := Band1.Left;
				end;
			end;
		end;
	end;


procedure TGradient.SetColors;
	var
	i: integer;
	ARGB: longint;
	CEnd: array [0..2] of byte;
	begin
	ARGB := MegaColorToRGB(FStart);
	CStart[0] := GetRValue(ARGB);
	CStart[1] := GetGValue(ARGB);
	CStart[2] := GetBValue(ARGB);
	ARGB := MegaColorToRGB(FEnd);
	CEnd[0] := GetRValue(ARGB);
	CEnd[1] := GetGValue(ARGB);
	CEnd[2] := GetBValue(ARGB);
	for i := 0 to 2 do
		CDiff[i] := CEnd[i] - CStart[i];
	end;


procedure TGradient.SetEnd(Value: TMegaColor);
	begin
	if FEnd = Value then
		exit;
	FEnd := Value;
	SetColors;
	if FType <> gtNone then
		FPanel.Invalidate;
	end;


procedure TGradient.SetStart(Value: TMegaColor);
	begin
	if FStart = Value then
		exit;
	FStart := Value;
	SetColors;
	if FType <> gtNone then
		FPanel.Invalidate;
	end;


procedure TGradient.SetStyle(Value: TPictureStyle);
	begin
	if FStyle = Value then
		exit;
	FStyle := Value;
	if FType <> gtNone then
		FPanel.Invalidate;
	end;


procedure TGradient.SetType(Value: TGradientType);
	begin
	if FType = Value then
		exit;
	FType := Value;
	FPanel.Invalidate;
	end;


procedure TGradient.SetSteps(Value: integer);
	begin
	if FSteps = Value then
		exit;
	FSteps := Value;
	if FSteps > 256 then
		FSteps := 256;
	if FType <> gtNone then
		FPanel.Invalidate;
	end;


{// TShadowEffect /////////////////////////////////////////////////////////////}
constructor TShadowEffect.Create(Panel: TMegaPanel);
	begin
	FPanel := Panel;
	FColor := clGray;
	FStyle := csTransparent;
	FXOffset := 4;
	FYOffset := 4;
	end;


procedure TShadowEffect.SetColor(Value: TMegaColor);
	begin
	if FColor = Value then
		exit;
	FColor := Value;
	if FStyle <> csTransparent then
		FPanel.UpdateClassFixups;
	end;


procedure TShadowEffect.SetShadow(Value: TColorStyle);
	begin
	if FStyle = Value then
		exit;
	FStyle := Value;
	FPanel.UpdateClassFixups;
	end;


procedure TShadowEffect.SetXOffset(Value: integer);
	begin
	if FXOffset = Value then
		exit;
	FXOffset := Value;
	if FStyle <> csTransparent then
		FPanel.UpdateClassFixups;
	end;


procedure TShadowEffect.SetYOffset(Value: integer);
	begin
	if FYOffset = Value then
		exit;
	FYOffset := Value;
	if FStyle <> csTransparent then
		FPanel.UpdateClassFixups;
	end;


{// TFocusEffect //////////////////////////////////////////////////////////////}
constructor TFocusEffect.Create;
	begin
	FEffect := feNone;
	FBack := clnone;
	FBevel := bvNone;
	FStyle := fsNormal;
	FFontColor := clBlack;
	FColStyle := csOpaque;
	end;


procedure TFocusEffect.SetLabelBack(Value: TMegaColor);
	begin
	FBack := Value;
	if IsColorNone(FBack) then
		FColStyle := csTransparent;
	end;


{// TMegaPanel ////////////////////////////////////////////////////////////////}
constructor TMegaPanel.Create(AOwner: TComponent);
	begin
	inherited Create(AOwner);
	inherited ParentFont := True;
	Alignment := taCenter;
	BevelInner := bvNone;
	BevelWidth := 1;
	BevelOuter := bvNone;
	BorderStyle := bsNone;
	BorderWidth := 0;
	Color := clBtnFace;
	FLabelList := nil;
	FPanelBevelInner := bvNone;
	FPanelBevelWidth := 1;
	FPanelBevelOuter := bvRaised;
	FPanelBorderStyle := bsNone;
	FPanelBorderWidth := 0;
	FPanelBevelMargin := 0;
	FPanelForm := nil;
	FPanelFormAlign := alClient;
	FLabelStyle := lsNone;
	FLabelVertJust := vjCenter;
	FLabelHorzJust := hjRight;
	FLabelWidth := 75;
	FLabelBevel := bvNone;
	FLabelBevelWidth := 1;
	FLabelHeight := 0;
	FLabelPos := lpLeftTop;
	FLabelClear := 2;
	FLabelSpace := 4;
	FLabelFont := TFont.Create;
	FLabelFontStyle := fsNormal;
	FLabelAngle := 0;
	FLabelX := 3;
	FLabelY := 3;
	FLabelType := ltNormal;
	FCaptionFont := TFont.Create;
	FCaptionSpace := 2;
	FCaptionStyle := csNone;
	FCaptionPos := cpTopLeft;
	FCaptionAngle := 0;
	FCaptionBevelWidth := 1;
	FCaptionBevelInner := bvNone;
	FCaptionBevelOuter := bvRaised;
	FCaptionBevelMargin := 2;
	FCaptionBorderWidth := 1;
	FCaptionClear := 2;
	FCaptionLoc := clOutsideFrame;
	FCaptionFontStyle := fsNormal;
	FCaptionBorderStyle := bsNone;
	FCaptionHorzJust := hjLeft;
	FDividerColor1 := clBtnShadow;
	FDividerColor2 := clBtnHighlight;
	FDividerBevel := bvLowered;
	FDividerWidth := 2;
	FDividersVert := 0;
	FDividersHorz := 0;
	FAutoCenter := [];
	FPicture := TBitmap.Create;
	FPicturePos := ppTile;
	FPictureTransparent := ptNone;
	FPictureStyle := psAll;
	FPictureXOffset := 0;
	FPictureYOffset := 0;
	FCaptionPicture := TBitmap.Create;
	FCaptionPicturePos := ppTile;
	FCaptionPictureTransparent := ptNone;
	FCaptionPictureXOffset := 0;
	FCaptionPictureYOffset := 0;
	FCaptionPictureStyle := psCaptionInsideFrame;
	FColorDisabled := clInactiveCaptionText;
	FColorHighlight := clBtnHighlight;
	FColorShadow := clBtnShadow;
	FColorCaptionBkgnd := clBtnFace;
	FColorLabelBkgnd := clNone;
	FCtlLabelCol := clNone;
	FCtlLabelBkgnd := clNone;
	FTagUsage := tuNone;
	FIsCaption := False;
	FResizing := False;
	FResizeEnable := True;
	FResizeDesign := False;
	FResizeControls := [rcHorizontal, rcVertical, rcCaptionFrames, rcPanelFrames, rcLabelFrames,
						rcCtlShadow, rcPictureOffsets, rcGridCells, rcGridLines];
	FResizeFonts := [rfCaption, rfLabels, rfControls];
	FFixKeys := [fkEnter, fkUpDown];
	FPanelColStyle := csOpaque;
	FCaptionColStyle := csOpaque;
	FLabelColStyle := csOpaque;
	FTransparent := IsColorNone(inherited Color) or (FPanelColStyle <> csOpaque);
	FHideCount := 0;
	FPainting := False;
	FClipChildren := False;
	FUpdateControls := False;
	FFocus := TFocusEffect.Create;
	FShadow := TShadowEffect.Create(self);
	FGradient := TGradient.Create(self);
	FClassFix := TStringList.Create;
	FFocusCtl := nil;
	FPanelFormDestroy := nil;
	FFormActivate := True;
	if csDesigning in ComponentState then
		FPanelFormView := dvNormal
	else
		FPanelFormView := dvRunTime;
{$IFDEF WIN32}
	ControlStyle := ControlStyle - [csReplicatable];
{$ENDIF}
	end;


procedure TMegaPanel.CreateParams(var Params: TCreateParams);
	begin
	inherited CreateParams(Params);
	FTransparent := IsColorNone(inherited Color) or (FPanelColStyle <> csOpaque);
	if (not FClipChildren) or FTransparent then
		Params.Style := Params.Style and (not WS_CLIPCHILDREN);
	end;


destructor TMegaPanel.Destroy;
	begin
	ReleasePanelForm;
	MegaList.DestroyPanel(self);
	DeleteRotatedFont;
	FPicture.Free;
	FCaptionPicture.Free;
	FLabelFont.Free;
	FCaptionFont.Free;
	FFocus.Free;
	FShadow.Free;
	FGradient.Free;
	FClassFix.Free;
	FLabelList.Free;
	inherited Destroy;
	end;


function TMegaPanel.GetPalette: HPalette;
	begin
	Result := 0;
	if GetDeviceCaps(Canvas.Handle, NUMCOLORS) > 256 then
		exit;
	if (FPicture <> nil) then
		Result := FPicture.Palette;
	if (Result = 0) and (FCaptionPicture <> nil) then
		Result := FCaptionPicture.Palette;
	if Result = 0 then
		Result := inherited GetPalette;
	end;


procedure TMegaPanel.WriteState(Writer: TWriter);
	var
	i, j: integer;
	DoIt: boolean;
	s: string;
	begin
	if FPanelFormView <> dvNormal then
		begin
		ReleasePanelForm;
		PanelFormDesignView := dvNormal;
		end;
	if CleanupFixups and (FClassFix.Count > 0) then
		for i := FClassFix.Count - 1 downto 0 do
			begin
			s := Copy(FClassFix[i], 7, 99);
			DoIt := True;
			for j := 0 to ControlCount - 1 do
				if (CompareText(Controls[j].ClassName, s) = 0) then
					begin
					DoIt := False;
					break;
					end;
			if DoIt then
				FClassFix.Delete(i);
			end;
	inherited WriteState(Writer);
	end;


procedure TMegaPanel.WMDestroy(var Message: TWMDestroy);
	begin
	ReleasePanelForm;
	MegaList.DestroyPanel(self);
	inherited;
	end;


function TMegaPanel.UnSafe: boolean;
	begin
	Result := (csLoading in ComponentState) or (csDestroying in ComponentState) or (Parent = nil);
	end;


procedure TMegaPanel.CanvasFont(AFont: TFont);
	begin
	if ParentFont and (Parent <> nil) then
		Canvas.Font.Assign(TMegaWin(Parent).Font)
	else
		Canvas.Font.Assign(AFont);
	end;


procedure TMegaPanel.InvalidatePanel;
	begin
	RealignPanel;
	Invalidate;
	end;


procedure TMegaPanel.WMMouseMove(var Message: TWMMouseMove);
	var
	Ctl: TWinControl;
	begin
	if (FFocus.FEffect = feLive) and (LiveCtl <> nil) then
		begin
		Ctl := LiveCtl;
		LiveCtl := nil;
		InvalidateLiveLabel(Ctl);
		LiveCtl := nil;
		end;
	inherited;
	end;


procedure TMegaPanel.InvalidateLiveLabel(Ctl: TWinControl);
	var
	r: TRect;
	begin
	if UnSafe
		or (Ctl = nil)
		or not (Ctl.Enabled)
		or (FFocus.FEffect <> feLive)
		or (FLabelStyle = lsNone)
		or (FLabelStyle = lsInControl)
		or (csDesigning in ComponentState) then
		exit;
	if (LiveCtl <> Ctl) and (FFocusCtl <> Ctl) then
		begin
		RotateFont(FLabelAngle, FLabelFont);
		if LiveCtl <> nil then
			if LiveCtl.Parent = self then
				begin
				r := LabelRect(LiveCtl);
				if not IsRectEmpty(r) then
					InvalidateRect(Handle, @r, True);
				end
			else
				TMegaPanel(LiveCtl.Parent).InvalidateLiveLabel(nil);
		LiveCtl := Ctl;
		if LiveCtl <> nil then
			begin
			r := LabelRect(LiveCtl);
			if not IsRectEmpty(r) then
				InvalidateRect(Handle, @r, True);
			end;
DebugStr('LiveLabel');
		end;
	end;


procedure TMegaPanel.InvalidateLabel(Ctl: TControl);
	var
	r: TRect;
	begin
	if (Ctl = nil) or UnSafe or (FLabelStyle = lsNone) or (FLabelStyle = lsInControl) then
		exit;
	RotateFont(FLabelAngle, FLabelFont);
	r := LabelRect(Ctl);
	if not IsRectEmpty(r) then
		InvalidateRect(Handle, @r, True);
	end;


procedure TMegaPanel.FocusControl(Ctl: TWinControl);
	begin
	if FocusPnl <> nil then
		FocusPnl.UnFocusControl;
	FocusPnl := self;
	if FFocus.FEffect = feFocus then
		begin
		FFocusCtl := Ctl;
		InvalidateLabel(Ctl);
		end
	else
		if FFocus.FEffect = feColor then
			begin
			FFocusCtl := Ctl;
			if Ctl <> nil then
				begin
				FFocusCtlBack := TMegaWin(Ctl).Color;
				FFocusCtlFore := TMegaWin(Ctl).Font.Color;
				TMegaWin(Ctl).Color := FFocus.FBack;
				TMegaWin(Ctl).Font.Color := FFocus.FFontColor;
				end;
DebugStr('FocusEffect');
			end;
	end;


procedure TMegaPanel.UnFocusControl;
	var
	Ctl: TWinControl;
	begin
	FocusPnl := nil;
	if FFocusCtl = nil then
		exit;
	Ctl := FFocusCtl;
	if FFocus.FEffect = feFocus then
		begin
		FFocusCtl := nil;
		InvalidateLabel(Ctl);
		end
	else
		if FFocus.FEffect = feColor then
			begin
			FFocusCtl := Nil;
			if Ctl <> nil then
				begin
				TMegaWin(Ctl).Color := FFocusCtlBack;
				TMegaWin(Ctl).Font.Color := FFocusCtlFore;
				end;
			end;
	end;


function TMegaPanel.CreateShadowRgn(Ctl: TControl): HRgn;
	var
	r: TRect;
	crgn: HRgn;
	begin
	r := Ctl.BoundsRect;
	crgn := CreateRectRgnIndirect(r);
	OffsetRect(r, FShadow.FXOffset, FShadow.FYOffset);
	Result := CreateRectRgnIndirect(r);
	CombineRgn(Result, Result, crgn, RGN_DIFF);
	DeleteObject(crgn);
	end;


procedure TMegaPanel.InvalidateShadow(Ctl: TControl);
	var
	srgn: HRgn;
	begin
	if (Ctl = nil) or UnSafe
		or (FShadow.FStyle = csTransparent)
		or IsColorNone(FShadow.FColor) then
		exit;
	srgn := CreateShadowRgn(Ctl);
	InvalidateRgn(Handle, srgn, True);
	DeleteObject(srgn);
	end;


procedure TMegaPanel.PaintShadow(Ctl: TControl);
	var
	r: TRect;
	srgn: HRgn;
	begin
	if (Ctl = nil) or UnSafe
		or (FShadow.FStyle = csTransparent)
		or IsColorNone(FShadow.FColor) then
		exit;
	srgn := CreateShadowRgn(Ctl);
	SelectClipRgn(Canvas.Handle, srgn);
	if FShadow.FStyle = csOpaque then
		begin
		Canvas.Brush.Color := FShadow.FColor;
		PatBlt(Canvas.Handle, Ctl.Left + FShadow.FXOffset, Ctl.Top + FShadow.FYOffset, Ctl.Width, Ctl.Height, PATCOPY);
		end
	else
		begin
		r := Ctl.BoundsRect;
		OffsetRect(r, FShadow.FXOffset, FShadow.FYOffset);
		if FShadow.FStyle = csDithered then
			PaintDitherRect(r, FShadow.FColor)
		else
			PaintRopRect(r, FShadow.FColor, FShadow.FStyle);
		end;
	SelectClipRgn(Canvas.Handle, 0);
	DeleteObject(srgn);
	end;


procedure TMegaPanel.PaintDitherRect(r: TRect; c: TMegaColor);
	var
	cr: TRect;
	begin
	DitherBmp.Palette := GetPalette;
	ShadowBmp.Palette := GetPalette;
	if c = clBlack then
		begin
		DitherBmp.Canvas.Brush.Color := clYellow;
		PatBlt(DitherBmp.Canvas.Handle, 0, 0, 64, 64, PATCOPY);
		DitherBmp.Canvas.Brush.Bitmap := ShadowBmp;
		PatBlt(DitherBmp.Canvas.Handle, 0, 0, 64, 64, $A0329);
		end
	else
		begin
		DitherBmp.Canvas.Brush.Color := c;
		PatBlt(DitherBmp.Canvas.Handle, 0, 0, 64, 64, PATCOPY);
		DitherBmp.Canvas.Brush.Bitmap := ShadowBmp;
		PatBlt(DitherBmp.Canvas.Handle, 0, 0, 64, 64, $A000C9);
		end;
	GetClipBox(Canvas.Handle, cr);
	PaintPicture(cr, r, DitherBmp, psAll, ppTileFast, 0, 0, ptFull);
	DitherBmp.Canvas.Brush.Bitmap := nil;
	DitherBmp.ReleasePalette;
	ShadowBmp.ReleasePalette;
	end;


procedure TMegaPanel.PaintRopRect(r: TRect; c: TMegaColor; Style: TColorStyle);
	var
	Bmp: TBitmap;
	Rop: DWORD;
	begin
	Bmp := TBitMap.Create;
	Bmp.Width := 8;
	Bmp.Height := 8;
	Bmp.Monochrome := False;
	Bmp.Palette := GetPalette;
	case Style of
		csAND:
			Rop := $A000C9;
		csOR:
			Rop := $FA0089;
		csNAND:
			Rop := $500325;
		csNOR:
			Rop := $F50225;
		csXOR:
			Rop := $5A0049;
		else
			Rop := $A000C9;
		end;
	Bmp.Canvas.Brush.Color := c;
	PatBlt(Bmp.Canvas.Handle, 0, 0, 8, 8, PATCOPY);
	Canvas.Brush.Bitmap := Bmp;
	PatBlt(Canvas.Handle, r.Left, r.Top, r.Right - r.Left, r.Bottom - r.Top, Rop);
	Canvas.Brush.Bitmap := nil;
	Bmp.Canvas.Handle := 0;
	Bmp.ReleasePalette;
	Bmp.Free;
	end;


procedure TMegaPanel.Loaded;
	var
	i: integer;
	s: string;
	begin
	inherited Loaded;
	if (FClassFix.Count > 0) and (FClassFix[0][4] <> '0') and (FClassFix[0][4] <> '1') then
		for i := 0 to FClassFix.Count - 1 do
			if (FClassFix[i][4] <> '0') and (FClassFix[i][4] <> '1') then
				begin
				s := Copy(FClassFix[i], 1, 3) + '111' + Copy(FClassFix[i], 4, 99);
				FClassFix[i] := s;
				end;
	UpdateClassFixups;
	SetScalingFactors;
	RealignPanel;
	end;


procedure TMegaPanel.SetScalingFactors;
	var
	i: integer;
	Inf: TMegaInfo;
	begin
	if UnSafe then
		exit;
	FWid := Width;
	FHgt := Height;
	FCapSize := FCaptionFont.Size;
	FLabSize := FLabelFont.Size;
	FLabX := FLabelX;
	FLabY := FLabelY;
	FCapSpc := FCaptionSpace;
	FCapBevWid := FCaptionBevelWidth;
	FCapBevMar := FCaptionBevelMargin;
	FCapBorWid := FCaptionBorderWidth;
	FCapClr := FCaptionClear;
	FPanBevWid := FPanelBevelWidth;
	FPanBorWid := FPanelBorderWidth;
	FPanBevMar := FPanelBevelMargin;
	FDivWid := FDividerWidth;
	FLabWid := FLabelWidth;
	FLabHgt := FLabelHeight;
	FLabBevWid := FLabelBevelWidth;
	FLabClr := FLabelClear;
	FLabSpc := FLabelSpace;
	FShdXOff := FShadow.XOffset;
	FShdYOff := FShadow.YOffset;
	FPicXOff := FPictureXOffset;
	FPicYOff := FPictureYOffset;
	FCapPicXOff := FCaptionPictureXOffset;
	FCapPicYOff := FCaptionPictureYOffset;
	for i := 0 to ControlCount - 1 do
		begin
		Inf := MegaList.GetControlInf(Controls[i]);
		if (Inf <> nil) and (Inf.Ctl <> nil) then
			begin
			Inf.Lft := Inf.Ctl.Left;
			Inf.Top := Inf.Ctl.Top;
			Inf.Wid := Inf.Ctl.Width;
			Inf.Hgt := Inf.Ctl.Height;
			Inf.Fnt := TMegaCtl(Inf.Ctl).Font.Size;
			if Inf.Gin <> nil then
				begin
				Inf.Gin.Free;
				Inf.Gin := TGridInfo.Create(TMegaGrid(Inf.Ctl));
				end;
			end;
		end
	end;


procedure TMegaPanel.RealignPanel;
	begin
	if UnSafe then
		exit;
	CanvasFont(FCaptionFont);
	inherited Font := TMegaWin(Parent).Font;
	FIsCaption := (inherited Caption <> '') and (FCaptionStyle <> csNone);
	FTransparent := IsColorNone(inherited Color) or (FPanelColStyle <> csOpaque);
	FPanelFraming := PanelFraming;
	FCaptionFraming := CaptionFraming;
	Realign;
	Resize;
	DoAutoCenter;
	end;


function TMegaPanel.GetPanelLabel(Ctl: TControl): string;
	var
	i: integer;
	begin
	Result := '';
	if (FLabelStyle = lsNone) or (FLabelStyle = lsInControl) then
		exit;
	if FLabelType = ltNormal then
		Result := GetShortHint(GetLongHint(Ctl.Hint))
	else
		begin
		Result := Ctl.Name;
		for i := 1 to length(Result) do
			if Result[i] = '_' then
				Result[i] := ' ';
		end;
	end;


procedure TMegaPanel.DeleteRotatedFont;
	begin
	FRad := 0;
	FAngle := 0;
	CanvasFont(Font);
	if FRotatedFont = 0 then
		exit;
	DeleteObject(FRotatedFont);
	FRotatedFont := 0;
	end;


function TMegaPanel.AdjustPanelRect(Rect: TRect): TRect;
	var
	CapW, CapH: integer;
	CRect: TRect;
	begin
	Result := Rect;
	if (FCaptionLoc <> clOutsideFrame)
		or (FCaptionStyle <> csPanel) then
		exit;
	CRect := CaptionRect;
	CapW := CRect.Right - CRect.Left;
	CapH := CRect.Bottom - CRect.Top;
	case FCaptionPos of
		cpTopLeft, cpTopCenter, cpTopRight:
			Inc(Result.Top, CapH + FCaptionSpace);
		cpLeftTop, cpLeftCenter, cpLeftBottom:
			Inc(Result.Left, CapW + FCaptionSpace);
		cpRightTop, cpRightCenter, cpRightBottom:
			Dec(Result.Right, CapW + FCaptionSpace);
		cpBottomLeft, cpBottomCenter, cpBottomRight:
			Dec(Result.Bottom, CapH + FCaptionSpace);
		end;
	end;


procedure TMegaPanel.Notification(AComponent: TComponent; Operation: TOperation);
	begin
	FUpdateControls := True;
	if (Operation = opRemove) and (AComponent is TControl) then
		MegaList.RemoveControl(TControl(AComponent));
	inherited Notification(AComponent, Operation);
	end;


procedure TMegaPanel.DoAutoCenter;
	var
	i, Centering: integer;
	CRect, LRect: TRect;
	Ctl: TControl;
	begin
	if (FAutoCenter = []) or (ControlCount = 0) or UnSafe then
		exit;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		RotateFont(FLabelAngle, FLabelFont)
	else
		CanvasFont(FLabelFont);
	SetRectEmpty(CRect);
	for i := 0 to ControlCount - 1 do
		begin
		Ctl := Controls[i];
		if not Ctl.Visible then
			continue;
		if (Ctl is TCustomPanel) and not (acPanels in FAutoCenter) then
			continue;
		if not (Ctl is TCustomPanel) and not (acControls in FAutoCenter) then
			continue;
		UnionRect(CRect, CRect, Ctl.BoundsRect);
		if acLabels in FAutoCenter then
			begin
			LRect := LabelRect(Ctl);
			UnionRect(CRect, CRect, LRect);
			end;
		end;
	FRect := AdjustPanelRect(ClientRect);
	Centering := (FRect.Right - FRect.Left - CRect.Right + CRect.Left) div 2;
	for i := 0 to ControlCount - 1 do
		begin
		Ctl := Controls[i];
		if (Ctl is TCustomPanel) and not (acPanels in FAutoCenter) then
			continue;
		if not (Ctl is TCustomPanel) and not (acControls in FAutoCenter) then
			continue;
		Ctl.Left := Ctl.Left + Centering - CRect.Left + FRect.Left;
		end;
	DeleteRotatedFont;
	if Assigned(FOnAutoCenter) then
		FOnAutoCenter(self);
	end;


procedure TMegaPanel.WMWinPosChanging(var Message: TWMWindowPosChanging);
	var
	i, j, AllocSize: integer;
	Ctl: TControl;
	Grd: TMegaGrid;
	PropList: PPropList;
	WinPos: TWindowPos;
	Inf: TMegaInfo;
	begin
	WinPos := Message.WindowPos^;
	if FUpdateControls then
		MegaList.Update(self);
	if ((WinPos.Flags and (SWP_NOSIZE or SWP_NOMOVE)) = 0)
		and (not FResizing) and FResizeEnable and (not UnSafe) and (FResizeControls <> [])
		and (Message.WindowPos <> nil) and (WinPos.cx <> 0) and (WinPos.cy <> 0)
		and ((not (csDesigning in ComponentState)) or ((csDesigning in ComponentState) and FResizeDesign)) then
		begin
		FResizing := True;
		SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_HIDE);
		if rcHorizontal in FResizeControls then
			Fx := WinPos.cx
		else
			Fx := FWid;
		if rcVertical in FResizeControls then
			Fy := WinPos.cy
		else
			Fy := FHgt;
		if (rfCaption in FResizeFonts) and not ParentFont then
			FCaptionFont.Size := MulDiv(FCapSize, Fy, FHgt);
		for i := 0 to ControlCount - 1 do
			begin
			Ctl := Controls[i];
			Inf := MegaList.GetControlInf(Ctl);
			if (Inf = nil) or (Inf.Ctl = nil) then
				continue;
			if Inf.Gin <> nil then
				Grd := TMegaGrid(Ctl)
			else
				Grd := nil;
			Ctl.Left := MulDiv(Inf.Lft, Fx, FWid);
			Ctl.Top := MulDiv(Inf.Top, Fy, FHgt);
			if Inf.Ddw <> 0 then
				begin
				AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
				GetMem(PropList, AllocSize);
				try
					GetPropInfos(Ctl.ClassInfo, PropList);
					SetOrdProp(Ctl, PropList^[DropWidthIndex], MulDiv(Inf.Ddw, Fy, FHgt));
				finally
					FreeMem(PropList, AllocSize);
					end;
				end;
			if (rfControls in FResizeFonts) and not TMegaCtl(Ctl).ParentFont then
				begin
				TMegaCtl(Ctl).Font.Size := MulDiv(Inf.Fnt, Fy, FHgt);
				if (Grd <> nil) and (Inf.Gin.TitleSize <> 0) then
					begin
					AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
					GetMem(PropList, AllocSize);
					try
						GetPropInfos(Grd.ClassInfo, PropList);
						TFont(GetOrdProp(Grd, PropList^[TitleFontIndex])).Size := MulDiv(Inf.Gin.TitleSize, Fy, FHgt);
					finally
						FreeMem(PropList, AllocSize);
						end;
					end;
				if Inf.Dfs <> 0 then
					begin
					AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
					GetMem(PropList, AllocSize);
					try
						GetPropInfos(Ctl.ClassInfo, PropList);
						TFont(GetOrdProp(Ctl, PropList^[DropFontIndex])).Size := MulDiv(Inf.Dfs, Fy, FHgt);
					finally
						FreeMem(PropList, AllocSize);
						end;
					end;
				end;
			if (Inf.Dlw <> 0) and (rcPanelFrames in FResizeControls) then
				begin
				AllocSize := GetTypeData(Ctl.ClassInfo)^.PropCount * SizeOf(Pointer);
				GetMem(PropList, AllocSize);
				try
					GetPropInfos(Ctl.ClassInfo, PropList);
					SetOrdProp(Ctl, PropList^[DropLineIndex], MulDiv(Inf.Dlw, Fy, FHgt));
				finally
					FreeMem(PropList, AllocSize);
					end;
				end;
			if (Ctl is TScrollbar) and not (rcScrollbars in FResizeControls) then
				begin
				if TScrollBar(Ctl).Kind = sbHorizontal then
					Ctl.Width := MulDiv(Inf.Wid , Fx, FWid);
				if TScrollBar(Ctl).Kind = sbVertical then
					Ctl.Height := MulDiv(Inf.Hgt , Fy, FHgt);
				end
			else
				begin
				Ctl.Width := MulDiv(Inf.Wid, Fx, FWid);
				Ctl.Height := MulDiv(Inf.Hgt, Fy, FHgt);
				end;
			if (rcGridCells in FResizeControls) and (Grd <> nil) then
				begin
				Grd.DefaultColWidth := MulDiv(Inf.Gin.DefaultColWidth, Fx, FWid);
				Grd.DefaultRowHeight := MulDiv(Inf.Gin.DefaultRowHeight, Fy, FHgt);
				for j := 0 to min(Inf.Gin.ColWidths.Count, Grd.ColCount) - 1 do
					Grd.ColWidths[j] := MulDiv(longint(Inf.Gin.ColWidths.Items[j]), Fx, FWid);
				end;
			if (rcGridLines in FResizeControls) and (Grd <> nil) then
				Grd.GridLineWidth := MulDiv(Inf.Gin.GridLineWidth, Fx, FWid);
			end;
		if rfLabels in FResizeFonts then
			begin
			FLabelFont.Size := MulDiv(FLabSize, Fy, FHgt);
			FLabelX := MulDiv(FLabX, Fx, FWid);
			FLabelY := MulDiv(FLabY, Fy, FHgt);
			end;
		if rcCaptionFrames in FResizeControls then
			begin
			FCaptionSpace := MulDiv(FCapSpc, Fy, FHgt);
			FCaptionBevelWidth := MulDiv(FCapBevWid, Fy, FHgt);
			FCaptionBevelMargin := MulDiv(FCapBevMar, Fy, FHgt);
			FCaptionBorderWidth := MulDiv(FCapBorWid, Fy, FHgt);
			FCaptionClear := MulDiv(FCapClr, Fy, FHgt);
			end;
		if rcPanelFrames in FResizeControls then
			begin
			FPanelBevelWidth := MulDiv(FPanBevWid, Fy, FHgt);
			FPanelBorderWidth := MulDiv(FPanBorWid, Fy, FHgt);
			FPanelBevelMargin := MulDiv(FPanBevMar, Fy, FHgt);
			FDividerWidth := MulDiv(FDivWid, Fy, FHgt);
			end;
		if rcLabelFrames in FResizeControls then
			begin
			FLabelWidth := MulDiv(FLabWid, Fx, FWid);
			FLabelHeight := MulDiv(FLabHgt, Fy, FHgt);
			FLabelBevelWidth := MulDiv(FLabBevWid, Fy, FHgt);
			FLabelClear := MulDiv(FLabClr, Fy, FHgt);
			FLabelSpace := MulDiv(FLabSpc, Fy, FHgt);
			end;
		if rcCtlShadow in FResizeControls then
			begin
			FShadow.FXOffset := MulDiv(FShdXOff, Fx, FWid);
			FShadow.FYOffset := MulDiv(FShdYOff, Fy, FHgt);
			end;
		if rcPictureOffsets in FResizeControls then
			begin
			FPictureXOffset := MulDiv(FPicXOff, Fx, FWid);
			FPictureYOffset := MulDiv(FPicYOff, Fy, FHgt);
			FCaptionPictureXOffset := MulDiv(FCapPicXOff, Fx, FWid);
			FCaptionPictureYOffset := MulDiv(FCapPicYOff, Fy, FHgt);
			end;
		if Assigned(FOnRescale) then
			FOnRescale(self);
		end;
	inherited;
	Message.Result := 0;
	end;


procedure TMegaPanel.WMMove(var Message: TWMMove);
	begin
	inherited;
	if FResizing then
		begin
		SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_SHOW);
		FResizing := False;
		end;
	RealignPanel;
(*
//??	if IsColorNone(inherited Color) then
//??		Repaint;
*)
	end;


procedure TMegaPanel.WMSize(var Message: TWMSize);
	begin
	inherited;
	if FResizing then
		begin
		SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_SHOW);
		FResizing := False;
		end;
	RealignPanel;
	end;


procedure TMegaPanel.WMMegaText(var Message: TMessage);
	var
	i, OldDC: integer;
	Ctl: TMegaWin;
	DC: HDC;
	OldFont: HFont;
	dummy: TRect;
	Inf: TMegaInfo;
	BkCol, TxCol: TMegaColor;
{$IFNDEF WIN32}
	ps: array[0..255] of char;
{$ENDIF}
	begin
	if (FLabelList = nil) or FResizing
		or GetUpdateRect(Handle, dummy, False)
		or (HandleAllocated and not IsWindowVisible(Handle)) then
		exit;
	for i := FLabelList.Count - 1 downto 0 do
		begin
		Ctl := TMegaWin(FLabelList[i]);
		Inf := MegaList.GetControlInf(Ctl);
		ListRemove(FLabelList, Ctl);
		if (Ctl = nil)
			or (Ctl.Text <> '')
			or (not Ctl.Visible)
			or (Inf = nil)
			or (not (cfCtlLabel in Inf.Fix)) then
			continue;
		if FLabelType = ltNormal then
			FString := GetLongHint(GetLongHint(Ctl.Hint))
		else
			FString := Ctl.Name;
		if FString = '' then
			continue;
		DC := GetDC(Ctl.Handle);
		OldDC := SaveDC(DC);
		OldFont := SelectObject(DC, FLabelFont.Handle);
		if IsColorNone(FCtlLabelCol) then
			begin
			TxCol := FLabelFont.Color;
			BkCol := FColorLabelBkgnd;
			end
		else
			begin
			TxCol := FCtlLabelCol;
			BkCol := FCtlLabelBkgnd;
			end;
		SetTextColor(DC, ColorToRGB(TxCol));
		if (FLabelColStyle = csTransparent) or IsColorNone(BkCol) then
			SetBkColor(DC, ColorToRGB(Ctl.Color))
		else
			SetBkColor(DC, MegaColorToRGB(BkCol));
		SetBkMode(DC, OPAQUE);
		if ((FFocus.FEffect = feFocus) or (FFocus.FEffect = feColor)) and (Ctl = FFocusCtl) then
			begin
			SetTextColor(DC, ColorToRGB(FFocus.FFontColor));
			if not IsColorNone(FFocus.FBack) then
				SetBkColor(DC, MegaColorToRGB(FFocus.FBack));
			end
		else
			if not Ctl.Enabled then
				SetTextColor(DC, MegaColorToRGB(FColorDisabled))
			else
				if (FTagUsage = tuLabelColor) and not IsColorNone(Ctl.Tag) then
					SetTextColor(DC, MegaColorToRGB(Ctl.Tag))
				else
					if (FTagUsage = tuLabelBackground) and not IsColorNone(Ctl.Tag) then
						SetBkColor(DC, MegaColorToRGB(Ctl.Tag));
		FRect := Ctl.ClientRect;
		OffsetRect(FRect, FLabelX, FLabelY);
		DrawText(DC, {$IFDEF WIN32} pchar(FString) {$ELSE} StrPCopy(ps, FString) {$ENDIF}, -1, FRect, DT_NOCLIP);
		SelectObject(DC, OldFont);
		RestoreDC(DC, OldDC);
		ReleaseDC(Ctl.Handle, DC);
		end;
	end;


procedure TMegaPanel.WMCTLColor(var Message: TWMCTLColor);
	begin
	if FTransparent
{$IFDEF WIN32}
		and (HiWord(Message.ChildWnd) <> CTLCOLOR_EDIT) then
{$ELSE}
		and (Message.CtlType <> CTLCOLOR_EDIT) then
{$ENDIF}
		begin
		if (Parent <> nil) and not IsColorNone(TMegaWin(Parent).Color) then
			Message.Result := Parent.Brush.Handle
		else
			Message.Result := longint(TWinControl(FindControl(Message.ChildWnd)).Brush.Handle);
		end
	else
		inherited;
	end;


procedure TMegaPanel.WMNCPaint(var Message: TWMNCPaint);
	begin
	Message.Result := 0;
	end;


procedure TMegaPanel.WMEraseBkgnd(var Message: TWMEraseBkgnd);
	var
	r: TRect;
	begin
	Message.Result := 1;
	if FResizeDesign and (csDesigning in ComponentState) then
		begin
		GetUpdateRect(Handle, r, False);
		if not EqualRect(r, ClientRect) then
			SetScalingFactors;
		end;
	end;


procedure TMegaPanel.PaintGradient(ClipRect: TRect);
	begin
	case FGradient.FStyle of
		psAll:
			FRect := ClientRect;
		psPanel:
			begin
			FRect := AdjustPanelRect(ClientRect);
			Inc(FRect.Top, GroupBoxOffset);
			end;
		psPanelFrame:
			begin
			FRect := AdjustPanelRect(ClientRect);
			InflateRect(FRect, -FPanelBevelMargin, -FPanelBevelMargin);
			if FPanelBorderStyle = bsSingle then
				InflateRect(FRect, -1, -1);
			Inc(FRect.Top, GroupBoxOffset);
			end;
		psPanelInsideFrame:
			begin
			FRect := AdjustPanelRect(InsidePanelRect);
			Inc(FRect.Top, GroupBoxOffset);
			end;
		psCaption:
			FRect := CaptionRect;
		psCaptionFrame:
			begin
			FRect := CaptionRect;
			InflateRect(FRect, -FCaptionBevelMargin, -FCaptionBevelMargin);
			end;
		psCaptionInsideFrame:
			begin
			FRect := InsideCaptionRect;
			InflateRect(FRect, FCaptionClear, FCaptionClear);
			end;
		psCaptionText:
			FRect := InsideCaptionRect;
		end;
	FGradient.Fill(FRect, ClipRect);
	end;


procedure TMegaPanel.PaintCaption;
	begin
	if (FCaptionColStyle = csTransparent) or IsColorNone(FColorCaptionBkgnd) then
		exit;
	FRect := CaptionRect;
	InflateRect(FRect, -FCaptionBevelMargin, -FCaptionBevelMargin);
	if FCaptionColStyle = csOpaque then
		begin
		Canvas.Brush.Style := bsSolid;
		Canvas.Brush.Color := FColorCaptionBkgnd;
		PatBlt(Canvas.Handle, FRect.Left, FRect.Top, FRect.Right - FRect.Left, FRect.Bottom - FRect.Top, PATCOPY);
		end
	else
		if FCaptionColStyle = csDithered then
			PaintDitherRect(FRect, FColorCaptionBkgnd)
		else
			PaintRopRect(FRect, FColorCaptionBkgnd, FCaptionColStyle);
	end;


procedure TMegaPanel.TransStretchBlt(Bmp: TBitmap; dr, sr: TRect; TransparentColor: TColor; FreeFlag: boolean);
	const
	bmBack: HBitmap = 0;
	bmFore: HBitmap = 0;
	bmTemp: HBitmap = 0;
	bmBackOld: HBitmap = 0;
	bmForeOld: HBitmap = 0;
	bmTempOld: HBitmap = 0;
	hdcTemp: HDC = 0;
	hdcBack: HDC = 0;
	hdcFore: HDC = 0;
	Image: TBitmap = nil;
	var
	dl, dt, dw, dh: integer;
	OldColor: TColorRef;
	ptSize: TPoint;
	begin
	dl := dr.Left;
	dt := dr.Top;
	dw := dr.Right - dr.Left;
	dh := dr.Bottom - dr.Top;
	try
		Image := TBitmap.Create;
		Image.Width := dw;
		Image.Height := dh;
		Image.Monochrome := Bmp.Monochrome;
		Image.Palette := GetPalette;
		StretchBlt(Image.Canvas.Handle, 0, 0, dw, dh, Bmp.Canvas.Handle, sr.Left,
				   sr.Top, sr.Right - sr.Left, sr.Bottom - sr.Top, SRCCOPY);
		if FreeFlag then
			begin
			Bmp.ReleasePalette;
			Bmp.Free;
			end;
		try
			ptSize.x := dw;
			ptSize.y := dh;
			hdcBack := CreateCompatibleDC(Canvas.Handle);
			hdcFore := CreateCompatibleDC(Canvas.Handle);
			hdcTemp := CreateCompatibleDC(Canvas.Handle);
			bmBack := CreateBitmap(dw, dh, 1, 1, nil);
			bmFore := CreateBitmap(dw, dh, 1, 1, nil);
			bmTemp := CreateCompatibleBitmap(Canvas.Handle, dw, dh);
			bmBackOld := SelectObject(hdcBack, bmBack);
			bmForeOld := SelectObject(hdcFore, bmFore);
			bmTempOld := SelectObject(hdcTemp, bmTemp);
			try
				OldColor := SetBkColor(Image.Canvas.Handle, TransparentColor);
				BitBlt(hdcFore, 0, 0, dw, dh, Image.Canvas.Handle, 0, 0, SRCCOPY);	{mono foreground mask}
				SetBkColor(Image.Canvas.Handle, OldColor);
				BitBlt(hdcBack, 0, 0, dw, dh, hdcFore, 0, 0, NOTSRCCOPY);			{mono background mask}
				BitBlt(hdcTemp, 0, 0, dw, dh, Canvas.Handle, dl, dt, SRCCOPY);		{copy entire destination}
				BitBlt(hdcTemp, 0, 0, dw, dh, hdcFore, 0, 0, SRCAND);				{mask out foreground}
				BitBlt(Image.Canvas.Handle, 0, 0, dw, dh, hdcBack, 0, 0, SRCAND);	{mask out background}
				BitBlt(hdcTemp, 0, 0, dw, dh, Image.Canvas.Handle, 0, 0, SRCPAINT);	{mask in  foreground}
				BitBlt(Canvas.Handle, dl, dt, dw, dh, hdcTemp, 0, 0, SRCCOPY);		{copy to final destination}
			finally
				DeleteObject(SelectObject(hdcBack, bmBackOld));
				DeleteObject(SelectObject(hdcFore, bmForeOld));
				DeleteObject(SelectObject(hdcTemp, bmTempOld));
				end;
		finally
			DeleteDC(hdcTemp);
			DeleteDC(hdcBack);
			DeleteDC(hdcFore);
			end;
	finally
		Image.ReleasePalette;
		Image.Free;
		end;
	end;


procedure TMegaPanel.PaintPicture(ClipRect, PicRect: TRect; Pic: TBitmap; Sty: TPictureStyle;
					 Pos: TPicturePos; XOffset, YOffset: integer; Tran: TPictureTransparent);
	var
	x, y, w, h, fl, ft, fr, fb, fw, fh, ox, oy: integer;
	r, dr, sr, br, cr, dummy: TRect;
	BMP: TBitmap;
	begin
	if not IsRectEmpty(PicRect) then
		FRect := PicRect
	else
		case Sty of
			psAll:
				FRect := ClientRect;
			psPanel:
				begin
				FRect := AdjustPanelRect(ClientRect);
				Inc(FRect.Top, GroupBoxOffset);
				end;
			psPanelFrame:
				begin
				FRect := AdjustPanelRect(ClientRect);
				InflateRect(FRect, -FPanelBevelMargin, -FPanelBevelMargin);
				if FPanelBorderStyle = bsSingle then
					InflateRect(FRect, -1, -1);
				Inc(FRect.Top, GroupBoxOffset);
				end;
			psPanelInsideFrame:
				begin
				FRect := AdjustPanelRect(InsidePanelRect);
				Inc(FRect.Top, GroupBoxOffset);
				end;
			psCaption:
				FRect := CaptionRect;
			psCaptionFrame:
				begin
				FRect := CaptionRect;
				InflateRect(FRect, -FCaptionBevelMargin, -FCaptionBevelMargin);
				end;
			psCaptionInsideFrame:
				begin
				FRect := InsideCaptionRect;
				InflateRect(FRect, FCaptionClear, FCaptionClear);
				end;
			psCaptionText:
				FRect := InsideCaptionRect;
			end;
	if (Pic <> nil) and (Pic.Height > 0) then
		begin
		w := Pic.Width;
		h := Pic.Height;
		br := Bounds(0, 0, w, h);
		sr := br;
		r := FRect;
		case Pos of
			ppStretchTop, ppStripTop, ppStripTopFast:
				begin
				r.Bottom := r.Top + h;
				OffsetRect(r, 0, YOffset);
				end;
			ppStretchBottom, ppStripBottom, ppStripBottomFast:
				begin
				r.Top := r.Bottom - h;
				OffsetRect(r, 0, -YOffset);
				end;
			ppStretchLeft, ppStripLeft, ppStripLeftFast:
				begin
				r.Right := r.Left + w;
				OffsetRect(r, XOffset, 0);
				end;
			ppStretchRight, ppStripRight, ppStripRightFast:
				begin
				r.Left := r.Right - w;
				OffsetRect(r, -XOffset, 0);
				end;
			end;
		fl := r.Left;
		ft := r.Top;
		fr := r.Right;
		fb := r.Bottom;
		fw := fr - fl;
		fh := fb - ft;
		case Pos of
			ppStretch, ppStretchTop, ppStretchBottom, ppStretchLeft, ppStretchRight:
				case Tran of
					ptFull:
						TransStretchBlt(Pic, r, br, Pic.TransparentColor, False);
					ptSimple:
						Canvas.BrushCopy(r, Pic, br, Pic.TransparentColor);
					ptNone:
						Canvas.CopyRect(r, Pic.Canvas, br);
					end;
			ppTileFast, ppStripTopFast, ppStripBottomFast, ppStripLeftFast, ppStripRightFast:
				begin
				IntersectRect(cr, ClipRect, r);
				BMP := TBitmap.Create;
				BMP.Width := cr.Right - cr.Left;
				BMP.Height := cr.Bottom - cr.Top;
				BMP.Monochrome := Pic.Monochrome;
				BMP.Palette := GetPalette;
				y := ft;
				repeat
					x := fl;
					repeat
						if Ord(IntersectRect(dr, cr, Bounds(x, y, w, h))) <> 0 then
							begin
							ox := (dr.Left - fl) mod w;
							oy := (dr.Top - ft) mod h;
							OffsetRect(dr, -cr.Left, -cr.Top);
							BitBlt(BMP.Canvas.Handle, dr.Left, dr.Top,
									dr.Right - dr.Left, dr.Bottom - dr.Top,
									Pic.Canvas.Handle, ox, oy, SRCCOPY);
							end;
						Inc(x, w);
					until x > fr;
					Inc(y, h);
				until y > fb;
				case Tran of
					ptFull:
						TransStretchBlt(BMP, cr, Bounds(0, 0, BMP.Width, BMP.Height), Pic.TransparentColor, True);
					ptSimple:
						begin
						Canvas.BrushCopy(cr, BMP, Bounds(0, 0, BMP.Width, BMP.Height), Pic.TransparentColor);
						BMP.ReleasePalette;
						BMP.Free;
						end;
					ptNone:
						begin
						Canvas.CopyRect(cr, BMP.Canvas, Bounds(0, 0, BMP.Width, BMP.Height));
						BMP.ReleasePalette;
						BMP.Free;
						end;
					end;
				end;
			ppTile, ppStripTop, ppStripBottom, ppStripLeft, ppStripRight:
				begin
				sr.Left := 0;
				sr.Top := 0;
				y := ft;
				repeat
					x := fl;
					repeat
						IntersectRect(dr, r, Bounds(x, y, w, h));
						sr.Right := dr.Right - dr.Left;
						sr.Bottom := dr.Bottom - dr.Top;
						if Ord(IntersectRect(dummy, ClipRect, dr)) <> 0 then
							case Tran of
								ptFull:
									TransStretchBlt(Pic, dr, sr, Pic.TransparentColor, False);
								ptSimple:
									Canvas.BrushCopy(dr, Pic, sr, Pic.TransparentColor);
								ptNone:
									Canvas.CopyRect(dr, Pic.Canvas, sr);
								end;
						Inc(x, w);
					until x > fr;
					Inc(y, h);
				until y > fb;
				end;
			else
				begin
				case Pos of
					ppTopLeft:
						OffsetRect(br, fl + XOffset, ft + YOffset);
					ppTopCenter:
						OffsetRect(br, fl + (fw - w) div 2, ft + YOffset);
					ppTopRight:
						OffsetRect(br, fr - w - XOffset, ft + YOffset);
					ppLeftCenter:
						OffsetRect(br, fl + XOffset,  ft + (fh - h) div 2);
					ppCenter:
						OffsetRect(br, fl + (fw - w) div 2, ft + (fh - h) div 2);
					psRightCenter:
						OffsetRect(br, fr - w - XOffset,  ft + (fh - h) div 2);
					ppBottomLeft:
						OffsetRect(br, fl + XOffset, fb - h - YOffset);
					ppBottomCenter:
						OffsetRect(br, fl + (fw - w) div 2, fb - h - YOffset);
					ppBottomRight:
						OffsetRect(br, fr - w - XOffset, fb - h - YOffset);
					end;
				IntersectRect(dr, FRect, br);
				sr.Right := dr.Right - dr.Left;
				sr.Bottom := dr.Bottom - dr.Top;
				case Tran of
					ptFull:
						TransStretchBlt(Pic, dr, sr, Pic.TransparentColor, False);
					ptSimple:
						Canvas.BrushCopy(dr, Pic, sr, Pic.TransparentColor);
					ptNone:
						Canvas.CopyRect(dr, Pic.Canvas, sr);
					end;
				end;
			end;
		end;
	end;


function TMegaPanel.PanelFormRect: TRect;
	var
	w, h: integer;
	begin
	if FPanelForm <> nil then
		begin
		Result := ClientRect;
		AlignControls(nil, Result);
		w := FPanelForm.ClientWidth;
		h := FPanelForm.ClientHeight;
		case FPanelFormAlign of
			alTop:
				Result.Bottom := Result.Top + h;
			alBottom:
				Result.Top := Result.Bottom - h;
			alLeft:
				Result.Right := Result.Left + w;
			alRight:
				Result.Left := Result.Right - w;
			end;
		end
	else
		SetRectEmpty(Result);
	end;


procedure TMegaPanel.Paint;
	var
	OldDC, i, fl, ft, fr, fb, fw, fh: integer;
	pt: TPoint;
	cr, er, pr: TRect;
	tmp: string;
	OldPal, Pal: HPalette;
	begin
	if ((not (csDesigning in ComponentState)) and (not Visible))
		or UnSafe
		or FPainting
		or (csDestroying in ComponentState) then
		exit;
	OldPal := 0;
	Pal := GetPalette;
	if Pal <> 0 then
		begin
		OldPal := SelectPalette(Canvas.Handle, Pal, False);
		RealizePalette(Canvas.Handle);
		end;
	FPainting := FTransparent;
	SetRectEmpty(er);
	if (FPanelFormView = dvRuntime) and (FPanelFormName <> '') and (FPanelForm = nil) then
		begin
		tmp := FPanelFormName;
		FPanelFormName := '';
		SetPanelFormName(tmp);
		end;
	pr := PanelFormRect;
	PaintPanelForm(pr);
	if FPanelFormView = dvRunTime then
		ExcludeClipRect(Canvas.Handle, pr.Left, pr.Top, pr.Right, pr.Bottom);
	GetClipBox(Canvas.Handle, cr);
	if FPanelColStyle = csOpaque then
		begin
		Canvas.Brush.Style := bsSolid;
		Canvas.Brush.Color := inherited Color;
		PatBlt(Canvas.Handle, cr.Left, cr.Top, cr.Right - cr.Left, cr.Bottom - cr.Top, PATCOPY);
		end
	else
		begin
		OldDC := SaveDC(Canvas.Handle);
{$IFDEF VER100}
		GetViewPortOrgEx(Canvas.Handle, pt);
{$ELSE}
{$IFDEF VER120}
		GetViewPortOrgEx(Canvas.Handle, pt);
{$ELSE}
		GetViewPortOrgEx(Canvas.Handle, @pt);
{$ENDIF}
{$ENDIF}
		SetViewPortOrgEx(Canvas.Handle, pt.x - Left, pt.y - Top, nil);
		TMegaWin(Parent).PaintWindow(Canvas.Handle);
		RestoreDC(Canvas.Handle, OldDC);
		if FPanelColStyle = csDithered then
			PaintDitherRect(cr, inherited Color)
		else
			if FPanelColStyle <> csTransparent then
				PaintRopRect(cr, inherited Color, FPanelColStyle);
		end;
	if (FGradient.FType <> gtNone) and (FGradient.FStyle < psCaption) then
		PaintGradient(cr);
	if FPictureStyle < psCaption then
		PaintPicture(cr, er, FPicture, FPictureStyle, FPicturePos,
					 FPictureXOffset, FPictureYOffset, FPictureTransparent);
	if FCaptionPictureStyle < psCaption then
		PaintPicture(cr, er, FCaptionPicture, FCaptionPictureStyle, FCaptionPicturePos,
					 FCaptionPictureXOffset, FCaptionPictureYOffset, FCaptionPictureTransparent);
 	case FDividerBevel of
		bvLowered:
			begin
			FDividerColor1 := FColorShadow;
			FDividerColor2 := FColorHighlight;
			end;
		bvRaised:
			begin
			FDividerColor1 := FColorHighlight;
			FDividerColor2 := FColorShadow;
			end;
		end;
	if (FDividerBevel <> bvNone) and (FDividerWidth > 0) then
		begin
		FRect := ClientRect;
		AlignControls(nil, FRect);
		fl := FRect.Left;
		ft := FRect.Top;
		fr := FRect.Right;
		fb := FRect.Bottom;
		fw := fr - fl;
		fh := fb - ft;
		if FDividersVert > 0 then
			begin
			for i := 1 to FDividersVert do
				begin
				FRect.Left := fl - FDividerWidth + MulDiv(fw, i, FDividersVert + 1);
				FRect.Top := ft;
				FRect.Right := FRect.Left + FDividerWidth * 2;
				FRect.Bottom := fb + 1;
				Frame3D(Canvas, FRect, FDividerColor1, FDividerColor2, FDividerWidth);
				end;
			end;
		if FDividersHorz > 0 then
			begin
			for i := 1 to FDividersHorz do
				begin
				FRect.Left := fl;
				FRect.Top := ft - FDividerWidth + MulDiv(fh, i, FDividersHorz + 1);
				FRect.Right := fr + 1;
				FRect.Bottom := FRect.Top + FDividerWidth * 2;
				Frame3D(Canvas, FRect, FDividerColor1, FDividerColor2, FDividerWidth);
				end;
			end;
		end;
	if (FIsCaption and not IsColorNone(FColorCaptionBkgnd))
		and (FPicture.Empty or (FPictureStyle < psCaption))
		and (not (FGradient.FType <> gtNone) or (FGradient.FStyle <> psCaption)) then
		PaintCaption;
	if (FGradient.FType <> gtNone)
		and (FGradient.FStyle > psPanelInsideFrame) then
		PaintGradient(cr);
	if FPictureStyle > psPanelInsideFrame then
		PaintPicture(cr, er, FPicture, FPictureStyle, FPicturePos,
					 FPictureXOffset, FPictureYOffset, FPictureTransparent);
	if FCaptionPictureStyle > psPanelInsideFrame then
		PaintPicture(cr, er, FCaptionPicture, FCaptionPictureStyle, FCaptionPicturePos,
					 FCaptionPictureXOffset, FCaptionPictureYOffset, FCaptionPictureTransparent);
	if FIsCaption and (FCaptionBorderStyle = bsSingle) then
		begin
		FRect := CaptionRect;
		InflateRect(FRect, -FCaptionBevelMargin, -FCaptionBevelMargin);
		Canvas.Brush.Color := clBlack;
		Canvas.FrameRect(FRect);
		end;
	if FPanelBorderStyle = bsSingle then
		begin
		FRect := ClientRect;
		Canvas.Brush.Color := clBlack;
		Canvas.FrameRect(FRect);
		end;
	DrawPanel;
	SelectClipRgn(Canvas.Handle, 0);
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		PanelText;
	if (FShadow.FStyle <> csTransparent) and not IsColorNone(FShadow.FColor) then
		ControlShadows;
	if FTransparent then
		for i := 0 to ControlCount - 1 do
			Controls[i].Refresh;
	if FLabelList <> nil then
		PostMessage(Handle, WM_MEGATEXT, 0, 0);
	if OldPal <> 0 then
		SelectPalette(Canvas.Handle, OldPal, False);
	FPainting := False;
	end;


function TMegaPanel.GroupBoxOffset: integer;
	var
	cr: TRect;
	begin
	Result := 0;
	if FCaptionStyle <> csGroupBox then
		exit;
	cr := CaptionRect;
	Result := (cr.Bottom - cr.Top - FPanelFraming + FPanelBevelMargin) div 2;
	end;


procedure TMegaPanel.AlignControls(AControl: TControl; var Rect: TRect);
	var
	h, w: integer;
	CRect: TRect;
	begin
	CRect := CaptionRect;
	if FCaptionStyle = csGroupBox then
		begin
		InflateRect(Rect, -FPanelFraming, -FPanelFraming);
		Rect.Top := CRect.Bottom + FCaptionSpace;
		end
	else
		begin
		InflateRect(Rect, -FPanelFraming, -FPanelFraming);
		if (FCaptionStyle = csPanel) and FIsCaption then
			begin
			w := CRect.Right - CRect.Left + FCaptionSpace;
			h := CRect.Bottom - CRect.Top + FCaptionSpace;
			case FCaptionPos of
				cpTopLeft, cpTopCenter, cpTopRight:
					Inc(Rect.Top, h);
				cpLeftTop, cpLeftCenter, cpLeftBottom:
					Inc(Rect.Left, w);
				cpRightTop, cpRightCenter, cpRightBottom:
					Dec(Rect.Right, w);
				cpBottomLeft, cpBottomCenter, cpBottomRight:
					Dec(Rect.Bottom, h);
				end;
			end;
		end;
	inherited AlignControls(AControl, Rect);
	end;


procedure TMegaPanel.RotateFont(Angle: integer; AFont: TFont);
	var
{$IFDEF WIN32}
	FontName: string;
{$ELSE}
	ps: array[0..255] of char;
{$ENDIF}
	begin
{$IFDEF WIN32}
	FontName := AFont.Name;
{$ENDIF}
	FAngle := Angle;
	FRad := pi * Angle / 180;
	CanvasFont(AFont);
	if FAngle = 0 then
		exit;
	if FRotatedFont <> 0 then
		DeleteObject(FRotatedFont);
	FRotatedFont := CreateFont(AFont.Height, 0, Angle * 10, 0,
				Ord(fsBold in AFont.Style) * FW_BOLD, Ord(fsItalic in AFont.Style),
				Ord(fsUnderLine in AFont.Style), Ord(fsStrikeOut in AFont.Style),
				DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
				DEFAULT_PITCH + FF_DONTCARE,
{$IFDEF WIN32}
				pchar(FontName));
{$ELSE}
				StrPCopy(ps, AFont.Name));
{$ENDIF}
	Canvas.Font.Handle := FRotatedFont;
	end;


function TMegaPanel.PanelFraming: integer;
	begin
	Result := FPanelBorderWidth + FPanelBevelMargin;
	if FPanelBorderStyle = bsSingle then
		Inc(Result);
	if FPanelBevelOuter <> bvNone then
		Inc(Result, FPanelBevelWidth);
	if FPanelBevelInner <> bvNone then
		Inc(Result, FPanelBevelWidth);
	end;


function TMegaPanel.CaptionFraming: integer;
	begin
	if FIsCaption then
		begin
		Result := FCaptionBorderWidth + FCaptionBevelMargin + FCaptionClear;
		if FCaptionBorderStyle = bsSingle then
			Inc(Result);
		if FCaptionBevelOuter <> bvNone then
			Inc(Result, FCaptionBevelWidth);
		if FCaptionBevelInner <> bvNone then
			Inc(Result, FCaptionBevelWidth);
		end
	else
		Result := 0;
	end;


function TMegaPanel.InsideCaptionRect: TRect;
	begin
	Result := CaptionRect;
	if FIsCaption then
		InflateRect(Result, -FCaptionFraming, -FCaptionFraming);
	end;


function TMegaPanel.CaptionRect: TRect;
	var
	w, h: integer;
	begin
	if not FIsCaption then
		begin
		SetRectEmpty(Result);
		exit;
		end;
	Result := RotatedCaptionRect;
	if FCaptionStyle = csGroupBox then
		begin
		InflateRect(Result, FCaptionFraming, FCaptionFraming);
		OffsetRect(Result, FPanelFraming + TxWidth('n') - Result.Left, FPanelBevelMargin - Result.Top);
		exit;
		end;
	if FCaptionStyle = csFloating then
		begin
		InflateRect(Result, FCaptionFraming, FCaptionFraming);
		w := Result.Right - Result.Left;
		h := Result.Bottom - Result.Top;
		case FCaptionPos of
			cpTopCenter:
				OffsetRect(Result, (Width - w) div 2, 0);
			cpTopRight, cpRightTop:
				OffsetRect(Result, Width - w, 0);
			cpLeftCenter:
				OffsetRect(Result, 0, (Height - h) div 2);
			cpLeftBottom, cpBottomLeft:
				OffsetRect(Result, 0, Height - h);
			cpRightCenter:
				OffsetRect(Result, Width - w, (Height - h) div 2);
			cpRightBottom, cpBottomRight:
				OffsetRect(Result, Width - w, Height - h);
			cpBottomCenter:
				OffsetRect(Result, (Width - w) div 2, Height - h);
			end;
		OffsetRect(Result, FCaptionFraming, FCaptionFraming);
		exit;
		end;
	w := Result.Right + FCaptionFraming * 2;
	h := Result.Bottom + FCaptionFraming * 2;
	Result := ClientRect;
	if FCaptionLoc = clOutsideFrame then
		InflateRect(Result, -FPanelBevelMargin, -FPanelBevelMargin)
	else
		InflateRect(Result, -FPanelFraming, -FPanelFraming);
	case FCaptionPos of
		cpTopLeft, cpTopCenter, cpTopRight:
			Result.Bottom := Result.Top + h;
		cpLeftTop, cpLeftCenter, cpLeftBottom:
			Result.Right := Result.Left + w;
		cpRightTop, cpRightCenter, cpRightBottom:
			Result.Left := Result.Right - w;
		cpBottomLeft, cpBottomCenter, cpBottomRight:
			Result.Top := Result.Bottom - h;
		end;
	end;


function TMegaPanel.RotatedCaptionRect: TRect;
	var
	w, h: integer;
	rad: real;
	begin
	if not FIsCaption then
		SetRectEmpty(Result);
	CanvasFont(FCaptionFont);
	FString := inherited Caption;
	w:= TxWidth(FString);
	h:= TxHeight(FString);
	if FCaptionAngle = 0 then
		Result := Bounds(0, 0, w, h)
	else
		begin
		rad := pi * FCaptionAngle / 180;
		Result := Bounds(0, 0, Round(Abs(h * sin(rad)) + Abs(w * cos(rad))), Round(Abs(w * sin(rad)) + Abs(h * cos(rad))));
		end;
	end;


function TMegaPanel.InsidePanelRect: TRect;
	begin
	Result := ClientRect;
	InflateRect(Result, -FPanelFraming, -FPanelFraming);
	end;


procedure TMegaPanel.DrawPanel;
	var
	CapW, CapH, w, h: integer;
	CRect: TRect;
	begin
	FString := inherited Caption;
	CRect := CaptionRect;
	if FIsCaption
		and (FCaptionStyle = csGroupBox)
		and not IsRectEmpty(CRect)
		and (FCaptionColStyle = csOpaque) then
		ExcludeClipRect(Canvas.Handle, CRect.Left, CRect.Top, CRect.Right, CRect.Bottom);
	FRect := ClientRect;
	if FPanelBorderStyle = bsSingle then
		InflateRect(FRect, -1, -1);
	InflateRect(FRect, -FPanelBevelMargin, -FPanelBevelMargin);
	if FIsCaption then
		begin
		if FCaptionStyle = csGroupBox then
			Inc(FRect.Top, (CRect.Bottom - CRect.Top - FPanelFraming + FPanelBevelMargin) div 2)
		else
			if FCaptionStyle <> csFloating then
				FRect := AdjustPanelRect(FRect);
		end;
	if FPanelBevelOuter <> bvNone then
		begin
		case FPanelBevelOuter of
			bvLowered:
				Frame3D(Canvas, FRect, FColorShadow, FColorHighlight, FPanelBevelWidth);
			bvRaised:
				Frame3D(Canvas, FRect, FColorHighlight, FColorShadow, FPanelBevelWidth);
			end;
		end;
	InflateRect(FRect, -FPanelBorderWidth, -FPanelBorderWidth);
	if FPanelBevelInner <> bvNone then
		begin
		case FPanelBevelInner of
			bvLowered:
				Frame3D(Canvas, FRect, FColorShadow, FColorHighlight, FPanelBevelWidth);
			bvRaised:
				Frame3D(Canvas, FRect, FColorHighlight, FColorShadow, FPanelBevelWidth);
			end;
		end;
	if not FIsCaption then
		exit;
	if FCaptionStyle = csGroupBox then
		SelectClipRgn(Canvas.Handle, 0);
	FRect := CRect;
	InflateRect(FRect, -FCaptionBevelMargin, -FCaptionBevelMargin);
	if FCaptionBorderStyle = bsSingle then
		InflateRect(FRect, -1, -1);
	if FCaptionBevelOuter <> bvNone then
		begin
		case FCaptionBevelOuter of
			bvLowered:
				Frame3D(Canvas, FRect, FColorShadow, FColorHighlight, FCaptionBevelWidth);
			bvRaised:
				Frame3D(Canvas, FRect, FColorHighlight, FColorShadow, FCaptionBevelWidth);
			end;
		end;
	InflateRect(FRect, -FCaptionBorderWidth, -FCaptionBorderWidth);
	if FCaptionBevelInner <> bvNone then
		begin
		case FCaptionBevelInner of
			bvLowered:
				Frame3D(Canvas, FRect, FColorShadow, FColorHighlight, FCaptionBevelWidth);
			bvRaised:
				Frame3D(Canvas, FRect, FColorHighlight, FColorShadow, FCaptionBevelWidth);
			end;
		end;
	InflateRect(FRect, -FCaptionClear, -FCaptionClear);
	Canvas.Brush.Style := bsClear;
	CapW := FRect.Right - FRect.Left;
	CapH := FRect.Bottom - FRect.Top;
	CRect := RotatedCaptionRect;
	RotateFont(FCaptionAngle, FCaptionFont);
	w := CRect.Right - CRect.Left;
	h := CRect.Bottom - CRect.Top;
	if FCaptionStyle = csPanel then
		case FCaptionPos of
			cpLeftCenter, cpRightCenter:
				Inc(FRect.Top, (CapH - h) div 2);
			cpLeftBottom, cpRightBottom:
				Inc(FRect.Top, CapH - h);
			cpTopCenter, cpBottomCenter:
				Inc(FRect.Left, (CapW - w) div 2);
			cpBottomRight, cpTopRight:
				Inc(FRect.Left, CapW - w);
			end;
	case FCaptionHorzJust of
		hjLeft:
			FHorzJustify := DT_LEFT;
		hjCenter:
			FHorzJustify := DT_CENTER;
		hjRight:
			FHorzJustify := DT_RIGHT;
		end;
	FVertJustify := vjTop;
	DrawTextStyle(FCaptionFontStyle, FCaptionFont.Color);
	DeleteRotatedFont;
	FAngle := 0;
	end;


procedure TMegaPanel.AdjustTextRect;
	var
	x, y, w, ww, h, hh: integer;
	rad: real;
	begin
	x := 0;
	y := 0;
	rad := pi * FAngle / 180;
	w := TxWidth(FString);
	h := TxHeight(FString);
	ww := Round(Abs(h * sin(rad)) + Abs(w * cos(rad)));
	hh := Round(Abs(w * sin(rad)) + Abs(h * cos(rad)));
	if (FAngle <= 90) and (FAngle >= 0) then
		begin
		x:= 0;
		y:= Abs(Round(w * sin(rad)));
		end;
	if (FAngle < 0) and (FAngle >= -90) then
		begin
		x:= Abs(Round(h * sin(rad)));
		y:= 0;
		end;
	if (FAngle > 90) and (FAngle <= 180) then
		begin
		x:= Abs(Round(w * cos(rad)));
		y:= hh;
		end;
	if (FAngle < -90) and (FAngle >- 180) then
		begin
		x:= ww;
		y:= Abs(Round(h * cos(rad)));
		end;
	OffsetRect(FRect, x, y);
	end;


procedure TMegaPanel.DrawTextRect(Offset: integer);
	var
	VJustify: integer;
	r: TRect;
{$IFNDEF WIN32}
	ps: array[0..255] of char;
{$ENDIF}
	begin
	r := FRect;
	VJustify := 0;
	case FVertJustify of
		vjCenter:
			VJustify := (r.Bottom - r.Top - FTextHeight) div 2;
		vjBottom:
			VJustify := r.Bottom - r.Top - FTextHeight;
		end;
	OffsetRect(FRect, Offset, Offset + VJustify);
	if FAngle <> 0 then
		AdjustTextRect;
{$IFDEF WIN32}
	DrawText(Canvas.Handle, pchar(FString), -1, FRect, FHorzJustify or DT_NOCLIP);
{$ELSE}
	DrawText(Canvas.Handle, StrPCopy(ps, FString), -1, FRect, FHorzJustify or DT_NOCLIP);
{$ENDIF}
	FRect := r;
	end;


procedure TMegaPanel.DrawTextStyle(DrawStyle: TFontStyle; DrawColor: TMegaColor);
	begin
	case DrawStyle of
		fsNormal:
			begin
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsRaisedLight:
			begin
			Canvas.Font.Color := FColorHighlight;
			DrawTextRect(-1);
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsRaisedHeavy:
			begin
			Canvas.Font.Color := FColorHighlight;
			DrawTextRect(-1);
			Canvas.Font.Color := FColorShadow;
			DrawTextRect(1);
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsInsetLight:
			begin
			Canvas.Font.Color := FColorHighlight;
			DrawTextRect(1);
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsInsetHeavy:
			begin
			Canvas.Font.Color := FColorHighlight;
			DrawTextRect(1);
			Canvas.Font.Color := FColorShadow;
			DrawTextRect(-1);
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsDropShadow:
			begin
			Canvas.Font.Color := FColorShadow;
			DrawTextRect(2);
			Canvas.Font.Color := DrawColor;
			DrawTextRect(0);
			end;
		fsHeavy:
			begin
			Canvas.Font.Color := DrawColor;
			DrawTextRect(1);
			DrawTextRect(0);
			end;
		end;
	end;


function TMegaPanel.TxWidth(s: string): integer;
	var
	i, l, w: integer;
	t: string;
	begin
	t := '';
	Result := 0;
	l := Length(s);
	for i := 1 to l do
		begin
		if (s[i] = '&')
			and (i < l)
			and (s[i + 1] <> '&') then
			continue;
		if (s[i] = #13) then
			begin
			w := Canvas.TextWidth(t);
			if w > Result then
				Result := w;
			t := '';
			end
		else
			t := t + s[i];
		end;
	w := Canvas.TextWidth(t);
	if w > Result then
		Result := w;
	end;


function TMegaPanel.TxHeight(s: string): integer;
	var
	i, l: integer;
	begin
	l := 1;
	for i := 1 to Length(s) do
		if s[i] = #13 then
			Inc(l);
	Result := Canvas.TextHeight('SMF') * l;
	end;


function TMegaPanel.LabelRect(LabelCtl: TControl): TRect;
	var
	t, l, w, h, lf, tw, th: integer;
	begin
	lf := FLabelClear;
	if FLabelBevel <> bvNone then
		Inc(lf, FLabelBevelWidth);
	l := 0;
	t := 0;
	w := LabelCtl.Width;
	h := LabelCtl.Height;
	FString := GetPanelLabel(LabelCtl);
	if FString = '' then
		begin
		SetRectEmpty(Result);
		exit;
		end;
	FTextHeight := TxHeight(FString);
	FTextWidth := TxWidth(FString);
	if FLabelAngle <> 0 then
		begin
		tw := Round(Abs(FTextHeight * sin(FRad)) + Abs(FTextWidth * cos(FRad)));
		th := Round(Abs(FTextWidth * sin(FRad)) + Abs(FTextHeight * cos(FRad)));
		FTextWidth := tw;
		FTextHeight := th;
		end;
	if FLabelWidth = 0 then
		tw := FTextWidth
	else
		tw := FLabelWidth;
	if FLabelHeight = 0 then
		th := FTextHeight
	else
		th := FLabelHeight;
	case FLabelPos of
		lpTopLeftCorner, lpTopCenter, lpTopRightCorner, lpTopLeft, lpTopRight:
			t := -th - lf - FLabelSpace;
		lpLeftCenter, lpRightCenter:
			t := (h - th) div 2;
		lpBottomLeftCorner, lpBottomCenter, lpBottomRightCorner, lpBottomLeft, lpBottomRight:
			t := h + lf + FLabelSpace;
		lpLeftTop, lpRightTop:
			t := lf;
		lpLeftBottom, lpRightBottom:
			t := h - th - lf;
		end;
	case FLabelPos of
		lpLeftTop, lpLeftCenter, lpLeftBottom, lpTopLeftCorner, lpBottomLeftCorner:
			l := -tw - lf - FLabelSpace;
		lpTopCenter, lpBottomCenter:
			l := (w - tw) div 2;
		lpTopLeft, lpBottomLeft:
			l := lf;
		lpTopRight, lpBottomRight:
			l := w - tw - lf;
		lpRightTop, lpRightCenter, lpRightBottom, lpTopRightCorner, lpBottomRightCorner:
			l := w + lf + FLabelSpace;
		end;
	Result := Bounds(LabelCtl.Left + l, LabelCtl.Top + t, tw, th);
	InflateRect(Result, lf, lf);
	end;


procedure TMegaPanel.ControlShadows;
	var
	i: integer;
	Ctl: TControl;
	Inf: TMegaInfo;
	begin
	for i:= 0 to ControlCount - 1 do
		begin
		Ctl := Controls[i];
		Inf := MegaList.GetControlInf(Ctl);
		if (Inf <> nil) and (cfShadow in Inf.Fix) then
			PaintShadow(Ctl);
		end;
	end;


procedure TMegaPanel.PanelText;
	var
	i: integer;
	LabelColor: TMegaColor;
	Ctl: TControl;
	Inf: TMegaInfo;
	SaveBevel: TPanelBevel;
	SaveStyle: TFontStyle;
	begin
	SaveBevel := bvNone;
	SaveStyle := fsNormal;
	case FLabelHorzJust of
		hjLeft:
			FHorzJustify := DT_LEFT;
		hjCenter:
			FHorzJustify := DT_CENTER;
		hjRight:
			FHorzJustify := DT_RIGHT;
		end;
	FVertJustify := FLabelVertJust;
	RotateFont(FLabelAngle, FLabelFont);
	for i:= 0 to ControlCount - 1 do
		begin
		Ctl := TControl(Controls[i]);
		Inf := MegaList.GetControlInf(Ctl);
		FString := GetPanelLabel(Ctl);
		if (FString = '')
			or (Inf = nil)
			or (not Ctl.Visible) then
			continue;
		FRect := LabelRect(Ctl);
		if (cfFocEffect in Inf.Fix)
			and (((FFocus.FEffect = feFocus) and (Ctl = FFocusCtl))
			or ((FFocus.FEffect = feLive) and (Ctl = LiveCtl))) then
			begin
			SaveBevel := FLabelBevel;
			SaveStyle := FLabelFontStyle;
			FLabelBevel := FFocus.FBevel;
			FLabelFontStyle := FFocus.FStyle;
			end;
		if (([cfFocEffect, cfPnlLabel] * Inf.Fix) <> [])
			and (FLabelBevel <> bvNone)
			and (FLabelBevelWidth > 0) then
			if FLabelBevel = bvRaised then
				Frame3D(Canvas, FRect, FColorHighlight, FColorShadow, FLabelBevelWidth)
			else
				Frame3D(Canvas, FRect, FColorShadow, FColorHighlight, FLabelBevelWidth);
		if ((FFocus.FEffect = feFocus) and (Ctl = FFocusCtl))
			or ((FFocus.FEffect = feLive) and (Ctl = LiveCtl)) then
			begin
			if (cfFocEffect in Inf.Fix)
				and not IsColorNone(FFocus.FBack) then
				case FFocus.FColStyle of
					csTransparent:
						{do nothing};
					csOpaque:
						begin
						Canvas.Brush.Style := bsSolid;
						Canvas.Brush.Color := FFocus.FBack;
						PatBlt(Canvas.Handle, FRect.Left, FRect.Top, FRect.Right - FRect.Left, FRect.Bottom - FRect.Top, PATCOPY);
						end;
					csDithered:
						PaintDitherRect(FRect, FFocus.FBack);
					else
						PaintRopRect(FRect, FFocus.FBack, FFocus.FColStyle);
					end;
			end
		else
			if ([cfFocEffect, cfPnlLabel] * Inf.Fix) <> [] then
				begin
				if FTagUsage = tuLabelBackground then
					begin
					if not IsColorNone(Ctl.Tag) then
						case FLabelColStyle of
							csTransparent:
								{do nothing};
							csOpaque:
								begin
								Canvas.Brush.Style := bsSolid;
								Canvas.Brush.Color := Ctl.Tag;
								PatBlt(Canvas.Handle, FRect.Left, FRect.Top, FRect.Right - FRect.Left, FRect.Bottom - FRect.Top, PATCOPY);
								end;
							csDithered:
								PaintDitherRect(FRect, Ctl.Tag);
							else
								PaintRopRect(FRect, Ctl.Tag, FLabelColStyle);
							end;
					end
				else
					begin
					if not IsColorNone(FColorLabelBkgnd) then
						case FLabelColStyle of
							csTransparent:
								{do nothing};
							csOpaque:
								begin
								Canvas.Brush.Style := bsSolid;
								Canvas.Brush.Color := FColorLabelBkgnd;
								PatBlt(Canvas.Handle, FRect.Left, FRect.Top, FRect.Right - FRect.Left, FRect.Bottom - FRect.Top, PATCOPY);
								end;
							csDithered:
								PaintDitherRect(FRect, FColorLabelBkgnd);
							else
								PaintRopRect(FRect, FColorLabelBkgnd, FLabelColStyle);
							end;
					end;
				end;
		if ([cfFocEffect, cfPnlLabel] * Inf.Fix) <> [] then
			InflateRect(FRect, -FLabelClear, -FLabelClear);
		LabelColor := FLabelFont.Color;
		if ((FFocus.FEffect = feFocus) and (Ctl = FFocusCtl))
			or ((FFocus.FEffect = feLive) and (Ctl = LiveCtl)) then
			begin
			if cfFocEffect in Inf.Fix then
				LabelColor := FFocus.FFontColor;
			end
		else
			if ([cfFocEffect, cfPnlLabel] * Inf.Fix) <> [] then
				begin
				if not Ctl.Enabled then
					LabelColor := FColorDisabled
				else
					if (FTagUsage = tuLabelColor) and not IsColorNone(Ctl.Tag) then
						LabelColor := Ctl.Tag;
				end;
		if ([cfFocEffect, cfPnlLabel] * Inf.Fix) <> [] then
			begin
			Canvas.Brush.Style := bsClear;
			DrawTextStyle(FLabelFontStyle, LabelColor);
			end;
		if (cfFocEffect in Inf.Fix)
			and (((FFocus.FEffect = feFocus) and (Ctl = FFocusCtl))
			or ((FFocus.FEffect = feLive) and (Ctl = LiveCtl))) then
 			begin
			FLabelBevel := SaveBevel;
			FLabelFontStyle := SaveStyle;
			end;
		end;
	DeleteRotatedFont;
	FAngle := 0;
	end;


procedure TMegaPanel.SetPicture(Value: TBitmap);
	begin
	FPicture.Free;
	FPicture := TBitmap.Create;
	FPicture.Assign(Value);
{$IFDEF WIN32}
	FPicture.IgnorePalette := False;
{$ENDIF}
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPicture(Value: TBitmap);
	begin
	FCaptionPicture.Free;
	FCaptionPicture := TBitmap.Create;
	FCaptionPicture.Assign(Value);
{$IFDEF WIN32}
	FCaptionPicture.IgnorePalette := False;
{$ENDIF}
	Invalidate;
	end;


procedure TMegaPanel.SetPicturePos(Value: TPicturePos);
	begin
	if FPicturePos = Value then
		exit;
	FPicturePos := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetPictureTransparent(Value: TPictureTransparent);
	begin
	if FPictureTransparent = Value then
		exit;
	FPictureTransparent := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetPictureStyle(Value: TPictureStyle);
	begin
	if FPictureStyle = Value then
		exit;
	FPictureStyle := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetPictureXOffset(Value: integer);
	begin
	if FPictureXOffset = Value then
		exit;
	FPictureXOffset := Value;
	if csDesigning in ComponentState then
		FPicXOff := FCaptionPictureXOffset;
	Invalidate;
	end;


procedure TMegaPanel.SetPictureYOffset(Value: integer);
	begin
	if FPictureYOffset = Value then
		exit;
	FPictureYOffset := Value;
	if csDesigning in ComponentState then
		FPicYOff := FCaptionPictureYOffset;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPicturePos(Value: TPicturePos);
	begin
	if FCaptionPicturePos = Value then
		exit;
	FCaptionPicturePos := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPictureTransparent(Value: TPictureTransparent);
	begin
	if FCaptionPictureTransparent = Value then
		exit;
	FCaptionPictureTransparent := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPictureXOffset(Value: integer);
	begin
	if FCaptionPictureXOffset = Value then
		exit;
	FCaptionPictureXOffset := Value;
	if csDesigning in ComponentState then
		FCapPicXOff := FPictureXOffset;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPictureYOffset(Value: integer);
	begin
	if FCaptionPictureYOffset = Value then
		exit;
	FCaptionPictureYOffset := Value;
	if csDesigning in ComponentState then
		FCapPicYOff := FPictureYOffset;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionPictureStyle(Value: TPictureStyle);
	begin
	if FCaptionPictureStyle = Value then
		exit;
	FCaptionPictureStyle := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetLabelStyle(Value: TLabelStyle);
	begin
	if FLabelStyle = Value then
		exit;
	FLabelStyle := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelHorzJust(Value: THorzJust);
	begin
	if FLabelHorzJust = Value then
		exit;
	FLabelHorzJust := Value;
	if FLabelStyle <> lsNone then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelVertJust(Value: TVertJust);
	begin
	if FLabelVertJust = Value then
		exit;
	FLabelVertJust := Value;
	if FLabelStyle <> lsNone then
		Invalidate;
	end;


procedure TMegaPanel.SetPanelBevelMargin(Value: integer);
	begin
	if FPanelBevelMargin = Value then
		exit;
	FPanelBevelMargin := Value;
	if csDesigning in ComponentState then
		FPanBevMar := FPanelBevelMargin;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelBevelWidth(Value: integer);
	begin
	if FLabelBevelWidth = Value then
		exit;
	FLabelBevelWidth := Value;
	if csDesigning in ComponentState then
		FLabBevWid := FLabelBevelWidth;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelWidth(Value: integer);
	begin
	if FLabelWidth = Value then
		exit;
	FLabelWidth := Value;
	if csDesigning in ComponentState then
		FLabWid := FLabelWidth;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelHeight(Value: integer);
	begin
	if FLabelHeight = Value then
		exit;
	FLabelHeight := Value;
	if csDesigning in ComponentState then
		FLabHgt := FLabelHeight;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		Invalidate;
	end;


procedure TMegaPanel.SetLabelPos(Value: TLabelPos);
	begin
	if FLabelPos = Value then
		exit;
	FLabelPos := Value;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelClear(Value: integer);
	begin
	if FLabelClear = Value then
		exit;
	FLabelClear := Value;
	if csDesigning in ComponentState then
		FLabClr := FLabelClear;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelSpace(Value: integer);
	begin
	if FLabelSpace = Value then
		exit;
	FLabelSpace := Value;
	if csDesigning in ComponentState then
		FLabSpc := FLabelSpace;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelX(Value: integer);
	begin
	if FLabelX = Value then
		exit;
	FLabelX := Value;
	if csDesigning in ComponentState then
		FLabX := FLabelX;
	if (FLabelStyle = lsInControl) or (FLabelStyle = lsMixed) then
		Invalidate;
	end;


procedure TMegaPanel.SetLabelY(Value: integer);
	begin
	if FLabelY = Value then
		exit;
	FLabelY := Value;
	if csDesigning in ComponentState then
		FLabY := FLabelY;
	if (FLabelStyle = lsInControl) or (FLabelStyle = lsMixed) then
		Invalidate;
	end;


procedure TMegaPanel.SetLabelType(Value: TLabelType);
	begin
	if FLabelType = Value then
		exit;
	FLabelType := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetDividersHorz(Value: integer);
	begin
	if FDividersHorz = Value then
		exit;
	FDividersHorz := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetDividersVert(Value: integer);
	begin
	if FDividersVert = Value then
		exit;
	FDividersVert := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetCaptionHorzJust(Value: THorzJust);
	begin
	if FCaptionHorzJust = Value then
		exit;
	FCaptionHorzJust := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionStyle(Value: TCaptionStyle);
	begin
	if FCaptionStyle = Value then
		exit;
	FCaptionStyle := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionFontStyle(Value: TFontStyle);
	begin
	if FCaptionFontStyle = Value then
		exit;
	FCaptionFontStyle := Value;
	ParentFont := False;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionFont(Value: TFont);
	begin
	if (Value <> nil)
		and (FCaptionFont <> nil)
		and (FCaptionFont.Color = Value.Color)
		and (FCaptionFont.Height = Value.Height)
		and (FCaptionFont.Name = Value.Name)
		and (FCaptionFont.Pitch = Value.Pitch)
		and (FCaptionFont.Size = Value.Size)
		and (FCaptionFont.Style = Value.Style) then
		exit;
	ParentFont := False;
	FCaptionFont.Assign(Value);
	if csDesigning in ComponentState then
		FCapSize := FCaptionFont.Size;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetClipChildren(Value: boolean);
	begin
	if FClipChildren = Value then
		exit;
	FClipChildren := Value;
	SetWSClipChild
	end;


procedure TMegaPanel.SetWSClipChild;
	begin
	FTransparent := IsColorNone(inherited Color) or (FPanelColStyle <> csOpaque);
	if (not FClipChildren) or FTransparent then
		SetWindowLong(Handle, GWL_STYLE, GetWindowLong(Handle, GWL_STYLE) and (not WS_CLIPCHILDREN))
	else
		SetWindowLong(Handle, GWL_STYLE, GetWindowLong(Handle, GWL_STYLE) or WS_CLIPCHILDREN);
	end;


procedure TMegaPanel.SetPanelColStyle(Value: TColorStyle);
	begin
	if FPanelColStyle = Value then
		exit;
	FPanelColStyle := Value;
	SetWSClipChild;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionColStyle(Value: TColorStyle);
	begin
	if FCaptionColStyle = Value then
		exit;
	FCaptionColStyle := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetLabelColStyle(Value: TColorStyle);
	begin
	if FLabelColStyle = Value then
		exit;
	FLabelColStyle := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetPanelColor(Value: TMegaColor);
	begin
	inherited Color := Value;
	SetWSClipChild;
	InvalidatePanel;
	end;


function TMegaPanel.GetColor: TMegaColor;
	begin
	Result := inherited Color;
	end;


procedure TMegaPanel.SetLabelFontStyle(Value: TFontStyle);
	begin
	if FLabelFontStyle <> Value then
		begin
		FLabelFontStyle := Value;
		ParentFont := False;
		InvalidatePanel;
		end;
	end;


procedure TMegaPanel.SetLabelFont(Value: TFont);
	begin
	if (Value <> nil)
		and (FLabelFont <> nil)
		and (FLabelFont.Color = Value.Color)
		and (FLabelFont.Height = Value.Height)
		and (FLabelFont.Name = Value.Name)
		and (FLabelFont.Pitch = Value.Pitch)
		and (FLabelFont.Size = Value.Size)
		and (FLabelFont.Style = Value.Style) then
		exit;
	ParentFont := False;
	FLabelFont.Assign(Value);
	if csDesigning in ComponentState then
		FLabSize := FLabelFont.Size;
	if FLabelStyle <> lsNone then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetColorCaptionBkgnd(Value: TMegaColor);
	begin
	if FColorCaptionBkgnd = Value then
		exit;
	FColorCaptionBkgnd := Value;
	if IsColorNone(FColorCaptionBkgnd) then
		FCaptionColStyle := csTransparent;
	if FCaptionStyle <> csNone then
		Invalidate;
	end;


procedure TMegaPanel.SetColorLabelBkgnd(Value: TMegaColor);
	begin
	if FColorLabelBkgnd = Value then
		exit;
	FColorLabelBkgnd := Value;
	if IsColorNone(FColorLabelBkgnd) then
		FLabelColStyle := csTransparent;
	if FLabelStyle <> lsNone then
		Invalidate;
	end;


procedure TMegaPanel.SetColorDisabled(Value: TMegaColor);
	begin
	if FColorDisabled = Value then
		exit;
	FColorDisabled := Value;
	if FLabelStyle <> lsNone then
		Invalidate;
	end;


procedure TMegaPanel.SetColorHighlight(Value: TMegaColor);
	begin
	if FColorHighlight = Value then
		exit;
	FColorHighlight := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetColorShadow(Value: TMegaColor);
	begin
	if FColorShadow = Value then
		exit;
	FColorShadow := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetLabelBevel(Value: TPanelBevel);
	begin
	if FLabelBevel = Value then
		exit;
	FLabelBevel := Value;
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetDividerWidth(Value: integer);
	begin
	if FDividerWidth = Value then
		exit;
	FDividerWidth := Value;
	if csDesigning in ComponentState then
		FDivWid := FDividerWidth;
	Invalidate;
	end;


procedure TMegaPanel.SetDividerBevel(Value: TPanelBevel);
	begin
	if FDividerBevel = Value then
		exit;
	FDividerBevel := Value;
	Invalidate;
	end;


procedure TMegaPanel.SeTTagUsage(Value: TTagUsage);
	begin
	if FTagUsage = Value then
		exit;
	FTagUsage := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetCaption(Value: string);
	begin
	if inherited Caption = Value then
		exit;
	inherited Caption := Value;
	InvalidatePanel;
	end;


function TMegaPanel.GetCaption: string;
	begin
	Result := inherited Caption;
	end;


class function TMegaPanel.GetCopyright: string;
	begin
	Result := CopyrightNotice;
	end;


procedure TMegaPanel.SetCaptionPos(Value: TCaptionPos);
	begin
	if FCaptionPos = Value then
		exit;
	FCaptionPos := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBevelWidth(Value: integer);
	begin
	if FCaptionBevelWidth = Value then
		exit;
	FCaptionBevelWidth := Value;
	if csDesigning in ComponentState then
		FCapBevWid := FCaptionBevelWidth;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBevelInner(Value: TPanelBevel);
	begin
	if FCaptionBevelInner = Value then
		exit;
	FCaptionBevelInner := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBevelOuter(Value: TPanelBevel);
	begin
	if FCaptionBevelOuter = Value then
		exit;
	FCaptionBevelOuter := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBevelMargin(Value: integer);
	begin
	if FCaptionBevelMargin = Value then
		exit;
	FCaptionBevelMargin := Value;
	if csDesigning in ComponentState then
		FCapBevMar := FCaptionBevelMargin;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBorderWidth(Value: integer);
	begin
	if FCaptionBorderWidth = Value then
		exit;
	FCaptionBorderWidth := Value;
	if csDesigning in ComponentState then
		FCapBorWid := FCaptionBorderWidth;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionLoc(Value: TCaptionLoc);
	begin
	if FCaptionLoc = Value then
		exit;
	FCaptionLoc := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionClear(Value: integer);
	begin
	if FCaptionClear = Value then
		exit;
	FCaptionClear := Value;
	if csDesigning in ComponentState then
		FCapClr := FCaptionClear;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionSpace(Value: integer);
	begin
	if FCaptionSpace = Value then
		exit;
	FCaptionSpace := Value;
	if csDesigning in ComponentState then
		FCapSpc := FCaptionSpace;
	InvalidatePanel;
	end;


function NormalizeAngle(Angle: Integer): integer;
	begin
	if Angle > 0 then
		Result := Angle mod 360
	else
		Result := -(abs(Angle) mod 360);
	if Result > 180 then
		Result := Result - 360;
	if Result < -180 then
		Result := Result + 360;
	end;


procedure TMegaPanel.SetCaptionAngle(Value: Integer);
	begin
	if FCaptionAngle = NormalizeAngle(Value) then
		exit;
	FCaptionAngle:= NormalizeAngle(Value);
	InvalidatePanel;
	end;


procedure TMegaPanel.SetLabelAngle(Value: Integer);
	begin
	if FLabelAngle = NormalizeAngle(Value) then
		exit;
	FLabelAngle:= NormalizeAngle(Value);
	if (FLabelStyle = lsInPanel) or (FLabelStyle = lsMixed) then
		InvalidatePanel;
	end;


procedure TMegaPanel.SetCaptionBorderStyle(Value: TBorderStyle);
	begin
	if FCaptionBorderStyle = Value then
		exit;
	FCaptionBorderStyle := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelBevelInner(Value: TPanelBevel);
	begin
	if FPanelBevelInner = Value then
		exit;
	FPanelBevelInner := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelBevelWidth(Value: integer);
	begin
	if FPanelBevelWidth = Value then
		exit;
	FPanelBevelWidth := Value;
	if csDesigning in ComponentState then
		FPanBevWid := FPanelBevelWidth;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelBevelOuter(Value: TPanelBevel);
	begin
	if FPanelBevelOuter = Value then
		exit;
	FPanelBevelOuter := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelBorderStyle(Value: TBorderStyle);
	begin
	if FPanelBorderStyle = Value then
		exit;
	FPanelBorderStyle := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelBorderWidth(Value: integer);
	begin
	if FPanelBorderWidth = Value then
		exit;
	FPanelBorderWidth := Value;
	if csDesigning in ComponentState then
		FPanBorWid := FPanelBorderWidth;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetPanelFormView(Value: TDesignView);
	begin
	if FPanelFormView = Value then
		exit;
	FPanelFormView := Value;
	Invalidate;
	end;


procedure TMegaPanel.SetPanelFormAlign(Value: TAlign);
	begin
	if FPanelFormAlign = Value then
		exit;
	FPanelFormAlign := Value;
	Invalidate;
	end;


procedure TMegaPanel.PanelFormDestroy(Sender: TObject);
	begin
	FocusPnl := nil;
	FFocusCtl := nil;
	LiveCtl := nil;
	ReleasePanelForm;
	if Assigned(FOnPanelFormDestroying) then
		FOnPanelFormDestroying(self, FPanelForm);
	if Assigned(FPanelFormDestroy) then
		FPanelFormDestroy(Sender);
	FPanelFormDestroy := nil;
	end;


procedure TMegaPanel.ReleasePanelForm;
	var
	pr: TRect;
	pt: TPoint;
	CXF, CYC: integer;
	begin
	if (FPanelForm = nil) or (csLoading in FPanelForm.ComponentState) then
		exit;
	if Assigned(FOnPanelFormHide) then
		FOnPanelFormHide(self, FPanelForm);
	FPanelForm.Visible := False;
	if (csDesigning in ComponentState) then
		begin
		if (GetWindowLong(FPanelForm.Handle, GWL_STYLE) <> $16CF0000)
			or (WinProcs.GetParent(FPanelForm.Handle) <> GetDesktopWindow) then
			begin
			WinProcs.SetFocus(GetDesktopWindow);
			SetWindowLong(FPanelForm.Handle, GWL_STYLE, $16CF0000);
			SetWindowLong(FPanelForm.Handle, GWL_EXSTYLE, $100);
			WinProcs.SetParent(FPanelForm.Handle, GetDesktopWindow);
			end;
		FPanelForm.Align := alNone;
		FPanelForm.Position := poDesigned;
		FPanelForm.BorderStyle := bsSizeable;
		FPanelForm.BorderIcons := [biSystemMenu, biMinimize, biMaximize];
		pr := PanelFormRect;
		pt := ClientToScreen(pr.TopLeft);
		OffsetRect(pr, pt.x, pt.y);
		CXF := GetSystemMetrics(SM_CXFRAME);
		CYC := GetSystemMetrics(SM_CYCAPTION);
		FPanelForm.Left := pr.Left - CXF;
		FPanelForm.Top := pr.Top - CYC;
		FPanelForm.ClientWidth := pr.Right - pr.Left - 1;
		FPanelForm.ClientWidth := pr.Right - pr.Left;
		FPanelForm.ClientHeight := pr.Bottom - pr.Top;
		BringWindowToTop(TForm(Owner).Handle);
		end;
	if Assigned(FOnPanelFormDeactivated) then
		FOnPanelFormDeactivated(self, FPanelForm);
	FPanelForm := nil;
	end;


procedure TMegaPanel.PaintPanelForm(pr: TRect);
	begin
	if UnSafe
		or (FPanelForm = nil)
		or (csLoading in FPanelForm.ComponentState) then
		exit;
	if not IsRectEmpty(pr) and (FPanelFormView = dvRunTime) then
		begin
		if (GetWindowLong(FPanelForm.Handle, GWL_STYLE) <> $56000000)
			or (WinProcs.GetParent(FPanelForm.Handle) <> Handle) then
			begin
			SetWindowLong(FPanelForm.Handle, GWL_STYLE, $56000000);
			SetWindowLong(FPanelForm.Handle, GWL_EXSTYLE, 0);
			WinProcs.SetParent(FPanelForm.Handle, Handle);
			if Assigned(FOnPanelFormShow) then
				FOnPanelFormShow(self, FPanelForm);
			end;
		FPanelForm.SetBounds(pr.Left, pr.Top, pr.Right - pr.Left, pr.Bottom - pr.Top);
		FPanelForm.Visible := True;
		end
	else
		ReleasePanelForm;
	end;


procedure TMegaPanel.ControlHint(Ctl: TControl; Hnt: string);
	begin
	try
		if ContainsControl(Ctl) then
			begin
			Ctl.Hint := Hnt;
			InvalidateLabel(Ctl);
			end;
	except
		end;
	end;


procedure TMegaPanel.ActivatePanelForm;
	var
{$IFDEF VER100}
	Frm: TCustomForm;
{$ELSE}
{$IFDEF VER120}
	Frm: TCustomForm;
{$ELSE}
	Frm: TForm;
{$ENDIF}
{$ENDIF}
	begin
	if not (csDesigning in ComponentState) and FPanelForm.HandleAllocated then
		PostMessage(FPanelForm.Handle, WM_SETFOCUS, 0, 0);
	Frm := GetParentForm(self);
	if (Frm <> nil) and Frm.HandleAllocated then
		PostMessage(Frm.Handle, WM_NCACTIVATE, 1, 0);
	end;


procedure TMegaPanel.SetPanelForm(Value: TForm);
	begin
	if FPanelForm = Value then
		exit;
	if FPanelForm <> nil then
		ReleasePanelForm;
	FPanelForm := Value;
	if FPanelForm = nil then
		FPanelFormName := ''
	else
		begin
		FPanelForm.Visible := False;
		FPanelForm.Left := -9000;
		FPanelForm.Top := -9000;
		if not Assigned(FPanelFormDestroy) then
			begin
			FPanelFormDestroy := FPanelForm.OnDestroy;
			FPanelForm.OnDestroy := PanelFormDestroy;
			end;
		FPanelFormName := Copy(FPanelForm.ClassName, 2, Length(FPanelForm.ClassName) - 1);
		if Assigned(FOnPanelFormActivated) then
			FOnPanelFormActivated(self, FPanelForm);
		if FFormActivate then
			ActivatePanelForm;
		end;
	Invalidate;
	end;


procedure TMegaPanel.SetPanelFormName(Value: string);
	var
	tWnd: HWnd;
{$IFDEF VER100}
	Frm: TCustomForm;
{$ELSE}
{$IFDEF VER120}
	Frm: TCustomForm;
{$ELSE}
	Frm: TForm;
{$ENDIF}
{$ENDIF}
	begin
	if (FPanelForm <> nil)
		and (CompareText(FPanelFormName, Value) <> 0) then
		ReleasePanelForm;
	FPanelForm := Nil;
	FPanelFormName := Value;
	if FPanelFormName <> '' then
		begin
		tWnd := GetWindow(Application.Handle, GW_HWNDFIRST);
		while (tWnd <> 0) do
			begin
			Frm := TForm(FindControl(tWnd));
			if (Frm <> nil)
				and (Frm is TForm)
				and (CompareText(Frm.ClassName, 'T' + FPanelFormName) = 0) then
				begin
				FPanelForm := TForm(Frm);
				break;
				end;
			tWnd := GetWindow(tWnd, GW_HWNDNEXT);
			end;
		end;
	if FPanelForm <> nil then
		begin
		FPanelForm.Visible := False;
		if not Assigned(FPanelFormDestroy) then
			begin
			FPanelFormDestroy := FPanelForm.OnDestroy;
			FPanelForm.OnDestroy := PanelFormDestroy;
			end;
		if Assigned(FOnPanelFormActivated) then
			FOnPanelFormActivated(self, FPanelForm);
		if FPanelFormView = dvNormal then
			ReleasePanelForm
		else
			if FFormActivate then
				ActivatePanelForm;
		end;
	end;


procedure TMegaPanel.SetParentFont(Value: boolean);
	begin
	if inherited ParentFont = Value then
		exit;
	inherited ParentFont := Value;
	if inherited ParentFont then
		begin
		FResizeFonts := [];
		FResizeControls := [];
		end;
	InvalidatePanel;
	end;


function TMegaPanel.GetParentFont: boolean;
	begin
	Result := inherited ParentFont;
	end;


procedure TMegaPanel.SetAutoCenter(Value: TAutoCenter);
	begin
	if FAutoCenter = Value then
		exit;
	FAutoCenter := Value;
	InvalidatePanel;
	end;


procedure TMegaPanel.SetResizeFonts(Value: TResizeFonts);
	begin
	if FResizeFonts <> Value then
		begin
		FResizeFonts := Value;
		if FResizeFonts <> [] then
			inherited ParentFont := False;
		end;
	end;


procedure TMegaPanel.SetResizeControls(Value: TResizeConts);
	begin
	if FResizeControls <> Value then
		begin
		FResizeControls := Value;
		if FResizeControls <> [] then
			inherited ParentFont := False;
		end;
	end;


procedure TMegaPanel.SetFocusEffect(Value: TFocusEffect);
	begin
	if FFocus = Value then
		exit;
	FFocus.Assign(Value);
	Invalidate;
	end;


procedure TMegaPanel.SetShadowEffect(Value: TShadowEffect);
	begin
	if FShadow = Value then
		exit;
	FShadow.Assign(Value);
	if csDesigning in ComponentState then
		begin
		FShdXOff := FShadow.XOffset;
		FShdYOff := FShadow.YOffset;
		end;
	Invalidate;
	end;


procedure TMegaPanel.SetGradient(Value: TGradient);
	begin
	if FGradient = Value then
		exit;
	FGradient.Assign(Value);
	Invalidate;
	end;


procedure TMegaPanel.SetClassFixups(Value: TStrings);
	begin
	FClassFix.Assign(Value);
	UpdateClassFixups;
	end;


procedure TMegaPanel.UpdateClassFixups;
	var
	i, j: integer;
	Inf: TMegaInfo;
	Ctl: TControl;
	begin
	if csLoading in ComponentState then
		exit;
	for j := 0 to ControlCount - 1 do
		begin
		Ctl := Controls[j];
		Inf := MegaList.GetControlInf(Ctl);
		if Inf <> nil then
			for i := 0 to FClassFix.Count - 1 do
				if CompareText(Ctl.ClassName, Copy(FClassFix[i], 7, 99)) = 0 then
					begin
					Inf.Key := [];
					Inf.Fix := [];
					if FClassFix[i][1] = '1' then
						Inf.Key := Inf.Key + [fkEnter];
					if FClassFix[i][2] = '1' then
						Inf.Key := Inf.Key + [fkUpDown];
					if FClassFix[i][3] = '1' then
						Inf.Fix := Inf.Fix + [cfShadow];
					if FClassFix[i][4] = '1' then
						Inf.Fix := Inf.Fix + [cfPnlLabel];
					if FClassFix[i][5] = '1' then
						Inf.Fix := Inf.Fix + [cfCtlLabel];
					if FClassFix[i][6] = '1' then
						Inf.Fix := Inf.Fix + [cfFocEffect];
					break;
					end;
		end;
	Invalidate;
	end;


{// Termination ///////////////////////////////////////////////////////////////}
procedure Termination; far;
	begin
{$IFNDEF WIN32}
	if MegaProcInst <> nil then
		FreeProcInstance(MegaProcInst);
{$ENDIF}
	DeleteObject(ShadowBmp.Handle);
	DeleteObject(DitherBmp.Handle);
	ShadowBmp.Handle := 0;
	DitherBmp.Handle := 0;
	ShadowBmp.Free;
	DitherBmp.Free;
	MegaList.Free;
	end;


{// Initialization ////////////////////////////////////////////////////////////}
var
	Tricky: string;
Initialization
	begin
{$IFNDEF WIN32}
	AddExitProc(Termination);
	MegaProcInst := MakeProcInstance(@ChildProc, HInstance);
{$ENDIF}
	MegaList := TMegaList.Create;
	DitherBmp := TBitmap.Create;
	ShadowBmp := TBitmap.Create;
	DitherBmp.Handle := LoadBitmap(HInstance, 'DITHERBMP');
	ShadowBmp.Handle := LoadBitmap(HInstance, 'SHADOWBMP');
	RegisterIntegerConsts(TypeInfo(TMegaColor), IdentToMegaColor, MegaColorToIdent);
	Tricky := 'MegaPanel Copyright  1995-1999 Steve Flynn, All Rights Reserved.'#0#0#0#0;
	CopyrightNotice := StrPas(@Tricky[1]) + #13#13;
{$IFDEF WIN32}
	CopyrightNotice := CopyrightNotice + ' 32Bit';
{$ELSE}
	CopyrightNotice := CopyrightNotice + ' 16Bit';
{$ENDIF}
	CopyrightNotice := CopyrightNotice + ' Version 4.0';
	CopyrightNotice := CopyrightNotice + #13#13'By using this Software you agree to be bound to the terms of the';
	CopyrightNotice := CopyrightNotice + #13'MegaPanel Software License Agreement provided with this Software.';
	end;


{// Finalization //////////////////////////////////////////////////////////////}
{$IFDEF WIN32}
Finalization
	begin
	Termination;
	end;
{$ENDIF}

end.

