{                                                                    }
{  12/12/1997 by Mik                                          }
{                                                                    }

unit MDLGRES;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes;

type
  TcallBack = Function(Dlg : Hwnd ; Wparam : word; lparam : longint): integer;
  TDlgRes = class(TComponent)
    private
      { Private fields of TDlgRes }
        { Storage for property DlgName }
        FDlgName : String;
        { Pointer to application's OnCallBack handler, if any }
{        FOnCallBack : TcallBack;}

      { Private methods of TDlgRes }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TDlgRes }

      { Protected methods of TDlgRes }
        { Method to generate OnCallBack event }
        procedure Loaded; override;
    public
      { Public fields of TDlgRes }

      { Public methods of TDlgRes }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        function Execute : Boolean;
    published
      { Published properties of the component }
        { Link to caller callback }
{        property OnCallBack : TcallBack read FOnCallBack write FOnCallBack;}
        property DlgName : String read FDlgName write FDlgName;

  end;
CONST Callback : Tcallback = NIL;
procedure Register;

implementation
USES BWCC;
procedure Register;
begin
     { Register TDlgRes with Additional as its
       default page on the Delphi component palette }
     RegisterComponents('Custom', [TDlgRes]);
end;

Function DlgActive(Dialog: HWnd; Msg, WParam: Word; LParam: Longint): boolean; export;
begin
  DlgActive := true;
  case Msg of
    WM_SIZE:;
    WM_PAINT: if Assigned(CallBack) then
                CallBack(dialog, WParam,LParam);
    WM_InitDialog:
    BEGIN
      Try
        {DEAL WITH POS}
        WPARAM := MSG;
        If Assigned(CallBack) then
                CallBack(dialog, WParam,LParam);
        EXIT;
      except
      end;
    END;

   WM_Command:
    case WParam  of
    id_Ok,id_Cancel:
      begin
        EndDialog(Dialog, 1);
        If Assigned(CallBack) then
                CallBack(dialog, WParam,LParam);
        Exit;
      end;
     else
     if Assigned(CallBack) then
               CallBack(dialog, WParam,LParam);
    end; {CASE WPARAM}
   WM_SysCommand:
     case wparam of
       sc_move : ;
     end;
  end; {CASE MESSAGE}
  DlgActive := false;
end;


{ Method to set variable and property values and create objects }
procedure TDlgRes.AutoInitialize;
begin
callback := nil;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TDlgRes.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
callback := nil;
end; { of AutoDestroy }


constructor TDlgRes.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
end;

destructor TDlgRes.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TDlgRes.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

function fo(dlg : hwnd ; wparam : word; lparam : longint): integer; far;
begin
fo := -1;
end;

function TDlgRes.Execute : Boolean;
     { Perform the component operation }
var
  TProc: TFarProc;
  P : array[0..20] of char;
  H : thandle;
begin
Result := false;
FDlgName := uppercase(FDlgName);
   Strpcopy(P,FDlgName);
    H := FindResource(HINSTANCE, P ,RT_DIALOG);
     if H = 0 then
      begin
        messagebox(0,'Dialog Resource not found!','DlgRes',1);
        exit;
      end;
     If not assigned(callback) then
       callback := fo;
     H:= 0;
     TProc := MakeProcInstance(@DlgActive, HInstance);
     Execute := DialogBox(HInstance, P, H, tProc) > 0;
     FreeProcInstance(tProc);
     Exit;
     { Return True if the operation was successful, False otherwise }
end;



end.
