unit Unit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, MathCtrl, Menus, ExtCtrls;

type
  TForm1 = class(TForm)
    MathGrid1: TMathGrid;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Run1: TMenuItem;
    Exit1: TMenuItem;
    MathCurve1: TMathCurve;
    Panel1: TPanel;
    procedure Exit1Click(Sender: TObject);
    procedure Run1Click(Sender: TObject);
    procedure MathGrid1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Run1Click(Sender: TObject);
var
  t, h_t: Extended;
begin
  MathCurve1.Reset;
  t := MathGrid1.MinX;
  h_t := MathGrid1.SizeX / MathGrid1.MapSize.X;
  while t <= MathGrid1.MaxX do
  begin
    MathGrid1.PutPixel(t, 0.5*(sin(10*t)+1) , clBlue);
    MathCurve1.PutPixel(t, 0.5*(cos(10*t)+1));
    t := t + h_t;
  end;
end;

procedure TForm1.MathGrid1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  tX, tY: Extended;
begin
  MathGrid1.PointAtPos(Point(X, Y), tX, tY);
  Panel1.Caption := Format('%1.2f:%1.2f', [tX, tY]);
end;

end.
