UNIT TMAP;
INTERFACE
uses hex2dec;
Type
   Tcatrec = record
   name: String[20];
   clas : String[20];
   length : longint;
   from: String[10];
   too : String[10];
   End;
{$ifdef windows}
   TMAP16 = CLASS
{$else}
   TMAP16 = object
{$endif}
      INNAME : String[40];
      OUTNAME : String[40];
      F : file of tcatrec;
      T : text;
      T2 : TEXT;
      Rec : tcatrec;
      prv : tcatrec;
      FIRST,lastdata: String[9];
      Function GetParent(tPrv :tcatrec): String;
      Procedure FORMATSEG(S:String; VAR R: TCATREC);
      Procedure FORMATADDRESS(S:String; VAR R: TCATREC);
      Procedure UPDATEPREV(R:TCATREC;VAR tPRV: TCATREC);
      Procedure writerec(trec:TCATREC);
      Procedure UPDATEFILE;
      Procedure OUTREC(TREC: TCATREC);
      Function DOREPORT:BOOLEAN;
      Procedure GENREPORT;
   End;
VAR
   MMAP :TMAP16;
IMPLEMENTATION
{$ifdef windows}
uses dialogs;
{$endif}
Function TMAP16.GetParent(TPrv :tcatrec): String;
VAR I : LONGINT;
   AREC : tcatrec;
Begin
   GetParent := '';
   FOR I := 0 TO FILESIZE(F) -1  DO
   Begin
      SEEK(F,I);
      READ(F,AREC);
      IF (AREC.NAME[1] = ' ')  THEN
      Begin
         if (copy(arec.from,1,4) = copy(Tprv.from,1,4)) then
            IF (Tprv.FROM >= AREC.FROM) AND (Tprv.too <= AREC.too) THEN
            Begin
               GETPARENT := AREC.NAME;
               EXIT;
            End;
         End
         ELSE
            EXIT;
      End;
   End;

Procedure TMAP16.FORMATSEG(S:String; VAR R: TCATREC);
Begin
   FILLCHAR(R,SIZEOF(TCATREC),#0);
   R.NAME := COPY (S,21,15);
   R.CLAS := COPY (S,41,10);
   R.LENGTH := hex2word(COPY(S,14,4));
   R.FROM := COPY(S,1,9);
   R.TOO := '';
   if TRIM(r.name) = 'DATA' THEN
   Begin
      LASTDATA := COPY(S,14,4);
      FIRST := R.FROM;
   End;
End;


Procedure TMAP16.FORMATADDRESS(S:String; VAR R: TCATREC);
Begin
   FILLCHAR(R,SIZEOF(TCATREC),#0);
   R.NAME := COPY (S,17,20);
   R.LENGTH := 0;
   R.FROM := COPY(S,1,9);
   R.TOO := '';
End;

Procedure TMAP16.UPDATEPREV(R:TCATREC;VAR tPRV: TCATREC);
Begin
   if trim(Tprv.name) = 'DATA' THEN
      TPRV.TOO := COPY(TPRV.FROM,1,5) + LASTDATA
   ELSE
      TPRV.too := R.FROM;
   IF TPRV.LENGTH = 0 THEN
      Tprv.length := getval(Tprv.too) - getval(Tprv.from);
   if Tprv.clas = '' then
      Tprv.CLAS := GetParent(Tprv);
End;

Function uppercase(s: String): String;
var i : byte;
Begin
   for i := 1 to length(s) do
      s[i] := upcase(s[i]);
   uppercase := s;
End;

Procedure TMAP16.writerec(Trec:TCATREC);
Begin
   IF (TRIM(TREC.NAME) <> '@') AND (TRIM(TREC.NAME) <> '') THEN
   Begin
      SEEK(F,FILESIZE(F));
      write(f,Trec);
   End;
End;

Procedure TMAP16.OUTREC(TREC: TCATREC);
Begin
   if TREC.NAME[1] = ' ' then
      WRITELN(T2, TREC.NAME ,'    ', TREC.LENGTH)
   else
      if TRIM(TREC. CLAS) = 'DATA' THEN
      WRITELN(T2, TREC. CLAS:10, ' ',TREC.NAME:20, ' ' , TREC.LENGTH)
   ELSE
      WRITELN(T2, TREC. CLAS:10, ' ',TREC.NAME, ' ')
End;

Procedure TMAP16.UPDATEFILE;
VAR I,n,m : LONGINT;
   rec1,rec2 : tcatrec;
Begin
   m:= 0;
   FOR I := 0 TO FILESIZE(F) -1 DO
   Begin
      SEEK(F,I);
      READ(F,REC);
      if rec.name[1] = ' ' then
        m:= i;
      IF TRIM(REC.CLAS) = '' THEN
      Begin
         REC.CLAS := PRV.CLAS;
         SEEK(F,I);
         WRITE(F,REC);
      End;
      PRV := REC;
   End;
if m > 0 then
 for i := 0 to m do
  begin
   SEEK(F,I);
   READ(F,REC1);
   rec1.name := uppercase(rec1.name);
   for n := i + 1 to m do
     begin
        SEEK(F,n);
        READ(F,REC2);
        rec2.name := uppercase(rec2.name);
        if rec1.name > rec2.name then
          begin
           seek(f,i);
           write(f,rec2);
           seek(f,n);
           write(f,rec1);
           rec1 := rec2;
          end;
     end;
  end;
   close(f);
End;

Procedure TMAP16.GENREPORT;
VAR I : LONGINT;
   publics : boolean;
   data : boolean;
Begin
   reset(f);
   publics := false;
   DATA := FALSE;
   writeln(t2,'Info. from ', inname);
   WRITELN(T2);
   WRITELN(T2,'******   UNITS USED AND SIZES  *******');
   WRITELN(T2);
   FOR I := 0 TO FILESIZE(F) -1 DO
   Begin
      SEEK(F,I);
      READ(F,REC);
      if (rec.name[1] <> ' ') and not publics then
      Begin
         publics := true;
         WRITELN(T2);
         WRITELN(T2,'******   UNITS AND PROCEDURES   *********');
      End;
      if publics and (trim(rec.clas) = 'DATA') AND NOT DATA THEN
      Begin
         DATA := TRUE;
         WRITELN(T2);
         WRITELN(T2,'******   GLOBAL DATA AND SIZES  *******');
         WRITELN(T2);
      End;
      OUTREC(REC);
   End;
End;

Function TMAP16.DOREPORT;
VAR
   s : String;
   segment : boolean;
   address : boolean;
   LINE : BOOLEAN;
label fini;
Begin
   DOREPORT := FALSE;
   FILLCHAR(PRV,SIZEOF(TCATREC),#0);
   Segment := false;
   Address := false;
   if trim(INNAME) = '' then
      halt;
   assign(t,INNAME);
   {$I-}
   reset(t);
   {$I+}
   IF IORESULT <> 0 THEN
      HALT;
   assign(f,'TEMP.$$$');
   rewrite(f);
   CLOSE(F);
   RESET(F);
   OUTNAME := 'TEMP.TXT';
   assign(T2,'TEMP.TXT');
   rewrite(T2);
   LINE := FALSE;
   while not eof(t)  do
   Begin
      readln(t,s);
      S:= TRIM(S);
      if s = '' then
        continue;
      s := uppercase(s);

      If pos('START',s) = 1 then
      Begin
         SegmEnt := true;
         S:= '';
      End;
      If pos('ADDRESS',s) = 1 then
      Begin
         S:= '';
         Segment := false;
         address := true;
      End;
      if (pos('PROGRAM ',s) = 1) OR (POS('LINES ',S) > 0) then
      Begin
         updateprev(rec,prv);
         PRV.LENGTH := GETVAL(LASTDATA) -  (GETVAL(PRV.FROM) - GETVAL(FIRST));
         writerec(prv);
         LINE := TRUE;
         Segment := false;
         ADDRESS := FALSE;
         goto fini;
      End;

      if segment then
         IF S <> '' THEN
         Begin
            IF POS(':',S) > 0 THEN
               IF LENGTH(COPY(S,1,POS(' ',S))) > 10 THEN
               Begin
{$ifdef windows}
                  SHOWMESSAGE('NOT A DELPH 16 MAP FILE');
{$endif}
                  halt;
               End;
               formatseg(s,rec);
               updateprev(rec,prv);
               writerec(PRV);
               PRV := REC;
            End;
            If address then
               IF S <> '' THEN
               Begin
                  formataddress(s,rec);
                  updateprev(rec,prv);
                  writerec(prv);
                  PRV := REC;
               End;
            End;
fini:
            UPDATEFILE;
            GENREPORT;
            DOREPORT := TRUE;
            CLOSE(F);
            CLOSE(T2);
            CLOSE(T);
         End;

Begin
End.
