unit Docedit;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Clipbrd, Dialogs, ExtCtrls, StdCtrls, Menus, Buttons,
	Printers, TMAP;

type
    TDocEditForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    SaveAs1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Document: TMemo;
	  Panel1: TPanel;
	  OpenDialog1: TOpenDialog;
	  SaveDialog1: TSaveDialog;
	  OpenBtn: TSpeedButton;
	  SaveBtn: TSpeedButton;
	  Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    CutBtn: TSpeedButton;
    CopyBtn: TSpeedButton;
    PasteBtn: TSpeedButton;
    N2: TMenuItem;
    SelectAll1: TMenuItem;
    N3: TMenuItem;
    Close1: TMenuItem;
    PrintDialog1: TPrintDialog;
    N4: TMenuItem;
    Print1: TMenuItem;
	  PrintBtn: TSpeedButton;
    CloseBtn: TSpeedButton;
    SpeedButton1: TSpeedButton;

	  procedure New1Click(Sender: TObject);
	  procedure FormCreate(Sender: TObject);
	  procedure Open1Click(Sender: TObject);
	  procedure Save1Click(Sender: TObject);
	  procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	  procedure SaveAs1Click(Sender: TObject);
	  procedure Cut1Click(Sender: TObject);
	  procedure Copy1Click(Sender: TObject);
	  procedure Paste1Click(Sender: TObject);
	  procedure Delete1Click(Sender: TObject);
	  procedure SelectAll1Click(Sender: TObject);
	  procedure Exit1Click(Sender: TObject);
		procedure DocumentMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
		procedure DocumentKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
		procedure FormClose(Sender: TObject; var Action: TCloseAction);
	  procedure Print1Click(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure ReportPrinter1Print(Sender: TObject);
    procedure Format2Click(Sender: TObject);
    procedure TagBtnClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);

	private
	  { Private declarations }
	public
	  { Public declarations }
	  DocName, DefCaption: String;
	  Ans: Word;
	  ClipBrdChain: HWnd;
		FindString: String;

		procedure UpdateMenus;
		procedure WMDESTROYCLIPBOARD(var Message: TMessage); message WM_DESTROYCLIPBOARD;
		procedure WMDRAWCLIPBOARD(var Message: TMessage); message WM_DRAWCLIPBOARD;
		procedure WMCHANGECBCHAIN(var Message: TMessage); message WM_CHANGECBCHAIN;
		procedure LoadFile(PathName, FileName: String);
	end;

const
	cr = #13;

var
	DocEditForm: TDocEditForm;

procedure showfile( FileName: String);
procedure editfile( FileName: String);

implementation

{$R *.DFM}

const
  { Default word delimiters are any character except the core alphanumerics. }
  WordDelimiters: set of Char = [#0..#255] - ['a'..'z','A'..'Z','1'..'9','0'];

{ SearchMemo scans the text of a TEdit, TMemo, or other TCustomEdit-derived
  component for a given search string.  The search starts at the current
  caret position in the control.  The Options parameter determines whether the
  search runs forward (frDown) or backward from the caret position, whether
  or not the text comparison is case sensitive, and whether the matching
  string must be a whole word.  If text is already selected in the control,
  the search starts at the 'far end' of the selection (SelStart if searching
  backwards, SelEnd if searching forwards).  If a match is found, the
  control's text selection is changed to select the found text and the
  function returns True.  If no match is found, the function returns False. }

  function Trim(S : string) : string;
    {-Return a string with leading and trailing white space removed}
  var
    I : Word;
    SLen : Byte absolute Result;
  begin
    Result := S;
    while (SLen > 0) and (Result[SLen] <= ' ') do
      Dec(SLen);

    I := 1;
    while (I <= SLen) and (Result[I] <= ' ') do
      Inc(I);
    Dec(I);
    if I > 0 then
      Delete(Result, 1, I);
  end;


function SearchBuf(Buf: PChar; BufLen: Integer;
                   SelStart, SelLength: Integer;
                   SearchString: String;
                   Options: TFindOptions): PChar;
var
  SearchCount, I: Integer;
  C: Char;
  Direction: Shortint;
  CharMap: array [Char] of Char;

  function FindNextWordStart(var BufPtr: PChar): Boolean;
  begin                   { (True XOR N) is equivalent to (not N) }
    Result := False;      { (False XOR N) is equivalent to (N)    }
     { When Direction is forward (1), skip non delimiters, then skip delimiters. }
     { When Direction is backward (-1), skip delims, then skip non delims }
    while (SearchCount > 0) and
          ((Direction = 1) xor (BufPtr^ in WordDelimiters)) do
    begin
      Inc(BufPtr, Direction);
      Dec(SearchCount);
    end;
    while (SearchCount > 0) and
          ((Direction = -1) xor (BufPtr^ in WordDelimiters)) do
    begin
      Inc(BufPtr, Direction);
      Dec(SearchCount);
    end;
    Result := SearchCount > 0;
    if Direction = -1 then
    begin   { back up one char, to leave ptr on first non delim }
      Dec(BufPtr, Direction);
      Inc(SearchCount);
    end;
  end;

begin
  Result := nil;
  if BufLen <= 0 then Exit;
  if frDown in Options then
  begin
    Direction := 1;
    Inc(SelStart, SelLength);  { start search past end of selection }
    SearchCount := BufLen - SelStart - Length(SearchString);
    if SearchCount < 0 then Exit;
    if Longint(SelStart) + SearchCount > BufLen then Exit;
  end
  else
  begin
    Direction := -1;
    Dec(SelStart, Length(SearchString));
    SearchCount := SelStart;
  end;
  if (SelStart < 0) or (SelStart > BufLen) then Exit;
  Result := @Buf[SelStart];

  { Using a Char map array is faster than calling AnsiUpper on every character }
  for C := Low(CharMap) to High(CharMap) do
    CharMap[C] := C;

  if not (frMatchCase in Options) then
  begin
    AnsiUpperBuff(PChar(@CharMap), sizeof(CharMap));
    AnsiUpperBuff(@SearchString[1], Length(SearchString));
  end;

  while SearchCount > 0 do
  begin
    if frWholeWord in Options then
      if not FindNextWordStart(Result) then Break;
    I := 0;
    while (CharMap[Result[I]] = SearchString[I+1]) do
    begin
      Inc(I);
      if I >= Length(SearchString) then
      begin
        if (not (frWholeWord in Options)) or
           (SearchCount = 0) or
           (Result[I] in WordDelimiters) then
          Exit;
        Break;
      end;
    end;
    Inc(Result, Direction);
    Dec(SearchCount);
  end;
  Result := nil;
end;

function SearchMemo(Memo: TCustomEdit;
                    const SearchString: String;
                    Options: TFindOptions): Boolean;
var
  Buffer, P: PChar;
  Size: Word;
begin
  Result := False;
  if (Length(SearchString) = 0) then Exit;
  Size := Memo.GetTextLen;
  if (Size = 0) then Exit;
  Buffer := StrAlloc(Size + 1);
  try
    Memo.GetTextBuf(Buffer, Size + 1);
    P := SearchBuf(Buffer, Size, Memo.SelStart, Memo.SelLength,
                   SearchString, Options);
    if P <> nil then
    begin
      Memo.SelStart := P - Buffer;
      Memo.SelLength := Length(SearchString);
      Result := True;
    end;
  finally
    StrDispose(Buffer);
  end;
end;


procedure editfile( FileName: String);
Var
	TmpDir : string;
	OK     : Boolean;
begin
  {$I-} GetDir(0, TmpDir); {$I+}
	OK := (IOResult = 0);
	Application.CreateForm(TDocEditForm, DocEditForm);
  if fileexists(filename) then
   	DocEditForm.LoadFile('', FileName)
  else
    showmessAGE('CANNOT LOCATE FILE ' + FILENAME);
	DocEditForm.ShowModal;
	DocEditForm.free;

	{$I-} ChDir(TmpDir); {$I+}
	OK := (IOResult = 0);
end;

procedure showfile( FileName: String);
begin
	Application.CreateForm(TDocEditForm, DocEditForm);
	DocEditForm.LoadFile('', FileName);
	DocEditForm.document.readonly := true;
	DocEditForm.updatemenus;
	DocEditForm.OpenBtn.enabled := false;
	DocEditForm.SaveBtn.enabled := false;
	DocEditForm.CutBtn.enabled := false;
	DocEditForm.CopyBtn.enabled := false;
	DocEditForm.PasteBtn.enabled := false;
	DocEditForm.ShowModal;
	DocEditForm.free;
end;

procedure TDocEditForm.LoadFile(PathName, FileName:String);
begin
	OpenDialog1.InitialDir := PathName;
	Document.Clear;
  try
	Document.Lines.LoadFromFile(PathName + FileName);
	Document.Modified := False;
	DocName := PathName + FileName;
	Caption := DefCaption + ' - ' + DocName;
  except
   showmessage('Cannot load file ' + FileName);
  end;
end;

procedure TDocEditForm.WMDESTROYCLIPBOARD(var Message: TMessage);
begin
	UpdateMenus;
	Message.Result := 0;
end;

procedure TDocEditForm.WMDRAWCLIPBOARD(var Message: TMessage);
begin
	UpdateMenus;
	Message.Result := 0;
end;

procedure TDocEditForm.WMCHANGECBCHAIN(var Message: TMessage);
begin
	ClipBrdChain := Message.lParam;
	Message.Result := 0;
end;

procedure TDocEditForm.UpdateMenus;
var
	HasSelection: Boolean;
begin
{$ifndef debug}
	Paste1.Enabled := Clipboard.HasFormat(CF_TEXT);
	PasteBtn.Enabled := Clipboard.HasFormat(CF_TEXT);
	HasSelection := Document.SelLength <> 0;
	Cut1.Enabled := HasSelection;
	Copy1.Enabled := HasSelection;
{	Delete1.Enabled := HasSelection;}
	CutBtn.Enabled := HasSelection;
	CopyBtn.Enabled := HasSelection;
  {$endif}
end;

procedure TDocEditForm.New1Click(Sender: TObject);
begin
	if Document.Modified then begin
		Ans := MessageDlg('File has been modified.'+cr+cr+
				'Do you want to save the changes?', mtConfirmation,mbYesNoCancel,0);
		if Ans = mrYes then begin
			if DocName <> '' then begin
				Document.Lines.SaveToFile(DocName);
			end else if SaveDialog1.Execute then begin
				try
					Document.Lines.SaveToFile(SaveDialog1.FileName);
					SaveDialog1.FileName := '*.DOC';
				except
				end;
			end;
			DocName := '';
			Document.Clear;
			Document.Modified := False;
			Caption := DefCaption;
		end else if Ans = mrNo then begin
			Document.Clear;
			Document.Modified := False;
			Caption := DefCaption;
			DocName := '';
		end;
	end else begin
		Document.Clear;
		Document.Modified := False;
		Caption := DefCaption;
		DocName := '';
	end;
	UpdateMenus;
end;

procedure TDocEditForm.Open1Click(Sender: TObject);
begin
					if OpenDialog1.Execute then
						begin
							Document.Clear;
							Document.Lines.LoadFromFile(OpenDialog1.FileName);
							Document.MODIFIED := False;
							DocName := OpenDialog1.FileName;
							Caption := DefCaption + ' - ' + DocName;
						end;
end;

procedure TDocEditForm.Save1Click(Sender: TObject);
begin
	if DocName <> '' then
  begin
		Document.Lines.SaveToFile(DocName);
		Document.MODIFIED := False;
  end
	else
	if SaveDialog1.Execute then
		begin
			try
				Document.Lines.SaveToFile(SaveDialog1.FileName);
				DocName := SaveDialog1.FileName;
				Document.MODIFIED := False;
				Caption := DefCaption + ' - ' + DocName;
			except
			end;
		end;
end;

procedure TDocEditForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	New1Click(Self);
	if Ans = mrCancel then CanClose := False;
end;

procedure TDocEditForm.SaveAs1Click(Sender: TObject);
begin
	if SaveDialog1.Execute then
		begin
			Document.Lines.SaveToFile(SaveDialog1.FileName);
			DocName := SaveDialog1.FileName;
			Document.MODIFIED := False;
			Caption := DefCaption + ' - ' + DocName;
		end;
end;

procedure TDocEditForm.Cut1Click(Sender: TObject);
begin
	Document.CutToClipboard;
	UpdateMenus;
end;

procedure TDocEditForm.Copy1Click(Sender: TObject);
begin
	Document.CopyToClipboard;
	UpdateMenus;
end;

procedure TDocEditForm.Paste1Click(Sender: TObject);
begin
	Document.PasteFromClipboard;
	UpdateMenus;
end;

procedure TDocEditForm.Delete1Click(Sender: TObject);
begin
{	Document.CLEAR;}
	UpdateMenus;
end;

procedure TDocEditForm.SelectAll1Click(Sender: TObject);
begin
	Document.SelectAll;
	UpdateMenus;
end;

procedure TDocEditForm.Exit1Click(Sender: TObject);
begin
	Close;
end;

procedure TDocEditForm.DocumentMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	UpdateMenus;
end;

procedure TDocEditForm.DocumentKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
	UpdateMenus;
end;

procedure TDocEditForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	ChangeClipBoardChain(Handle,ClipBrdChain);
  Action := caFree;
end;

procedure TDocEditForm.FormCreate(Sender: TObject);
begin
	DocName := '';
	DefCaption := Caption;
	FindString := '';

	SaveDialog1.DefaultExt := 'TXT';
	OpenDialog1.DefaultExt := 'MAP';

	UpdateMenus;

	ClipBrdChain := SetClipboardViewer(Handle);
end;

procedure TDocEditForm.Print1Click(Sender: TObject);
begin
{	PrinterSetupDialog1.Execute;
	ReportPrinter1.PrinterIndex := -2; ver 1
	ReportPrinter1.Execute; mik 08/09/97
	ReportPrinter1.PrinterIndex := -1;
	ReportPrinter1.Execute;}
end;

procedure TDocEditForm.CloseBtnClick(Sender: TObject);
begin
  Close;
end;
{mik 080797 look for [B1] bin}
function get_bin(st:string): integer;
var n: byte;
begin
st := sysutils.uppercase(st);
get_bin := -1;
n := pos('[B',st);
if n = 0 then exit
else
  if st[n+2] in ['1'..'9'] then
    get_bin := byte(st[n+2]) - 48 -1;
end;

procedure TDocEditForm.ReportPrinter1Print(Sender: TObject);
var
	n,Line : Integer;
begin
(*if Document.Lines.count > 0 then
 n:= get_bin(Document.Lines[0]);
 IF NOT reportprinter1.SUPPORTBIN(N) THEN N:= 0;{CASE BIN IS NOT AVAILABLE MIK 9/7/97}
 if n > 0 then
  reportprinter1.selectbin(reportprinter1.bins[n]);
  if n >=0 then {skip first line [B1] mik 8/07/97}
   n:= 1
  else
   n:= 0;

 With Sender as TbaseReport do
    begin
      SetFont('Courier New',10);
			for Line := n to Document.Lines.Count - 1 do
				begin
					if linesleft = 2 then newpage;
					Println(Document.Lines[Line]);
				end;
    end; *)
end;

procedure TDocEditForm.Format2Click(Sender: TObject);
var p : array[0..255] of char;
    RE : WORD;
    f: file;
    fp: string;
begin
if (length(trim(docname)) > 0)
and (pos('.$$$',docname) = 0) then
begin
(*system.assign(f,'temp.$$$');
{$i-}
erase(f);
{$i+}
if ioresult <> 0 then; *)
fp := extractfilepath(application.exename);
   strpcopy(p, fp+'pf.exe ' + docname + ' /O ' + fp + 'temp.$$$');
   RE := winexec(P,SW_HIDE);
   if re > 32 then
   begin
     LoadFile('',fp +'temp.$$$');
   end;
end;
end;

procedure TDocEditForm.TagBtnClick(Sender: TObject);
begin
Format2Click(sender);
end;

function Get_filesize(s:string):longint;
var f : file;
begin
Get_filesize := 0;
assign(f,s);
{$i-}
reset(f,1);
{$i+}
if ioresult = 0 then
Get_filesize := filesize(f);
{$i-}
close(f);
{$i+}
if ioresult <> 0 then;
end;

procedure TDocEditForm.SpeedButton1Click(Sender: TObject);
var p : array[0..40] of char;
    s: string;
    b: boolean;
begin
if trim(docname) = '' then exit;
IF NOT ASSIGNED(MMAP) THEN
    MMAP := TMAP16.CREATE;

 MMAP.INNAME := DOCNAME;
 screen.cursor := crHourglass;
 b := MMAP.DOREPORT;
 screen.cursor := 0;
    IF b THEN
     BEGIN
      if fileexists(MMAP.OUTname) then
      begin
        if get_filesize(MMAP.OUTname) > 32000 then
         begin
          s:= 'notepad.exe ' + MMAP.OUTname;
          strpcopy(p,s);
          winexec(p,sw_show);
         end
        else
         	DocEditForm.LoadFile('', MMAP.OUTname);
      end;
     END;
end;
begin          
filemode := 66;
end.
