{  Common unit for Make Update and Update

  Copyright (c) 1998 Gregory L. Bullock (bullock@mbay.net).
  Freeware: May be freely distributed and modified. Use at your own risk.
  This program draws heavily on

    - the aDiff unit, Copyright (c) 1997 S.Kurinny & S.Kostinsky

    - the Lh5Unit unit, which had various contributers, as noted in its
      source code

  History:
     3-7-98 Added a CRC for the *compressed* differences to better detect
            whether an .Upd is corrupted. Incremented the UpdateFileHeader
            to account for this change to the .Upd file.

    16-5-98 Modified to compile under D3 (32-bits) as well as D1 (16-bits).

            Added a new compiler directive, MAKE16AND32COMPATIBLE, which
            will ensure that the *.Upd file is compatible independent
            of the platform (16- or 32-bit) which creates it or uses it.
            On the one test case I ran, I found that using MAKE16AND32COMPATIBLE
            increased the size of the *.Upd file.  The file sizes I got were
              29304  for the 32-bit .Upd file
              30746  for the 16-bit .Upd file
              30759  for the compatible .Upd file

            Improved one of the log messages and corrected the help file.

    23-4-98 Initial version.

  If you fix any bugs or make significant enhancements, I ask you to send
  me your modifications.

  For example, at present, these programs only allow you to make changes to
  existing files. Update will not add a new file nor will it delete an
  existing file. Perhaps a future version of these programs will enable
  Update to add new files or delete obsolete files. Another feature for a
  future version would be to have Update change the date & time of the
  updated files.

  If you make any changes to the structure of the Update File,
  change the UpdateFileHeader in the Common Unit so older versions
  of Update won't try to read an Update File that they won't understand.

}

unit Common;

interface

uses
  SysUtils, StdCtrls, Classes, FileCtrl,
   {$IFDEF Win32} aCRC32; {$ELSE} aCRC3216; {$ENDIF}

const
{$IFDEF MAKE16AND32COMPATIBLE}
  FileNameSize = 256;
{$ELSE}
{$IFDEF Win32}
  FileNameSize = 256;
{$ELSE}
  FileNameSize = 80;
{$ENDIF}
{$ENDIF}

type
  InvalidCRCIndex = (IINo,IIYes,IIMaybe);
  TFileUpdateInfo = class
    Name    : string[FileNameSize-1];
    OldCRC  : longint;
    NewCRC  : longint;
    InvalidCRC  : InvalidCRCIndex;
  end;

const
  SaveFileUpdateInfoSize = FileNameSize + 2*SizeOf(longint);
    {This determines the amount of TFileUpdateInfo that is saved in the *.Upd file}

{$IFDEF MAKE16AND32COMPATIBLE}
  UpdateFileHeader : string[15] = 'UpdateFile 1.11';
{$ELSE}
{$IFDEF Win32}
  UpdateFileHeader : string[15] = 'Update-32  1.01';
{$ELSE}
  UpdateFileHeader : string[15] = 'UpdateFile 1.01';
{$ENDIF}
{$ENDIF}
    {Change the UpdateFileHeader if you make any changes to the structure
    of the Update File, so older versions of Update won't try to read
    an Update File that they won't understand.}


function GetFullPathTo(FileName: TFileName; DirectoryListBox: TDirectoryListBox) : TFileName;
function CalculateStreamCRC(Stream: TStream): LongInt;

var
  UpdateStream,
  OldStream,
  NewStream     : TFileStream;
  UpdAccumulateStream,
  DiffStream    : TMemoryStream;

implementation

function GetFullPathTo(FileName: TFileName; DirectoryListBox: TDirectoryListBox) : TFileName;
begin
  Result := AnsiLowerCase(DirectoryListBox.Directory);
  if Result[Length(Result)] <> '\' then
    Result := Result + '\';
  Result := Result + FileName;
end;

function CalculateStreamCRC(Stream: TStream): LongInt;
Const
  BufSize=$FFF0;
type
  PLongInt=^LongInt;
  TByteArray=Array[1..BufSize] of byte;
  PByteArray=^TByteArray;
var
  Buf : PByteArray;
  BufRead : LongInt;
  SavePosition  : LongInt;
begin
  Buf := nil;
  try
    Result := 0;
    SavePosition := Stream.Position;
    GetMem(Buf,BufSize);
    Result := CRC32Start;
    repeat
      BufRead := Stream.Read(Buf^,BufSize);
      if BufRead = 0 then Break;
      Result := CRC32Calc(Buf^[1],Result,BufRead);
    until BufRead = 0;
    Result := CRC32Finish(Result); {This ensures compatibility with pkzip's
    CRC32, but since that's just the bitwise complement of the CRC32 we
    already had, there's probably no advantage here.}
  finally
    if Buf <> nil then
      FreeMem(Buf,BufSize);
    Stream.Position := SavePosition;
  end;
end;

end.
 