{  Common unit for Make Update and Update

  Copyright (c) 1998 Gregory L. Bullock (bullock@mbay.net).
  Freeware: May be freely distributed and modified. Use at your own risk.
  This program draws heavily on

    - the aDiff unit, Copyright (c) 1997 S.Kurinny & S.Kostinsky

    - the Lh5Unit unit, which had various contributers, as noted in its
      source code

  History:
    23-4-98 Initial version.

  If you fix any bugs or make significant enhancements, I ask you to send
  me your modifications.

  For example, at present, these programs only allow you to make changes to
  existing files.  Update will not add a new file nor will it delete an
  existing file.  Perhaps a future version of these programs will enable
  Update to add new files or delete obsolete files.

  If you make any changes to the structure of the Update File,
  change the UpdateFileHeader in the Common Unit so older versions
  of Update won't try to read an Update File that they won't understand.

}

unit Common;

interface

uses
  SysUtils, StdCtrls, Classes, 
   {$IFDEF Win32} aCRC32; {$ELSE} aCRC3216; {$ENDIF}


type
  InvalidCRCIndex = (IINo,IIYes,IIMaybe);
  TFileUpdateInfo = class
    Name    : TFileName;
    OldCRC  : longint;
    NewCRC  : longint;
    InvalidCRC  : InvalidCRCIndex;
  end;

const
  UpdateFileHeader : string[15] = 'UpdateFile 1.00';
    {Change the UpdateFileHeader if you make any changes to the structure
    of the Update File, so older versions of Update won't try to read
    an Update File that they won't understand.}


function GetFullPathTo(FileName: TFileName; DirectoryLabel: TLabel) : TFileName;
function CalculateStreamCRC(Stream: TStream): LongInt;

var
  UpdateStream,
  OldStream,
  NewStream     : TFileStream;
  UpdAccumulateStream,
  DiffStream    : TMemoryStream;

implementation

function GetFullPathTo(FileName: TFileName; DirectoryLabel: TLabel) : TFileName;
begin
  Result := LowerCase(DirectoryLabel.Caption) + '\' + FileName;
end;

function CalculateStreamCRC(Stream: TStream): LongInt;
Const
  BufSize=$FFF0;
type
  PLongInt=^LongInt;
  TByteArray=Array[1..BufSize] of byte;
  PByteArray=^TByteArray;
var
  Buf : PByteArray;
  BufRead : LongInt;
begin
  {Compute the Old & New file CRCs }
  Result := 0;
  Buf := nil;
  try
    GetMem(Buf,BufSize);
    Stream.Position := 0;
    Result := CRC32Start;
    repeat
      BufRead := Stream.Read(Buf^,BufSize);
      Result := CRC32Calc(Buf^,Result,BufRead);
    until BufRead = 0;
    Result := CRC32Finish(Result); {This ensures compatibility with pkzip's
    CRC32, but since that's just the bitwise complement of the CRC32 we
    already had, there's probably no advantage here.}
  finally
    if Buf <> nil then
      FreeMem(Buf,BufSize);
    Stream.Position := 0;
  end;
end;

end.
 