unit LimitMe;
{ Allows switching between open delphi applications and/or lauching (any) application
  Note: App to Switch to must have TActivateApp component
  Methods:        1) DoIExist - Returns Boolean True/False
  Properties:         1) Bija/Seed - 32 bit Only, The is your own name for the application,
                         it can be anything that you wish to identify your app by, but it must
                         be unique.
                         16 bit uses the application class name, and thus does not need a seed
                         it will only return true if there is a previous version open
                         32 bit uses a semaphore, which can be adapted for other purposes, it works
                         slightly differently. Because it uses a semaphore which may be used by threads,
                         as apposed to applications, it will return true if more than one call
                         is made to DoIExist by the same app. Hence becareful how you use it!
                     2) Terminate - Sets wether the current application must be terminated
                        if a previous instance already exists.
  Event:           1) BeforeTerminate - Fires Only If Property Terminate is True
  The code for this component comes from various authors who put it into the public domain
  , all I did was to turn it into a component.
  Freeware Use & Abuse
  Author: Edward de la Rey
          edwardr@mailbox.ru.ac.za
          USE AT OWN RISK
  For Delphi 1,2,3 Will Automatically pickup the correct DCR File,
  D16 is for Delphi1, D32 for Delphi 2&3, Don't rename them.}

interface
{$IFDEF WIN32}
uses
  Windows, Messages, SysUtils, Classes, Forms;
{$ELSE}
uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Forms;
{$ENDIF}

type
  {$IFDEF WIN32}
  {Nothing}
  {$ELSE}
  PHWND = ^HWND;
  {$ENDIF}
  TLimitMe = class(TComponent)
  private
  GetTerminate:Boolean;
  {$IFDEF WIN32}
  GetBija:String;
  {$ENDIF}
  EBeforeTerminate:TNotifyEvent;
  procedure SetTerminate(Value:Boolean);
 {$IFDEF WIN32}
  procedure SetBija(Value:String);
  {$ENDIF}
  protected
    { Protected declarations }
  public
  {}
  published
  Constructor Create(AOwner: TComponent); override;
  Function DoIExist:Boolean;
  {$IFDEF WIN32}
  Property  Bija:String Read GetBija Write SetBija;
  {$ENDIF}
  Property  Terminate:Boolean Read GetTerminate Write SetTerminate;
  Property BeforeTerminate:TNotifyEvent Read EBeforeTerminate Write EBeforeTerminate;
  end;

procedure Register;

{$IFDEF WIN32}
{$ELSE}
 function EnumFunc(Wnd:HWND; TargetWindow:PHWND): bool; export;
{$ENDIF}

implementation
{$IFDEF WIN32}
{$R *.D32}
{$ELSE}
{$R *.D16}
{$ENDIF}

{$IFDEF WIN32}
function TLimitMe.DoIExist:Boolean;
var
  hSem:THandle;
  semNm,wTtl    : Array[0..256] of Char;
begin
  DoIExist := False;
  StrPCopy(wTtl, GetBija);
  StrPCopy(semNm, wTtl);
  {Create a Semaphore in memory - If this is the first instance, then
  it should be 0.}
  hSem := CreateSemaphore(nil, 0, 1, semNm);
  {Now, check to see if the semaphore exists}
  if ((hSem <> 0) AND (GetLastError() = ERROR_ALREADY_EXISTS)) then begin
    CloseHandle(hSem);
    DoIExist := True;{it Does}
    If GetTerminate then begin
    If Assigned(EBeforeTerminate) Then begin
    EBeforeTerminate(Self);
    Application.Terminate;
    end;
    end;
  end;
end;
{$ELSE}
Function TLimitMe.DoIExist:Boolean;
  var
    PrevInstWnd : HWND;
  begin
    PrevInstWnd := 0;
    EnumWindows(@EnumFunc,longint(@PrevInstWnd));
    if PrevInstWnd <> 0 then begin
    DoIExist:= True;
    If GetTerminate then begin
    If Assigned(EBeforeTerminate) Then EBeforeTerminate(Self);
    Application.Terminate;
    end;
    end
    else DoIExist:= False;
end;
{$ENDIF}

{$IFDEF WIN32}
Procedure TLimitMe.SetBija(Value:String);
begin
GetBija := Value;
end;
{$ENDIF}

Procedure TLimitMe.SetTerminate(Value:Boolean);
begin
GetTerminate := Value;
end;

constructor TLimitMe.Create(AOwner: TComponent);
begin
   INHERITED CREATE(Aowner);
   {$IFDEF WIN32}
   GetBija:='Aum';
   {$ENDIF}
   GetTerminate:=True;
End;


{---------------------------------------Delphi 16-----------------------------}
{$IFDEF WIN32}
{Nothing}
{$ELSE}
function EnumFunc(Wnd:HWND; TargetWindow:PHWND): bool;
  var
    ClassName : array[0..30] of char;
  begin
    Result := true;
    if GetWindowWord(Wnd,GWW_HINSTANCE) = hPrevInst then

       begin
       GetClassName(Wnd,ClassName,30);
       if StrIComp(ClassName,'TApplication') = 0 then
          begin
          TargetWindow^ := Wnd;
          Result := false;
          end;
       end;
end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Freeware', [TLimitMe]);
end;

end.
