unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Licen, StdCtrls;

type
  TMainForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    License1: TLicense;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FUser: string;
    FLicense: string;
    procedure ReadCompData;
  public
    { Public declarations }
    procedure WriteCompData;
  end;

var
  MainForm: TMainForm;
  sBin: string;                             {stores binary file writing to...}

const
 liPasswordConstant: longint = 42;          {password}


implementation

{$R *.DFM}

uses
 Enter;

{***buttons*********************************************************************}

{close}
procedure TMainForm.Button2Click(Sender: TObject);
begin
 close;
end;

{install}
procedure TMainForm.Button1Click(Sender: TObject);
begin
 ReadCompData;
 if FUser = '' then
  begin
   {install has not been run previously}
   hide;
   EnterDetailsDlg.editUser.Text := FUser;
   EnterDetailsDlg.editLicense.Text := FLicense;
   EnterDetailsDlg.lblUser.visible := false;
   EnterDetailsDlg.lblLicense.visible := false;
   EnterDetailsDlg.ShowModal;
   show;
  end
 else
  begin
   {install has been run previously}
   hide;
   EnterDetailsDlg.editUser.visible := false;
   EnterDetailsDlg.editLicense.visible := false;
   EnterDetailsDlg.lblUser.visible := true;
   EnterDetailsDlg.lblLicense.visible := true;
   EnterDetailsDlg.lblUser.caption  := FUser;
   EnterDetailsDlg.lblLicense.caption := FLicense;
   EnterDetailsDlg.ShowModal;
   show;
  end;
end;

{***custom routines*************************************************************}

{write component data}
procedure TMainForm.WriteCompData;
begin
 with License1 do
  begin
   binFile := sBin;
   user := EnterDetailsDlg.EditUser.Text;
   License := EnterDetailsDlg.EditLicense.Text;
   Tag := liPasswordConstant;
   WriteCompData;
  end;
end;

{read component data}
procedure TMainForm.ReadCompData;
var
 fs: TStream;
 cNew: TComponent;
 lNew: TLicense;
begin
 try

  fs := TFileStream.Create(sBin,fmOpenRead);

  {create component}
  cNew := TComponent.create(application);
  lNew := TLicense.create(application);
  cNew := fs.ReadComponent(lNew);

  {pass tag value to read fields}
  if lNew.RevealFieldVals( liPasswordConstant ) then
   begin
    FUser := lNew.user;
    FLicense := lNew.license;
   end;

  lNew.free;

  finally
   fs.free;
  end;

end;

{***form's preferences*********************************************************}

{on create}
procedure TMainForm.FormCreate(Sender: TObject);
begin
 {find file}
 sBin := ExtractFilePath( ParamStr(0)) + '\LICEN.BIN';
end;

{}
end.
