{
 Designer: Craig Ward, 100554.2072@compuserve.com
 Date:     3/1/96
 Version:  1.0

 Function: Stores product licensing information (discretely).

           The component will only allow users to read property values (at run-time)
           if the correct tag property is passed.

           Therefore, if used in a setup routine, the component could be written to
           the setup disk (via the WriteComponent procedure) in order to store user\license data.
           This data will be secure, since it can only be read by a user who possesses the
           value of the tag property before the component was written to disk (ie: the tag
           property becomes similar to a credit-card's PIN number).

 Fields:   There are several fields:

            [1] BinFile      - stores the file to write information to
            [2] User         - the user who the license belongs to
            [3] License      - the license for the product


 Using:    I envisage the component being used in the following manner:

            [1] the setup routine and the file (that this component will be written to)
                will be placed on the same disk.
            [2] the setup routine will read the component (see example below), and
                then check to see if the fields are blank. In order to read the
                component's properties (since they are hidden at run-time) the
                setup routine will need to pass the tag value that was set at
                design-time (ie: this is the "password").
            [3] if the fields are blank, it then prompts the user to enter their
                name and license number, which it in turn will write to the file.
                This information is now securely stored, so any future installations
                of your program will bring up the original user and license information.

           The component allows user's to mimic the traditional Windows setup routines where
           license information is securely stored after the first installation.

 Calling:  The component possesses a method (WriteCompData) that will facilitate
           the writing of information to disk.
*******************************************************************************}
unit Licen;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
  TLicense = class(TComponent)
  private
    { Private declarations }
    FTag: longint;
    FBinFile: string;
    FUser: string;
    FLicense: string;
    FHideUser: string;
    FHideLicense: string;
    procedure SetUser(value: string);
    procedure SetLicense(value: string);
    procedure SetBinFile(value: string);
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure Loaded; override;
    function RevealFieldVals(value: longint): boolean;
    procedure WriteCompData;
  published
    { Published declarations }
    property User: string read FUser write SetUser;
    property License: string read FLicense write SetLicense;
    property BinFile: string read FBinFile write SetBinFile;
  end;

procedure Register;

{*******************************************************************************}
implementation

{register}
procedure Register;
begin
  RegisterComponents('Samples', [TLicense]);
end;


{loaded}
procedure TLicense.Loaded;
begin
  inherited Loaded;
   {if not in design mode then clear out property fields}
   if not (csDesigning in ComponentState) then
    begin
     {get field values}
     FHideUser := FUser;
     FHideLicense := FLicense;
     FTag := Tag;
     {clear field values}
     FUser := '';
     FLicense := '';
     Tag := 0;
   end;
end;

{set binary file}
procedure TLicense.SetBinFile(value: string);
begin
 if value <> FBinFile then
  begin
   FBinFile := value;
  end;
end;

{set user}
procedure TLicense.SetUser(value: string);
begin
 if value <> FUser then
  begin
   FUser := value;
  end;
end;

{set license}
procedure TLicense.SetLicense(value: string);
begin
 if value <> FLicense then
  begin
   FLicense := value;
  end;
end;


{write data to binary file}
procedure TLicense.WriteCompData;
var
 fs: TStream;
 li: longint;
begin
 try
  fs := TFileStream.Create(FBinFile,fmOpenWrite);
  fs.WriteComponent(self);
 finally
  fs.free;
 end;
end;

{check license}
function TLicense.RevealFieldVals(value: longint): boolean;
begin
 {check value passed against previous tag}
 if value = FTag then
  begin
   {reveal field values}
   FUser := FHideUser;
   FLicense := FHideLicense;
   result := true;
  end
 else
  begin
   {error - values don't match}
   messageDlg('Invalid Password',mtWarning,[mbOK],0);
   result := false;
  end;
end;

{}
end.
