========
Newsgroups: comp.lang.pascal.delphi.components
Subject: Lexical Scanner [2/4]
From: jbui@scd.hp.com (Joseph Bui)
Date: 27 Jul 1995 16:59:10 GMT

{******************** LISTCLAS.PAS ******************}
unit Listclas;

interface

uses
  Classes, SysUtils;             

type
  PLongint = ^longint;
  PExtended = ^extended;

  TIntList = class(TObject)
  private
    FList: TList;
    function GetItems(Item: integer): longint;
    procedure SetItems(Item: integer; Value: longint);
    function GetCount: integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value: longint): integer;
    function First: longint;
    function Last: longint;
    procedure Clear;
    procedure Delete(Item: integer);
    property Items[Item: integer]: longint read GetItems
        write SetItems; default;
    property Count: integer read GetCount;
  end;

  TFloatList = class(TObject)
  private
    FList: TList;
    function GetItems(Item: integer): extended;
    procedure SetItems(Item: integer; Value: extended);
    function GetCount: integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value: extended): integer;
    function First: extended;
    function Last: extended;
    procedure Clear;
    procedure Delete(Item: integer);
    property Items[Item: integer]: extended read GetItems
        write SetItems; default;
    property Count: integer read GetCount;
  end;

  TPCharList = class(TObject)
  private
    FList: TList;
    function GetItems(Item: integer): PChar;
    procedure SetItems(Item: integer; Value: PChar);
    function GetCount: integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value: PChar): integer;
    procedure Insert(Item: integer; Value: PChar);
    procedure Move(CurItem, NewItem: integer);
    procedure Exchange(Item1, Item2: integer);
    procedure Clear;
    procedure Delete(Item: integer);
    procedure LoadFromFile(AFileName: string);
    procedure SaveToFile(AFileName: string);
    property Items[Item: integer]: PChar read GetItems
        write SetItems; default;
    property Count: integer read GetCount;
  end;

implementation

{*************************** TIntList ***********************}
function TIntList.GetItems(Item: integer): longint;
begin
  Result:=PLongint(FList[Item])^;
end;

procedure TIntList.SetItems(Item: integer; Value: longint);
begin
  PLongint(FList[Item])^:=Value;
end;

function TIntList.GetCount: integer;
begin
  Result:=FList.Count;
end;

constructor TIntList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TIntList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TIntList.Add(Value: longint): integer;
var
  IntPtr: PLongint;
begin
  GetMem(IntPtr, SizeOf(longint));
  IntPtr^:=Value;
  Result:=FList.Add(IntPtr);
end;

function TIntList.First: longint;
begin
  Result:=PLongint(FList[0])^;
end;

function TIntList.Last: longint;
begin
  Result:=PLongint(FList[FList.Count - 1])^;
end;

procedure TIntList.Clear;
var
  Index: integer;
begin
  for Index:=0 to FList.Count - 1 do
    FreeMem(FList.Items[Index], SizeOf(longint));
  FList.Clear;
end;

procedure TIntList.Delete(Item: integer);
begin
  FreeMem(FList.Items[Item], SizeOf(longint));
  FList.Delete(Item);
end;

{*************************** TFloatList ***********************}
function TFloatList.GetItems(Item: integer): extended;
begin
  Result:=PExtended(FList[Item])^;
end;

procedure TFloatList.SetItems(Item: integer; Value: extended);
begin
  PExtended(FList[Item])^:=Value;
end;

function TFloatList.GetCount: integer;
begin
  Result:=FList.Count;
end;

constructor TFloatList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TFloatList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TFloatList.Add(Value: extended): integer;
var
  FloatPtr: PExtended;
begin
  GetMem(FloatPtr, SizeOf(extended));
  FloatPtr^:=Value;
  Result:=FList.Add(FloatPtr);
end;

function TFloatList.First: extended;
begin
  Result:=PExtended(FList[0])^
end;

function TFloatList.Last: extended;
begin
  Result:=PExtended(FList[FList.Count - 1])^;
end;

procedure TFloatList.Clear;
var
  Index: integer;
begin
  for Index:=0 to FList.Count - 1 do
    FreeMem(FList.Items[Index], SizeOf(extended));
  FList.Clear;
end;

procedure TFloatList.Delete(Item: integer);
begin
  FreeMem(FList.Items[Item], SizeOf(extended));
  FList.Delete(Item);
end;

{*************************** TPCharList ***********************}
function TPCharList.GetItems(Item: integer): PChar;
begin
  Result:=PChar(FList[Item]);
end;

procedure TPCharList.SetItems(Item: integer; Value: PChar);
var
  APChar: PChar;
begin
  FreeMem(Items[Item], StrLen(Items[Item]) + 1);
  GetMem(APChar, StrLen(Value) + 1);
  StrCopy(APChar, Value);
end;

function TPCharList.GetCount: integer;
begin
  Result:=FList.Count;
end;

constructor TPCharList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TPCharList.Destroy;
begin
  Clear;
  FList.Free;
  inherited Destroy;
end;

function TPCharList.Add(Value: PChar): integer;
var
  APChar: PChar;
begin
  GetMem(APChar, StrLen(Value) + 1);
  StrCopy(APChar, Value);
  Result:=FList.Add(APChar);
end;

procedure TPCharList.Insert(Item: integer; Value: PChar);
var
  APChar: PChar;
begin
  GetMem(APChar, StrLen(Value) + 1);
  StrCopy(APChar, Value);
  FList.Insert(Item, APChar);
end;

procedure TPCharList.LoadFromFile(AFileName: string);
var
  FS: TFileStream;
  Buffer: array[0..255] of char;
  i: integer;
  APChar: PChar;
begin
  FS:=TFileStream.Create(AFileName, fmOpenRead);
  try
    Clear;
    Add(#0);
    repeat
      i:=FS.Read(Buffer, 255);
      Buffer[i]:=#0;
      GetMem(APChar, StrLen(Items[Count - 1]) + StrLen(@Buffer) + 1);
      StrCopy(APChar, Items[Count - 1]);
      StrCat(APChar, @Buffer);
      Items[Count - 1]:=APChar;
      if StrLen(@Buffer) < i then
      begin
        FS.Seek((StrLen(@Buffer) + 1) - i, 1);
        Add(#0);
      end;
    until FS.Position = FS.Size;
  finally
    FS.Free;
  end;
end;

procedure TPCharList.SaveToFile(AFileName: string);
var
  FS: TFileStream;
  Buffer: array[0..255] of char;
  i: integer;
  APChar: PChar;
begin
  FS:=TFileStream.Create(AFileName, fmCreate);
  try
    for i:=0 to Count - 1 do
    begin
      APChar:=Items[Count];
      i:=0;
      repeat
        StrLCopy(APChar, @Buffer, 255);
        i:=i + StrLen(@Buffer);
        FS.Write(Buffer, StrLen(Buffer));
      until i = StrLen(APChar);
      Buffer[0]:=#0;
      FS.Write(Buffer, 1);
    end;
  finally
    FS.Free;
  end;
end;

procedure TPCharList.Move(CurItem, NewItem: integer);
begin
  FList.Move(CurItem, NewItem);
end;

procedure TPCharList.Exchange(Item1, Item2: integer);
begin
  FList.Exchange(Item1, Item2);
end;

procedure TPCharList.Clear;
var
  Index: integer;
begin
  for Index:=0 to FList.Count - 1 do
    FreeMem(Items[Index], StrLen(Items[Index]) + 1);
  FList.Clear;
end;

procedure TPCharList.Delete(Item: integer);
begin
  FreeMem(Items[Item], StrLen(Items[Item]) + 1);
  FList.Delete(Item);
end;

end.

