{ This is an interesting testbed app, that I wrote to learn how to provide a
  good visual metaphor for showing multiple table linkages in an SQL query.
  This wil bo added to a visual SQL query builder component I am working on,
  but I thought some of the code might be of interset to others.

  Author : Thomas Hill, dba t.h.ink Software

  Version : 1.0, final workig version, Feb 28, 1996
}

unit Mtsel01;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DB, DBTables, ExtCtrls;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    PaintBox1: TPaintBox;
    Table1: TTable;
    AliasList: TListBox;
    TableList: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Memo1: TMemo;
    procedure FormShow(Sender: TObject);
    procedure AliasListClick(Sender: TObject);
    procedure TableListClick(Sender: TObject);
    procedure PaintBox1Paint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    LinkLBs : array[0..10] of TListBox;
    NextLB : integer;
    procedure FillAliasList;
    procedure FillTableList;
    procedure DrawArrow(X,Y : integer; Left : boolean; Clr : TColor; Filled : boolean);
    procedure EraseArrow(X,Y : integer; Left : boolean; Clr : TColor; Filled : boolean);
    procedure DrawLine(X1,Y1,X2,Y2 : integer; Clr : TColor; Style : TPenStyle);
    procedure LinkLBMouseDown(Sender : TObject; Button : TMouseButton; Shift : TShiftState;
                              X,Y : integer);
    procedure LinkLBDragOver(Sender, Source : TObject; X,Y : integer; State : TDragState;
                             var Accept : boolean);
    procedure LinkLBDragDrop(Sender, Source : TObject; X,Y : integer);
    procedure LinkLBClick(Sender : TObject);
    procedure LinkLBEnter(Sender : TObject);
    procedure LinkLBExit(Sender : TObject);

    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
{$R LCURSOR.RES }

const
   crLinkTo = 1;

type
    TNodeObj = class(Tobject)
                  LeftLB : integer;
                  RightLB : integer;
                  LeftItem : integer;
                  RightItem : integer;
               end;

var
   NodeList : TList;
   ThisNode : TNodeObj;

procedure TForm1.DrawArrow(X,Y : integer; Left : boolean; Clr : TColor; Filled : boolean);

var
   Offset : integer;

begin
  with PaintBox1.Canvas do
  begin
    if Left then OffSet := X + 12 else Offset := X - 12;
    Pen.Color := Clr;
    Pen.Style := psSolid;
    MoveTo(X,Y);
    LineTo(Offset,Y - 6);
    LineTo(Offset,Y + 6);
    LineTo(X,Y);
    if Filled then
    begin
      if Left then Offset := 3 else Offset := -3;
      Brush.Color := Clr;
      FloodFill(X + Offset,Y,Clr,fsBorder);
    end;
  end;
end;

procedure TForm1.EraseArrow(X,Y : integer; Left : boolean; Clr : TColor; Filled : boolean);

var
   Offset : integer;

begin
  with PaintBox1.Canvas do
  begin
    if Left then Offset := 3 else Offset := -3;
    if Filled then
    begin
      Brush.Color := Form1.Color;
      FloodFill(X + Offset,Y,Clr,fsSurface);
    end;
    if Left then Offset := X + 12 else Offset := X - 12;
    Pen.Color := Form1.Color;
    Pen.Style := psSolid;
    MoveTo(X,Y);
    LineTo(Offset,Y - 6);
    LineTo(OFfset,Y + 6);
    LineTo(X,Y);
  end;
end;


procedure TForm1.DrawLine(X1,Y1,X2,Y2 : integer; Clr : TColor; Style : TPenStyle);

begin
  with PaintBox1.Canvas do
  begin
    Brush.Color := Form1.Color;
    Pen.Style := Style;
    Pen.Color := Clr;
    if Style <> psSolid then SetROP2(Handle,R2_NOTXORPEN) else SetROP2(Handle,R2_COPYPEN);
    MoveTo(X1,Y1);
    LineTo(X2,Y2);
  end;
end;

procedure TForm1.FillAliasList;

begin
  AliasList.Clear;
  Session.GetAliasNames(AliasList.Items);
  AliasList.ItemIndex := -1;
end;

procedure TForm1.FillTableList;

var
   A,T : string;

begin
  TableList.Clear;
  A := AliasList.Items[AliasList.ItemIndex];
  Session.GetTableNames(A,'*.DB',FALSE,FALSE,TableList.Items);
  TableList.ItemIndex := -1;
end;

procedure TForm1.LinkLBMouseDown(Sender : TObject; Button : TMouseButton; Shift : TShiftState;
                          X,Y : integer);

begin
  (Sender as TListBox).BeginDrag(FALSE);
end;

procedure TForm1.LinkLBDragOver(Sender, Source : TObject; X,Y : integer; State : TDragState;
                         var Accept : boolean);

begin
  if Source is TListBox then Accept := TRUE;
end;

procedure TForm1.LinkLBDragDrop(Sender, Source : TObject; X,Y : integer);

var
   FromLB,ToLB : integer;
   ToItem : integer;

begin
  if Source is TListBox then
  begin
    ThisNode := TNodeObj.Create;
    FromLB := (Source as TListBox).Tag;
    ToLB := (Sender as TListBox).Tag;
    ToItem := (Sender as TListBox).ItemAtPos(Point(X,Y),TRUE);
    if ToItem >= 0 then
    with ThisNode do
    begin
      if FromLB < ToLB then
      begin
        LeftLB := FromLB;
        LeftItem := (Source as TListBox).ItemIndex;
        RightLB := ToLB;
        RightItem := ToItem;
        NodeList.Add(ThisNode);
      end
      else
      if FromLB > ToLB then
      begin
        LeftLB := ToLB;
        LeftItem := ToItem;
        RightLB := FromLB;
        RightItem := (Source as TListBox).Itemindex;
        NodeList.Add(ThisNode);
      end
      else
        ShowMessage('Cannot link table to itself.');
      end;
  end
  else
    ShowMessage('Invalid location for link in list box!');
  PaintBox1.Invalidate;
end;


procedure TForm1.LinkLBClick(Sender : TObject);

begin
  PaintBox1.Invalidate;
end;

procedure TForm1.LinkLBEnter(Sender : TObject);

begin
  Paintbox1.Invalidate;
end;

procedure TForm1.LinkLBExit(Sender : TObject);

begin
  Paintbox1.Invalidate;
end;

procedure TForm1.FormShow(Sender: TObject);

var
   i : integer;

begin
  FillAliasList;
  fillchar(LinkLBs,sizeof(LinkLBs),0);
  NextLB := 10;
  ScrollBox1.VertScrollBar.Margin := 35;
  NodeList := TList.Create;
end;

procedure TForm1.AliasListClick(Sender: TObject);
begin
  FillTableList;
end;

procedure TForm1.TableListClick(Sender: TObject);

var
   i,f : integer;
   L : TLabel;

begin
  i := 0;
  while LinkLBs[i] <> nil do inc(i);
  LinkLBs[i] := TListBox.Create(Self);
  with LinkLBs[i] do
  begin
    Parent := ScrollBox1;
    Top := 30;
    Left := NextLB + (i * Width);
    DragMode := dmManual;
    Tag := i;
    DragCursor := crLinkTo;
    OnCLick := LinkLBClick;
    OnEnter := LinkLBEnter;
    OnExit := LinkLBExit;
    OnMouseDown := LinkLBMouseDown;
    OnDragOver := LinkLBDragOver;
    OnDragDrop := LinkLBDragDrop;
  end;
  L := TLabel.Create(Self);
  L.Parent := ScrollBox1;
  L.Caption := TableList.Items[TableList.ItemIndex];
  L.Font.Style := [fsUnderline];
  L.Left := NextLB + (i * LinkLBs[i].Width);
  L.Top := 5;
  Table1.DatabaseName := AliasList.Items[AliasList.ItemIndex];
  Table1.TableName := TableList.Items[TableList.ItemIndex];
  Table1.Open;
  for f := 0 to Table1.FieldCount - 1 do
  begin
    LinkLBs[i].Items.Add(Table1.Fields[f].Fieldname);
  end;
  Table1.Close;
  LinkLBs[i].Height := (LinkLBs[i].Items.Count + 1) * LinkLBs[i].ItemHeight;
  inc(NextLB,50);
end;

procedure TForm1.PaintBox1Paint(Sender: TObject);

var
   cy,i : integer;
   X1,Y1,X2,Y2 : integer;
   Node : TNodeObj;

begin
  for i := 0 to NodeList.Count - 1 do
  begin
    Node := TNodeObj(NodeList[i]);
    Y1 := 30 + ((Node.LeftItem) * LinkLBs[Node.LeftLB].ItemHeight);
    inc(Y1,LinkLBs[Node.LeftLB].ItemHeight div 2);
    X1 := LinkLBs[Node.LeftLB].Left + LinkLBs[Node.LeftLB].Width + 1;
    inc(X1,ScrollBox1.HorzScrollBar.Position);
    DrawArrow(X1,Y1,TRUE,clBlue,TRUE);
    Y2 := 30 + ((Node.RightItem) * LinkLBs[Node.RightLB].ItemHeight);
    inc(Y2,LinkLBs[Node.RightLB].ItemHeight div 2);
    X2 := LinkLBs[Node.RightLB].Left + 1;
    inc(X2,ScrollBox1.HorzScrollBar.Position);
    DrawArrow(X2,Y2,FALSE,clBlue,TRUE);
    inc(X1,12); dec(X2,12);
    DrawLine(X1,Y1,X2,Y2,clBlue,psSolid);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Screen.Cursors[crLinkTo] := LoadCursor(hInstance,'CRLINKTO');
end;

end.
