unit LeStylEd;

{
  This unit implements a property editor for the StyleHighlight and StyleShadow
  properties of the TLabelEffect component.
  Written by Keith Wood - 17 Feb 1996.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, LblEffct, StdCtrls, Buttons, DsgnIntf, ExtCtrls;

type
  { The form to be displayed when choosing the value of the property }
  TEffectOptionPropEd = class(TForm)
    LabelEffect1: TLabelEffect;    { Each label has a different effect }
    LabelEffect2: TLabelEffect;
    LabelEffect3: TLabelEffect;
    LabelEffect4: TLabelEffect;
    btnOK: TBitBtn;
    BitBtn2: TBitBtn;
    Shape1: TShape;
    procedure LabelEffectClick(Sender: TObject);
    procedure LabelEffectDblClick(Sender: TObject);
  private
    { Private declarations }
    FEffectOption: TEffectOption;
    procedure SetEffectOption(EoOption: TEffectOption);
  public
    { Public declarations }
    { Declare a public property to allow communication with the form }
    property EffectOption: TEffectOption read FEffectOption write SetEffectOption
      default eoNormal;
    constructor Create(AOwner:TComponent); override;
  end;

  { The property editor for the EffectOption property }
  TEffectOptionPropertyEditor = class(TEnumProperty)
  public
    { Public declarations }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

{$R *.DFM}

{ Define the property editor to Delphi }
procedure Register;
begin
  { Only applies to properties of type TEffectOption in TLabelEffect component }
  RegisterPropertyEditor(TypeInfo(TEffectOption), TLabelEffect, '',
    TEffectOptionPropertyEditor);
end;

{ Tell Delphi that we now have a dialog box for editing as well }
function TEffectOptionPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList];
end;

{ The procedure invoked when the property is double-clicked }
procedure TEffectOptionPropertyEditor.Edit;
var
  EffectOptionPropEd: TEffectOptionPropEd;
begin
  { Create a dialog box as defined above }
  EffectOptionPropEd := TEffectOptionPropEd.Create(Application);
  try
    { Initialise with the current style }
    EffectOptionPropEd.EffectOption := TEffectOption(GetOrdValue);
    if EffectOptionPropEd.ShowModal = mrOK then
      { If OK then update with the new value }
      SetOrdValue(Ord(EffectOptionPropEd.EffectOption));
  finally
    EffectOptionPropEd.Free;    { Tidy up }
  end;
end;

{ Initialise default values for internal fields }
constructor TEffectOptionPropEd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEffectOption := eoNormal;
end;

{ Set the EffectOption property of the form and highlight appropriate label }
procedure TEffectOptionPropEd.SetEffectOption(EoOption: TEffectOption);
var
  i: Integer;
begin
  FEffectOption := EoOption;
  for i := 0 to ComponentCount -1 do
    if Components[i] is TLabelEffect then
      if TLabelEffect(Components[i]).StyleShadow = EoOption then
        TLabelEffect(Components[i]).Transparent := False
      else
        TLabelEffect(Components[i]).Transparent := True;
end;

{ Set the form's EffectOption property based on the value of the label selected }
procedure TEffectOptionPropEd.LabelEffectClick(Sender: TObject);
begin
  EffectOption := (Sender as TLabelEffect).StyleShadow;
end;

{ As above and exit }
procedure TEffectOptionPropEd.LabelEffectDblClick(Sender: TObject);
begin
  btnOK.Click;
end;

end.
