unit LeGradEd;

{
  This unit implements a property editor for the GraduateFace
  property of the TLabelEffect component.
  Written by Keith Wood - 17 Feb 1996.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, LblEffct, StdCtrls, Buttons, DsgnIntf;

type
  { The form to be displayed when choosing the value of the property }
  TGraduateOptionPropEd = class(TForm)
    LabelEffect1: TLabelEffect;    { Each label has a different effect }
    LabelEffect2: TLabelEffect;
    LabelEffect3: TLabelEffect;
    btnOK: TBitBtn;
    BitBtn2: TBitBtn;
    procedure LabelEffectClick(Sender: TObject);
    procedure LabelEffectDblClick(Sender: TObject);
  private
    { Private declarations }
    FGraduateOption: TGraduateOption;
    procedure SetGraduateOption(GoOption: TGraduateOption);
  public
    { Public declarations }
    { Declare a public property to allow communication with the form }
    property GraduateOption: TGraduateOption read FGraduateOption
      write SetGraduateOption default goNone;
    constructor Create(AOwner:TComponent); override;
  end;

  { The property editor for the GraduateOption property }
  TGraduateOptionPropertyEditor = class(TEnumProperty)
  public
    { Public declarations }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

{$R *.DFM}

{ Define the property editor to Delphi }
procedure Register;
begin
  { Only applies to properties of type TGraduateOption in TLabelEffect component }
  RegisterPropertyEditor(TypeInfo(TGraduateOption), TLabelEffect, '',
    TGraduateOptionPropertyEditor);
end;

{ Tell Delphi that we now have a dialog box for editing as well }
function TGraduateOptionPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList];
end;

{ The procedure invoked when the property is double-clicked }
procedure TGraduateOptionPropertyEditor.Edit;
var
  GraduateOptionPropEd: TGraduateOptionPropEd;
begin
  { Create a dialog box as defined above }
  GraduateOptionPropEd := TGraduateOptionPropEd.Create(Application);
  try
    { Initialise with the current style }
    GraduateOptionPropEd.GraduateOption := TGraduateOption(GetOrdValue);
    if GraduateOptionPropEd.ShowModal = mrOK then
      { If OK then update with the new value }
      SetOrdValue(Ord(GraduateOptionPropEd.GraduateOption));
  finally
    GraduateOptionPropEd.Free;    { Tidy up }
  end;
end;

{ Initialise default values for internal fields }
constructor TGraduateOptionPropEd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FGraduateOption := goNone;
end;

{ Set the GraduateOption property of the form and highlight appropriate label }
procedure TGraduateOptionPropEd.SetGraduateOption(GoOption: TGraduateOption);
var
  i: Integer;
begin
  FGraduateOption := GoOption;
  for i := 0 to ComponentCount -1 do
    if Components[i] is TLabelEffect then
      if TLabelEffect(Components[i]).GraduateFace = GoOption then
        TLabelEffect(Components[i]).Transparent := False
      else
        TLabelEffect(Components[i]).Transparent := True;
end;

{ Set the form's GraduateOption property based on the value of the label selected }
procedure TGraduateOptionPropEd.LabelEffectClick(Sender: TObject);
begin
  GraduateOption := (Sender as TLabelEffect).GraduateFace;
end;

{ As above and exit }
procedure TGraduateOptionPropEd.LabelEffectDblClick(Sender: TObject);
begin
  btnOK.Click;
end;

end.
