unit LeEfctEd;

{
  This unit implements a property editor for the EffectStyle
  property of the TLabelEffect component.
  Written by Keith Wood - 3 Nov 1995.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, LblEffct, StdCtrls, Buttons, DsgnIntf;

type
  { The form to be displayed when choosing the value of the property }
  TEffectStylePropEd = class(TForm)
    LabelEffect1: TLabelEffect;    { Each label has a different effect }
    LabelEffect2: TLabelEffect;
    LabelEffect3: TLabelEffect;
    LabelEffect4: TLabelEffect;
    LabelEffect5: TLabelEffect;
    btnOK: TBitBtn;
    BitBtn2: TBitBtn;
    procedure LabelEffectClick(Sender: TObject);
    procedure LabelEffectDblClick(Sender: TObject);
  private
    { Private declarations }
    FEffectStyle: TEffectStyle;
    procedure SetEffectStyle(EsStyle: TEffectStyle);
  public
    { Public declarations }
    { Declare a public property to allow communication with the form }
    property EffectStyle: TEffectStyle read FEffectStyle write SetEffectStyle
      default esCustom;
    constructor Create(AOwner:TComponent); override;
  end;

  { The property editor for the EffectStyle property }
  TEffectStylePropertyEditor = class(TEnumProperty)
  public
    { Public declarations }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

{$R *.DFM}

{ Define the property editor to Delphi }
procedure Register;
begin
  { Only applies to properties of type TEffectStyle in TLabelEffect component }
  RegisterPropertyEditor(TypeInfo(TEffectStyle), TLabelEffect, '',
    TEffectStylePropertyEditor);
end;

{ Tell Delphi that we now have a dialog box for editing as well }
function TEffectStylePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList];
end;

{ The procedure invoked when the property is double-clicked }
procedure TEffectStylePropertyEditor.Edit;
var
  EffectStylePropEd: TEffectStylePropEd;
begin
  { Create a dialog box as defined above }
  EffectStylePropEd := TEffectStylePropEd.Create(Application);
  try
    { Initialise with the current style }
    EffectStylePropEd.EffectStyle := TEffectStyle(GetOrdValue);
    if EffectStylePropEd.ShowModal = mrOK then
      { If OK then update with the new value }
      SetOrdValue(Ord(EffectStylePropEd.EffectStyle));
  finally
    EffectStylePropEd.Free;    { Tidy up }
  end;
end;

{ Initialise default values for internal fields }
constructor TEffectStylePropEd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FEffectStyle := esCustom;
end;

{ Set the EffectStyle property of the form and highlight appropriate label }
procedure TEffectStylePropEd.SetEffectStyle(EsStyle: TEffectStyle);
var
  i: Integer;
begin
  if FEffectStyle <> EsStyle then
  begin
    FEffectStyle := EsStyle;
    for i := 0 to ComponentCount -1 do
      if Components[i] is TLabelEffect then
        if TLabelEffect(Components[i]).EffectStyle = EsStyle then
          TLabelEffect(Components[i]).Transparent := False
        else
          TLabelEffect(Components[i]).Transparent := True;
  end;
end;

{ Set the form's EffectStyle property based on the value of the label selected }
procedure TEffectStylePropEd.LabelEffectClick(Sender: TObject);
begin
  EffectStyle := (Sender as TLabelEffect).EffectStyle;
end;

{ As above and exit }
procedure TEffectStylePropEd.LabelEffectDblClick(Sender: TObject);
begin
  btnOK.Click;
end;

end.
