unit LeColrEd;

{
  This unit implements a property editor for the ColourScheme
  property of the TLabelEffect component.
  Written by Keith Wood - 3 Nov 1995.
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, LblEffct, StdCtrls, Buttons, DsgnIntf;

type
  { The form to be displayed when choosing the value of the property }
  TColourSchemePropEd = class(TForm)
    LabelEffect1: TLabelEffect;    { Each label has a different effect }
    LabelEffect2: TLabelEffect;
    LabelEffect3: TLabelEffect;
    LabelEffect4: TLabelEffect;
    LabelEffect5: TLabelEffect;
    btnOK: TBitBtn;
    BitBtn2: TBitBtn;
    procedure LabelEffectClick(Sender: TObject);
    procedure LabelEffectDblClick(Sender: TObject);
  private
    { Private declarations }
    FColourScheme: TColourScheme;
    procedure SetColourScheme(CsScheme: TColourScheme);
  public
    { Public declarations }
    { Declare a public property to allow communication with the form }
    property ColourScheme: TColourScheme read FColourScheme write SetColourScheme
      default csCustom;
    constructor Create(AOwner:TComponent); override;
  end;

  { The property editor for the ColourScheme property }
  TColourSchemePropertyEditor = class(TEnumProperty)
  public
    { Public declarations }
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;

implementation

{$R *.DFM}

{ Define the property editor to Delphi }
procedure Register;
begin
  { Only applies to properties of type TColourScheme in TLabelEffect component }
  RegisterPropertyEditor(TypeInfo(TColourScheme), TLabelEffect, '',
    TColourSchemePropertyEditor);
end;

{ Tell Delphi that we now have a dialog box for editing as well }
function TColourSchemePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList];
end;

{ The procedure invoked when the property is double-clicked }
procedure TColourSchemePropertyEditor.Edit;
var
  ColourSchemePropEd: TColourSchemePropEd;
begin
  { Create a dialog box as defined above }
  ColourSchemePropEd := TColourSchemePropEd.Create(Application);
  try
    { Initialise with the current style }
    ColourSchemePropEd.ColourScheme := TColourScheme(GetOrdValue);
    if ColourSchemePropEd.ShowModal = mrOK then
      { If OK then update with the new value }
      SetOrdValue(Ord(ColourSchemePropEd.ColourScheme));
  finally
    ColourSchemePropEd.Free;    { Tidy up }
  end;
end;

{ Initialise default values for internal fields }
constructor TColourSchemePropEd.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FColourScheme := csCustom;
end;

{ Set the ColourScheme property of the form and highlight appropriate label }
procedure TColourSchemePropEd.SetColourScheme(CsScheme: TColourScheme);
var
  i: Integer;
begin
  if FColourScheme <> CsScheme then
  begin
    FColourScheme := CsScheme;
    for i := 0 to ComponentCount -1 do
      if Components[i] is TLabelEffect then
        if TLabelEffect(Components[i]).ColourScheme = CsScheme then
          TLabelEffect(Components[i]).Transparent := False
        else
          TLabelEffect(Components[i]).Transparent := True;
  end;
end;

{ Set the form's ColourScheme property based on the value of the label selected }
procedure TColourSchemePropEd.LabelEffectClick(Sender: TObject);
begin
  ColourScheme := (Sender as TLabelEffect).ColourScheme;
end;

{ As above and exit }
procedure TColourSchemePropEd.LabelEffectDblClick(Sender: TObject);
begin
  btnOK.Click;
end;

end.
