unit ktReadDg; {v1.03 08/20/1998 for Delphi 1, 2, 3 and 4}

interface

uses
	{$IFNDEF VER80}
	Windows,
	{$ELSE}
	WinTypes,	WinProcs,
	{$ENDIF}
	Messages,	SysUtils,	Classes, Graphics, Controls, Forms,	Dialogs,
	StdCtrls,	ExtCtrls,	DsgnIntf,	Buttons;

{$IFDEF	VER100}
	{$DEFINE D2_UP}
{$ENDIF}

{$IFDEF	VER120}
	{$DEFINE D2_UP}
{$ENDIF}

type
	TReadmeDialogEditor	=	class(TDefaultEditor)
	public
		function GetVerb(Index:	Integer):	string;	override;
		function GetVerbCount: Integer;	override;
		procedure	ExecuteVerb(Index: Integer); override;
	end;

	TktReadmeDialog	=	class(TComponent)
	private
		FAllright: TCaption;
		FCaption:	TCaption;
		FCopyright:	string;
		FCopyrightFont:	TFont;
		FBehind: string;
		FInsString:	string;
		FLines:	TStringList;
		FMemoColor:	TColor;
		FMemoFont: TFont;
		FOnOff:	Boolean;
		FOnOffCaption: TCaption;
		FOnOffVisible: Boolean;
		FPicture:	TPicture;
		FTextFile: string;
		FTitle:	TCaption;
		FTitleFont:	TFont;
		procedure	SetPicture(Value:	TPicture);
		procedure	SetReadme(Value: TStringList);
		procedure	GetSystemFont(SysFont: TFont);
		procedure	SetTitleFont(Value:	TFont);
	public
		constructor	Create(AOwner: TComponent);	override;
		destructor Destroy;	override;
		function Execute:	Boolean;
	published
		property BtnOKCaption: TCaption	read FAllright write FAllright;
		property CopyrightCaption: string	read FCopyright	write	FCopyright;
		property CopyrightFont:	TFont	read FCopyrightFont	write	FCopyrightFont;
		property DialogCaption:	TCaption read	FCaption write FCaption;
		property InsBehindString:	string read	FBehind	write	FBehind;
		property InsString:	string read	FInsString write FInsString;
		property Lines:	TStringList	read FLines	write	SetReadme;
		property MemoColor:	TColor read	FMemoColor write FMemoColor
			default{$IFNDEF	VER80}clInfoBk{$ELSE}clYellow{$ENDIF};
		property MemoFont: TFont read	FMemoFont	write	FMemoFont;
		property ShowOnStart:	Boolean	read FOnOff	write	FOnOff default FALSE;
		property ShowOnStartCaption: TCaption	read FOnOffCaption write FOnOffCaption;
		property ShowOnStartVisible: Boolean read	FOnOffVisible	write	FOnOffVisible
			default	TRUE;
		property Picture:	TPicture read	FPicture write SetPicture;
		property TextFile: string	read FTextFile write FTextFile;
		property TitleCaption: TCaption	read FTitle	write	FTitle;
		property TitleFont:	TFont	read FTitleFont	write	SetTitleFont;
	end;

type
  TfmReadme = class(TForm)
    Panel1: TPanel;
    Title: TLabel;
    pnlRead: TPanel;
    ImgReadme: TImage;
    cbShowOnStart: TCheckBox;
    pnlMemo: TPanel;
    MemoReadme: TMemo;
    BtnOK: TBitBtn;
    Timer1: TTimer;
    Copyright: TLabel;
    Bevel1: TShape;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure cbShowOnStartClick(Sender: TObject);
  private
    procedure	AdjustCursor;
  public
  end;

procedure Register;

implementation

{$R *.DFM}

var
	fmReadme:	TfmReadme;

procedure	Register;
begin
	RegisterComponents('Dialoge',	[TktReadmeDialog]);
	RegisterComponentEditor(TktReadmeDialog, TReadmeDialogEditor);
end;

function TReadmeDialogEditor.GetVerbCount: Integer;
begin
	Result :=	1;
end;

function TReadmeDialogEditor.GetVerb(Index:	Integer):	string;
begin
	Result :=	'Test &ktReadmeDialog';
end;

procedure	TReadmeDialogEditor.ExecuteVerb;
begin
	(Component as	TktReadmeDialog).Execute;
end;

constructor	TktReadmeDialog.Create(AOwner: TComponent);
begin
	inherited	Create(AOwner);
	FCopyrightFont :=	TFont.Create;
	FLines :=	TStringList.Create;
	FMemoFont	:= TFont.Create;
	FPicture :=	TPicture.Create;
	FTitleFont :=	TFont.Create;
	with FCopyrightFont	do
	begin
		Color	:= {$IFNDEF	VER80}clInfoText{$ELSE}clWindowText{$ENDIF};
		Style	:= [fsBold];
	end;
	with FTitleFont	do
	begin
		GetSystemFont(FTitleFont);
		Color	:= clActiveCaption;
		Size :=	18;
		Style	:= [fsBold,	fsItalic];
	end;
	FAllright	:= '&OK';
	FCaption :=	'Readme';
	FCopyright :=	'Copyright ';
	FInsString :=	'e.g. your eMail-address';
	FBehind	:= 'eMail: ';
	FLines.Add('Read');
	FLines.Add('eMail: ');
	FMemoColor :=	{$IFNDEF VER80}clInfoBk{$ELSE}clYellow{$ENDIF};
	FOnOff :=	FALSE;
	FOnOffCaption	:= 'Show Readme on next start?';
	FOnOffVisible	:= TRUE;
	FPicture.Icon.Assign(Application.Icon);
	{$IFNDEF VER80}
	FTitle :=	Application.Title;
	{$ELSE}
	FTitle :=	'Delphi	1';
	{$ENDIF}
end;

destructor TktReadmeDialog.Destroy;
begin
	FCopyrightFont.Free;
	FMemoFont.Free;
	FTitleFont.Free;
	FPicture.Free;
	FLines.Free;
	inherited	Destroy;
end;

procedure	TktReadmeDialog.SetTitleFont(Value:	TFont);
begin
	FTitleFont.Assign(Value);
end;

procedure	TktReadmeDialog.SetPicture(Value:	TPicture);
begin
	FPicture.Assign(Value);
end;

procedure	TktReadmeDialog.SetReadme(Value: TStringList);
begin
	if FLines	<> Value then
		FLines.Assign(Value)
end;

procedure	TktReadmeDialog.GetSystemFont(SysFont: TFont);
{$IFNDEF VER80}
var
	Ncm: TNonClientMetrics;
	{$ENDIF}
begin
	SysFont.Handle :=	GetStockObject(SYSTEM_FONT);
	{$IFNDEF Win32}
	Exit;
	{$ENDIF}
	{$IFNDEF VER80}
	Ncm.cbSize :=	SizeOf(TNonClientMetrics);
	if SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0,	@Ncm,	0) then
		SysFont.Name :=	Ncm.lfCaptionFont.lfFacename;
	{$ENDIF}
end;

procedure	TfmReadme.AdjustCursor;
var
	POK: TPoint;
begin
	POK	:= BtnOK.ClientToScreen(Point(BtnOK.Width	div	2, BtnOK.Height	div	2));
	SetCursorPos(POK.x,	POK.y);
end;

function TktReadmeDialog.Execute:	Boolean;
begin
	fmReadme :=	TfmReadme.Create(Application);
	with fmReadme	do
	try
		Result :=	FALSE;
		BtnOK.Caption	:= BtnOKCaption;
		Caption	:= DialogCaption;
		cbShowOnStart.Checked	:= ShowOnStart;
		cbShowOnStart.Caption	:= ShowOnStartCaption;
		cbShowOnStart.Visible	:= ShowOnStartVisible;
		Copyright.Caption	:= CopyrightCaption;
		Copyright.Font :=	CopyrightFont;
		ImgReadme.Picture.Assign(Picture);
		pnlRead.Color	:= MemoColor;
		pnlMemo.Color	:= MemoColor;
		{$IFDEF	D2_UP}
			Bevel1.Align :=	alBottom;
		{$ENDIF}
		with MemoReadme	do
		begin
			Color	:= MemoColor;
			Font :=	MemoFont;
			if (TextFile <>	'')	and	FileExists(TextFile) then
				Lines.LoadFromFile(TextFile)
			else
				Lines.Assign(Self.Lines);
			if Pos(InsBehindString,	Text)	>	0	then
			begin
				SelStart :=	Pos(InsBehindString, Text) + Length(InsBehindString) - 1;
				SelText	:= InsString;
				SelStart :=	Pos(InsString, Text) - 1;
				SelLength	:= Length(InsString);
			end;
		end;
		ActiveControl	:= MemoReadme;
		Title.Caption	:= TitleCaption;
		Title.Font :=	TitleFont;
		Title.AutoSize :=	TRUE;
		ShowModal;
		Result :=	cbShowOnStart.Checked;
		ShowOnStart	:= Result;
	finally
		Free;
	end;
end;

procedure	TfmReadme.FormShow(Sender: TObject);
begin
	Timer1.Enabled :=	TRUE;
end;

procedure	TfmReadme.Timer1Timer(Sender:	TObject);
begin
	AdjustCursor;
	Timer1.Enabled :=	FALSE;
end;

procedure	TfmReadme.cbShowOnStartClick(Sender: TObject);
begin
	AdjustCursor;
end;

end.
