unit TNPDFEX;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Image1: TImage;
    Memo1: TMemo;
    Label1: TLabel;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


var
  Form1: TForm1;

implementation

{$R *.DFM}

uses tnpdf;

procedure TForm1.Button1Click(Sender: TObject);
var i:Integer; PDF:TPrintPDF;
begin

if SaveDialog1.Execute then
begin

{Create TPrintPDF VCL}
PDF:=TPrintPDF.Create(self);

{Set Doc Info}
PDF.TITLE := Label1.Caption;


{Set Page Size}
PDF.PageWidth:= 612;
PDF.PageHeight:= 792;

{Set Filename to save}
PDF.FileName := SaveDialog1.Filename;

{Start Printing...}
PDF.BeginDoc;

{Set Linewidth for line}
PDF.LineWidth:=1;

{Draw Line}
PDF.DrawLine(12,50,600,50);

PDF.LineWidth:=2;
{Draw Rectangle}
PDF.DrawRectangle(12,12,600,780);

{Set Font & Print Text}
PDF.Font.Name:=poHelveticaBold;
PDF.Font.Size:=20;
PDF.TextOut(15,30,Label1.Caption);

{Set Font & Print Memo}
PDF.Font.Name:=poTimesRoman;
PDF.Font.Size:=12;
PDF.MemoOut(15,60, Memo1);

{Add New Page}
PDF.NewPage;

{Draw Rectangle}
PDF.DrawRectangle(12,12,600,780);

{Print Image}
PDF.Draw(15,15,Image1);


{End Printing}
PDF.EndDoc;

{FREE TPrintPDF VCL}
PDF.Free;
end;


end;

end.
