{
 KeyState V1.0 - By Marc Nieuwhof (15-aug-95)
 --------------------------------------------

 KeyState was a test component for me to see if I understand the
 creation of components in Delphi.

 KeyState is based on the TPanel component because I wanted a nice
 statusbar with those fancy CAPS/NUM/SCR/INS panels.
 Well this is it. With keystate you can display the keystatus
 of CAPSlock, NUMlock, SCROLLlock or INSERT.
 With KeyState you can select for wich key you want a statuspanel.
 KeyState behaves like a Panel but I have added 1 method:

 GetState: Needs   : Nothing
           Returns : True or False if a key is toggled On/Off
                     Correct Caption in the panel

 To check if a key was set on or off call:

     KeyStateX.GetState;

 where X is the number of the KeyState component in the form.

 }

unit Keystate;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls;

type

  TKeyState = class(TPanel)

  private
    { Private declarations }

    FKeyCapsLock:    Boolean;
    FKeyScrollLock:  Boolean;
    FKeyNumLock:     Boolean;
    FKeyInsertKey:   Boolean;

    Procedure SetkeyCapsLock   (Toggled: Boolean);
    Procedure SetKeyNumLock    (Toggled: Boolean);
    Procedure SetKeyScrollLock (Toggled: Boolean);
    Procedure SetKeyInsertKey  (Toggled: Boolean);

  protected
    { Protected declarations }
  public
    { Public declarations }

    Constructor Create (AOwner: TComponent); Override;

    {Method declaration for GetState}
    Function GetState: Boolean;

  published
    { Published declarations }

    Property KeyCapsLock:   Boolean Read FKeyCapsLock   Write SetKeyCapsLock   Default True;
    Property KeyNumLock:    Boolean Read FKeyNumLock    Write SetKeyNumLock    Default False;
    Property KeyScrollLock: Boolean Read FkeyScrollLock Write SetKeyScrollLock Default False;
    Property KeyInsertKey:  Boolean Read FKeyInsertKey  Write SetKeyInsertKey  Default False;

  end;

procedure Register;

implementation

{Register the KeyState component}
procedure Register;
begin
  RegisterComponents('Misc', [TKeyState]);
end;

{Set default values}
Constructor TKeyState.Create (AOwner: TComponent);
Begin
    Inherited Create(AOwner);
    Width:=37;
    Height:=17;
    Alignment :=TaCenter;
    BevelOuter:=BvLowered;
    Font.Name:='MS Sans Serif';
    Font.Size:=8;
    Caption:='CAPS';

    {Setting my own properties}

    KeyCapsLock:=True;
    KeyNumLock:=False;
    KeyScrollLock:=False;
    KeyInsertKey:=False;
End;

{Set property for CAPSlock}
Procedure TKeyState.SetKeyCapsLock (Toggled: Boolean);
Begin
    If Toggled<>FKeyCapsLock then Begin
        FKeyCapsLock:=Toggled;
        If FkeyCapsLock=True then begin
            FKeyNumLock:=False;
            FKeyScrollLock:=False;
            FKeyInsertKey:=False;
            Caption:='CAPS';
        End;
        UpDate;
    End;
End;

{Set Property for NUMlock}
Procedure TKeyState.SetKeyNumLock (Toggled: Boolean);
Begin
    If Toggled<>FKeyNumLock then Begin
        FKeyNumLock:=Toggled;
        If FkeyNumLock=True then begin
            FKeyCapsLock:=False;
            FKeyScrollLock:=False;
            FKeyInsertKey:=False;
            Caption:='NUM';
        End;
        UpDate;
    End;
End;

{Set propertie ScrollLock}
Procedure TKeyState.SetKeyScrollLock (Toggled: Boolean);
Begin
    If Toggled<>FKeyScrollLock then Begin
        FKeyScrollLock:=Toggled;
        If FkeyScrollLock=True then begin
            FKeyCapsLock:=False;
            FKeyNumLock:=False;
            FKeyInsertKey:=False;
            Caption:='SCR';
        End;
        UpDate;
    End;
End;

{Set property for Insert key}
Procedure TKeyState.SetKeyInsertKey (Toggled: Boolean);
Begin
    If Toggled<>FKeyInsertKey then Begin
        FKeyInsertKey:=Toggled;
        If FkeyInsertKey=True then begin
            FKeyCapsLock:=False;
            FKeyNumLock:=False;
            FKeyScrollLock:=False;
            Caption:='INS';
        End;
        UpDate;
    End;
End;

{ Generic method to retrieve a keystate!
  Returns: True or False for ON or OFF
}
Function TKeyState.GetState: Boolean;

Var
    Key: Integer;

Begin

    {Is KeyState Enabled?}
    If Enabled then begin

        {Read state of CapsLock key}
        If FKeyCapsLock=True then Begin
            Key:=GetKeyState(20);
            If Key And 1=1 then begin
                Caption:='CAPS';
                Result:=True;
            End
            Else Begin
                Caption:='';
                Result:=False;
            End;
        End;

        {Read state of NumLock key}
        If FKeyNumLock=True then Begin
            Key:=GetKeyState(144);
            If Key And 1=1 then begin
                Caption:='NUM';
                Result:=True;
            End
            Else Begin
                Caption:='';
                Result:=False;
            End;
        End;

        {Read state of ScrollLock key}
        If FKeyScrollLock=True then Begin
            Key:=GetKeyState(145);
            If Key And 1=1 then begin
                Caption:='SCR';
                Result:=True;
            End
            Else Begin
                Caption:='';
                Result:=False;
            End;
        End;

        {Read state of Insert key}
        If FKeyInsertKey=True then Begin
            Key:=GetKeyState(45);
            If Key And 1=1 then begin
                Caption:='INS';
                Result:=True;
            End
            Else Begin
                Caption:='OVR';
                Result:=False;
            End;
        End;

        Update;

    End;

End;

end.
