{
 Unit JmpMemo: TJumpMemo component. v 2.0
 Copyright  1997 by Alexander Kuznetsov from
  Republican Center of Legal Information of the Republic of Kazakhstan.
 This component is freeware, and you can use it as you wish,
   but you can`t distribute or sale them.
 For all questions and suggestions about this component please
  send me a massage by e-mail to sanhome@hotmail.com.
 Big thanks to Gerry Skolnik (skolnik@kapsch.co.at)
 for his component TBigText, because I get the scrolling from it
}

unit Jmpmemo;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs,StdCtrls,Printers,S_StrLst;


type

  TLongRect = record
    Left:LongInt;
    Top: LongInt;
    Right:LongInt;
    Bottom:LongInt;
   end;

  TLongPoint = record
    X: LongInt;
    Y: LongInt;
  end;

  TJump=class
  public
   StrNum:longInt;
   JumpName:string;
   Rect:TLongRect;
   constructor Create(AName:string;AStrNum:longint;x,y,w,h:longint);
   function OnMe(X,Y:longInt;Origin:TLongPoint;CharSize:TPoint):boolean;
   procedure DrawMe(ACanvas:TCanvas;Origin:TLongPoint;CharSize:TPoint;Col,JCol:TColor);
  end;

  TPict=class
  public
   StrNum:longInt;
   PictName:string;
   Rect:TLongRect;
   constructor Create(AName:string;AStrNum:longint;x,y,w,h:longint);
   function OnMe(X,Y:longInt;Origin:TLongPoint;CharSize:TPoint):boolean;
   procedure DrawMe(ACanvas:TCanvas;Origin:TLongPoint;CharSize:TPoint;Col,JCol:TColor);
  end;

  TJumpClick=procedure(Sender:TObject;JumpString:String)of Object;

  TPictClick=procedure(Sender:TObject;PictString:String)of Object;
  TCopyToClipboard=procedure(Sender:TObject;Count:longInt)of Object;

  TPositionInfo = record
   StrNumber:LongInt;
   LineNumber:integer;
   SimbolIndex:integer;
   EnabledIndex:integer;
  end;

  TJumpMemo = class(TCustomControl)
  private
   { Private declarations }
   FDefInstance: Pointer;
   FDefProc: Pointer;
   FInternBmp:TBitmap;
   FOnJumpClick:TJumpClick;
   FOnPictClick:TPictClick;
   FOnCopyToClipboard:TCopyToClipboard;
   FOnSelect:TNotifyEvent;
   FOnDeSelect:TNotifyEvent;
   FLines:TS_StringList;
   FSelWords:TStrings;
   JumpList:TStringList;
   FJumps:TList;
   FPictures:TList;
   FPageMarker:string;
   FColor:TColor;
   FTextColor:TColor;
   FSelColor:TColor;
   FJumpColor:TColor;
   FFont:TFont;
   FScrollBars:TScrollStyle;
   FUseJumpPointLength:Boolean;
   SelDown,SelUp,FShowPages:Boolean;
   OldMouseY,MyCursor:Integer;
   OldCursor,PictCursor:Integer;
   MaxStrLength,FJumpLength:Integer;
   FBorder:boolean;
   procedure UpdateCaret(FromMouse:boolean);
   procedure DrawSelection;
   procedure UnDrawSelection;
   procedure Paint;override;
   procedure SetShowPages(Value: boolean);
   procedure SetSelWords(Value: TStrings);
   procedure SetPageMarker(Value: String);
   procedure SetBorder(value:boolean);
   procedure SetFont(Fnt:TFont);
   procedure SetColor(Col:Tcolor);
   procedure SetSelColor(Col:Tcolor);
   procedure SetJumpColor(Col:Tcolor);
   procedure SetJumpLength(Value:Integer);
   procedure SetUseJumpPointLength(Value:Boolean);
   procedure SetTextColor(Col:Tcolor);
   procedure DoScroll(Which, Action, Thumb: longint);
   procedure WMHScroll(var M: TWMHScroll); message wm_HScroll;
   procedure WMVScroll(var M: TWMVScroll); message wm_VScroll;
   procedure WMSize(var M: TWMSize); message wm_Size;
   procedure WMGetDlgCode(var M: TWMGetDlgCode); message wm_GetDlgCode;
   procedure MouseMove(Shift:TShiftState;X,Y:Integer);override;
   procedure MouseDown(Button: TMouseButton;Shift:TShiftState;X,Y:Integer);override;
   procedure MouseUp(Button: TMouseButton;Shift:TShiftState;X,Y:Integer);override;
   procedure KeyDown(var Key: Word; Shift: TShiftState); override;
   procedure KeyUp(var Key: Word; Shift: TShiftState); override;
  protected
   { Protected declarations }
   FRange: TLongPoint;
   FOrigin: TLongPoint;
   FClientSize: TPoint;
   FCharSize: TPoint;
   FOverhang: longint;
   FPageSize: longint;
   scx:longint;
   PictCurs,crMyCurs:TCursor;
   procedure WndProc(var Message: TMessage); override;
   procedure JumpClick;dynamic;
   procedure PictClick;dynamic;
   procedure FontChanged(Sender: TObject);
   procedure InsertPages;
   procedure RemovePages;
   procedure CreateParams(var Params: TCreateParams);override;
   procedure ChangeScrollBars(Value: TScrollStyle);
   procedure SetScrollBars;
  public
   { Public declarations }
   PageCount:integer;
   InSelect,IsJump,IsPict:boolean;
   PictStr,JmpStr:string;
   CurentCaretPos,CurentSelectStart,CurentSelectEnd:TPositionInfo;
   InBlock:boolean;
   SelStart,SelEnd:longint;
   MaxFound:boolean;
   procedure RecalcRange;
   procedure Clear;
   procedure SelectionToZero;
   procedure ReadJumps;
   property JumpWords:TStringList read JumpList;
   property Lines:TS_StringList read FLines;
   constructor Create(AnOwner: TComponent); override;
   destructor Destroy; override;
   procedure LoadFromFile(const FileName:string);
   procedure ScrollTo(X, Y: longint);
   procedure Add(const Str:string);
   procedure Print(const fn:string;stpg,endpg:longint;infile,allfile:boolean);
   function CopyToClipboard:longint;
   function GotoWord(const Str:string;curpos:longint;Up:Boolean):longint;
   function GetPos(const Str:string;curpos:longint):longint;
   function Search(srstr:string;Down:boolean):boolean;
   function GetCurPos:longint;
   function GetWord(X,Y:integer):string;
  published
   { Published declarations }
   property Border:boolean read FBorder write SetBorder default true;
   property Font:TFont read FFont write SetFont;
   property Color:TColor read FColor write SetColor;
   property SelWords:TStrings read FSelWords write SetSelWords;
   property SelectColor:TColor read FSelColor write SetSelColor;
   property JumpColor:TColor read FJumpColor write SetJumpColor;
   property TextColor:TColor read FTextColor write SetTextColor;
   property JumpPointLength:Integer read FJumpLength write SetJumpLength;
   property UseJumpPointLength:boolean read FUseJumpPointLength write SetUseJumpPointLength;
   property Align;
   property HelpContext;
   property Pagemarker:string read FPageMArker write SetPageMarker;
   property ScrollBars: TScrollStyle read FScrollBars write ChangeScrollBars default ssNone;
   property ShowPages:Boolean read FShowPages write SetShowPages default false;
   property TabStop;
   property Visible;
   property OnDeSelect:TNotifyEvent read FOnDeSelect write FOnDeSelect;
   property OnCopyToClipboard:TCopyToClipboard read FOnCopyToClipboard write FOnCopyToClipboard;
   property OnJumpClick:TJumpClick read FOnJumpClick write FOnJumpClick;
   property OnKeyDown;
   property OnKeyUp;
   property OnMouseDown;
   property OnPictureClick:TPictClick read FOnPictClick write FOnPictClick;
   property OnSelect:TNotifyEvent read FOnSelect write FOnSelect;
  end;
{$M-}

procedure Register;
function Max(i1,i2:longint):longint;
function Min(i1,i2:longint):longint;

implementation
{$R JMPMEMO2.RES}

type
  TScrollKey = record
    sKey: Byte;
    Ctrl: Boolean;
    SBar: Byte;
    Action: Byte;
  end;

{ Scroll keys table }

const
  ScrollKeyCount = 16;
  ScrollKeys: array[1..ScrollKeyCount] of TScrollKey = (
    (sKey: vk_Left;  Ctrl: False; SBar: sb_Horz; Action: sb_LineUp),
    (sKey: vk_Right; Ctrl: False; SBar: sb_Horz; Action: sb_LineDown),
    (sKey: vk_Left;  Ctrl: True;  SBar: sb_Horz; Action: sb_PageUp),
    (sKey: vk_Right; Ctrl: True;  SBar: sb_Horz; Action: sb_PageDown),
    (sKey: vk_Home;  Ctrl: False; SBar: sb_Vert; Action: sb_Top),
    (sKey: vk_End;   Ctrl: False; SBar: sb_Vert; Action: sb_Bottom),
    (sKey: vk_Up;    Ctrl: False; SBar: sb_Vert; Action: sb_LineUp),
    (sKey: vk_Down;  Ctrl: False; SBar: sb_Vert; Action: sb_LineDown),
    (sKey: vk_Prior; Ctrl: False; SBar: sb_Vert; Action: sb_PageUp),
    (sKey: vk_Next;  Ctrl: False; SBar: sb_Vert; Action: sb_PageDown),
    (sKey: vk_F1;    Ctrl: False; SBar: sb_Vert; Action: sb_PageDown),
    (sKey: vk_F2;    Ctrl: False; SBar: sb_Vert; Action: sb_PageUp),
    (sKey: vk_F3;    Ctrl: False; SBar: sb_Vert; Action: sb_Top),
    (sKey: vk_F4;    Ctrl: False; SBar: sb_Vert; Action: sb_Bottom),
    (sKey: vk_Home;  Ctrl: True;  SBar: sb_Horz; Action: sb_Top),
    (sKey: vk_End;   Ctrl: True;  SBar: sb_Horz; Action: sb_Bottom));


function UpChar(CL:char):char;
var CK,CM:char;
begin
 CK:=CL;
 CM:=CL;
 if CK='' then CM:=''
  else if CK='' then CM:=''
   else if CK='' then CM:=''
    else if CK='' then CM:=''
     else if CK='' then CM:=''
      else if CK='' then CM:=''
       else if (CM='')or(CK='')then CM:='I'
        else if CK='' then CM:=''
          else if(CM='')or(CK='')then CM:='H';

if(CM='A')or(CM='a')or(CM='') then CL:=''
 else if CM='' then CL:='' else if(CM='B')or(CM='b')or(CM='')then CL:=''
 else if CM='' then CL:='' else if(CM='C')or(CM='c')or(CM='')then CL:=''
 else if CM='' then CL:='' else if CM='d' then CL:='D'
 else if CM='' then CL:='' else if(CM='E')or(CM='e')or(CM='')then CL:=''
 else if CM='' then CL:='' else if CM='f' then CL:='F'
 else if CM='' then CL:='' else if CM='g' then CL:='G'
 else if CM='' then CL:='' else if(CM='H')or(CM='h')or(CM='')then CL:=''
 else if CM='' then CL:=''
 else if(CM='I')or(CM='i')then CL:='I' else if CM='' then CL:=''
 else if(CM='J')or(CM='j')then CL:='J' else if CM='' then CL:=''
 else if(CM='K')or(CM='k')or(CM='')then CL:='' else if CM='' then CL:=''
 else if(CM='L')or(CM='l')then CL:='L' else if CM='' then CL:=''
 else if(CM='M')or(CM='m')or(CM='')then CL:='' else if CM='' then CL:=''
 else if(CM='N')or(CM='n')then CL:='N' else if CM='' then CL:=''
 else if(CM='O')or(CM='o')or(CM='')then CL:='' else if CM='' then   CL:=''
 else if(CM='P')or(CM='p')or(CM='')then CL:='' else if CM='' then   CL:=''
 else if(CM='Q')or(CM='q')then CL:='Q' else if CM='' then   CL:=''
 else if(CM='R')or(CM='r')then CL:='R' else if CM='' then   CL:=''
 else if(CM='S')or(CM='s')then CL:='S' else if CM='' then   CL:=''
 else if(CM='T')or(CM='t')or(CM='')then CL:='' else if CM='' then   CL:=''
 else if(CM='U')or(CM='u')then CL:='U'
 else if(CM='V')or(CM='v')then CL:='V'
 else if(CM='W')or(CM='w')then CL:='W'
 else if(CM='X')or(CM='x')or(CM='')then CL:=''
 else if(CM='Y')or(CM='y')or(CM='')then CL:=''
 else if(CM='Z')or(CM='z')then CL:='Z'
 else CL:=CM;
 result:=CL;
end;

function UpStr(const s:string):string;
var i,Len:integer;
    temp:string;
begin
 Len:=Length(s);
 temp:=s;
 for i:=1 to len do temp[i]:=UpChar(s[i]);
 result:=temp;
end;

function Max(i1,i2:longint):longint;
begin
 if i1>i2 then result:=i1
 else result:=i2;
end;

function Min(i1,i2:longint):longint;
begin
 if i1<i2 then result:=i1
 else result:=i2;
end;

function PosFrom(Substr,Mainstr:string;position:integer;WholeWord:boolean):integer;
var j,i:integer;
    Breaked:boolean;
begin
 result:=position;
 if Length(Substr)>Length(MainStr)then
 begin
  result:=0;
  Exit;
 end;
 breaked:=false;
 if (position+Length(Substr))<=Length(MainStr)then
 begin
  for j:=position to Length(Mainstr)-Length(Substr)do
  begin
   for i:=1 to Length(Substr)do
   begin
    if MainStr[J+i]<>SubStr[i]then
    begin
     breaked:=true;
     break;
    end
    else breaked:=false;
   end;
   if not breaked then
   begin
    if j>0 then
    begin
     case MainStr[j] of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':break;
     end;
    end;
    if WholeWord then
    begin
     case MainStr[j+Length(Substr)+1] of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':break;
     end;
    end;
    result:=j+1;
    break;
   end;
  end;
 end;
end;

{TJump}

constructor TJump.Create(AName:string;AStrNum:longint;x,y,w,h:longint);
begin
 JumpName:=Aname;
 StrNum:=AStrNum;
 Rect.Left:=x;
 Rect.Top:=y;
 Rect.Right:=x+w;
 Rect.Bottom:=y+h;
end;

function TJump.OnMe(X,Y:longInt;Origin:TLongPoint;CharSize:TPoint):boolean;
begin
 Result:=(x>=(-Origin.X*CharSize.X)+4+Rect.Left)and(x<=(-Origin.X*CharSize.X)+4+Rect.Right)
    and(y>=Rect.Top-(CharSize.Y*Origin.Y))and(y<=Rect.Bottom-(CharSize.Y*Origin.Y));
end;

procedure TJump.DrawMe(ACanvas:TCanvas;Origin:TLongPoint;CharSize:TPoint;Col,JCol:TColor);
var OldColor:TColor;
    OldStyle:TFontStyles;
begin
 OldColor:=ACanvas.Font.Color;
 OldStyle:=ACanvas.Font.Style;
 ACanvas.Font.Color:=Col;
 ACanvas.Font.Style:=[fsUnderLine];
 {Drawing a jump}
 ACanvas.TextOut((-Origin.X*CharSize.X)+4+Rect.Left-ACanvas.TextWidth('~'),Rect.Top-(CharSize.Y*Origin.Y),'~');
 ACanvas.Font.Color:=JCol;
 ACanvas.TextOut((-Origin.X*CharSize.X)+4+Rect.Left,Rect.Top-(CharSize.Y*Origin.Y),JumpName);
 {End of Drawing a jump}
 ACanvas.Font.Style:=[];
 ACanvas.Font.Color:=OldColor;
 ACanvas.Font.Style:=OldStyle;
end;

{TPict}

constructor TPict.Create(AName:string;AStrNum:longint;x,y,w,h:longint);
begin
 PictName:=Aname;
 StrNum:=AStrNum;
 Rect.Left:=x;
 Rect.Top:=y;
 Rect.Right:=x+w;
 Rect.Bottom:=y+h;
end;

function TPict.OnMe(X,Y:longInt;Origin:TLongPoint;CharSize:TPoint):boolean;
begin
 Result:=(x>=(-Origin.X*CharSize.X)+4+Rect.Left)and(x<=(-Origin.X*CharSize.X)+4+Rect.Right)
    and(y>=Rect.Top-(CharSize.Y*Origin.Y))and(y<=Rect.Bottom-(CharSize.Y*Origin.Y));
end;

procedure TPict.DrawMe(ACanvas:TCanvas;Origin:TLongPoint;CharSize:TPoint;Col,JCol:TColor);
var OldColor:TColor;
    Obs:TBrushStyle;
    Ops:TPenStyle;
    Tmpst:string;
    i:integer;
begin
 TmpSt:=PictName;
 while pos('_',TmpSt)>0 do TmpSt[pos('_',TmpSt)]:='.';
 OldColor:=ACanvas.Font.Color;
 Obs:=ACanvas.Brush.Style;
 Ops:=ACanvas.Pen.Style;
 ACanvas.Font.Color:=Col;
 {Drawing a Pict}
 ACanvas.Pen.Style:=psDot;
 ACanvas.Rectangle((-Origin.X*CharSize.X)+3+Rect.Left,Rect.Top-(CharSize.Y*Origin.Y),
 (-Origin.X*CharSize.X)+5+Rect.Right,Rect.Bottom-(CharSize.Y*Origin.Y));
 ACanvas.Brush.Style:=bsClear;
 ACanvas.TextOut((-Origin.X*CharSize.X)+4+Rect.Left-ACanvas.TextWidth('^'),Rect.Top-(CharSize.Y*Origin.Y),'^');
 ACanvas.Font.Color:=JCol;
 ACanvas.TextOut((-Origin.X*CharSize.X)+4+Rect.Left,Rect.Top-(CharSize.Y*Origin.Y)-1,TmpSt);
 {End of Drawing a Pict}
 ACanvas.Pen.Style:=Ops;
 ACanvas.Brush.Style:=Obs;
 ACanvas.Font.Color:=OldColor;
end;

{TJumpMemo}
Constructor TJumpMemo.Create(AnOwner: TComponent);
begin
 FInternBmp:=TBitmap.Create;
 inherited Create(AnOwner);
 try
 FLines:=TS_StringList.Create;
 except MessageBox(0,'Can`t create List for text lines','Error',Mb_OK);
  Exit;
 end;
 try
 FSelWords:=TStringList.Create;
 except MessageBox(0,'Can`t create List for Selected words','Error',Mb_OK);
  Exit;
 end;
 try
 JumpList:=TStringList.Create;
 JumpList.Sorted:=True;
 except MessageBox(0,'Can`t create List for Jump words','Error',Mb_OK);
  Exit;
 end;
 try
  FJumps:=TList.Create;
 except MessageBox(0,'Can`t create List for Jump coordinates','Error',Mb_OK);
  Exit;
 end;
 try
  FPictures:=TList.Create;
 except MessageBox(0,'Can`t create List for Pictures coordinates','Error',Mb_OK);
  Exit;
 end;
 FColor:=ClWhite;
 FSelColor:=ClRed;
 FJumpColor:=ClGreen;
 FTextColor:=ClBlack;
 FPageMArker:='Page';
 FFont:=TFont.Create;
 FFont.Name:='Courier New';
 FFont.Color:=FTextColor;
 FFont.Size:=10;
 FBorder:=true;
 Width:=200;
 Height:=200;
 CurentCaretPos.StrNumber:=0;
 CurentCaretPos.LineNumber:=0;
 CurentCaretPos.SimbolIndex:=0;
 CurentCaretPos.EnabledIndex:=0;
 CurentSelectStart.StrNumber:=0;
 CurentSelectStart.LineNumber:=0;
 CurentSelectStart.SimbolIndex:=0;
 CurentSelectEnd.StrNumber:=0;
 CurentSelectEnd.LineNumber:=0;
 CurentSelectEnd.SimbolIndex:=0;
 InBlock:=False;
 InSelect:=False;
 MaxFound:=False;
 FFont.OnChange := FontChanged;
 FontChanged(nil);
 Align:=alNone;
 FJumpLength:=7;
 FUseJumpPointLength:=false;
 MaxStrLength:=0;
 PageCount:=0;
 MyCursor:=1;
 PictCursor:=2;
 IsJump:=False;
 IsPict:=False;
 scx:=0;
 JmpStr:='';
 PictStr:='';
 Cursor:=crIBeam;
 OldCursor:=Cursor;
 try
 crMyCurs:=LoadCursor(HInstance, 'HANDCURSOR2');
 Screen.Cursors[MyCursor]:=crMyCurs;
 PictCurs:=LoadCursor(HInstance, 'PICTCURSOR2');
 Screen.Cursors[PictCursor]:=PictCurs;
 if crMyCurs=0 then MyCursor:=crUpArrow;
 if PictCurs=0 then PictCursor:=crUpArrow;
 except
  MyCursor:=crUpArrow;
  PictCursor:=crUpArrow;
 end;
 Repaint;
end;


destructor TJumpMemo.Destroy;
var i:longint;
begin
 for i:=0 to FJumps.Count-1 do TJump(FJumps[i]).Free;
 FJumps.Clear;
 FJumps.Free;
 for i:=0 to FPictures.Count-1 do TPict(FPictures[i]).Free;
 FPictures.Clear;
 FPictures.Free;
 FLines.Clear;
 FLines.Free;
 FSelWords.Clear;
 FSelWords.Free;
 FFont.Free;
 FInternBmp.Free;
 inherited Destroy;
end;

procedure TJumpMemo.CreateParams(var Params: TCreateParams);
const
  ScrollBar: array[TScrollStyle] of LongInt = (0, WS_HSCROLL, WS_VSCROLL,
    WS_HSCROLL or WS_VSCROLL);
begin
  inherited CreateParams(Params);
  if FBorder then Params.Style := Params.Style or ScrollBar[FScrollBars] or WS_BORDER
  else Params.Style := Params.Style or ScrollBar[FScrollBars];
end;

procedure TJumpMemo.WndProc(var Message: TMessage);
begin
 with Message do
 begin
  case Msg of
   WM_SETFOCUS:
     if not GetParentForm(Self).SetFocusedControl(Self) then Exit
     else
     begin
      if HandleAllocated then
      begin
       CreateCaret(WindowHandle,0,2,FCharSize.Y);
       if Focused then
       begin
        ShowCaret(Handle);
        UpdateCaret(True);
       end;
      end;
     end;
   WM_KILLFOCUS:
     if csFocusing in ControlState then Exit
     else
     begin
      if HandleAllocated then
      begin
       HideCaret(WindowHandle);
       DestroyCaret;
      end;
     end;
   WM_LBUTTONDBLCLK:
     begin
      result:=1;
      Exit;
     end;
  end;
  result:=0;
 end;
 inherited WndProc(Message);
end;

procedure TJumpMemo.SetBorder(value:boolean);
begin
 if FBorder<>value then
 begin
  FBorder:=value;
  RecreateWnd;
 end;
end;

procedure TJumpMemo.SetSelWords(Value: TStrings);
begin
  FSelWords.Assign(Value);
  Repaint;
end;

procedure TJumpMemo.ChangeScrollBars(Value: TScrollStyle);
begin
  if FScrollBars <> Value then
  begin
    FScrollBars := Value;
    RecreateWnd;
  end;
end;

procedure TJumpMemo.SetScrollBars;
begin
  if HandleAllocated then
  begin
    if (FScrollBars = ssHorizontal) or (FScrollBars = ssBoth) then
    begin
      SetScrollRange(Handle, sb_Horz, 0, Max(1, FRange.X), False);
      SetScrollPos(Handle, sb_Horz, FOrigin.X, True);
    end;
    if (FScrollBars = ssVertical) or (FScrollBars = ssBoth) then
    begin
      SetScrollRange(Handle, sb_Vert, 0, Max(1, FRange.Y), False);
      SetScrollPos(Handle, sb_Vert, FOrigin.Y, True);
    end;
  end;
end;

procedure TJumpMemo.LoadFromFile(const FileName:string);
var Kb:word;
begin
 FLines.Clear;
 try
  FLines.LoadFromFile(FileName);
 except MessageBox(0,'      !','',Mb_OK+MB_ICONSTOP);
 end;
 if FShowPages then
 begin
  RemovePages;
  InsertPages;
 end;
 CurentCaretPos.StrNumber:=0;
 CurentCaretPos.LineNumber:=0;
 CurentCaretPos.SimbolIndex:=0;
 CurentCaretPos.EnabledIndex:=Length(FLines[0]);
 CurentSelectStart.StrNumber:=0;
 CurentSelectStart.LineNumber:=0;
 CurentSelectStart.SimbolIndex:=0;
 CurentSelectStart.EnabledIndex:=Length(FLines[0]);
 CurentSelectEnd.StrNumber:=0;
 CurentSelectEnd.LineNumber:=0;
 CurentSelectEnd.SimbolIndex:=0;
 CurentSelectEnd.EnabledIndex:=Length(FLines[0]);
 InSelect:=false;
 InBlock:=False;
 MaxFound:=False;
{ UpdateCaret(false);}
 RecalcRange;
 ReadJumps;
 Repaint;
end;

procedure TJumpMemo.Clear;
var i:longint;
begin
 for i:=0 to FJumps.Count-1 do TJump(FJumps[i]).Free;
 FJumps.Clear;
 FJumps.Free;
 for i:=0 to FPictures.Count-1 do TPict(FPictures[i]).Free;
 FPictures.Clear;
 FPictures.Free;
 FLines.Clear;
 FLines.Free;
 FSelWords.Clear;
 FSelWords.Free;
 if FShowPages then
 begin
  InsertPages;
 end;
 CurentCaretPos.StrNumber:=0;
 CurentCaretPos.LineNumber:=0;
 CurentCaretPos.SimbolIndex:=0;
 CurentCaretPos.EnabledIndex:=Length(FLines[0]);
 CurentSelectStart.StrNumber:=0;
 CurentSelectStart.LineNumber:=0;
 CurentSelectStart.SimbolIndex:=0;
 CurentSelectStart.EnabledIndex:=Length(FLines[0]);
 CurentSelectEnd.StrNumber:=0;
 CurentSelectEnd.LineNumber:=0;
 CurentSelectEnd.SimbolIndex:=0;
 CurentSelectEnd.EnabledIndex:=Length(FLines[0]);
 InSelect:=false;
 InBlock:=False;
 MaxFound:=False;
 RecalcRange;
 ReadJumps;
 Repaint;
 UpdateCaret(false);
end;

procedure TJumpMemo.SelectionToZero;
begin
 CurentCaretPos.StrNumber:=0;
 CurentCaretPos.LineNumber:=0;
 CurentCaretPos.SimbolIndex:=0;
 CurentCaretPos.EnabledIndex:=Length(FLines[0]);
 CurentSelectStart.StrNumber:=0;
 CurentSelectStart.LineNumber:=0;
 CurentSelectStart.SimbolIndex:=0;
 CurentSelectStart.EnabledIndex:=Length(FLines[0]);
 CurentSelectEnd.StrNumber:=0;
 CurentSelectEnd.LineNumber:=0;
 CurentSelectEnd.SimbolIndex:=0;
 CurentSelectEnd.EnabledIndex:=Length(FLines[0]);
 InSelect:=false;
 InBlock:=False;
 Repaint;
 UpdateCaret(false);
end;

procedure TJumpMemo.Paint;
var
n,wp,oldwp,swc,j,cury,x,i:longint;
selwrd,tmpstr,tmpwrd:string;
wholword:boolean;
begin
 if csLoading in componentstate then exit;
 if csDesigning in componentstate then exit;
 swc:=FSelWords.Count;
 FInternBmp.Canvas.Brush.Color:=FColor;
 FInternBmp.Canvas.Brush.Style:=bsSolid;
 FInternBmp.Canvas.FillRect(ClientRect);
 x:=(-FOrigin.X*FCharSize.X)+4;
 if FLines.Count<>0 then
 begin
  HideCaret(Handle);
  cury:=FOrigin.Y;
  i:=0;
  for i:=0 to FPageSize do
  begin
   if pos('- '+FPageMarker+' ',FLines[i+cury])>0then
   begin
    FInternBmp.Canvas.Font.Color:=clBlue;
    FInternBmp.Canvas.TextOut(x,FCharSize.Y * i,FLines[i+cury]);
    FInternBmp.Canvas.Font.Color:=FFont.Color;
   end
   else
   begin
    FInternBmp.Canvas.TextOut(x,FCharSize.Y * i,FLines[i+cury]);
   end;
   if swc>0 then
   begin
    FInternBmp.Canvas.Font.Color:=FSelColor;
    for j:=0 to swc-1 do
    begin
     oldwp:=0;
     while true do
     begin
      wholword:=true;
      selwrd:=FSelWords[j];
      if selwrd[Length(selwrd)]='*'then
      begin
       wholword:=false;
       selwrd:=Copy(selwrd,1,Length(selwrd)-1);
      end;
      wp:=posfrom(UpStr(selwrd),UpStr(FLines[i+cury]),oldwp,wholword);
      if wp>oldwp then
      begin
       oldwp:=wp+Length(selwrd);
       tmpstr:='';
       for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[i+cury][n];
       tmpwrd:='';
       for n:=wp to wp+Length(selwrd)-1 do tmpwrd:=tmpwrd+FLines[i+cury][n];
        FInternBmp.Canvas.TextOut(x+FInternBmp.Canvas.TextWidth(tmpstr),i*FCharSize.Y,tmpwrd);
      end
      else break;
     end;
    end;
   end;
   FInternBmp.Canvas.Font.Color:=FFont.Color;
   FInternBmp.Canvas.Font.Style:=FFont.Style;
   if i+cury=FLines.Count-1 then break;
  end;
  if FJumps.Count>0 then
   for j:=0 to FJumps.Count-1 do
   begin
    if (TJump(FJumps[j]).StrNum>=FOrigin.Y)and(TJump(FJumps[j]).StrNum<=FOrigin.Y+FPageSize)then
     TJump(FJumps[j]).DrawMe(FInternBmp.Canvas,FOrigin,FCharSize,FColor,FJumpColor);
   end;
  if FPictures.Count>0 then
   for j:=0 to FPictures.Count-1 do
   begin
    if (TPict(FPictures[j]).StrNum>=FOrigin.Y)and(TPict(FPictures[j]).StrNum<=FOrigin.Y+FPageSize)then
     TPict(FPictures[j]).DrawMe(FInternBmp.Canvas,FOrigin,FCharSize,FColor,clBlue);
   end;
  Canvas.Draw(0,0,FInternBmp);
  ShowCaret(Handle);
  if Inblock then DrawSelection;
 end;
end;

procedure TJumpMemo.SetFont(Fnt:TFont);
begin
 FFont.Assign(Fnt);
 FInternBmp.Canvas.Font.Assign(FFont);
 FontChanged(self);
 if not (csDesigning in componentstate) then
 begin
  CreateCaret(Handle,0,2,FCharSize.Y);
  ShowCaret(Handle);
  UpdateCaret(true);
 end;
 Invalidate;
end;

procedure TJumpMemo.FontChanged(Sender: TObject);
var
  DC: HDC;
  Save: THandle;
  Metrics: TTextMetric;
  Temp: String;
begin
  DC := GetDC(0);
  Save := SelectObject(DC, FFont.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, Save);
  ReleaseDC(0, DC);
  with Metrics do
  begin
   FCharSize.X := tmAveCharWidth;
   FCharSize.Y := tmHeight;
   FOverhang   := Max(tmOverhang, tmMaxCharWidth - tmAveCharWidth);
  end;
  RecalcRange;
  ReadJumps;
  scx:=0;
  FInternBmp.Canvas.Font:=FFont;
  ScrollTo(0,FOrigin.Y);
end;

procedure TJumpMemo.SetColor(Col:Tcolor);
begin
 if Col<>FColor then
 begin
  Fcolor:=Col;
  Repaint;
 end;
end;

procedure TJumpMemo.SetSelColor(Col:Tcolor);
begin
 if Col<>FSelColor then
 begin
  FSelcolor:=Col;
  Repaint;
 end;
end;

procedure TJumpMemo.SetJumpColor(Col:Tcolor);
begin
 if Col<>FJumpColor then
 begin
  FJumpcolor:=Col;
  Repaint;
 end;
end;

procedure TJumpMemo.SetJumpLength(Value:Integer);
begin
 if Value<>FJumpLength then
 begin
  FJumpLength:=Value;
  ReadJumps;
  Repaint;
 end;
end;

procedure TJumpMemo.SetUseJumpPointLength(Value:Boolean);
begin
 if Value<>FUseJumpPointLength then
 begin
  FUseJumpPointLength:=Value;
  ReadJumps;
  Repaint;
 end;
end;

procedure TJumpMemo.SetTextColor(Col:Tcolor);
begin
 if Col<>FTextColor then
 begin
  FTextColor:=Col;
  FFont.Color:=FTextColor;
  Repaint;
 end;
end;

procedure TJumpMemo.WMHScroll(var M: TWMHScroll);
begin
 DoScroll(sb_Horz, M.ScrollCode, M.Pos);
end;

procedure TJumpMemo.WMVScroll(var M: TWMVScroll);
begin
 DoScroll(sb_Vert, M.ScrollCode, M.Pos);
end;

procedure TJumpMemo.WMSize(var M: TWMSize);
begin
  inherited;
  RecalcRange;
end;

procedure TJumpMemo.WMGetDlgCode(var M: TWMGetDlgCode);
begin
  M.Result := dlgc_WantArrows or dlgc_WantChars;
end;

procedure TJumpMemo.KeyDown(var Key: Word; Shift: TShiftState);
var
  oldlinenum,delta:integer;
  I: Integer;
  OldRangeX:integer;
  K:word;
  CarP:TPoint;
  tmpstr:string;
begin
  if FLines.Count=0 then Exit;
  if (Key = vk_F1)then
  begin
   Application.HelpContext(HelpContext);
   Exit;
  end;
  if (Shift=[ssCtrl])and(Key=VK_INSERT)then
  begin
   CopyToClipboard;
   Exit;
  end;
  if Key <> 0 then
  begin
   if Key=VK_RETURN then
   begin
    GetCaretPos(Carp);
    for i:=0 to FJumps.Count-1 do
     if TJump(FJumps[i]).OnMe(Carp.X,Carp.Y+2,FOrigin,FCharSize) then
     begin
      JmpStr:=TJump(FJumps[i]).JumpName;
      JumpClick;
      Inherited KeyDown(Key,Shift);
      Exit;
     end;
    for i:=0 to FPictures.Count-1 do
     if TPict(FPictures[i]).OnMe(Carp.X,Carp.Y+2,FOrigin,FCharSize) then
     begin
      PictStr:=TPict(FPictures[i]).PictName;
      PictClick;
      Inherited KeyDown(Key,Shift);
      Exit;
     end;
   end;
   with CurentCaretPos do
   begin
    if LineNumber<0 then
    begin
     oldlinenum:=LineNumber;
     LineNumber:=0;
     delta:=LineNumber-oldlinenum;
     ScrollTo(Min(FOrigin.X, FRange.X),FOrigin.Y-delta);
    end;
    if LineNumber>FPageSize-1 then
    begin
     oldlinenum:=LineNumber;
     LineNumber:=FPageSize-1;
     delta:=LineNumber-oldlinenum;
     ScrollTo(Min(FOrigin.X, FRange.X),FOrigin.Y-delta);
    end;
    { }
    if Key=VK_Down then
    begin
     if StrNumber<FLines.Count-1 then
     begin
      if Shift=[ssShift] then InSelect:=true;
      inc(StrNumber);
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      if LineNumber<FPageSize-1 then inc(LineNumber)
      else DoScroll(sb_Vert,sb_LineDown,0);
      UpdateCaret(false);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end;
     if (not InSelect) and (InBlock) then
     begin
{      UndrawSelection;}
{      CurentSelectStart:=CurentCaretPos;}
      CurentSelectEnd:=CurentCaretPos;
      InBlock:=False;
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      Repaint;
     end;
    end;
    { }
    if Key=VK_Up then
    begin
     if StrNumber>0 then
     begin
      if Shift=[ssShift] then InSelect:=true;
      dec(StrNumber);
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      if LineNumber>0 then dec(LineNumber)
      else DoScroll(sb_Vert,sb_LineUp,0);
      UpdateCaret(false);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end;
     if (not InSelect) and (InBlock) then
     begin
{      UndrawSelection;}
{      CurentSelectStart:=CurentCaretPos;}
      CurentSelectEnd:=CurentCaretPos;
      InBlock:=False;
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      Repaint;
     end;
    end;
    { PgDown}
    if Key=VK_Next then
    begin
     InSelect:=false;
     InBlock:=False;
{     UnDrawSelection;}
     Paint;
     if Assigned(FOnDeSelect)then FOnDeSelect(Self);
     if ssShift in Shift then InSelect:=true;
     if ssCtrl in Shift then
     begin
      StrNumber:=FOrigin.Y+FPageSize-1;
      LineNumber:=FPageSize-1;
      if StrNumber>FLines.Count-1 then
      begin
       StrNumber:=FLines.Count-1;
       if FPageSize>FLines.Count-1 then LineNumber:=FLines.Count-1
       else LineNumber:=FPageSize-1;
      end;
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      UpdateCaret(True);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end
     else
     begin
      inc(StrNumber,FPageSize);
      if StrNumber>FLines.Count-1 then
      begin
       StrNumber:=FLines.Count-1;
       if FPageSize>FLines.Count-1 then LineNumber:=FLines.Count-1
       else LineNumber:=FPageSize-1;
      end;
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      DoScroll(sb_Vert,sb_PageDown,0);
      UpdateCaret(True);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end;
    end;
    { PgUp}
    if Key=VK_Prior then
    begin
     InSelect:=false;
     InBlock:=False;
{     UnDrawSelection;}
     Paint;
     if Assigned(FOnDeSelect)then FOnDeSelect(Self);
     if ssShift in Shift then InSelect:=true;
     if ssCtrl in Shift then
     begin
      StrNumber:=FOrigin.Y;
      LineNumber:=0;
      if StrNumber<0 then
      begin
       StrNumber:=0;
       LineNumber:=0;
      end;
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      UpdateCaret(True);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end
     else
     begin
      dec(StrNumber,FPageSize);
      if StrNumber<0 then
      begin
       StrNumber:=0;
       LineNumber:=0;
      end;
      EnabledIndex:=Length(Flines[StrNumber]);
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      DoScroll(sb_Vert,sb_PageUp,0);
      UpdateCaret(True);
      GetCaretPos(Carp);
      if Carp.X<0 then DoScroll(sb_Horz,sb_Top,0);
     end;
    end;
    { }
    if Key=VK_Left then
    begin
     if SimbolIndex>0 then
     begin
      EnabledIndex:=Length(FLines[StrNumber]);
      if Shift=[ssShift] then InSelect:=true;
      if EnabledIndex<SimbolIndex then SimbolIndex:=EnabledIndex;
      dec(SimbolIndex);
      GetCaretPos(Carp);
      if CarP.X-FInternBmp.Canvas.TextWidth(Flines[StrNumber][SimbolIndex])<0 then
       DoScroll(sb_Horz,sb_LineUp,0);
       UpdateCaret(false);
     end
     else
     begin
      if StrNumber>0 then
      begin
       Key:=VK_UP;
       KeyDown(Key,Shift);
       EnabledIndex:=Length(FLines[StrNumber]);
       if Shift=[ssShift] then InSelect:=true;
       SimbolIndex:=EnabledIndex;
       UpdateCaret(false);
       GetCaretPos(Carp);
       if CarP.X+FInternBmp.Canvas.TextWidth(Flines[StrNumber][SimbolIndex])>ClientWidth then
        DoScroll(sb_Horz,sb_LineDown,0);
       UpdateCaret(false);
      end;
     end;
     if (not InSelect) and (InBlock) then
     begin
      InBlock:=False;
      UndrawSelection;
{      CurentSelectStart:=CurentCaretPos;}
      CurentSelectEnd:=CurentCaretPos;
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      Repaint;
     end;
    end;
    { }
    if Key=VK_Right then
    begin
     if SimbolIndex<Length(FLines[StrNumber]) then
     begin
      EnabledIndex:=Length(FLines[StrNumber]);
      if Shift=[ssShift] then InSelect:=true;
      inc(SimbolIndex);
      GetCaretPos(Carp);
      if CarP.X+FInternBmp.Canvas.TextWidth(Flines[StrNumber][SimbolIndex])>ClientWidth then
       DoScroll(sb_Horz,sb_LineDown,0);
      UpdateCaret(false);
     end
     else
     begin
      if StrNumber<FLines.Count-1 then
      begin
       Key:=VK_Down;
       KeyDown(Key,Shift);
       EnabledIndex:=Length(FLines[StrNumber]);
       if Shift=[ssShift] then InSelect:=true;
       SimbolIndex:=1;
       UpdateCaret(false);
       GetCaretPos(Carp);
       if CarP.X-FInternBmp.Canvas.TextWidth(Flines[StrNumber][SimbolIndex])<0 then
        DoScroll(sb_Horz,sb_LineUp,0);
       UpdateCaret(false);
      end;
     end;
     if (not InSelect) and (InBlock) then
     begin
{      UndrawSelection;
{      CurentSelectStart:=CurentCaretPos;}
      CurentSelectEnd:=CurentCaretPos;
      InBlock:=False;
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      Repaint;
     end;
    end;
    { Home}
    if Key=Vk_Home then
    begin
     InSelect:=false;
     InBlock:=False;
     UnDrawSelection;
     if ssShift in Shift then InSelect:=true;
     if ssCtrl in Shift then
     begin
{      if InSelect then CurentSelectStart:=CurentCaretPos;}
      InSelect:=false;
      StrNumber:=0;
      LineNumber:=0;
      SimbolIndex:=0;
      EnabledIndex:=Length(FLines[StrNumber]);
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      DoScroll(sb_Vert,sb_Top,0);
{      if InSelect then
      begin
       UpdateCaret(true);
       InSelect:=True;
       InBlock:=True;
       DrawSelection;
      end
      else }UpdateCaret(true);
      inherited KeyDown(Key, Shift);
      Exit;
     end
     else
     begin
      SimbolIndex:=0;
      EnabledIndex:=Length(FLines[StrNumber]);
      DoScroll(sb_Horz,sb_Top,0);
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      UpdateCaret(false);
     end;
    end;
    { End}
    if Key=Vk_End then
    begin
     InSelect:=false;
     InBlock:=False;
     UnDrawSelection;
     if ssShift in Shift then InSelect:=true;
     if ssCtrl in Shift then
     begin
{      if InSelect then CurentSelectStart:=CurentCaretPos;}
      InSelect:=false;
      StrNumber:=FLines.Count-1;
      LineNumber:=FPageSize-1;
      SimbolIndex:=Length(FLines[StrNumber]);
      EnabledIndex:=Length(FLines[StrNumber]);
      if LineNumber>FLines.Count-1 then LineNumber:=FLines.Count-1;
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      DoScroll(sb_Vert,sb_Bottom,0);
{      if InSelect then
      begin
       UpdateCaret(true);
       InSelect:=True;
       InBlock:=True;
       DrawSelection;
      end
      else} UpdateCaret(true);
      inherited KeyDown(Key, Shift);
      Exit;
     end
     else
     begin
      SimbolIndex:=Length(FLines[StrNumber]);
      EnabledIndex:=Length(FLines[StrNumber]);
      if Length(FLines[StrNumber])>FClientSize.X then DoScroll(sb_Horz,sb_Bottom,0);
      if Assigned(FOnDeSelect)then FOnDeSelect(Self);
      UpdateCaret(false);
     end;
    end;
{    UpdateCaret(true);}
   end;
  inherited KeyDown(Key, Shift);
  end;
end;

procedure TJumpMemo.KeyUp(var Key: Word; Shift: TShiftState);
begin
 if (Key=16)and (InSelect) then
 begin
  InSelect:=false;
  if (CurentSelectStart.StrNumber<>CurentSelectEnd.StrNumber) or
     (CurentSelectStart.SimbolIndex<>CurentSelectEnd.SimbolIndex) then InBlock:=true;
 end;
 inherited KeyUp(Key, Shift);
end;

procedure TJumpMemo.DoScroll(Which, Action, Thumb: longint);
var
  X, Y: longint;
function GetNewPos(Pos, Page, Range: longint): longint;
begin
  case Action of
    sb_LineUp: GetNewPos := Pos - 1;
    sb_LineDown: GetNewPos := Pos + 1;
    sb_PageUp: GetNewPos := Pos - Page;
    sb_PageDown: GetNewPos := Pos + Page;
    sb_Top: GetNewPos := 0;
    sb_Bottom: GetNewPos := Range;
    sb_ThumbPosition,
    sb_ThumbTrack    : GetNewPos := Thumb;
  else
    GetNewPos := Pos;
  end;
end;
begin
  X := FOrigin.X;
  Y := FOrigin.Y;
  case Which of
    sb_Horz: X := GetNewPos(X, FClientSize.X div 2, FRange.X);
    sb_Vert: Y := GetNewPos(Y, FClientSize.Y, FRange.Y);
  end;
  ScrollTo(X, Y);
end;

procedure TJumpMemo.ScrollTo(X, Y: longint);
var
  i:integer;
  R: TRect;
  OldOrigin: TLongPoint;
begin
  X := Max(0, Min(X, FRange.X));
  Y := Max(0, Min(Y, FRange.Y));
  if (X <> FOrigin.X) or (Y <> FOrigin.Y) then
  begin
    OldOrigin := FOrigin;
    FOrigin.X := X;
    FOrigin.Y := Y;
    if HandleAllocated then
    begin
      R := Parent.ClientRect;
      if (OldOrigin.X - X)<0 then scx:=scx+((OldOrigin.X - X) * FCharSize.X)+1*abs((OldOrigin.X - X))
      else if (OldOrigin.X - X)=0 then
      else scx:=scx+((OldOrigin.X - X) * FCharSize.X)-1*abs((OldOrigin.X - X));
      ScrollWindowEx(Handle, (OldOrigin.X - X) * FCharSize.X, (OldOrigin.Y - Y) * FCharSize.Y,
                     nil, @R, 0, @R, 0);
      if Y <> OldOrigin.Y then
        SetScrollPos(Handle, sb_Vert, Y, True);
      if X <> OldOrigin.X then
      SetScrollPos(Handle, sb_Horz, X, True);
      InvalidateRect(Handle, @R, true);
      Update;
      UpdateCaret(true);
    end;
  end;
end;

procedure TJumpMemo.RecalcRange;
var i:Integer;
    oldlinenum,delta:integer;
begin
 try
  if HandleAllocated then
  begin
   if not MaxFound then
   begin
    MaxStrLength:=0;
    for i:=0 to FLines.Count-1 do
     if Length(FLines[i])>MaxStrLength then MaxStrLength:=Length(FLines[i]);
    MaxFound:=true;
   end;
   FClientSize.X := ClientWidth div FCharSize.X;
   FClientSize.Y := ClientHeight div FCharSize.Y;
   FInternBmp.Width:=Max(MaxStrLength*FCharSize.X+10,Width);
   FInternBmp.Height:=ClientHeight;
   FPageSize := FClientSize.Y;
   FRange.X :=Max(0, MaxStrLength-FClientSize.X+1);
   FRange.Y := Max(0, FLines.Count - FClientSize.Y);
   if FLines.Count=0 then Exit;
   if CurentCaretPos.LineNumber>FPageSize-1 then
   begin
    oldlinenum:=CurentCaretPos.LineNumber;
    CurentCaretPos.LineNumber:=FPageSize-1;
    delta:=CurentCaretPos.LineNumber-oldlinenum;
    CurentSelectEnd:=CurentCaretPos;
    ScrollTo(Min(FOrigin.X, FRange.X),FOrigin.Y-delta);
   end
   else ScrollTo(Min(FOrigin.X, FRange.X), Min(FOrigin.Y, FRange.Y));
   SetScrollBars;
   UpdateCaret(True);
  end;
 except
 end;
end;

procedure TJumpMemo.Add(const Str:string);
begin
 try
  FLines.Add(str);
  if FShowPages then
  begin
   RemovePages;
   InsertPages;
  end;
  MaxFound:=false;
  RecalcRange;
  ReadJumps;
  Repaint;
 except MessageBox(0,'      !','',Mb_OK);
 end;
end;

function TJumpMemo.GotoWord(const Str:string;curpos:longint;Up:Boolean):longint;
var wp,i:longint;
    tmpstr:string;
    whlwrd:boolean;
label endwl1,endwl2;
begin
 i:=curpos;
 result:=curpos;
 tmpstr:=str;
 whlwrd:=true;
 if str[Length(Str)]='*' then
 begin
  tmpstr:=Copy(str,1,Length(str)-1);
  whlwrd:=false;
 end;
 if Up=True then
 begin
  while i < FLines.Count do
  begin
   wp:=pos(UpStr(tmpStr),UpStr(FLines[i]));
   if wp>0 then
   begin
    if wp>1 then
    begin
     case FLines[i][wp-1]of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':goto endwl1;
     end;
    end;
    if whlwrd then
    begin
     case FLines[i][wp+Length(tmpstr)]of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':goto endwl1;
     end;
    end;
    InSelect:=false;
    InBlock:=false;
    ScrollTo(Max(0,wp+Length(str)-FClientSize.X),i);
    SetScrollBars;
    with CurentCaretPos do
    begin
     StrNumber:=i;
     LineNumber:=i-FOrigin.Y;
     EnabledIndex:=Length(FLines[i]);
     SimbolIndex:=wp-1;
    end;
    CurentSelectStart:=CurentCaretPos;
    CurentSelectEnd:=CurentCaretPos;
    UpdateCaret(false);
    result:=i;
    exit;
   end;
   endwl1:
   inc(i);
  end;
 end
 else
 begin
  while i >0 do
  begin
   wp:=pos(UpStr(tmpStr),UpStr(FLines[i]));
   if wp>0 then
   begin
    if wp>1 then
    begin
     case FLines[i][wp-1]of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':goto endwl2;
     end;
    end;
    if whlwrd then
    begin
     case FLines[i][wp+Length(tmpstr)]of
     'A'..'Z','a'..'z','0'..'9',''..'',''..'':goto endwl2;
     end;
    end;
    InSelect:=false;
    InBlock:=false;
    ScrollTo(Max(0,wp+Length(str)-FClientSize.X),i);
    SetScrollBars;
    with CurentCaretPos do
    begin
     StrNumber:=i;
     LineNumber:=i-FOrigin.Y;
     EnabledIndex:=Length(FLines[i]);
     SimbolIndex:=wp-1;
    end;
    CurentSelectStart:=CurentCaretPos;
    CurentSelectEnd:=CurentCaretPos;
    UpdateCaret(false);
    result:=i;
    exit;
   end;
   endwl2:
   dec(i);
  end;
 end;
end;

function TJumpMemo.GetPos(const Str:string;curpos:longint):longint;
var wp,i:longint;
begin
 i:=curpos;
 while i < FLines.Count do
 begin
  wp:=pos(UpStr(Str),UpStr(FLines[i]));
  if wp>0 then
  begin
   result:=i;
   exit;
  end;
  inc(i);
 end;
 result:=curpos;
end;

function TJumpMemo.GetCurPos:longint;
begin
 result:=FOrigin.Y;
end;

procedure TJumpMemo.Print(const fn:string;stpg,endpg:longint;infile,allfile:boolean);
var
 Xs,Ys,y,i,Line,pg: longint;
 PrintTextF:System.TextFile;
begin
 if endpg<stpg then
 begin
  MessageBox(0,'Wrong pages range. Call printer procedure again','Error',mb_ok);
  Exit;
 end;
 if infile=true then
 begin
  AssignFile(PrintTextF,fn);
  Rewrite(PrintTextF);
  if allfile=True then
  begin
   for i:=0 to FLines.Count-1 do WriteLn(PrintTextF,FLines[i]);
   System.Close(PrintTextF);
  end
  else
  begin
   for i:=stpg to endpg do
   begin
    Line:=(i-1)*51;
    while Line<(i*51) do
    begin
     if Line=FLines.Count-1 then
     begin
      System.Close(PrintTextF);
      Exit;
     end;
     WriteLn(PrintTextF,FLines[Line]);
     Line:=Line+1;
    end;
   end;
   System.Close(PrintTextF);
   Exit;
  end;
 end
 else
 begin
   Printer.Title:='Printing Doc';
   Printer.BeginDoc;
   Printer.Canvas.Font:=FFont;
   Xs:=(Printer.PageWidth-100)div 80;
   Ys:=(Printer.PageHeight-200)div 51;
   Printer.Canvas.Font.Size:=FFont.Size;
   Xs:=Xs*4;
  if AllFile=True then
  begin
   try
    pg:=1;
    for i:=0 to FLines.Count-1 do
    begin
     Printer.Canvas.TextOut(Xs,i*Ys,FLines[i]);
     if i=FLines.Count-1 then break;
     if i=pg*51 then
     begin
      pg:=pg+1;
      Printer.NewPage;
     end;
    end;
    Printer.EndDoc;
   except
    MessageBox(0,'Can`t put document on printer','Error',mb_Ok);
    Exit;
   end;
   Exit;
  end
  else
  begin
   for i:=stpg to endpg do
   begin
    try
     Line:=(i-1)*51;
     y:=Ys;
     while Line<(i*51) do
     begin
      Printer.Canvas.TextOut(Xs,y,FLines[Line]);
      if (Line=FLines.Count-1)or(Line=(endpg*51)-1) then
      begin
       Printer.EndDoc;
       Exit;
      end;
      y:=y+Ys;
      Line:=Line+1;
     end;
     Printer.NewPage;
    except
     MessageBox(0,'Can`t put document on the printer','Error',mb_Ok);
     Printer.EndDoc;
     Exit;
    end;
   end;
   Printer.EndDoc;
  end;
 end;
end;

function TJumpMemo.GetWord(X,Y:integer):string;
var x1,y1,xw,yw,i,stw,enw:integer;
    unvsstr,tmpw,tmst:string;
    strt:string;
begin
 x1:=x;y1:=y;
 stw:=0;
 enw:=0;
 yw:=FOrigin.Y+(Y1 div FCharSize.Y);
 if yw > FLines.Count-1 then
 begin
  If IsJump then
  begin
   IsJump:=False;
   Screen.Cursor:=crDefault;
  end;
  result:=' ';
  Exit;
 end;
 if Length(FLines[yw])=0 then
 begin
  result:=' ';
  Exit;
 end;
 if x1 > FInternBmp.Canvas.TextWidth(FLines[yw]) then
 begin
  If IsJump then
  begin
   IsJump:=False;
   Screen.Cursor:=crDefault;
  end;
  result:=' ';
  Exit;
 end;
 for xw:=1 to Length(FLines[yw])do
 begin
  tmst:='';
  i:=1;
  for i:=1 to xw-1 do tmst:=tmst+FLines[yw][i];
  if (x1>(FInternBmp.Canvas.TextWidth(tmst)+scx-
                                  FInternBmp.Canvas.TextWidth(FLines[yw][xw])))
      and
      (x1<(FInternBmp.Canvas.TextWidth(tmst)+scx+
                                   FInternBmp.Canvas.TextWidth(FLines[yw][xw])))then break;
 end;
 strt:=FLines[yw];
 tmpw:='';
  for i:=xw downto 1+FOrigin.X do {Searching first division char from the right}
  begin
   if(strt[i]='.')or(strt[i]=',')or(strt[i]=':')or(strt[i]=';')or(strt[i]='-')or(strt[i]='(')or(strt[i]=')')or
     (strt[i]='_')or(strt[i]='#')or(strt[i]='[')or(strt[i]=']')or(strt[i]='{')or(strt[i]='}')or(strt[i]=' ')then stw:=i
   else break;
  end;
  for i:=xw to length(strt) do {Searching division char on the left or EOL }
  begin
   if(strt[i]='.')or(strt[i]=',')or(strt[i]=':')or(strt[i]=';')or(strt[i]='-')or(strt[i]='(')or( strt[i]=')')or
     (strt[i]='_')or(strt[i]='#')or(strt[i]='[')or(strt[i]=']')or(strt[i]='{')or(strt[i]='}')or (strt[i]=' ')then enw:=i
   else break;
  end;
  for i:=stw to enw do
  begin
   tmpw:=tmpw+strt[i];
  end;
 result:=tmpw;
end;

procedure TJumpMemo.MouseMove(Shift:TShiftState;X,Y:Integer);
var i:longint;
    K:word;
    MP:TPoint;
begin
 if FLines.Count>0 then
 begin
  if InSelect then
  begin
   with CurentCaretPos do
   begin
    LineNumber:=Y div FCharSize.Y;
    if LineNumber>FLines.Count-1 then LineNumber:=FLines.Count-1;
    if LineNumber<0 then LineNumber:=0;
    if LineNumber>FPageSize then LineNumber:=FPageSize;
    StrNumber:=FOrigin.Y+LineNumber;
    if StrNumber>FLines.Count-1 then StrNumber:=FLines.Count-1;
    EnabledIndex:=Length(Flines[StrNumber]);
    if X>FInternBmp.Canvas.TextWidth(Flines[StrNumber])then SimbolIndex:=EnabledIndex
    else
    begin
     for i:=1 to Length(Flines[StrNumber]) do
     begin
      if (-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[StrNumber],1,i))>=X then
      begin
       break;
      end;
     end;
     SimbolIndex:=i-1;
    end;
    UpdateCaret(true);
    if Y>ClientHeight-FCharSize.Y then
    begin
     k:=VK_Down;
     while true do
     begin
      try
       if CurentCaretPos.StrNumber=FLines.Count-1 then break;
       GetCursorPos(MP);
       MP:=ScreenToClient(MP);
       if MP.Y<ClientHeight-FCharSize.Y then break;
       KeyDown(k,[ssShift]);
      except
       break;
      end;
     end;
    end;
    if (Y<FCharSize.Y)and (FOrigin.Y>0) then
    begin
     k:=VK_Up;
     while true do
     begin
      try
       if CurentCaretPos.StrNumber=0 then break;
       GetCursorPos(MP);
       MP:=ScreenToClient(MP);
       if MP.Y>FCharSize.Y then break;
       KeyDown(k,[ssShift]);
      except
       break;
      end;
     end;
    end;
    if X>ClientWidth-FCharSize.X then
    begin
     k:=VK_Right;
     while true do
     begin
      try
       GetCursorPos(MP);
       MP:=ScreenToClient(MP);
       if MP.X<ClientWidth-FCharSize.X then break;
       KeyDown(k,[ssShift]);
      except
       break;
      end;
     end;
    end;
    if (X<FCharSize.X)and (FOrigin.X>0) then
    begin
     k:=VK_Left;
     while true do
     begin
      try
       GetCursorPos(MP);
       MP:=ScreenToClient(MP);
       if MP.X>FCharSize.X then break;
       KeyDown(k,[ssShift]);
      except
       break;
      end;
     end;
    end;
   end;
   inherited MouseMove(Shift,X,Y);
   Exit;
  end;
  try
   for i:=0 to FJumps.Count-1 do
   begin
    if TJump(FJumps[i]).OnMe(X,Y,FOrigin,FCharSize)=true then
    begin
     if Cursor<>MyCursor then Cursor:=MyCursor;
     IsJump:=True;
     JmpStr:=TJump(FJumps[i]).JumpName;
     inherited MouseMove(Shift,X,Y);
     Exit;
    end
    else IsJump:=False;
   end;
   if Cursor<>OldCursor then Cursor:=OldCursor;
  except
   MessageBox(0,'     !','',Mb_OK);
   Exit;
  end;
  try
    for i:=0 to FPictures.Count-1 do
    begin
     if TPict(FPictures[i]).OnMe(X,Y,FOrigin,FCharSize)=true then
     begin
      if Cursor<>PictCursor then Cursor:=PictCursor;
      IsPict:=True;
      PictStr:=TPict(FPictures[i]).PictName;
      inherited MouseMove(Shift,X,Y);
      Exit;
     end
     else IsPict:=False;
    end;
   if Cursor<>OldCursor then Cursor:=OldCursor;
  except
   MessageBox(0,'     !','',Mb_OK);
   Exit;
  end;
  inherited MouseMove(Shift,X,Y);
 end;
end;

procedure TJumpMemo.MouseDown(Button: TMouseButton;Shift:TShiftState;X,Y:Integer);
var i:integer;
begin
 if not Focused then Setfocus;
 if (Button=mbLeft) and (not IsJump) and (not IsPict) then
 begin
  with CurentCaretPos do
  begin
   LineNumber:=Y div FCharSize.Y;
   if LineNumber>FLines.Count-1 then LineNumber:=FLines.Count-1;
   if LineNumber<0 then LineNumber:=0;
   StrNumber:=FOrigin.Y+LineNumber;
   EnabledIndex:=Length(Flines[StrNumber]);
   if X>FInternBmp.Canvas.TextWidth(Flines[StrNumber])then SimbolIndex:=EnabledIndex
   else
   begin
    for i:=1 to Length(Flines[StrNumber]) do
    begin
     if (-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[StrNumber],1,i))>=X then
     begin
      break;
     end;
    end;
    SimbolIndex:=i-1;
   end;
  end;
  UpdateCaret(true);
  if InBlock then
  begin
   InSelect:=false;
   InBlock:=false;
{   UnDrawSelection;}
   CurentSelectStart:=CurentCaretPos;
   Repaint;
   if Assigned(FOnDeSelect)then FOnDeSelect(Self);
   InSelect:=True;
   InBlock:=false;
  end
  else
  begin
   InSelect:=True;
   InBlock:=false;
  end;
  CurentSelectEnd:=CurentSelectStart;
  inherited MouseDown(Button,Shift,X,Y);
  Exit;
 end
 else if (Button=mbLeft)and IsJump then JumpClick
 else if (Button=mbLeft)and IsPict then PictClick
 else inherited MouseDown(Button,Shift,X,Y);
end;

procedure TJumpMemo.MouseUp(Button: TMouseButton;Shift:TShiftState;X,Y:Integer);
begin
 InSelect:=false;
 if (CurentSelectStart.StrNumber<>CurentSelectEnd.StrNumber) or
     (CurentSelectStart.SimbolIndex<>CurentSelectEnd.SimbolIndex) then InBlock:=true;
 inherited MouseUp(Button,Shift,X,Y);
end;

procedure TJumpMemo.JumpClick;
begin
  if Assigned(FOnJumpClick)then
  begin
   Screen.Cursor:=crDefault;
   FOnJumpClick(self,JmpStr);
  end;
end;

procedure TJumpMemo.PictClick;
begin
  if Assigned(FOnPictClick)then
  begin
   Screen.Cursor:=crDefault;
   FOnPictClick(self,PictStr);
  end;
end;

function TJumpMemo.Search(srstr:string;Down:boolean):boolean;
var
 i:longint;
 wp,oldwp:integer;
begin
 {Check that searching word not in selword or in jumps}
 result:=False;
 InBlock:=false;
 if Assigned(FOnDeSelect)then FOnDeSelect(self);
{ if FSelWords.Count >0 then
 begin
  for i:=0 to FSelWords.Count-1 do
  if pos(UpStr(srstr),UpStr(FSelWords[i]))>0 then
  begin
   ShowMessage(' !    !');
   Exit;
  end;
 end;
 if JumpList.Count >0 then
 begin
  for i:=0 to JumpList.Count-1 do
  if pos(UpStr(srstr),UpStr(JumpList[i]))>0 then
  begin
   ShowMessage(' !    !');
   Exit;
  end;
 end;}
 if Down then
 begin
  oldwp:=CurentCaretPos.SimbolIndex;
  for i:=CurentCaretPos.StrNumber to FLines.Count-1 do
  begin
   wp:=posfrom(UpStr(srstr),UpStr(FLines[i]),oldwp,false);
   if wp>oldwp then
   begin
    Result:=true;
    CurentSelectStart.StrNumber:=i;
    CurentCaretPos.StrNumber:=i;
    CurentCaretPos.EnabledIndex:=Length(FLines[i]);
    CurentCaretPos.LineNumber:=CurentCaretPos.StrNumber-FOrigin.Y;
    CurentSelectStart.SimbolIndex:=wp-1;
    CurentSelectStart.EnabledIndex:=CurentCaretPos.EnabledIndex;
    CurentCaretPos.SimbolIndex:=wp+Length(srStr)-1;
    if CurentCaretPos.SimbolIndex>FClientSize.X then
    begin
     ScrollTo(CurentCaretPos.SimbolIndex-FClientSize.X+1,0);
     SetScrollBars;
    end;
    CurentSelectStart.LineNumber:=CurentCaretPos.LineNumber;
    CurentSelectEnd:=CurentCaretPos;
    InSelect:=false;
    InBlock:=True;
    UpdateCaret(false);
    Paint;
    if CurentCaretPos.LineNumber>=FPageSize then
    begin
     ScrollTo(0,FOrigin.Y+(CurentCaretPos.LineNumber-FPageSize+1));
     CurentCaretPos.LineNumber:=FPageSize-1;
    end;
    if Assigned(FOnSelect)then FOnSelect(self);
    Exit;
   end;
   oldwp:=0;
  end;
 end
 else
 begin
  oldwp:=CurentCaretPos.SimbolIndex;
  for i:=CurentCaretPos.StrNumber downto 0 do
  begin
   wp:=posfrom(UpStr(srstr),UpStr(FLines[i]),oldwp,false);
   if wp>oldwp then
   begin
    Result:=true;
    CurentSelectStart.StrNumber:=i;
    CurentCaretPos.StrNumber:=i;
    CurentCaretPos.EnabledIndex:=Length(FLines[i]);
    CurentCaretPos.LineNumber:=CurentCaretPos.StrNumber-FOrigin.Y;
    CurentSelectStart.SimbolIndex:=wp-1;
    CurentSelectStart.EnabledIndex:=CurentCaretPos.EnabledIndex;
    CurentCaretPos.SimbolIndex:=wp+Length(srStr)-1;
    if CurentCaretPos.SimbolIndex>FClientSize.X then
    begin
     ScrollTo(CurentCaretPos.SimbolIndex-FClientSize.X+1,0);
     SetScrollBars;
    end;
    CurentSelectStart.LineNumber:=CurentCaretPos.LineNumber;
    CurentSelectEnd:=CurentCaretPos;
    InSelect:=false;
    InBlock:=True;
    UpdateCaret(false);
    Paint;
    if CurentCaretPos.LineNumber<=0 then
    begin
     ScrollTo(0,FOrigin.Y+CurentCaretPos.LineNumber);
     CurentCaretPos.LineNumber:=0;
    end;
    if Assigned(FOnSelect)then FOnSelect(self);
    Exit;
   end;
   oldwp:=0;
  end;
 end;
 Repaint;
end;

procedure TJumpMemo.ReadJumps;
var
 n,wp,oldp,ep,jump,i,j:longint;
 index:integer;
 tmpstr,tmpwrd:string;
begin
 if FJumps.Count>0 then
 for i:=0 to FJumps.Count-1 do TJump(FJumps[i]).Free;
 if FPictures.Count>0 then
 for i:=0 to FPictures.Count-1 do TPict(FPictures[i]).Free;
 FJumps.Clear;
 FPictures.Clear;
 JumpList.Clear;
 if FUseJumpPointLength=true then ep:=FJumpLength;
 if FLines.Count=0then Exit;
 for i:=0 to FLines.Count-1 do
 begin
  if not FUseJumpPointLength then ep:=Length(FLines[i]);
  oldp:=0;
  while true do
  begin
   wp:=posfrom('~',FLines[i],oldp,false);
   if wp>oldp then
   begin
    oldp:=wp+1;
    tmpstr:='';
    for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[i][n];
    tmpwrd:='';
    for n:=wp+1 to Length(FLines[i]) do
    begin
     case FLines[i][n] of
     'a'..'z','A'..'Z',''..'',''..'','0'..'9':
      tmpwrd:=tmpwrd+FLines[i][n];
      else break;
     end;
    end;
    FJumps.Add(TJump.Create(tmpwrd,i,FInternBmp.Canvas.TextWidth(tmpstr+'~')-FOrigin.X*FCharsize.X,i*FCharSize.Y,
                            FInternBmp.Canvas.TextWidth(tmpwrd),FInternBmp.Canvas.TextHeight(tmpwrd)));
    if not JumpList.Find(tmpwrd,index)then JumpList.Add(tmpwrd);
   end
   else break;
  end;
  oldp:=0;
  while true do
  begin
   wp:=posfrom('^',FLines[i],oldp,false);
   if wp>oldp then
   begin
    oldp:=wp+1;
    tmpstr:='';
    for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[i][n];
    tmpwrd:='';
    for n:=wp+1 to Length(FLines[i]) do
    begin
     case FLines[i][n] of
     'a'..'z','A'..'Z',''..'',''..'','0'..'9','_','.':
      tmpwrd:=tmpwrd+FLines[i][n];
      else break;
     end;
    end;
    FPictures.Add(TPict.Create(tmpwrd,i,FInternBmp.Canvas.TextWidth(tmpstr+'^')-FOrigin.X*FCharsize.X,i*FCharSize.Y,
                            FInternBmp.Canvas.TextWidth(tmpwrd),FInternBmp.Canvas.TextHeight(tmpwrd)));
   end
   else break;
  end;
 end;
end;

procedure TJumpMemo.InsertPages;
var
 i,pgc:longint;
begin
 MaxFound:=False;
 pgc:=FLines.Count div 50;
 PageCount:=pgc+1;
 for i:=0 to pgc do
 begin
  try
   FLines.Insert((i*50)+i,'- '+FPageMarker+' '+IntToStr(i+1)+' -');
  except MessageBox(0,'     !','',Mb_OK);
   ReadJumps;
   RecalcRange;
   exit;
  end;
 end;
 ReadJumps;
 RecalcRange;
end;

procedure TJumpMemo.RemovePages;
var i:longint;
begin
 MaxFound:=False;
 for i:=FLines.Count-1 downto 0 do
 begin
  try
   if pos('- '+FPageMarker+' ',FLines[i])>0 then FLines.Delete(i);
  except MessageBox(0,'     !','',Mb_OK);
   PageCount:=(FLines.Count div 50)+1;
   ReadJumps;
   RecalcRange;
   exit;
  end;
 end;
 PageCount:=(FLines.Count div 50)+1;
 ReadJumps;
 RecalcRange;
end;

procedure TJumpMemo.SetPageMarker(Value:string);
begin
 if FPageMarker<>Value then
 begin
  FPageMarker:=Value;
  if FShowPages then
  begin
   RemovePages;
   InsertPages;
  end;
  Repaint;
 end;
end;

procedure TJumpMemo.SetShowPages(Value:boolean);
begin
 if FShowPages<>Value then
 begin
  FShowPages:=Value;
  if FShowPages then
  begin
   InsertPages;
  end
  else
  begin
   RemovePages;
  end
 end;
 Repaint;
end;

{This function copy the selected range into clipboard
and then it return the number of copied bytes or zero if not}
function TJumpMemo.CopyToClipboard:longint;
var BufLength,i,sx1,sx2,sy1,sy2:longInt;
    GlobAlloc:THandle;
    ClipBuf:PChar;
    TempBuf:array[0..255]of char;
    tmpstr:string;
begin
 result:=0;
 if not InBlock then Exit;
 if CurentSelectStart.StrNumber<CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  sx1:=CurentSelectStart.SimbolIndex;
  sx2:=CurentSelectEnd.SimbolIndex;
 end
 else if CurentSelectStart.StrNumber>CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectEnd.StrNumber;
  sy2:=CurentSelectStart.StrNumber;
  sx1:=CurentSelectEnd.SimbolIndex;
  sx2:=CurentSelectStart.SimbolIndex;
 end
 else
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  if CurentSelectStart.SimbolIndex<=CurentSelectEnd.SimbolIndex then
  begin
   sx1:=CurentSelectStart.SimbolIndex;
   sx2:=CurentSelectEnd.SimbolIndex;
  end
  else
  begin
   sx1:=CurentSelectEnd.SimbolIndex;
   sx2:=CurentSelectStart.SimbolIndex;
  end;
 end;
 BufLength:=0;
 if sy1=sy2 then BufLength:=sx2-sx1
 else
 begin
  BufLength:=BufLength+Length(FLines[sy1])-sx1+2;
  for i:=sy1+1 to sy2-1 do BufLength:=BufLength+Length(FLines[i])+2;
  Buflength:=BufLength+sx2+2;
 end;
 BufLength:=BufLength+1;
 GlobAlloc:=GlobalAlloc(GMEM_MOVEABLE,BufLength);
 if GlobAlloc=0 then Exit;
 ClipBuf:=GlobalLock(GlobAlloc);
 if ClipBuf=nil then
 begin
  GlobalFree(GlobAlloc);
  InSelect:=false;
  Exit;
 end;
 StrCopy(ClipBuf,'');
 if sy1=sy2 then
 begin
  tmpStr:=Copy(FLines[sy1],sx1+1,sx2-sx1);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)=0 then StrPCopy(Clipbuf,tmpstr);
 end
 else
 begin
   StrCopy(TempBuf,'');
   tmpStr:=Copy(FLines[sy1],sx1+1,Length(FLines[sy1])-sx1);
   while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
   while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
   StrPCopy(TempBuf,tmpstr+#13+#10);
   if Pos('- '+FPageMarker,tmpstr)=0 then StrCat(Clipbuf,TempBuf);
   for i:=sy1+1 to sy2-1 do
   begin
    tmpStr:=FLines[i];
    while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
    while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
    StrPCopy(TempBuf,tmpstr+#13+#10);
    if Pos('- '+FPageMarker,tmpstr)=0 then StrCat(Clipbuf,TempBuf);
   end;
   tmpStr:=Copy(FLines[sy2],1,sx2);
   while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
   while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
   StrPCopy(TempBuf,tmpstr);
   if Pos('- '+FPageMarker,tmpstr)=0 then StrCat(Clipbuf,TempBuf);
 end;
 if not OpenClipboard(Application.Handle)then
 begin
  GlobalUnLock(GlobAlloc);
  GlobalFree(GlobAlloc);
  Exit;
 end;
 if not EmptyClipboard then
 begin
  CloseClipboard;
  GlobalUnLock(GlobAlloc);
  GlobalFree(GlobAlloc);
  Exit;
 end;
 if SetClipboardData(CF_TEXT,GlobAlloc)=0 then
 begin
  CloseClipboard;
  GlobalUnLock(GlobAlloc);
  GlobalFree(GlobAlloc);
  Exit;
 end;
 CloseClipboard;
 GlobalUnLock(GlobAlloc);
 if Assigned(FOnCopyToClipboard)then FOnCopyToClipboard(self,BufLength);
 InBlock:=false;
 InSelect:=false;
 CurentSelectStart:=CurentCaretPos;
 CurentSelectEnd:=CurentCaretPos;
 Paint;
 if Assigned(FOnDeSelect)then FOnDeSelect(self);
 result:=BufLength;
end;

procedure TJumpMemo.UpdateCaret(FromMouse:boolean);
var n,wp,oldwp,swc,j,I:longint;
    tmpstr:string;
    sy1,sy2:longint;
    selwrd,tmpwrd:string;
    wholword:boolean;
begin
 if FLines.Count=0 then
 begin
  SetCaretPos((-FOrigin.X*FCharSize.X)+4,1);
  Exit;
 end;
 swc:=FSelWords.Count;
 with CurentCaretPos do
 begin
  if EnabledIndex>SimbolIndex then SetCaretPos((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[StrNumber],1,
     SimbolIndex)),(StrNumber-FOrigin.Y)*FCharSize.Y+1)
  else SetCaretPos((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[StrNumber],1,
       EnabledIndex)),(StrNumber-FOrigin.Y)*FCharSize.Y+1);
  LineNumber:=StrNumber-FOrigin.Y;
 end;
 if not InSelect then
 begin
  if not InBlock then CurentSelectStart:=CurentCaretPos;
 end
 else
 begin
  if(CurentCaretPos.SimbolIndex=CurentSelectEnd.SimbolIndex)and
    (CurentCaretPos.StrNumber=CurentSelectEnd.StrNumber)then Exit;
  HideCaret(Handle);
  if FromMouse then
  begin
   if CurentCaretPos.StrNumber>CurentSelectEnd.StrNumber then
   begin
    sy1:=CurentSelectEnd.StrNumber;
    sy2:=CurentCaretPos.StrNumber;
   end
   else
   begin
    sy2:=CurentSelectEnd.StrNumber;
    sy1:=CurentCaretPos.StrNumber;
   end;
   for i:=sy1 to sy2 do
   begin
    tmpStr:=Flines[i];
    while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
    while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
    if Pos('- '+FPageMarker,tmpstr)>0 then
    begin
     FInternBmp.Canvas.Font.Color:=clBlue;
     FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *(i-FOrigin.Y),tmpstr);
     FInternBmp.Canvas.Font.Color:=FFont.Color;
    end
    else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *(i-FOrigin.Y),tmpstr);
    if swc>0 then
    begin
     FInternBmp.Canvas.Font.Color:=FSelColor;
     for j:=0 to swc-1 do
     begin
      oldwp:=0;
      while true do
      begin
       wholword:=true;
       selwrd:=FSelWords[j];
       if selwrd[Length(selwrd)]='*'then
       begin
        wholword:=false;
        selwrd:=Copy(selwrd,1,Length(selwrd)-1);
       end;
       wp:=posfrom(UpStr(selwrd),UpStr(FLines[i]),oldwp,wholword);
       if wp>oldwp then
        begin
        oldwp:=wp+Length(selwrd);
        tmpstr:='';
        for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[i][n];
        tmpwrd:='';
        for n:=wp to wp+Length(selwrd)-1 do tmpwrd:=tmpwrd+FLines[i][n];
         FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(tmpstr),
         (i-FOrigin.Y)*FCharSize.Y,tmpwrd);
       end
       else break;
      end;
     end;
     FInternBmp.Canvas.Font.Color:=FFont.Color;
    end;
   end;
  end
  else
  begin
   tmpStr:=Flines[CurentSelectEnd.StrNumber];
   while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
   while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
   if Pos('- '+FPageMarker,tmpstr)>0 then
   begin
     FInternBmp.Canvas.Font.Color:=clBlue;
     FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *(CurentSelectEnd.StrNumber-FOrigin.Y),tmpstr);
     FInternBmp.Canvas.Font.Color:=FFont.Color;
   end
   else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *(CurentSelectEnd.StrNumber-FOrigin.Y),tmpstr);
   if swc>0 then
   begin
    FInternBmp.Canvas.Font.Color:=FSelColor;
    for j:=0 to swc-1 do
    begin
     oldwp:=0;
     while true do
     begin
      wholword:=true;
      selwrd:=FSelWords[j];
      if selwrd[Length(selwrd)]='*'then
      begin
       wholword:=false;
       selwrd:=Copy(selwrd,1,Length(selwrd)-1);
      end;
      wp:=posfrom(UpStr(selwrd),UpStr(FLines[CurentSelectEnd.StrNumber]),oldwp,wholword);
      if wp>oldwp then
       begin
       oldwp:=wp+Length(selwrd);
       tmpstr:='';
       for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[CurentSelectEnd.StrNumber][n];
       tmpwrd:='';
       for n:=wp to wp+Length(selwrd)-1 do tmpwrd:=tmpwrd+FLines[CurentSelectEnd.StrNumber][n];
        FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(tmpstr),
        (CurentSelectEnd.StrNumber-FOrigin.Y)*FCharSize.Y,tmpwrd);
      end
      else break;
     end;
    end;
    FInternBmp.Canvas.Font.Color:=FFont.Color;
   end;
  end;
  CurentSelectEnd:=CurentCaretPos;
  tmpStr:=Flines[CurentSelectEnd.StrNumber];
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *CurentSelectEnd.LineNumber,tmpstr);
   FInternBmp.Canvas.Font.Color:=FFont.Color;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y *CurentSelectEnd.LineNumber,tmpstr);
  if swc>0 then
  begin
   FInternBmp.Canvas.Font.Color:=FSelColor;
   for j:=0 to swc-1 do
   begin
    oldwp:=0;
    while true do
    begin
     wholword:=true;
     selwrd:=FSelWords[j];
     if selwrd[Length(selwrd)]='*'then
     begin
      wholword:=false;
      selwrd:=Copy(selwrd,1,Length(selwrd)-1);
     end;
     wp:=posfrom(UpStr(selwrd),UpStr(FLines[CurentSelectEnd.StrNumber]),oldwp,wholword);
     if wp>oldwp then
      begin
      oldwp:=wp+Length(selwrd);
      tmpstr:='';
      for n:=1 to wp-1 do tmpstr:=tmpstr+FLines[CurentSelectEnd.StrNumber][n];
      tmpwrd:='';
      for n:=wp to wp+Length(selwrd)-1 do tmpwrd:=tmpwrd+FLines[CurentSelectEnd.StrNumber][n];
       FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(tmpstr),
       (CurentSelectEnd.StrNumber-FOrigin.Y)*FCharSize.Y,tmpwrd);
     end
     else break;
    end;
   end;
   FInternBmp.Canvas.Font.Color:=FFont.Color;
  end;
  ShowCaret(Handle);
  if Assigned(FOnSelect)then FOnSelect(Self);
  if (CurentSelectStart.StrNumber<>CurentSelectEnd.StrNumber) or
     (CurentSelectStart.SimbolIndex<>CurentSelectEnd.SimbolIndex) then DrawSelection;
 end;
end;

procedure TJumpMemo.DrawSelection;
var sx1,sx2,sy1,sy2,i:longint;
    tmpstr:string;
begin
 HideCaret(Handle);
 FInternBmp.Canvas.Brush.Color:=clHighlight;
 FInternBmp.Canvas.Font.Color:=clHighlightText;
 if CurentSelectStart.StrNumber<CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  sx1:=CurentSelectStart.SimbolIndex;
  sx2:=CurentSelectEnd.SimbolIndex;
 end
 else if CurentSelectStart.StrNumber>CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectEnd.StrNumber;
  sy2:=CurentSelectStart.StrNumber;
  sx1:=CurentSelectEnd.SimbolIndex;
  sx2:=CurentSelectStart.SimbolIndex;
 end
 else
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  if CurentSelectStart.SimbolIndex<=CurentSelectEnd.SimbolIndex then
  begin
   sx1:=CurentSelectStart.SimbolIndex;
   sx2:=CurentSelectEnd.SimbolIndex;
  end
  else
  begin
   sx1:=CurentSelectEnd.SimbolIndex;
   sx2:=CurentSelectStart.SimbolIndex;
  end;
 end;
 if (sy2-sy1)>0 then
 begin
  tmpstr:=Copy(FLines[sy1],sx1+1,Length(FLines[sy1])-sx1);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
  for i:=sy1+1 to sy2-1 do
  begin
   if (i-FOrigin.Y>=0) and (i-FOrigin.Y<=FPageSize) then
   begin
    tmpstr:=FLines[i];
    while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
    while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
    if Pos('- '+FPageMarker,tmpstr)>0 then
    begin
     FInternBmp.Canvas.Font.Color:=clBlue;
     FInternBmp.Canvas.Brush.Color:=FColor;
     FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y*(i-FOrigin.Y),tmpstr);
     FInternBmp.Canvas.Brush.Color:=clHighlight;
     FInternBmp.Canvas.Font.Color:=clHighlightText;
    end
    else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y*(i-FOrigin.Y),tmpstr);
   end;
  end;
  tmpstr:=Copy(FLines[sy2],1,sx2);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,
                 FCharSize.Y*(sy2-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,
                 FCharSize.Y*(sy2-FOrigin.Y),tmpstr);
 end
 else
 begin
  tmpstr:=Copy(FLines[sy1],sx1+1,sx2-sx1);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
 end;
 FInternBmp.Canvas.Brush.Color:=FColor;
 FInternBmp.Canvas.Font.Color:=FFont.Color;
 Canvas.Draw(0,0,FInternBmp);
 ShowCaret(Handle);
end;

procedure TJumpMemo.UnDrawSelection;
var sx1,sx2,sy1,sy2,i:longint;
    tmpstr:string;
begin
 HideCaret(Handle);
 FInternBmp.Canvas.Brush.Color:=FColor;
 FInternBmp.Canvas.Font.Color:=FFont.Color;
 if CurentSelectStart.StrNumber<CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  sx1:=CurentSelectStart.SimbolIndex;
  sx2:=CurentSelectEnd.SimbolIndex;
 end
 else if CurentSelectStart.StrNumber>CurentSelectEnd.StrNumber then
 begin
  sy1:=CurentSelectEnd.StrNumber;
  sy2:=CurentSelectStart.StrNumber;
  sx1:=CurentSelectEnd.SimbolIndex;
  sx2:=CurentSelectStart.SimbolIndex;
 end
 else
 begin
  sy1:=CurentSelectStart.StrNumber;
  sy2:=CurentSelectEnd.StrNumber;
  if CurentSelectStart.SimbolIndex<=CurentSelectEnd.SimbolIndex then
  begin
   sx1:=CurentSelectStart.SimbolIndex;
   sx2:=CurentSelectEnd.SimbolIndex;
  end
  else
  begin
   sx1:=CurentSelectEnd.SimbolIndex;
   sx2:=CurentSelectStart.SimbolIndex;
  end;
 end;
 if (sy2-sy1)>0 then
 begin
  tmpstr:=Copy(FLines[sy1],sx1+1,Length(FLines[sy1])-sx1);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
  for i:=sy1+1 to sy2-1 do
  begin
   if (i-FOrigin.Y>=0) and (i-FOrigin.Y<=FPageSize) then
   begin
    tmpstr:=FLines[i];
    while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
    while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
    if Pos('- '+FPageMarker,tmpstr)>0 then
    begin
     FInternBmp.Canvas.Font.Color:=clBlue;
     FInternBmp.Canvas.Brush.Color:=FColor;
     FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y*(i-FOrigin.Y),tmpstr);
     FInternBmp.Canvas.Brush.Color:=clHighlight;
     FInternBmp.Canvas.Font.Color:=clHighlightText;
    end
    else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,FCharSize.Y*(i-FOrigin.Y),tmpstr);
   end;
  end;
  tmpstr:=Copy(FLines[sy2],1,sx2);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,
                 FCharSize.Y*(sy2-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4,
                 FCharSize.Y*(sy2-FOrigin.Y),tmpstr);
 end
 else
 begin
  tmpstr:=Copy(FLines[sy1],sx1+1,sx2-sx1);
  while Pos('~', tmpstr) > 0 do Tmpstr[Pos('~', tmpstr)] := ' ';
  while Pos('^', tmpstr) > 0 do Tmpstr[Pos('^', tmpstr)] := ' ';
  if Pos('- '+FPageMarker,tmpstr)>0 then
  begin
   FInternBmp.Canvas.Font.Color:=clBlue;
   FInternBmp.Canvas.Brush.Color:=FColor;
   FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
   FInternBmp.Canvas.Brush.Color:=clHighlight;
   FInternBmp.Canvas.Font.Color:=clHighlightText;
  end
  else FInternBmp.Canvas.TextOut((-FOrigin.X*FCharSize.X)+4+FInternBmp.Canvas.TextWidth(Copy(FLines[sy1],1,sx1)),
                 FCharSize.Y*(sy1-FOrigin.Y),tmpstr);
 end;
 FInternBmp.Canvas.Brush.Color:=FColor;
 FInternBmp.Canvas.Font.Color:=FFont.Color;
 Canvas.Draw(0,0,FInternBmp);
 ShowCaret(Handle);
end;

procedure Register;
begin
  RegisterComponents('AK Soft', [TJumpMemo]);
end;

end.
