unit Jbmbtn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Menus;

const
  nullchar = chr(0);

type
  TMenuBitBtn = class(TBitBtn)
  private
    FPopUpMenu: TPopupMenu;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
 public
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  published
    property MenuPopup: TPopupMenu read FPopupMenu write FPopupMenu;
  end;

type
  TMenuButton = class(TButton)
  private
    FPopUpMenu: TPopupMenu;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
  public
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
        X, Y: Integer); override;
  published
    property MenuPopup: TPopupMenu read FPopupMenu write FPopupMenu;
  end;

type
  TListBitBtn = class(TBitBtn)
  private
    FItems: TStrings;
    FItemIndex: Integer;
    FOnChange: TNotifyEvent;
    FItemChecked: Boolean;
    procedure SetItems(Items: TStrings);
    procedure WMCommand(var Message: TMessage); message WM_COMMAND;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
  public
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    constructor Create(AOwner: TComponent); override;
    destructor destroy; override;
  published
    property Items: TStrings read FItems write SetItems;
    property ItemIndex: Integer read FItemIndex write FItemIndex;
    property ItemChecked: Boolean read FItemChecked write FItemChecked;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;

  type
  TListButton = class(TButton)
  private
    FItems: TStrings;
    FItemIndex: Integer;
    FOnChange: TNotifyEvent;
    FItemChecked: Boolean;
    procedure SetItems(Items: TStrings);
    procedure WMCommand(var Message: TMessage); message WM_COMMAND;
    procedure WMChar(var Message: TWMChar); message WM_CHAR;
  public
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    constructor Create(AOwner: TComponent); override;
    destructor destroy; override;
  published
    property Items: TStrings read FItems write SetItems;
    property ItemIndex: Integer read FItemIndex write FItemIndex;
    property ItemChecked: Boolean read FItemChecked write FItemChecked;
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TMenuBitBtn]);
  RegisterComponents('Samples', [TMenuButton]);
  RegisterComponents('Samples', [TListBitBtn]);
  RegisterComponents('Samples', [TListButton]);
end;


{-----------------------------------------------------------------------------
 TListBitBtn
-----------------------------------------------------------------------------}

constructor TListBitBtn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Fitems := TStringList.Create;
  ItemIndex := -1;
end;

destructor TListBitBtn.Destroy;
begin
  Fitems.Free;
  Inherited destroy;
end;

procedure TListBitBtn.WMChar(var Message: TWMChar);
begin
  if Message.CharCode = VK_SPACE Then PostMessage(Handle,WM_LBUTTONDOWN,0,0)
  else inherited;
end;

procedure TListBitBtn.SetItems(Items: TStrings);
begin
  FItems.Assign(Items);
end;

procedure TListBitBtn.WMCommand(var Message: TMessage);
begin
  FItemIndex := Message.wParam;
  if Assigned(FonChange) Then FOnChange(Self);
end;

procedure TListBitBtn.MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
var
pc,pd: TPoint;
hMyMenu: Hmenu;
i: Integer;
CCaption: array[0..255] of Char;
begin

  inherited MouseDown(Button, Shift, X, Y);

  If Fitems.Count >=1 Then Begin
    { Create Menu }
    hMyMenu := CreatePopupMenu;
    For i := 1 to FItems.Count Do
      if FItems[i-1] = '-' then
        appendmenu(HMyMenu,MF_MENUBREAK,i-1,nil)
      else begin
        StrPCopy(CCaption,FItems[i-1]);
        if (FItemChecked) and (ItemIndex = i-1) then
          AppendMenu(HMyMenu,MF_STRING or MF_CHECKED,i-1,CCaption)
        else
          AppendMenu(HMyMenu,MF_STRING,i-1,CCaption);
      end;

    { Calculate Screen Co-ordiantes}
    pc.x := left;
    pc.y := top + Height;
    With (Owner as TForm) do pd := ClientToScreen(pc);
    TrackPopupMenu(HMyMenu,TPM_LEFTALIGN,pd.x,pd.y,0,Handle,nil);
    DestroyMenu(HMyMenu);
    PostMessage(Handle,WM_LBUTTONUP,0,0);
  end;
end;

{-----------------------------------------------------------------------------
 TListButton
-----------------------------------------------------------------------------}


constructor tlistbutton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Fitems := TStringList.Create;
  ItemIndex := -1;
end;

destructor tlistbutton.Destroy;
begin
  Fitems.Free;
  Inherited destroy;
end;

procedure TListButton.WMChar(var Message: TWMChar);
begin
  if Message.CharCode = VK_SPACE Then PostMessage(Handle,WM_LBUTTONDOWN,0,0)
  else inherited;
end;

procedure tlistbutton.SetItems(Items: TStrings);
begin
  FItems.Assign(Items);
end;

procedure tlistbutton.WMCommand(var Message: TMessage);
begin
  FItemIndex := Message.wParam;
  if Assigned(FonChange) Then FOnChange(Self);
end;

procedure tlistbutton.MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
var
pc,pd: TPoint;
hMyMenu: Hmenu;
i: Integer;
CCaption: array[0..255] of Char;
begin

  inherited MouseDown(Button, Shift, X, Y);

  If Fitems.Count >=1 Then Begin
    { Create Menu }
    hMyMenu := CreatePopupMenu;
    For i := 1 to FItems.Count Do
      if FItems[i-1] = '-' then
        appendmenu(HMyMenu,MF_MENUBREAK,i-1,nil)
      else begin
        StrPCopy(CCaption,FItems[i-1]);
        if (FItemChecked) and (ItemIndex = i-1) then
          AppendMenu(HMyMenu,MF_STRING or MF_CHECKED,i-1,CCaption)
        else
          AppendMenu(HMyMenu,MF_STRING,i-1,CCaption);
      end;

    { Calculate Screen Co-ordiantes}
    pc.x := left;
    pc.y := top + Height;
    With (Owner as TForm) do pd := ClientToScreen(pc);
    TrackPopupMenu(HMyMenu,TPM_LEFTALIGN,pd.x,pd.y,0,Handle,nil);
    DestroyMenu(HMyMenu);
    PostMessage(Handle,WM_LBUTTONUP,0,0);
  end;
end;

{-----------------------------------------------------------------------------
 TMenuBitBtn
-----------------------------------------------------------------------------}

procedure TMenuBitBtn.WMChar(var Message: TWMChar);
begin
  if Message.CharCode = VK_SPACE Then PostMessage(Handle,WM_LBUTTONDOWN,0,0)
  else inherited;
end;


procedure TMenuBitBtn.MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
var
pc,pd: TPoint;
begin

  inherited MouseDown(Button, Shift, X, Y);

  If Assigned(FPopupMenu) Then Begin
    pc.x := left;
    pc.y := top + Height;
    With (Owner as TForm) do pd := ClientToScreen(pc);
    FPopupMenu.Popup(pd.x,pd.y);
    PostMessage(Handle,WM_LBUTTONUP,0,0);
  end;
end;

{-----------------------------------------------------------------------------
 TMenuButton
-----------------------------------------------------------------------------}

procedure TMenuButton.WMChar(var Message: TWMChar);
begin
  if Message.CharCode = VK_SPACE Then PostMessage(Handle,WM_LBUTTONDOWN,0,0)
  else inherited;
end;

procedure TMenuButton.MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
var
pc,pd: TPoint;
begin

  inherited MouseDown(Button, Shift, X, Y);

  If Assigned(FPopupMenu) Then Begin
    pc.x := left;
    pc.y := top + Height;
    With (Owner as TForm) do pd := ClientToScreen(pc);
    FPopupMenu.Popup(pd.x,pd.y);
    PostMessage(Handle,WM_LBUTTONUP,0,0);
  end;
end;


end.
