unit Profil;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
	TProfileAction = (paRead, paWrite);
	Str64 = String[64];

	TProfile = class(TComponent)
	private
		FCategory : str64;
		FKeyName : str64;
		FDefault : str64;
		FDataString : str64;
		FFileName : str64;
		FAction : TProfileAction;
		FError : word;
		{ Private-dclarations }
	protected
		{ Protected-dclarations }
	public
		{ Public-dclarations }
		function Execute : Boolean;
	published
		property Category : str64 read FCategory write FCategory;
		property KeyName : str64 read FKeyName write FKeyName;
		property DefaultValue : str64 read FDefault write FDefault;
		property DataString : str64 read FDataString write FDataString;
		property IniFileName : str64 read FFileName write FFileName;
		property Action : TProfileAction read FAction write FAction;
		property Error : word read FError;
	end;

procedure Register;

implementation

procedure Register;
begin
	RegisterComponents('Exemples', [TProfile]);
end;

Function TProfile.Execute : Boolean;
type
	sz64 = array[0..63] of char;
var
	 szCategory : sz64;
	 szKeyName : sz64;
	 szDefault : sz64;
	 szDataString : array[0..255] of char;
	 szFileName : sz64;
	 ret : integer;
	 ok, did : bool;

begin
	ret := 0;
	ok := true;
	did := false;
	FError := 0;
	if FCategory = '' then ok := false;
	if FKeyName  = '' then ok := false;
	if FFileName = '' then ok := false;

	strPCopy (szCategory, FCategory);
	strPCopy (szKeyName,  FKeyName);
	strPCopy (szFileName, FFileName);
	if FDefault <> ''
	then strPCopy(szDefault, FDefault)
	else strPCopy(szDefault, ' ');

	if ok then
	case FAction of
		paRead :
		begin
			ret := GetPrivateProfileString (szCategory, szKeyName,
										szDefault, szDataString, 256, szFileName);
			FDataString := StrPas(szDataString);
		end;
		paWrite :
		begin
			strPCopy(szDataString, FDataString);
			did := WritePrivateProfileString (szCategory, szKeyName,
										szDataString, szFileName);
		end;
	end;
	if (ret > 0) or did then Execute := true
	else begin
		Execute := False;
		FError := 1;
	end;
end;


end.
