{*************************************************}
{                                                 }
{  IniBoxes - example                           }
{                                                 }
{  This example program demonstrates how to use   }
{  the Delphi component TIniCombo.                }
{  You will use the TIniListBox in the same way.  }
{  The IniCombo is a decendant of TComboBox, and  }
{  will let you save/load its items to/from disk, }
{  using an INI file or the Windows registry.     }
{                                                 }
{  The example program also shows how to check if }
{  an item already exists when about to add it.   }
{                                                 }
{  The component is freeware, and you use it and  }
{  this program as you wish, on your own risk.    }
{                                                 }
{  Daniel Jensen                                  }
{                                                 }
{*************************************************}

unit Unit1;

interface

uses
  Dialogs, SysUtils,Classes,Controls,Forms,IniCombo, ExtCtrls, StdCtrls, Buttons,
  IniBoxes;

type

  TForm1 = class(TForm)
    IniCombo1: TIniCombo;
    SpeedButton1: TSpeedButton;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Bevel1: TBevel;
    CheckBox1: TCheckBox;
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.SpeedButton1Click(Sender: TObject);
var
  I : Integer;
  AddItem : Boolean;
begin
  {This will add an item to the Combobox.}
  {If the checkbox is checked, an existing}
  {item will NOT be added.}
  AddItem := TRUE;
  if CheckBox1.Checked then
    for i:=0 to IniCombo1.Items.Count-1 do
      if  IniCombo1.Text = IniCombo1.Items[i]then AddItem := FALSE;
  if AddItem then IniCombo1.Items.Add( IniCombo1.Text );
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  {Save all items to INI}
  ShowMessage('Saving items to '+IniCombo1.IniFile
  +'['+IniCombo1.IniSection+']');
  IniCombo1.SaveToIni;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  {Save all items to registry}
  if Copy(IniCombo1.RegKey,Length(IniCombo1.RegKey),1)='\' then
    ShowMessage('Saving items to '+IniCombo1.RegKey
  +IniCombo1.RegSubKey)
  else
    ShowMessage('Saving items to '+IniCombo1.RegKey
  +'\'+IniCombo1.RegSubKey);
  IniCombo1.SaveToRegistry;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  {Load data from INI}
  ShowMessage('Loading items from '+IniCombo1.IniFile
  +'['+IniCombo1.IniSection+']');
  IniCombo1.LoadFromIni;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  {Load data from registry}
  if Copy(IniCombo1.RegKey,Length(IniCombo1.RegKey),1)='\' then
    ShowMessage('Loading items from '+IniCombo1.RegKey
  +IniCombo1.RegSubKey)
  else
    ShowMessage('Loading items from '+IniCombo1.RegKey
  +'\'+IniCombo1.RegSubKey);
  IniCombo1.LoadFromRegistry;
end;

end.
