{

  * INIBOXES *

  TIniCombo (v2) and TIniListBox
  These two similar components will let you save/load data easily,
  using INI files or the Windows registry. 

  There are four new methods:
  
  SaveToIni (procedure)		Saves all items to an INI file
  LoadFromIni (procedure)	Loads data from an INI file
  SaveToRegistry (procedure)	Saves all items to the registry
  LoadFromRegistry (procedure)	Loads data from the registry

  and four new properties:

  INIfile (string)		The INI-file to use
  INIsection (string)		Section in INIfile to save data to
  RegKey (string)		The path in registry to the subkey
  RegSubKey (string)		The subkey in wich values are stored

  Both components are handled in the same way, and are very similar.

  This unit is freeware.
  Send comments, questions, and bug reports to me;
  Daniel Jensen (nocomply@as-if.com)

  New in version 2 of TIniCombo:

  Registry - now you can save your items to the windows registry
  Added IniSection property (thanks Scott :)

}

unit IniBoxes;

interface

uses
  Windows, SysUtils, Classes, Controls, Stdctrls, IniFiles, Registry;


type

  TIniCombo = class(TComboBox)
    private
        IniFil : TIniFile;
        Reg : TRegIniFile;
        FINIfile : String;
        FINIsection : String;
        FRegKey : String;
        FRegSubKey : String;
        procedure AutoInitialize;
        function GetINIfile : String;
        procedure SetINIfile(Value : String);
        function GetINIsection : String;
        procedure SetINIsection(Value : String);
        function GetRegKey : String;
        procedure SetRegKey(Value : String);
        function GetRegSubKey : String;
        procedure SetRegSubKey(Value : String);
    protected
        procedure Click; override;
        procedure KeyPress(var Key : Char); override;
        procedure Change; override;
        procedure Loaded; override;
    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure SaveToIni;
        procedure LoadFromIni;
        procedure SaveToRegistry;
        procedure LoadFromRegistry;
    published
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property OnKeyUp;
        property OnKeyDown;
        property OnKeyPress;
        property OnEnter;
        property OnExit;
        property OnChange;
        property INIfile : String read GetINIfile write SetINIfile;
        property INIsection : String read GetINIsection write SetINIsection;
        property RegKey : String read GetRegKey write SetRegKey;
        property RegSubKey : String read GetRegSubKey write SetRegSubKey;
  end;

  TIniListBox = class(TListBox)
    private
        IniFil : TIniFile;
        Reg : TRegIniFile;
        FINIfile : String;
        FINIsection : String;
        FRegKey : String;
        FRegSubKey : String;
        procedure AutoInitialize;
        function GetINIfile : String;
        procedure SetINIfile(Value : String);
        function GetINIsection : String;
        procedure SetINIsection(Value : String);
        function GetRegKey : String;
        procedure SetRegKey(Value : String);
        function GetRegSubKey : String;
        procedure SetRegSubKey(Value : String);
    protected
        procedure Click; override;
        procedure KeyPress(var Key : Char); override;
        procedure Loaded; override;
    public
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure SaveToIni;
        procedure LoadFromIni;
        procedure SaveToRegistry;
        procedure LoadFromRegistry;
    published
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property OnKeyUp;
        property OnKeyDown;
        property OnKeyPress;
        property OnEnter;
        property OnExit;
        property INIfile : String read GetINIfile write SetINIfile;
        property INIsection : String read GetINIsection write SetINIsection;
        property RegKey : String read GetRegKey write SetRegKey;
        property RegSubKey : String read GetRegSubKey write SetRegSubKey;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Standard', [TIniCombo, TIniListBox]);
end;

procedure TIniCombo.AutoInitialize;
begin
     FINIfile := 'IniCombo.INI';
     FINIsection := 'History';
     FRegKey := 'Software\MyApp\inicombo';
     FRegSubKey := 'History';
end;

function TIniCombo.GetINIfile : String;
begin
     Result := FINIfile
end;

procedure TIniCombo.SetINIfile(Value : String);
begin
     FINIfile := Value;
end;

function TIniCombo.GetINIsection : String;
begin
     Result := FINIsection
end;

procedure TIniCombo.SetINIsection(Value : String);
begin
     FINIsection := Value;
end;

function TIniCombo.GetRegKey : String;
begin
     Result := FRegKey
end;

procedure TIniCombo.SetRegKey(Value : String);
begin
     FRegKey := Value;
end;

function TIniCombo.GetRegSubKey : String;
begin
     Result := FRegSubKey
end;

procedure TIniCombo.SetRegSubKey(Value : String);
begin
     FRegSubKey := Value;
end;

procedure TIniCombo.Click;
begin
     inherited Click;
end;

procedure TIniCombo.KeyPress(var Key : Char);
begin
     inherited KeyPress(Key);
end;

procedure TIniCombo.Change;
begin
     inherited Change;
end;

constructor TIniCombo.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
end;

destructor TIniCombo.Destroy;
begin
     inherited Destroy;
end;

procedure TIniCombo.Loaded;
begin
     inherited Loaded;
end;

procedure TIniCombo.SaveToIni;
var i: integer;
begin
   if FIniFile<>''then IniFil:=TIniFile.Create(FiniFile)
   else IniFil:=TIniFile.Create('inicombo.ini');
   if FIniSection=''then begin
     IniFil.EraseSection('History');
     for i:=0 to Items.Count-1 do
        IniFil.WriteString('History','n'+IntToStr(i),Items[i]);
   end else begin
     IniFil.EraseSection(FIniSection);
     for i:=0 to Items.Count-1 do
        IniFil.WriteString(FIniSection,'n'+IntToStr(i),Items[i]);
   end;
end;

procedure TIniCombo.LoadFromIni;
var i: Integer;
begin
  Clear;
  if Finifile<>''then IniFil:=TIniFile.Create(FiniFile)
  else IniFil:=TIniFile.Create('inicombo.ini');
  if Finisection=''then begin
    IniFil.ReadSection('History',Items);
    for i:=0 to Items.Count-1 do
      Items[i]:=IniFil.ReadString('History','n'+IntToStr(i),'');
  end else begin
    IniFil.ReadSection(FIniSection,Items);
    for i:=0 to Items.Count-1 do
      Items[i]:=IniFil.ReadString(FIniSection,'n'+IntToStr(i),'');
  end;
end;

procedure TIniCombo.SaveToRegistry;
var i: integer;
begin
  if FRegKey<>''then Reg:=TRegIniFile.Create(FRegKey)
  else Reg:=TRegIniFile.Create('Software\MyApp\inicombo');
  if FRegKey<>''then Reg.EraseSection('Software\MyApp\inicombo\History')
  else Reg.EraseSection(FRegSubKey);
  try
    for i:=0 to Items.Count-1 do
      if FRegSubKey=''then Reg.WriteString('History','n'+IntToStr(i),Items[i])
      else Reg.WriteString(FRegSubKey,'n'+IntToStr(i),Items[i]);
  except on Exception do {nothing}; end;
  Reg.CloseKey;
end;

procedure TIniCombo.LoadFromRegistry;
var i: integer;
    temp: ^String;
begin
  if FregKey<>''then Reg:=TReginifile.Create(FregKey)
  else Reg:=TRegIniFile.Create('Software\MyApp\inicombo');
  Clear;
  try
    if FRegKey=''then Reg.ReadSection('Software\MyApp\inicombo',Items)
    else Reg.ReadSection(FRegSubKey,Items);
    New(temp);
    for i:=0 to Items.Count-1 do begin
      if FRegSubKey<>''then temp^:= Reg.ReadString(FRegSubKey,'n'+IntToStr(i),'')
      else temp^:=Reg.ReadString('History','n'+IntToStr(i),'');
      if temp^<>''then Items[i]:=temp^;
    end;
    Dispose(temp);
  except on Exception do {nothing}; end;
end;

procedure TIniListBox.AutoInitialize;
begin
     FINIfile := 'IniListBox.INI';
     FINIsection := 'History';
     FRegKey := 'Software\MyApp\IniListBox';
     FRegSubKey := 'History';
end;

function TIniListBox.GetINIfile : String;
begin
     Result := FINIfile
end;

procedure TIniListBox.SetINIfile(Value : String);
begin
     FINIfile := Value;
end;

function TIniListBox.GetINIsection : String;
begin
     Result := FINIsection
end;

procedure TIniListBox.SetINIsection(Value : String);
begin
     FINIsection := Value;
end;

function TIniListBox.GetRegKey : String;
begin
     Result := FRegKey
end;

procedure TIniListBox.SetRegKey(Value : String);
begin
     FRegKey := Value;
end;

function TIniListBox.GetRegSubKey : String;
begin
     Result := FRegSubKey
end;

procedure TIniListBox.SetRegSubKey(Value : String);
begin
     FRegSubKey := Value;
end;

procedure TIniListBox.Click;
begin
     inherited Click;
end;

procedure TIniListBox.KeyPress(var Key : Char);
begin
     inherited KeyPress(Key);
end;

constructor TIniListBox.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;
end;

destructor TIniListBox.Destroy;
begin
     inherited Destroy;
end;

procedure TIniListBox.Loaded;
begin
     inherited Loaded;
end;

procedure TIniListBox.SaveToIni;
var i: integer;
begin
   if FIniFile<>''then IniFil:=TIniFile.Create(FiniFile)
   else IniFil:=TIniFile.Create('inilstbox.ini');
   if FIniSection=''then begin
     IniFil.EraseSection('History');
     for i:=0 to Items.Count-1 do
        IniFil.WriteString('History','n'+IntToStr(i),Items[i]);
   end else begin
     IniFil.EraseSection(FIniSection);
     for i:=0 to Items.Count-1 do
        IniFil.WriteString(FIniSection,'n'+IntToStr(i),Items[i]);
   end;
end;

procedure TIniListBox.LoadFromIni;
var i: Integer;
begin
  Clear;
  if Finifile<>''then IniFil:=TIniFile.Create(FiniFile)
  else IniFil:=TIniFile.Create('inilstbox.ini');
  if Finisection=''then begin
    IniFil.ReadSection('History',Items);
    for i:=0 to Items.Count-1 do
      Items[i]:=IniFil.ReadString('History','n'+IntToStr(i),'');
  end else begin
    IniFil.ReadSection(FIniSection,Items);
    for i:=0 to Items.Count-1 do
      Items[i]:=IniFil.ReadString(FIniSection,'n'+IntToStr(i),'');
  end;
end;

procedure TIniListBox.SaveToRegistry;
var i: integer;
begin
  if FRegKey<>''then Reg:=TRegIniFile.Create(FRegKey)
  else Reg:=TRegIniFile.Create('Software\MyApp\IniListBox');
  if FRegKey<>''then Reg.EraseSection('Software\MyApp\IniListBox\History')
  else Reg.EraseSection(FRegSubKey);
  try
    for i:=0 to Items.Count-1 do
      if FRegSubKey=''then Reg.WriteString('History','n'+IntToStr(i),Items[i])
      else Reg.WriteString(FRegSubKey,'n'+IntToStr(i),Items[i]);
  except on Exception do {nothing}; end;
  Reg.CloseKey;
end;

procedure TIniListBox.LoadFromRegistry;
var i: integer;
    temp: ^String;
begin
  if FregKey<>''then Reg:=TReginifile.Create(FregKey)
  else Reg:=TRegIniFile.Create('Software\MyApp\IniListBox');
  Clear;
  try
    if FRegKey=''then Reg.ReadSection('Software\MyApp\IniListBox',Items)
    else Reg.ReadSection(FRegSubKey,Items);
    New(temp);
    for i:=0 to Items.Count-1 do begin
      if FRegSubKey<>''then temp^:= Reg.ReadString(FRegSubKey,'n'+IntToStr(i),'')
      else temp^:=Reg.ReadString('History','n'+IntToStr(i),'');
      if temp^<>''then Items[i]:=temp^;
    end;
    Dispose(temp);
  except on Exception do {nothing}; end;
end;

end.
