unit UnZipWin;

(*                                                                      *)
(* Test window for interface into wizunz16.dll by the info-zip group.   *)
(* DLL can be found at: http://quest.jpl.nasa.gov/Info-ZIP/             *)
(*                                                                      *)

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, WizUnzip;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    ListBox1: TListBox;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
 Left := 10; Top := 10;
end;

procedure TForm1.Button1Click(Sender: TObject);
   var ZipFn : ARRAY[0..144] OF CHAR;
       _DCL  : PDCL;
       I     : INTEGER;
begin
 IF OpenDialog1.Execute
  THEN BEGIN
        ListBox1.Items.Clear;
        StrPCopy(ZipFn,OpenDialog1.FileName);
        WZInitADCL(_DCL,HInstance,Handle,ListBox1.Handle);
        WITH _DCL^ DO
         BEGIN {setup rest of parameters for unzip to list}
          lpszZipFN := @ZipFn;
          nvFlag := wzl_Short; {short listing}
         END; {with}
        I := WZ_UnZip(_DCL); {run unzip proc}
        WZDestroyDCL(_DCL);
        IF ListBox1.Items.Count > 0
         THEN BEGIN
               Button2.Enabled := TRUE;
               ListBox1.ItemIndex := 0;
              END
        ELSE Button2.Enabled := FALSE;
       END;
end;

procedure TForm1.Button2Click(Sender: TObject);
   var Fil, T1, T2 : STRING;
       I           : INTEGER;
       FF          : ARRAY[0..144] OF CHAR;
       Fils        : PACHAR;
       ZipFn       : ARRAY[0..144] OF CHAR;
       _DCL        : PDCL;
       TT          : THANDLE;
begin
 Fil := ListBox1.Items.Strings[ListBox1.ItemIndex];
 Fil := Copy(Fil,28,Length(Fil)); T2 := Fil; StrPCopy(FF,T2);
 FOR I := 1 TO Length(T2) DO
  IF T2[I] = '/' THEN T2[I] := '\';
 T1 := ExtractFileName(T2);
 I := MessageDlg('Unzip - '+T1,mtConfirmation,[mbNo,mbYes],0);
 IF I <> mrYes THEN Exit;
 SaveDialog1.FileName := T1;
 IF SaveDialog1.Execute
  THEN BEGIN {got path}
        {only allocating for single file}
        TT := GlobalAlloc(GHnd,SizeOf(PCHAR));
        Fils := GlobalLock(TT); 
        Fils^[0] := @FF;
        StrPCopy(ZipFn,OpenDialog1.FileName);
        WZInitADCL(_DCL,HInstance,Handle,0); {create/initialize struct}
        WITH _DCL^ DO
         BEGIN {setup rest of parameters for unzip}
          WITH lpUMB^ DO
           StrPCopy(szUnzipToDirName,ExtractFilePath(SaveDialog1.FileName));
          OverWrite := TRUE;
          ArgC := 1; {set equal to number of files submitting}
          lpszZipFN := @ZipFn;
          FNV := Fils;
         END; {with}
        I := WZ_UnZip(_DCL); {run unzip proc}
        WZDestroyDCL(_DCL);  {release control block}
        GlobalUnlock(TT);    {free file list}
        GlobalFree(TT); 
        IF I <> wze_OK
         THEN MessageDlg('Unzip failed - '+WZRetErrorString(I),mtError,[mbOK],0)
        ELSE MessageDlg('Unzip success',mtInformation,[mbOK],0);
       END; {then}
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 Close;
end;

end.

